/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.ia.model.AffGroup;
import com.ibm.cics.ia.model.AffinityType;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.ui.AffGroupTreeViewerNode;
import com.ibm.cics.ia.ui.Messages;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

class TrangroupTreeCellLabelProvider
extends StyledCellLabelProvider {
    private static String CREATE_TRANGRP = "CREATE TRANGRP NAME(";
    private static String AFFINITY = ") AFFINITY(";
    private static String AFFLIFE = ") AFFLIFE(";
    private static String DESC = ") DESC(";
    private static String CREATE_DTRINGRP = "CREATE DTRINGRP TRANGRP(";
    private static String TRANID = ") TRANID(";
    private static Color hilightColor = new Color((Device)Display.getDefault(), 42, 0, 255);
    private static final Logger logger = Logger.getLogger(TrangroupTreeCellLabelProvider.class.getPackage().getName());

    TrangroupTreeCellLabelProvider() {
    }

    public void update(ViewerCell cell) {
        AffGroupTreeViewerNode node = (AffGroupTreeViewerNode)cell.getElement();
        if (node.getType().equals((Object)AffGroupTreeViewerNode.Type.Dummy)) {
            cell.setText(Messages.getString("AffinityReportEditor.TransactionGroups.Dummy.Text"));
        } else if (node.getType().equals((Object)AffGroupTreeViewerNode.Type.AffinityType)) {
            AffinityType affinityType = (AffinityType)node.getData();
            cell.setText(affinityType.getName());
        } else if (node.getType().equals((Object)AffGroupTreeViewerNode.Type.AffGroup)) {
            AffGroup affGroup = (AffGroup)node.getData();
            String affinity = affGroup.getAffinity().toString();
            String lifetime = affGroup.getLifetime().toString();
            String description = affGroup.getResourceName();
            String tranGroup = affGroup.getTranGroup();
            String text = String.valueOf(CREATE_TRANGRP) + tranGroup + AFFINITY + affinity + AFFLIFE + lifetime + DESC + description + ");";
            cell.setText(text);
            StyleRange affGroupStyleRange = new StyleRange(CREATE_TRANGRP.length(), tranGroup.length(), hilightColor, null, 1);
            StyleRange affinityStyleRange = new StyleRange(CREATE_TRANGRP.length() + tranGroup.length() + AFFINITY.length(), affinity.length(), hilightColor, null, 1);
            StyleRange lifetimeStyleRange = new StyleRange(CREATE_TRANGRP.length() + tranGroup.length() + AFFINITY.length() + affinity.length() + AFFLIFE.length(), lifetime.length(), hilightColor, null, 1);
            StyleRange descriptionStyleRange = new StyleRange(CREATE_TRANGRP.length() + tranGroup.length() + AFFINITY.length() + affinity.length() + AFFLIFE.length() + lifetime.length() + DESC.length(), description.length(), hilightColor, null, 1);
            StyleRange[] ranges = new StyleRange[]{affGroupStyleRange, affinityStyleRange, lifetimeStyleRange, descriptionStyleRange};
            cell.setStyleRanges(ranges);
        } else if (node.getType().equals((Object)AffGroupTreeViewerNode.Type.Transaction)) {
            AffGroup affGroup = (AffGroup)node.getParentNode().getData();
            Transaction transaction = (Transaction)node.getData();
            String tranGroup = affGroup.getTranGroup();
            String transactionName = transaction.getName();
            String text = String.valueOf(CREATE_DTRINGRP) + tranGroup + TRANID + transactionName + ");";
            cell.setText(text);
            StyleRange dtringrpStyleRange = new StyleRange(CREATE_DTRINGRP.length(), tranGroup.length(), hilightColor, null, 1);
            StyleRange transactionStyleRange = new StyleRange(CREATE_DTRINGRP.length() + tranGroup.length() + TRANID.length(), transactionName.length(), hilightColor, null, 1);
            StyleRange[] ranges = new StyleRange[]{dtringrpStyleRange, transactionStyleRange};
            cell.setStyleRanges(ranges);
        }
        super.update(cell);
    }
}

