/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.model.TreeNode;
import com.ibm.cics.ia.model.threadsafe.Summary;
import com.ibm.cics.ia.model.threadsafe.ThreadsafeReport;
import com.ibm.cics.ia.model.threadsafe.ThreadsafeReportModel;
import com.ibm.cics.ia.model.threadsafe.ThreadsafeReportModelListener;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.ResourceRenderer;
import com.ibm.cics.ia.ui.ThreadsafeReportPresenter;
import com.ibm.cics.ia.ui.ThreadsafeReportView;
import com.ibm.cics.ia.ui.actions.CollectorAction;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TreeColumn;
import org.osgi.framework.Bundle;

public class ThreadsafeReportPresenterImpl
implements ThreadsafeReportPresenter,
ThreadsafeReportModelListener {
    private static final Logger logger = Logger.getLogger(ThreadsafeReportPresenterImpl.class.getPackage().getName());
    private ThreadsafeReportView view;
    private ThreadsafeReportModel model;
    private static ThreadsafeReportPresenterImpl instance;

    @Override
    public void setView(ThreadsafeReportView view) {
        this.view = view;
    }

    @Override
    public void setModel(ThreadsafeReportModel model) {
        this.model = model;
    }

    @Override
    public String getViewTitle() {
        return Messages.getString("ThreadsafeReportViewImpl.title");
    }

    public static ThreadsafeReportPresenterImpl getInstance() {
        if (instance == null) {
            instance = new ThreadsafeReportPresenterImpl();
        }
        return instance;
    }

    @Override
    public void onViewCreation() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"onViewCreation", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.view.setHelp("com.ibm.cics.ia.help.ReportView");
        this.view.getTreeViewer().setContentProvider((IContentProvider)new SummaryContentProvider());
        this.view.getTreeViewer().setLabelProvider((IBaseLabelProvider)new SummaryLabelProvider());
        this.view.getTableViewer().setContentProvider((IContentProvider)new DetailContentProvider());
        this.view.getTableViewer().setLabelProvider((IBaseLabelProvider)new DetailLabelProvider());
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"onViewCreation");
    }

    @Override
    public void onTableItemSelected() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"onTableItemSelected", (Object)("Thread ID: " + Thread.currentThread().getId()));
        ISelection iSelection = this.view.getTableViewer().getSelection();
        if (iSelection != null && iSelection instanceof StructuredSelection) {
            this.view.getCopyAction().setEnabled(true);
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"onTableItemSelected");
    }

    @Override
    public void onTreeItemSelected() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"onTreeItemSelected", (Object)("Thread ID: " + Thread.currentThread().getId()));
        ISelection iSelection = this.view.getTreeViewer().getSelection();
        if (iSelection != null && iSelection instanceof StructuredSelection) {
            this.view.getCopyAction().setEnabled(true);
            TreeNode node = (TreeNode)((StructuredSelection)iSelection).getFirstElement();
            Object data = node.getData();
            if (data instanceof Summary) {
                this.view.getTreeViewer().expandToLevel((Object)node, 1);
                Summary summary = (Summary)data;
                if (this.view.getTableViewer().getInput() != summary.getDetails()) {
                    this.view.getTableViewer().setInput((Object)summary.getDetails());
                    TableColumn[] tableColumnArray = this.view.getTableViewer().getTable().getColumns();
                    int n = tableColumnArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableColumn column = tableColumnArray[n2];
                        column.pack();
                        ++n2;
                    }
                }
            } else if (data instanceof String || data instanceof Region) {
                Object details = null;
                this.view.getTableViewer().setInput(details);
            }
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"onTreeItemSelected");
    }

    public void onReportLoad(ThreadsafeReport report) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"onReportLoad", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.view.getTreeViewer().setInput(null);
        this.view.getTableViewer().setInput(null);
        this.view.getTreeViewer().setInput((Object)this.model.convertReport());
        TreeColumn[] treeColumnArray = this.view.getTreeViewer().getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            column.pack();
            ++n2;
        }
        this.refreshCollectorStatus();
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"onReportLoad");
    }

    public void onReportSet(ThreadsafeReport report) {
        this.onReportLoad(report);
    }

    @Override
    public ThreadsafeReportModel getModel() {
        return this.model;
    }

    public void refreshCollectorStatus() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"refreshCollectorStatus", (Object)("Thread ID: " + Thread.currentThread().getId()));
        CollectorAction collectorStatusRefreshAction = new CollectorAction();
        collectorStatusRefreshAction.setId(CollectorAction.REFRESH_ACTION);
        collectorStatusRefreshAction.setEnabled(true);
        collectorStatusRefreshAction.run();
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"refreshCollectorStatus");
    }

    public void onUpdate() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"onUpdate", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.view.getTreeViewer() != null && !this.view.getTreeViewer().getTree().isDisposed()) {
            this.view.getTreeViewer().refresh();
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"onUpdate");
    }

    @Override
    public void onCopyRequest() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"onCopyRequest", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String relativeFilePath = "$nl$/threadsafe-report-to-csv.xsl";
        Bundle plugin = Activator.getDefault().getBundle();
        Path relativePath = new Path("$nl$/threadsafe-report-to-csv.xsl");
        String reportAsCsv = "";
        try {
            InputStream fis = FileLocator.openStream((Bundle)plugin, (IPath)relativePath, (boolean)true);
            InputStreamReader in = new InputStreamReader(fis, "UTF-8");
            HashMap<String, String> xslParameters = new HashMap<String, String>();
            if (this.view.getTreeViewer().getTree().isFocusControl()) {
                xslParameters.put("type", "summaries");
            }
            reportAsCsv = IAUtilities.transformXml((File)this.model.getReportFile(), (Reader)in, xslParameters);
        }
        catch (Exception e) {
            Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"onFinish", (String)"Unable to create CSV from the threadsafe report", (Throwable)e);
            IAPlugin.getDefault().logError("Unable to create CSV from the threadsafe report", (Throwable)e);
        }
        this.view.getClipboard().setContents(new Object[]{reportAsCsv}, new Transfer[]{TextTransfer.getInstance()});
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"onCopyRequest");
    }

    @Override
    public ThreadsafeReportView getView() {
        return this.view;
    }

    class DetailContentProvider
    implements IStructuredContentProvider {
        DetailContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null) {
                return new Object[0];
            }
            return ((Summary.Details)inputElement).getDetails().toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class DetailLabelProvider
    implements ITableLabelProvider {
        DetailLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof Summary.Details.Detail && columnIndex == 2) {
                Summary.Details.Detail detail = (Summary.Details.Detail)element;
                return ResourceRenderer.asImage(ResourceFactory.getSingleton().getResource(detail.getType(), detail.getObject()));
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Summary.Details.Detail) {
                Summary.Details.Detail detail = (Summary.Details.Detail)element;
                switch (columnIndex) {
                    case 0: {
                        return detail.getCommandType();
                    }
                    case 1: {
                        return detail.getFunction();
                    }
                    case 2: {
                        return detail.getType();
                    }
                    case 3: {
                        return detail.getObject();
                    }
                    case 4: {
                        return detail.getOffset();
                    }
                    case 5: {
                        return Integer.toString(detail.getUseCount());
                    }
                    case 6: {
                        return detail.getThreadsafe();
                    }
                    case 7: {
                        return detail.getInhibitor();
                    }
                }
            }
            return null;
        }
    }

    class SummaryContentProvider
    implements ITreeContentProvider {
        SummaryContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null) {
                return new Object[0];
            }
            return ((List)inputElement).toArray();
        }

        public Object[] getChildren(Object parentElement) {
            return ((TreeNode)parentElement).getChildren().toArray();
        }

        public Object getParent(Object element) {
            return ((TreeNode)element).getParent();
        }

        public boolean hasChildren(Object element) {
            return !((TreeNode)element).getChildren().isEmpty();
        }
    }

    class SummaryLabelProvider
    implements ITableLabelProvider,
    ITableFontProvider {
        private Font boldFont;

        public SummaryLabelProvider() {
            FontData fontData = ThreadsafeReportPresenterImpl.this.view.getTreeViewer().getTree().getFont().getFontData()[0];
            fontData.setStyle(1);
            this.boldFont = new Font(ThreadsafeReportPresenterImpl.this.view.getTreeViewer().getTree().getFont().getDevice(), fontData);
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            TreeNode node = (TreeNode)element;
            if (columnIndex == 0) {
                if (node.getData() instanceof String) {
                    return ImageFactory.getCollectionIdImage();
                }
                if (node.getData() instanceof Region) {
                    return ResourceRenderer.asImage((Region)node.getData());
                }
                if (node.getData() instanceof Summary) {
                    return ImageFactory.getProgramImage();
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            TreeNode node = (TreeNode)element;
            if (node.getData() instanceof String && columnIndex == 0) {
                return node.getData().toString();
            }
            if (node.getData() instanceof Region && columnIndex == 0) {
                Region region = (Region)node.getData();
                return String.valueOf(region.getName()) + " (CICS TS " + ((Summary)((TreeNode)node.getChildren().get(0)).getData()).getCicsReleaseExternal() + ")";
            }
            if (node.getData() instanceof Summary) {
                Summary summary = (Summary)node.getData();
                switch (columnIndex) {
                    case 0: {
                        return summary.getProgram();
                    }
                    case 1: {
                        return summary.getLibDataset();
                    }
                    case 2: {
                        return summary.getApist();
                    }
                    case 3: {
                        return summary.getConcurrency();
                    }
                    case 4: {
                        return summary.getExecutionKey();
                    }
                    case 5: {
                        return summary.getStorageProtect();
                    }
                    case 6: {
                        return summary.getReentrant();
                    }
                    case 7: {
                        return summary.getCicsReleaseInternal();
                    }
                }
            } else if (node.getData() instanceof Summary.CicsCalls) {
                Summary.CicsCalls cicsCalls = (Summary.CicsCalls)node.getData();
                switch (columnIndex) {
                    case 0: {
                        return "";
                    }
                    case 1: {
                        return Messages.getString("ThreadsafeReportViewImpl.Column.COUNT_CICS_CMD");
                    }
                    case 2: {
                        return Integer.toString(cicsCalls.getTotalCicsCalls());
                    }
                    case 3: {
                        return Messages.getString("ThreadsafeReportViewImpl.Column.COUNT_THREADSAFE");
                    }
                    case 4: {
                        return Integer.toString(cicsCalls.getThreadsafe());
                    }
                    case 5: {
                        return Messages.getString("ThreadsafeReportViewImpl.Column.COUNT_NON_THREADSAFE");
                    }
                    case 6: {
                        return Integer.toString(cicsCalls.getNonThreadsafe());
                    }
                    case 7: {
                        return "";
                    }
                }
            } else if (node.getData() instanceof Summary.Db2MqCalls) {
                Summary.Db2MqCalls db2MqCalls = (Summary.Db2MqCalls)node.getData();
                switch (columnIndex) {
                    case 0: {
                        return "";
                    }
                    case 1: {
                        return Messages.getString("ThreadsafeReportViewImpl.Column.COUNT_INDETERMINATE");
                    }
                    case 2: {
                        return Integer.toString(db2MqCalls.getIndeterminateThreadsafe());
                    }
                    case 3: {
                        return Messages.getString("ThreadsafeReportViewImpl.Column.COUNT_DB2_CMD");
                    }
                    case 4: {
                        return Integer.toString(db2MqCalls.getTotalDb2Calls());
                    }
                    case 5: {
                        return Messages.getString("ThreadsafeReportViewImpl.Column.COUNT_MQ_CMD");
                    }
                    case 6: {
                        return Integer.toString(db2MqCalls.getTotalMqCalls());
                    }
                    case 7: {
                        return "";
                    }
                }
            } else if (node.getData() instanceof Summary.ImsCalls) {
                Summary.ImsCalls imsCalls = (Summary.ImsCalls)node.getData();
                switch (columnIndex) {
                    case 0: {
                        return "";
                    }
                    case 1: {
                        return Messages.getString("ThreadsafeReportViewImpl.Column.COUNT_IMS_CMD");
                    }
                    case 2: {
                        return Integer.toString(imsCalls.getTotalImsCalls());
                    }
                    case 3: {
                        return Messages.getString("ThreadsafeReportViewImpl.Column.COUNT_DYNAMIC");
                    }
                    case 4: {
                        return Integer.toString(imsCalls.getDynamicCalls());
                    }
                    case 5: {
                        return Messages.getString("ThreadsafeReportViewImpl.Column.COUNT_INHIBITOR");
                    }
                    case 6: {
                        return Integer.toString(imsCalls.getThreadsafeInhibitorCalls());
                    }
                    case 7: {
                        return "";
                    }
                }
            } else if (node.getData() instanceof Summary.CpsmCalls) {
                Summary.CpsmCalls cpsmCalls = (Summary.CpsmCalls)node.getData();
                switch (columnIndex) {
                    case 0: {
                        return "";
                    }
                    case 1: {
                        return Messages.getString("ThreadsafeReportViewImpl.Column.COUNT_CPSM_CMD");
                    }
                    case 2: {
                        return Integer.toString(cpsmCalls.getTotalCpsmCalls());
                    }
                    case 3: {
                        return Messages.getString("ThreadsafeReportViewImpl.Column.COUNT_THREADSAFE");
                    }
                    case 4: {
                        return Integer.toString(cpsmCalls.getThreadsafe());
                    }
                    case 5: {
                        return Messages.getString("ThreadsafeReportViewImpl.Column.COUNT_NON_THREADSAFE");
                    }
                    case 6: {
                        return Integer.toString(cpsmCalls.getNonThreadsafe());
                    }
                    case 7: {
                        return "";
                    }
                }
            }
            return null;
        }

        public Font getFont(Object element, int columnIndex) {
            TreeNode node = (TreeNode)element;
            if (node.getData() instanceof Summary) {
                return this.boldFont;
            }
            return null;
        }
    }
}

