/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

class SelectionProviderWrapper
implements ISelectionProvider {
    private ISelectionProvider provider;
    private List selectionListeners;
    private ISelection sel = StructuredSelection.EMPTY;
    private static final Logger logger = Logger.getLogger(SelectionProviderWrapper.class.getPackage().getName());

    SelectionProviderWrapper() {
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        Debug.enter((Logger)logger, (String)SelectionProviderWrapper.class.getName(), (String)"addSelectionChangedListener", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId()});
        if (this.selectionListeners == null) {
            this.selectionListeners = new ArrayList(1);
        }
        this.selectionListeners.add(listener);
        if (this.provider != null) {
            this.provider.addSelectionChangedListener(listener);
        }
        Debug.exit((Logger)logger, (String)SelectionProviderWrapper.class.getName(), (String)"removeSelectionChangedListener");
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        Debug.enter((Logger)logger, (String)SelectionProviderWrapper.class.getName(), (String)"removeSelectionChangedListener", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.selectionListeners != null) {
            this.selectionListeners.remove(listener);
            if (this.provider != null) {
                this.provider.removeSelectionChangedListener(listener);
            }
        }
        Debug.exit((Logger)logger, (String)SelectionProviderWrapper.class.getName(), (String)"getSelection");
    }

    public ISelection getSelection() {
        return this.provider != null ? this.provider.getSelection() : this.sel;
    }

    public void setSelection(ISelection selection) {
        Debug.enter((Logger)logger, (String)SelectionProviderWrapper.class.getName(), (String)"setSelection", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId()});
        if (this.provider != null) {
            this.provider.setSelection(selection);
        } else {
            this.sel = selection;
            if (this.selectionListeners != null) {
                SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
                Iterator it = this.selectionListeners.iterator();
                while (it.hasNext()) {
                    ((ISelectionChangedListener)it.next()).selectionChanged(event);
                }
            }
        }
        Debug.exit((Logger)logger, (String)SelectionProviderWrapper.class.getName(), (String)"setSelection");
    }

    public void setSelectionProvider(ISelectionProvider provider) {
        Debug.enter((Logger)logger, (String)SelectionProviderWrapper.class.getName(), (String)"setSelectionProvider", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.provider != provider) {
            ISelection _sel = null;
            if (this.selectionListeners != null) {
                ISelectionChangedListener listener;
                int i;
                int c = this.selectionListeners.size();
                if (this.provider != null) {
                    i = 0;
                    while (i < c) {
                        listener = (ISelectionChangedListener)this.selectionListeners.get(i);
                        this.provider.removeSelectionChangedListener(listener);
                        ++i;
                    }
                }
                if (provider != null) {
                    i = 0;
                    while (i < c) {
                        listener = (ISelectionChangedListener)this.selectionListeners.get(i);
                        provider.addSelectionChangedListener(listener);
                        ++i;
                    }
                    _sel = provider.getSelection();
                } else {
                    _sel = this.sel;
                }
            }
            this.provider = provider;
            if (_sel != null) {
                this.setSelection(_sel);
            }
        }
        Debug.exit((Logger)logger, (String)SelectionProviderWrapper.class.getName(), (String)"setSelectionProvider");
    }

    public ISelectionProvider getSelectionProvider() {
        return this.provider;
    }
}

