/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.ScenarioBasedCollectionPresenter;
import com.ibm.cics.ia.ui.ScenarioBasedCollectionView;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class ScenarioBasedCollectionViewImpl
extends Dialog
implements ScenarioBasedCollectionView {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ScenarioBasedCollectionViewImpl.class.getPackage().getName());
    private Button[] radioButtons;
    private Button[] checkButtons;
    private ScenarioBasedCollectionPresenter presenter;

    public ScenarioBasedCollectionViewImpl(Shell parentShell) {
        super(parentShell);
        this.setBlockOnOpen(false);
    }

    protected void handleShellCloseEvent() {
        this.presenter.onViewClosing();
        super.handleShellCloseEvent();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("ScenarioBasedCollectionView.title"));
    }

    protected Control createDialogArea(Composite parent) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"createDialogArea", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)container.getLayout();
        gridLayout.numColumns = 3;
        gridLayout.horizontalSpacing = 25;
        this.radioButtons = new Button[4];
        this.checkButtons = new Button[6];
        this.radioButtons[0] = this.createButton(container, "ScenarioBasedCollectionView.radioButton0Text", 16);
        this.checkButtons[0] = this.createButton(container, "ScenarioBasedCollectionView.checkButton0Text", 32);
        this.checkButtons[5] = this.createButton(container, "ScenarioBasedCollectionView.checkButton5Text", 32);
        this.radioButtons[1] = this.createButton(container, "ScenarioBasedCollectionView.radioButton1Text", 16);
        this.checkButtons[1] = this.createButton(container, "ScenarioBasedCollectionView.checkButton1Text", 32);
        new Label(container, 0);
        this.radioButtons[2] = this.createButton(container, "ScenarioBasedCollectionView.radioButton2Text", 16);
        this.checkButtons[2] = this.createButton(container, "ScenarioBasedCollectionView.checkButton2Text", 32);
        new Label(container, 0);
        this.radioButtons[3] = this.createButton(container, "ScenarioBasedCollectionView.radioButton3Text", 16);
        this.checkButtons[3] = this.createButton(container, "ScenarioBasedCollectionView.checkButton3Text", 32);
        new Label(container, 0);
        new Label(container, 0);
        this.checkButtons[4] = this.createButton(container, "ScenarioBasedCollectionView.checkButton4Text", 32);
        new Label(container, 0);
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"createDialogArea");
        return container;
    }

    private Button createButton(Composite container, String messageKey, int style) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"createButton", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Button button = new Button(container, style);
        button.setText(Messages.getString(messageKey));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScenarioBasedCollectionViewImpl.this.presenter.onSelectionChanged();
            }
        });
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"createButton");
        return button;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"createButtonsForButtonBar", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Button okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScenarioBasedCollectionViewImpl.this.presenter.onOkPressed();
            }
        });
        Button cancelButton = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScenarioBasedCollectionViewImpl.this.presenter.onCancelPressed();
            }
        });
        this.packAndMoveToCenter(this.getShell());
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"createButtonsForButtonBar");
    }

    private void packAndMoveToCenter(Shell shell) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"packAndMoveToCenter", (Object)("Thread ID: " + Thread.currentThread().getId()));
        shell.pack();
        Rectangle monitorArea = shell.getDisplay().getPrimaryMonitor().getBounds();
        Rectangle shellArea = shell.getBounds();
        int x = monitorArea.x + (monitorArea.width - shellArea.width) / 2;
        int y = monitorArea.y + (monitorArea.height - shellArea.height) / 2;
        shell.setLocation(x, y);
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"packAndMoveToCenter");
    }

    @Override
    public int show() {
        return this.open();
    }

    @Override
    public boolean hide() {
        return this.close();
    }

    @Override
    public void setCheckButtonsStates(boolean[] states) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"setCheckButtonsStates", (Object)("Thread ID: " + Thread.currentThread().getId()));
        int i = 0;
        while (i < this.checkButtons.length) {
            this.checkButtons[i].setSelection(states[i]);
            ++i;
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"setCheckButtonsStates");
    }

    @Override
    public boolean[] getCheckButtonsStates() {
        return new boolean[]{this.checkButtons[0].getSelection(), this.checkButtons[1].getSelection(), this.checkButtons[2].getSelection(), this.checkButtons[3].getSelection(), this.checkButtons[4].getSelection(), this.checkButtons[5].getSelection()};
    }

    @Override
    public void setCheckButtonsEnablement(boolean ... enabled) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"setCheckButtonsEnablement", (Object)("Thread ID: " + Thread.currentThread().getId()));
        int i = 0;
        while (i < this.checkButtons.length) {
            this.checkButtons[i].setEnabled(enabled[i]);
            ++i;
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"setCheckButtonsEnablement");
    }

    @Override
    public int getSelectedRadioButtonIndex() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"getSelectedRadioButtonIndex", (Object)("Thread ID: " + Thread.currentThread().getId()));
        int i = 0;
        while (i < this.radioButtons.length) {
            if (this.radioButtons[i].getSelection()) {
                Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"getSelectedRadioButtonIndex");
                return i;
            }
            ++i;
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"getSelectedRadioButtonIndex");
        return -1;
    }

    @Override
    public void setSelectedRadioButtonIndex(int index) {
        int i = 0;
        while (i < this.radioButtons.length) {
            this.radioButtons[i].setSelection(i == index);
            ++i;
        }
    }

    @Override
    public void setPresenter(ScenarioBasedCollectionPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public ScenarioBasedCollectionPresenter getPresenter() {
        return this.presenter;
    }
}

