/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.command.EngineShell;
import com.ibm.cics.dbfunc.command.SQLCommand;
import com.ibm.cics.eclipse.common.ui.JobWithCancelingSupport;
import com.ibm.cics.ia.commands.FindCSectsCommand;
import com.ibm.cics.ia.commands.FindScannerDataCommand;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.CSect;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.DefaultRetrieveMorePresenterImpl;
import com.ibm.cics.ia.ui.DefaultRetrieveMoreViewImpl;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.NavigatorView;
import com.ibm.cics.ia.ui.ResourceRenderer;
import com.ibm.cics.ia.ui.RetrieveMorePresenter;
import com.ibm.cics.ia.ui.RetrieveMoreView;
import com.ibm.cics.ia.ui.ShowDetailsStrategy;
import com.ibm.cics.ia.ui.UIUtilities;
import com.ibm.cics.ia.ui.actions.ScannerCommandsAction;
import java.util.Collection;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;

public class ScannerView {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ScannerView.class.getPackage().getName());
    private static final String DSN = "DSN";
    public static final String PROGRAM = "PROGRAM";
    private static final String SEARCH_IN_PROGRESS_ITEM = "SEARCH_IN_PROGRESS_ITEM";
    public static final String CSECT = "CSECT";
    private static final String COUNT = "COUNT";
    private static final String SEARCH_LABEL_PADDING = "      ";
    private Display display;
    private Composite parent;
    private Tree scannerTree;
    private String taskName = "";
    private TreeItem dummyTreeItem;
    private TreeItem csectsSearchInProgressItem;
    private IASQLCommand programCommand;
    private IASQLCommand csectsCommand;
    private EngineShell.EngineListener programsCommandListener;
    private EngineShell.EngineListener csectsCommandListener;
    private Job findResourceJob;
    private Action refreshAction;
    private int searchCount;
    private ConnectionServiceListener connectionServiceListener;
    private TreeItem root;
    private NavigatorView navigatorView;
    private RetrieveMoreView retrieveMoreProgramsView;
    private RetrieveMorePresenter retrieveMoreProgramsPresenter;
    private RetrieveMoreView retrieveMoreCsectsView;
    private RetrieveMorePresenter retrieveMoreCsectsPresenter;

    public ScannerView(NavigatorView navigatorView) {
        this.navigatorView = navigatorView;
        this.scannerTree = navigatorView.getTree();
        this.root = UIUtilities.createTreeItem(this.scannerTree, Messages.getString("NavigatorView.category.scanner"), ImageFactory.getScannerImage());
    }

    private void initRetrieveMoreViews() {
        this.retrieveMoreProgramsView = new DefaultRetrieveMoreViewImpl(this.scannerTree, (IViewPart)this.navigatorView);
        this.retrieveMoreProgramsPresenter = new DefaultRetrieveMorePresenterImpl(this.retrieveMoreProgramsView);
        this.retrieveMoreProgramsView.setPresenter(this.retrieveMoreProgramsPresenter);
        this.retrieveMoreCsectsView = new DefaultRetrieveMoreViewImpl(this.scannerTree, (IViewPart)this.navigatorView);
        this.retrieveMoreCsectsPresenter = new DefaultRetrieveMorePresenterImpl(this.retrieveMoreCsectsView);
        this.retrieveMoreCsectsView.setPresenter(this.retrieveMoreCsectsPresenter);
    }

    public void createPartControl(Composite parent) {
        Debug.enter((Logger)logger, (String)ScannerView.class.getName(), (String)"createPartControl", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.parent = parent;
        this.display = parent.getDisplay();
        this.initRetrieveMoreViews();
        if (NavigatorView.isConnected()) {
            this.dummyTreeItem = UIUtilities.createDummyTreeItem(this.root);
        }
        this.refreshAction = new Action(Messages.getString("ScannerView.refreshButtonText"), ImageDescriptor.createFromImage((Image)ImageFactory.getRefreshImage())){

            public void run() {
                ScannerView.this.clear();
                ScannerView.this.programSearch();
            }
        };
        new ShowDetailsStrategy((Control)this.scannerTree){

            @Override
            public Object extractSource() {
                return 2.extractSourceFromTree(ScannerView.this.scannerTree, ScannerView.PROGRAM);
            }
        };
        this.scannerTree.addListener(17, new Listener(){

            public void handleEvent(Event e) {
                if (e.item == null && e.item.isDisposed()) {
                    return;
                }
                TreeItem item = (TreeItem)e.item;
                ScannerView.this.csectsSearchInProgressItem = (TreeItem)item.getData(ScannerView.SEARCH_IN_PROGRESS_ITEM);
                if (ScannerView.this.csectsSearchInProgressItem == null || ScannerView.this.csectsSearchInProgressItem.isDisposed()) {
                    return;
                }
                Object data = item.getData(ScannerView.PROGRAM);
                if (data != null) {
                    Program program = (Program)data;
                    TreeItem parent = item.getParentItem();
                    if (parent != null) {
                        Resource dsn = (Resource)parent.getData(ScannerView.DSN);
                        ScannerView.this.csectSearch(program, dsn);
                    }
                }
            }
        });
        this.connectionServiceListener = this.getConnectionServiceListener();
        ConnectionsPlugin.getDefault().getConnectionService().addConnectionServiceListener(this.connectionServiceListener);
        Debug.exit((Logger)logger, (String)ScannerView.class.getName(), (String)"createPartControl");
    }

    private void showMenu(IMenuManager mgr, TreeItem item) {
        Object itemData = item.getData(PROGRAM);
        if (itemData instanceof Program) {
            Program program = (Program)itemData;
            TreeItem dsnItem = item.getParentItem();
            Resource dsn = (Resource)dsnItem.getData(DSN);
            ScannerCommandsAction showAllCommandsAction = new ScannerCommandsAction();
            showAllCommandsAction.setText(Messages.getString("ScannerView.ShowAllCommands.action.text"));
            showAllCommandsAction.setId("SHOW_ALL_COMMANDS");
            showAllCommandsAction.setEnabled(true);
            showAllCommandsAction.setProgram(program);
            showAllCommandsAction.setDsn(dsn);
            ScannerCommandsAction showCommandsAffinitiesAction = new ScannerCommandsAction();
            showCommandsAffinitiesAction.setText(Messages.getString("ScannerView.ShowCommandsAffinities.action.text"));
            showCommandsAffinitiesAction.setId("SHOW_COMMANDS_AFFINITIES");
            showCommandsAffinitiesAction.setEnabled(true);
            showCommandsAffinitiesAction.setProgram(program);
            showCommandsAffinitiesAction.setDsn(dsn);
            ScannerCommandsAction showCommandsDependenciesAction = new ScannerCommandsAction();
            showCommandsDependenciesAction.setText(Messages.getString("ScannerView.ShowCommandsDependencies.action.text"));
            showCommandsDependenciesAction.setId("SHOW_COMMANDS_DEPENDENCIES");
            showCommandsDependenciesAction.setEnabled(true);
            showCommandsDependenciesAction.setProgram(program);
            showCommandsDependenciesAction.setDsn(dsn);
            MenuManager showCommandsMenu = new MenuManager(Messages.getString("ScannerView.ShowCommands.menu.text"));
            showCommandsMenu.add((IAction)showAllCommandsAction);
            showCommandsMenu.add((IAction)showCommandsAffinitiesAction);
            showCommandsMenu.add((IAction)showCommandsDependenciesAction);
            mgr.add((IContributionItem)showCommandsMenu);
        }
    }

    public void setFocus() {
    }

    public void dispose() {
        Debug.enter((Logger)logger, (String)ScannerView.class.getName(), (String)"dispose", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.connectionServiceListener != null) {
            this.connectionServiceListener.makeStale();
        }
        Debug.exit((Logger)logger, (String)ScannerView.class.getName(), (String)"dispose");
    }

    public void init(IViewSite site) throws PartInitException {
    }

    private String getTaskName() {
        return this.taskName;
    }

    private Job programSearch() {
        Debug.enter((Logger)logger, (String)ScannerView.class.getName(), (String)"programSearch", (Object)("Thread ID: " + Thread.currentThread().getId()));
        IConnectable resourceManager = ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.ia.connection.db2");
        if (!resourceManager.isConnected()) {
            return null;
        }
        if (this.scannerTree != null) {
            this.searchCount = 0;
            this.dummyTreeItem = UIUtilities.createDummyTreeItem(this.root);
            this.programCommand = new FindScannerDataCommand();
            this.programCommand.addListener(this.getProgramsCommandListener());
            this.retrieveMoreProgramsPresenter.setCommand((Command)this.programCommand);
            this.parent.setCursor(this.parent.getDisplay().getSystemCursor(3));
            this.findResourceJob = new JobWithCancelingSupport(this.getTaskName()){

                protected void cancelingSub() {
                    if (ScannerView.this.programCommand != null) {
                        ScannerView.this.programCommand.cancel();
                    }
                    IAPlugin.getDefault().taskEnded();
                }

                protected IStatus runSub(IProgressMonitor monitor) {
                    Debug.enter((Logger)logger, (String)"ScannerView.programSearch().findResourceJob", (String)"runSub", (Object)("Thread ID: " + Thread.currentThread().getId()));
                    Activator.getDefault().ensureConnected();
                    monitor.beginTask(ScannerView.this.getTaskName(), -1);
                    ScannerView.this.refreshAction.setEnabled(false);
                    if (ScannerView.this.programCommand != null) {
                        ScannerView.this.programCommand.setAsync(false);
                        ScannerView.this.programCommand.start();
                    }
                    ScannerView.this.refreshAction.setEnabled(true);
                    monitor.done();
                    IAPlugin.getDefault().taskEnded();
                    Debug.enter((Logger)logger, (String)"ScannerView.programSearch().findResourceJob", (String)"runSub");
                    return Status.OK_STATUS;
                }
            };
            this.retrieveMoreProgramsPresenter.setTaskName(this.getTaskName());
            this.findResourceJob.schedule();
            return this.findResourceJob;
        }
        Debug.exit((Logger)logger, (String)ScannerView.class.getName(), (String)"programSearch");
        return null;
    }

    private EngineShell.EngineListener getProgramsCommandListener() {
        if (this.programsCommandListener == null) {
            this.programsCommandListener = new EngineShell.EngineListener(){

                public void statusUpdate(EngineShell.EngineStatus es) {
                    switch (es) {
                        case Paused: {
                            ScannerView.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!ScannerView.this.parent.isDisposed()) {
                                        if (ScannerView.this.retrieveMoreProgramsView != null) {
                                            ScannerView.this.retrieveMoreProgramsView.show();
                                        }
                                        ScannerView.this.parent.setCursor(null);
                                    }
                                }
                            });
                            break;
                        }
                        case Complete: {
                            ScannerView.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!ScannerView.this.parent.isDisposed()) {
                                        if (ScannerView.this.retrieveMoreProgramsView != null) {
                                            ScannerView.this.retrieveMoreProgramsView.hide();
                                        }
                                        ScannerView.this.parent.setCursor(ScannerView.this.parent.getDisplay().getSystemCursor(0));
                                        if (ScannerView.this.dummyTreeItem != null) {
                                            ScannerView.this.dummyTreeItem.dispose();
                                            ScannerView.this.dummyTreeItem = null;
                                        }
                                    }
                                }
                            });
                            break;
                        }
                        case Error: {
                            ScannerView.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!ScannerView.this.parent.isDisposed()) {
                                        if (ScannerView.this.retrieveMoreProgramsView != null) {
                                            ScannerView.this.retrieveMoreProgramsView.hide();
                                        }
                                        ScannerView.this.parent.setCursor(ScannerView.this.parent.getDisplay().getSystemCursor(0));
                                        if (ScannerView.this.dummyTreeItem != null) {
                                            ScannerView.this.dummyTreeItem.dispose();
                                            ScannerView.this.dummyTreeItem = null;
                                        }
                                    }
                                }
                            });
                        }
                        case Cancelled: {
                            ScannerView.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!ScannerView.this.parent.isDisposed()) {
                                        if (ScannerView.this.retrieveMoreProgramsView != null) {
                                            ScannerView.this.retrieveMoreProgramsView.hide();
                                        }
                                        ScannerView.this.parent.setCursor(ScannerView.this.parent.getDisplay().getSystemCursor(0));
                                    }
                                }
                            });
                        }
                    }
                }

                public void notifyResultCount(int count) {
                }

                public void dataAvailable(final Collection<Object> items) {
                    if (ScannerView.this.display != null) {
                        ScannerView.this.display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    if (items.size() > 0) {
                                        ScannerView.this.insertPrograms(items);
                                    }
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                        });
                    }
                }
            };
        }
        return this.programsCommandListener;
    }

    private TreeItem createDsnItem(Resource dsn) {
        Debug.enter((Logger)logger, (String)ScannerView.class.getName(), (String)"createDsnItem", (Object)("Thread ID: " + Thread.currentThread().getId()));
        TreeItem dsnItem = (TreeItem)this.scannerTree.getData(dsn.getName());
        if (dsnItem == null || dsnItem.isDisposed()) {
            dsnItem = new TreeItem(this.root, 0);
            dsnItem.setData(DSN, (Object)dsn);
            dsnItem.setData(COUNT, (Object)0);
            dsnItem.setText(ResourceRenderer.asText(dsn));
            dsnItem.setImage(ImageFactory.getFolderImage());
            this.scannerTree.setData(dsn.getName(), (Object)dsnItem);
            ++this.searchCount;
        }
        Debug.exit((Logger)logger, (String)ScannerView.class.getName(), (String)"createDsnItem");
        return dsnItem;
    }

    private TreeItem createProgramItem(Program program, TreeItem dsnItem, Resource dsn) {
        Debug.enter((Logger)logger, (String)ScannerView.class.getName(), (String)"createProgramItem", (Object)("Thread ID: " + Thread.currentThread().getId()));
        TreeItem programItem = (TreeItem)dsnItem.getData(program.getName());
        if (programItem == null || programItem.isDisposed()) {
            programItem = new TreeItem(dsnItem, 0, this.getInsertIndexPoint(dsnItem, ResourceRenderer.asText((Resource)program)));
            programItem.setData(PROGRAM, (Object)program);
            programItem.setData(COUNT, (Object)0);
            programItem.setText(ResourceRenderer.asText((Resource)program));
            programItem.setImage(ResourceRenderer.asImage(program));
            dsnItem.setData(program.getName(), (Object)programItem);
            int count = (Integer)dsnItem.getData(COUNT);
            dsnItem.setData(COUNT, (Object)(++count));
            dsnItem.setText(String.valueOf(ResourceRenderer.asText(dsn)) + " (" + count + ")");
            programItem.setData(SEARCH_IN_PROGRESS_ITEM, (Object)UIUtilities.createDummyTreeItem(programItem));
            this.retrieveMoreProgramsView.setParentItem(dsnItem);
        }
        Debug.exit((Logger)logger, (String)ScannerView.class.getName(), (String)"createProgramItem");
        return programItem;
    }

    private void insertPrograms(Collection<Object> items) {
        Debug.enter((Logger)logger, (String)ScannerView.class.getName(), (String)"insertPrograms", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (!this.scannerTree.isDisposed()) {
            this.scannerTree.setRedraw(false);
            if (this.dummyTreeItem != null) {
                this.dummyTreeItem.dispose();
            }
            for (Object item : items) {
                if (!(item instanceof Resource[])) continue;
                Resource[] resources = (Resource[])item;
                Resource dsn = resources[0];
                Program program = (Program)resources[1];
                TreeItem dsnItem = this.createDsnItem(dsn);
                this.createProgramItem(program, dsnItem, dsn);
            }
            this.scannerTree.setRedraw(true);
        }
        Debug.exit((Logger)logger, (String)ScannerView.class.getName(), (String)"insertPrograms");
    }

    private void csectSearch(Program program, Resource dsn) {
        Debug.enter((Logger)logger, (String)ScannerView.class.getName(), (String)"csectSearch", (Object)("Thread ID: " + Thread.currentThread().getId()));
        IConnectable resourceManager = ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.ia.connection.db2");
        if (!resourceManager.isConnected()) {
            return;
        }
        if (this.scannerTree != null) {
            this.csectsCommand = new FindCSectsCommand(program, dsn);
            this.csectsCommand.addListener(this.getCSectsCommandListener());
            this.retrieveMoreCsectsPresenter.setCommand((Command)this.csectsCommand);
            this.parent.setCursor(this.parent.getDisplay().getSystemCursor(3));
            this.findResourceJob = new JobWithCancelingSupport(this.getTaskName()){

                protected void cancelingSub() {
                    if (ScannerView.this.csectsCommand != null) {
                        ScannerView.this.csectsCommand.cancel();
                    }
                    IAPlugin.getDefault().taskEnded();
                }

                protected IStatus runSub(IProgressMonitor monitor) {
                    Debug.enter((Logger)logger, (String)"ScannerView.csectSearch().findResourceJob", (String)"runSub", (Object)("Thread ID: " + Thread.currentThread().getId()));
                    Activator.getDefault().ensureConnected();
                    monitor.beginTask(ScannerView.this.getTaskName(), -1);
                    if (ScannerView.this.csectsCommand != null) {
                        ScannerView.this.csectsCommand.setAsync(false);
                        ScannerView.this.csectsCommand.start();
                    }
                    monitor.done();
                    IAPlugin.getDefault().taskEnded();
                    Debug.exit((Logger)logger, (String)"ScannerView.csectSearch().findResourceJob", (String)"runSub");
                    return Status.OK_STATUS;
                }
            };
            this.retrieveMoreCsectsPresenter.setTaskName(this.getTaskName());
            this.findResourceJob.schedule();
        }
        Debug.exit((Logger)logger, (String)ScannerView.class.getName(), (String)"csectSearch");
    }

    private EngineShell.EngineListener getCSectsCommandListener() {
        if (this.csectsCommandListener == null) {
            this.csectsCommandListener = new EngineShell.EngineListener(){

                public void statusUpdate(EngineShell.EngineStatus es) {
                    switch (es) {
                        case Paused: {
                            ScannerView.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!ScannerView.this.parent.isDisposed()) {
                                        if (ScannerView.this.retrieveMoreCsectsView != null) {
                                            ScannerView.this.retrieveMoreCsectsView.show();
                                        }
                                        ScannerView.this.parent.setCursor(null);
                                    }
                                }
                            });
                            break;
                        }
                        case Complete: {
                            ScannerView.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!ScannerView.this.parent.isDisposed()) {
                                        if (ScannerView.this.retrieveMoreCsectsView != null) {
                                            ScannerView.this.retrieveMoreCsectsView.hide();
                                        }
                                        ScannerView.this.parent.setCursor(ScannerView.this.parent.getDisplay().getSystemCursor(0));
                                    }
                                }
                            });
                            break;
                        }
                        case Error: {
                            ScannerView.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!ScannerView.this.parent.isDisposed()) {
                                        if (ScannerView.this.retrieveMoreCsectsView != null) {
                                            ScannerView.this.retrieveMoreCsectsView.hide();
                                        }
                                        ScannerView.this.parent.setCursor(ScannerView.this.parent.getDisplay().getSystemCursor(0));
                                    }
                                }
                            });
                        }
                        case Cancelled: {
                            ScannerView.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!ScannerView.this.parent.isDisposed()) {
                                        if (ScannerView.this.retrieveMoreCsectsView != null) {
                                            ScannerView.this.retrieveMoreCsectsView.hide();
                                        }
                                        ScannerView.this.parent.setCursor(ScannerView.this.parent.getDisplay().getSystemCursor(0));
                                    }
                                }
                            });
                        }
                    }
                }

                public void notifyResultCount(int count) {
                }

                public void dataAvailable(final Collection<Object> items) {
                    if (ScannerView.this.display != null) {
                        ScannerView.this.display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    ScannerView.this.insertCSects(items);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                        });
                    }
                }
            };
        }
        return this.csectsCommandListener;
    }

    private void insertCSects(Collection<Object> items) {
        Debug.enter((Logger)logger, (String)ScannerView.class.getName(), (String)"insertCSects", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (!this.scannerTree.isDisposed()) {
            this.scannerTree.setRedraw(false);
            this.csectsSearchInProgressItem.dispose();
            for (CSect cSect : items) {
                TreeItem dsnItem;
                Resource dsn = cSect.getDsn();
                Program program = cSect.getProgram();
                TreeItem programItem = this.createProgramItem(program, dsnItem = this.createDsnItem(dsn), dsn);
                TreeItem csectItem = (TreeItem)programItem.getData(cSect.getName());
                if (csectItem != null && !csectItem.isDisposed()) continue;
                csectItem = new TreeItem(programItem, 0, this.getInsertIndexPoint(programItem, cSect.getName()));
                csectItem.setData(CSECT, (Object)cSect);
                csectItem.setText(cSect.getName());
                csectItem.setImage(ImageFactory.getCSectImage());
                programItem.setData(cSect.getName(), (Object)csectItem);
                int count = (Integer)programItem.getData(COUNT);
                programItem.setData(COUNT, (Object)(++count));
                programItem.setText(String.valueOf(ResourceRenderer.asText((Resource)program)) + " (" + count + ")");
                this.retrieveMoreCsectsView.setParentItem(programItem);
            }
            this.scannerTree.setRedraw(true);
        }
        Debug.exit((Logger)logger, (String)ScannerView.class.getName(), (String)"insertCSects");
    }

    private void clear() {
        Debug.enter((Logger)logger, (String)ScannerView.class.getName(), (String)"clear", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.scannerTree.setRedraw(false);
        if (this.dummyTreeItem != null) {
            this.dummyTreeItem.dispose();
        }
        this.root.removeAll();
        this.scannerTree.setRedraw(true);
        if (this.navigatorView.getSelectionProvider() != null) {
            this.navigatorView.getSelectionProvider().setSelection((ISelection)StructuredSelection.EMPTY);
        }
        if (this.retrieveMoreProgramsView != null) {
            this.retrieveMoreProgramsView.hide();
        }
        if (this.retrieveMoreCsectsView != null) {
            this.retrieveMoreCsectsView.hide();
        }
        Debug.exit((Logger)logger, (String)ScannerView.class.getName(), (String)"clear");
    }

    private ConnectionServiceListener getConnectionServiceListener() {
        return new ConnectionServiceListener(){

            public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
                if ("com.ibm.cics.ia.connection.db2".equals(event.getConnectionCategoryId())) {
                    if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                        this.connected();
                    } else if (event instanceof ConnectionServiceListener.DisconnectedEvent) {
                        this.disconnected();
                    }
                }
            }

            public void connected() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ScannerView.this.scannerTree != null) {
                            ScannerView.this.dummyTreeItem = NavigatorView.createDummyIfNotExists(ScannerView.this.dummyTreeItem, ScannerView.this.root);
                            if (ScannerView.this.csectsCommand != null && ScannerView.this.csectsCommand.status() == 3) {
                                ScannerView.this.csectsCommand.cancel();
                            }
                            if (ScannerView.this.programCommand != null && ScannerView.this.programCommand.status() == 3) {
                                ScannerView.this.programCommand.cancel();
                            }
                        }
                    }
                });
            }

            public void disconnected() {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ScannerView.this.clear();
                    }
                });
            }
        };
    }

    private int getInsertIndexPoint(TreeItem parent, String itemName) {
        TreeItem[] childItems = parent.getItems();
        if (childItems.length > 0) {
            int i = 0;
            while (i < childItems.length) {
                int result = itemName.compareToIgnoreCase(childItems[i].getText());
                if (result < 0) {
                    return i;
                }
                ++i;
            }
            return childItems.length;
        }
        return 0;
    }

    public TreeItem getRoot() {
        return this.root;
    }

    public void buildPopupMenu(IMenuManager manager, TreeItem[] selectedItems) {
        if (selectedItems.length == 1) {
            TreeItem item = selectedItems[0];
            if (item == this.root) {
                manager.add((IAction)this.refreshAction);
            }
            this.showMenu(manager, item);
        }
    }

    public void rootExpanded() {
        if (NavigatorView.canRunCommand((SQLCommand)this.programCommand) && UIUtilities.widgetExists((Widget)this.dummyTreeItem) && NavigatorView.isConnected()) {
            this.clear();
            this.programSearch();
        }
    }

    public void selected() {
        this.navigatorView.createDummyTopComposite();
    }

    public void refresh(final Action afterRefreshAction) {
        this.clear();
        Job runJob = this.programSearch();
        if (runJob != null) {
            runJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    afterRefreshAction.run();
                }
            });
        } else {
            afterRefreshAction.run();
        }
    }
}

