/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.eclipse.common.editor.EditorHelper;
import com.ibm.cics.eclipse.common.ui.TextInput;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.ReportManager;
import com.ibm.cics.ia.ui.UIUtilities;
import com.ibm.cics.ia.ui.actions.Messages;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.logging.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SaveReportDialog
extends TitleAreaDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(SaveReportDialog.class.getPackage().getName());
    private Composite editComposite;
    private TreeItem itemToRename;
    private TreeEditor treeEditor;
    private Tree tree;
    private Button newFolderButton;
    private Button detailedCheckBox;
    private Text newFileText;
    private IContainer container = null;
    private String fileName = null;
    private boolean detailed = false;
    private boolean overwrite = false;
    private static String HTML_EXTENSION = ".html";
    private boolean detailsEnabled;
    private ReportManager reportManager;

    public SaveReportDialog(Shell parentShell, boolean detailsEnabled) {
        super(parentShell);
        this.detailsEnabled = detailsEnabled;
        this.setTitle(Messages.getString("SaveReportDialog.title.text"));
        this.setTitleImage(ImageFactory.getReportWizardImage());
    }

    protected Control createDialogArea(Composite parent) {
        Debug.enter((Logger)logger, (String)SaveReportDialog.class.getName(), (String)"createDialogArea", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)gridLayout);
        Label folderLabel = new Label(composite, 0);
        folderLabel.setText(Messages.getString("SaveReportDialog.selectFolder.message"));
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        folderLabel.setLayoutData((Object)gridData);
        FormToolkit toolkit = EditorHelper.getFormToolkit();
        this.tree = new Tree(composite, 2048);
        this.treeEditor = new TreeEditor(this.tree);
        this.reportManager = ReportManager.createReportManager(ReportManager.Type.folders);
        this.reportManager.setTree(this.tree);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        gridData.heightHint = 350;
        this.tree.setLayoutData((Object)gridData);
        this.newFolderButton = new Button(composite, 0);
        this.newFolderButton.setText(Messages.getString("SaveReportDialog.IFolder.newfolder"));
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 16384;
        gridData.horizontalSpan = 2;
        this.newFolderButton.setLayoutData((Object)gridData);
        Label fileLabel = new Label(composite, 0);
        fileLabel.setText(Messages.getString("SaveReportDialog.fileName.message"));
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 16384;
        fileLabel.setLayoutData((Object)gridData);
        this.newFileText = new Text(composite, 2052);
        TextInput.setAccessibleLabel((Text)this.newFileText, (Label)fileLabel);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        this.newFileText.setLayoutData((Object)gridData);
        this.detailedCheckBox = new Button(composite, 32);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        this.detailedCheckBox.setLayoutData((Object)gridData);
        this.detailedCheckBox.setText(Messages.getString("SaveReportDialog.DetailedButton.text"));
        this.detailedCheckBox.setEnabled(this.detailsEnabled);
        this.detailedCheckBox.setSelection(false);
        this.newFolderButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Debug.enter((Logger)logger, (String)"SaveReportDialog.createDialogArea().newFolderButton", (String)"widgetSelected", (Object)("Thread ID: " + Thread.currentThread().getId()));
                IContainer currentContainer = SaveReportDialog.this.getCurrentContainer();
                try {
                    IResource resource;
                    Path path = new Path("/");
                    IFolder newFolder = currentContainer.getFolder(path.append(Messages.getString("SaveReportDialog.IFolder.newfolder")));
                    int i = 2;
                    while (SaveReportDialog.this.reportManager.folderExists(currentContainer, newFolder.getName())) {
                        newFolder = currentContainer.getFolder(path.append(MessageFormat.format(Messages.getString("SaveReportDialog.IFolder.newFolderNum"), Integer.toString(i++))));
                    }
                    newFolder.create(true, true, null);
                    TreeItem[] items = SaveReportDialog.this.tree.getSelection();
                    TreeItem item = null;
                    if (items.length > 0 && !((resource = (IResource)(item = items[0]).getData("IRESOURCE")) instanceof IFolder)) {
                        item = item.getParentItem();
                    }
                    SaveReportDialog.this.reportManager.refresh(currentContainer);
                    TreeItem newFolderItem = SaveReportDialog.this.reportManager.getTreeItem((IResource)newFolder);
                    SaveReportDialog.this.fireRenameFocusEvent(newFolderItem);
                    Debug.exit((Logger)logger, (String)"SaveReportDialog.createDialogArea().newFolderButton", (String)"widgetSelected");
                }
                catch (Exception ex) {
                    Debug.warning((Logger)logger, (String)"SaveReportDialog.createDialogArea().newFolderButton", (String)"widgetSelected", (Throwable)ex, new HashMap());
                    IAPlugin.getDefault().logError("Unable to create new folder", (Throwable)ex);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Listener focusOutListener = new Listener(){

            public void handleEvent(Event event) {
                if (IAUtilities.isValidFilename((String)SaveReportDialog.this.newFileText.getText())) {
                    SaveReportDialog.this.updateOkStatus(true);
                } else {
                    SaveReportDialog.this.updateOkStatus(false);
                }
            }
        };
        Listener keyUpListener = new Listener(){

            public void handleEvent(Event event) {
                if (IAUtilities.isValidFilename((String)SaveReportDialog.this.newFileText.getText())) {
                    SaveReportDialog.this.updateOkStatus(true);
                } else {
                    SaveReportDialog.this.updateOkStatus(false);
                }
            }
        };
        this.newFileText.addListener(16, focusOutListener);
        this.newFileText.addListener(2, keyUpListener);
        this.refresh();
        Debug.exit((Logger)logger, (String)SaveReportDialog.class.getName(), (String)"createDialogArea");
        return composite;
    }

    private String addExtension(String fileName) {
        return String.valueOf(fileName) + HTML_EXTENSION;
    }

    private boolean duplicateFileName() {
        String name = this.addExtension(this.newFileText.getText());
        IContainer container = this.getCurrentContainer();
        return container != null && container.findMember(name) != null;
    }

    private void refresh() {
        this.tree.removeAll();
        this.reportManager.refresh();
        UIUtilities.expandTree(this.tree, true);
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.setMessage(Messages.getString("SaveReportDialog.message.text"));
        return result;
    }

    protected Control createButtonBar(Composite parent) {
        Control createButtonBar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return createButtonBar;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("SaveReportDialog.title.text"));
    }

    protected void okPressed() {
        Debug.enter((Logger)logger, (String)SaveReportDialog.class.getName(), (String)"okPressed", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.overwrite = false;
        IContainer container = this.getCurrentContainer();
        String path = container.getProjectRelativePath().addTrailingSeparator().toOSString();
        String fileName = this.addExtension(this.newFileText.getText());
        if (this.duplicateFileName()) {
            MessageBox box = new MessageBox(this.getShell(), 196);
            box.setMessage(MessageFormat.format(Messages.getString("SaveReportDialog.save.fileExists"), String.valueOf(path) + fileName));
            box.setText(Messages.getString("SaveReportDialog.save.confirmOverwrite"));
            int result = box.open();
            if (result == 128) {
                return;
            }
            this.container = container;
            this.fileName = fileName;
            this.overwrite = true;
            this.detailed = this.detailedCheckBox.getSelection();
            super.okPressed();
        } else {
            this.container = container;
            this.fileName = fileName;
            this.detailed = this.detailedCheckBox.getSelection();
            super.okPressed();
        }
        Debug.exit((Logger)logger, (String)SaveReportDialog.class.getName(), (String)"okPressed");
    }

    protected void updateOkStatus(boolean status) {
        this.getButton(0).setEnabled(status);
    }

    public boolean close() {
        ReportManager.removeReportManager(this.reportManager);
        return super.close();
    }

    private IContainer getCurrentContainer() {
        Debug.enter((Logger)logger, (String)SaveReportDialog.class.getName(), (String)"getCurrentContainer", (Object)("Thread ID: " + Thread.currentThread().getId()));
        TreeItem[] items = this.tree.getSelection();
        if (items.length == 0) {
            return (IContainer)this.tree.getData("IRESOURCE");
        }
        TreeItem item = items[0];
        IResource resource = (IResource)item.getData("IRESOURCE");
        Debug.exit((Logger)logger, (String)SaveReportDialog.class.getName(), (String)"getCurrentContainer");
        return resource instanceof IFolder ? (IContainer)resource : resource.getParent();
    }

    protected void fireRenameFocusEvent(TreeItem newFolderItem) {
        Debug.enter((Logger)logger, (String)SaveReportDialog.class.getName(), (String)"fireRenameFocusEvent", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.editComposite != null && !this.editComposite.isDisposed()) {
            this.editComposite.dispose();
        }
        Event e = new Event();
        e.item = newFolderItem;
        this.tree.setSelection(newFolderItem);
        this.renameTreeItem(newFolderItem);
        this.tree.setSelection(newFolderItem);
        Debug.exit((Logger)logger, (String)SaveReportDialog.class.getName(), (String)"fireRenameFocusEvent");
    }

    private void renameTreeItem(final TreeItem aTreeItem) {
        Debug.enter((Logger)logger, (String)SaveReportDialog.class.getName(), (String)"renameTreeItem", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.editComposite = new Composite((Composite)this.tree, 0);
        final Text editText = new Text(this.editComposite, 2048);
        this.editComposite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Rectangle rect = SaveReportDialog.this.editComposite.getClientArea();
                editText.setBounds(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
            }
        });
        Listener focusOutListener = new Listener(){

            public void handleEvent(Event event) {
                Debug.enter((Logger)logger, (String)"SaveReportDialog.renameTreeItem().focusOutListener", (String)"handleEvent", (Object)("Thread ID: " + Thread.currentThread().getId()));
                String name = editText.getText();
                IResource resource = (IResource)aTreeItem.getData("IRESOURCE");
                if (resource instanceof IFolder) {
                    SaveReportDialog.this.itemToRename = aTreeItem;
                    IContainer parent2 = resource.getParent();
                    if (parent2.findMember(name) != null) {
                        SaveReportDialog.this.editComposite.dispose();
                        event.doit = false;
                        return;
                    }
                    aTreeItem.setText(editText.getText());
                    SaveReportDialog.this.updateName(editText.getText(), aTreeItem);
                    SaveReportDialog.this.editComposite.dispose();
                    event.doit = false;
                }
                if (!SaveReportDialog.this.checkUserInput(name)) {
                    event.doit = false;
                    return;
                }
                aTreeItem.setText(editText.getText());
                SaveReportDialog.this.updateName(editText.getText(), aTreeItem);
                SaveReportDialog.this.editComposite.dispose();
                event.doit = false;
                Debug.exit((Logger)logger, (String)"SaveReportDialog.renameTreeItem().focusOutListener", (String)"handleEvent");
            }
        };
        Listener verifyListener = new Listener(){

            public void handleEvent(Event event) {
                Debug.enter((Logger)logger, (String)"SaveReportDialog.renameTreeItem().verifyListener", (String)"handleEvent", (Object)("Thread ID: " + Thread.currentThread().getId()));
                String newText = editText.getText();
                String leftText = newText.substring(0, event.start);
                String rightText = newText.substring(event.end, newText.length());
                GC gc = new GC((Drawable)editText);
                Point size = gc.textExtent(String.valueOf(leftText) + event.text + rightText);
                gc.dispose();
                size = editText.computeSize(size.x, -1);
                ((SaveReportDialog)SaveReportDialog.this).treeEditor.horizontalAlignment = 16384;
                Rectangle itemRect = aTreeItem.getBounds();
                Rectangle rect = SaveReportDialog.this.tree.getClientArea();
                ((SaveReportDialog)SaveReportDialog.this).treeEditor.minimumWidth = Math.max(size.x, itemRect.width) + 2;
                int left = itemRect.x;
                int right = rect.x + rect.width;
                ((SaveReportDialog)SaveReportDialog.this).treeEditor.minimumWidth = Math.min(((SaveReportDialog)SaveReportDialog.this).treeEditor.minimumWidth, right - left);
                ((SaveReportDialog)SaveReportDialog.this).treeEditor.minimumHeight = size.y + 2;
                SaveReportDialog.this.treeEditor.layout();
                Debug.exit((Logger)logger, (String)"SaveReportDialog.renameTreeItem().verifyListener", (String)"handleEvent");
            }
        };
        Listener traverseListener = new Listener(){

            public void handleEvent(Event event) {
                Debug.enter((Logger)logger, (String)"SaveReportDialog.renameTreeItem().traverseListener", (String)"handleEvent", (Object)("Thread ID: " + Thread.currentThread().getId()));
                if (event.detail == 4) {
                    String name = editText.getText();
                    IResource resource = (IResource)aTreeItem.getData("IRESOURCE");
                    if (resource instanceof IFolder) {
                        SaveReportDialog.this.itemToRename = aTreeItem;
                        IContainer parent2 = resource.getParent();
                        if (parent2.findMember(name) != null) {
                            SaveReportDialog.this.editComposite.dispose();
                            event.doit = false;
                            Debug.exit((Logger)logger, (String)"SaveReportDialog.renameTreeItem().traverseListener", (String)"handleEvent");
                            return;
                        }
                    }
                    if (!SaveReportDialog.this.checkUserInput(name)) {
                        event.doit = false;
                        Debug.exit((Logger)logger, (String)"SaveReportDialog.renameTreeItem().traverseListener", (String)"handleEvent");
                        return;
                    }
                    IFolder folder = SaveReportDialog.this.getCurrentContainer().getFolder(new Path(name).addTrailingSeparator());
                    if (folder.exists()) {
                        SaveReportDialog.this.editComposite.dispose();
                        event.doit = false;
                        Debug.exit((Logger)logger, (String)"SaveReportDialog.renameTreeItem().traverseListener", (String)"handleEvent");
                        return;
                    }
                    aTreeItem.setText(editText.getText());
                    SaveReportDialog.this.updateName(editText.getText(), aTreeItem);
                    SaveReportDialog.this.editComposite.dispose();
                    event.doit = false;
                } else if (event.detail == 2) {
                    SaveReportDialog.this.editComposite.dispose();
                    event.doit = false;
                }
                Debug.exit((Logger)logger, (String)"SaveReportDialog.renameTreeItem().traverseListener", (String)"handleEvent");
            }
        };
        editText.addListener(25, verifyListener);
        editText.addListener(31, traverseListener);
        this.treeEditor.setEditor((Control)this.editComposite, aTreeItem);
        editText.setText(aTreeItem.getText());
        editText.selectAll();
        editText.setFocus();
        Debug.exit((Logger)logger, (String)SaveReportDialog.class.getName(), (String)"renameTreeItem");
    }

    private boolean checkUserInput(String name) {
        if (!IAUtilities.hasContent((String)name) || !IAUtilities.isValidFilename((String)name)) {
            this.editComposite.dispose();
            return false;
        }
        return true;
    }

    private IContainer getContainerForItemToRename() {
        if (this.itemToRename != null) {
            IResource resource = (IResource)this.itemToRename.getData("IRESOURCE");
            return resource instanceof IFolder ? (IContainer)resource : resource.getParent();
        }
        return null;
    }

    public void updateName(String newName, TreeItem selectedItem) {
        Debug.enter((Logger)logger, (String)SaveReportDialog.class.getName(), (String)"updateName", (Object)("Thread ID: " + Thread.currentThread().getId()));
        IResource resource = (IResource)selectedItem.getData("IRESOURCE");
        if (resource instanceof IFolder) {
            IFolder folder = (IFolder)resource;
            Path path = new Path(newName);
            IPath newPath = path.addTrailingSeparator();
            try {
                this.reportManager.removeTreeItem((IResource)folder);
                folder.refreshLocal(2, null);
                folder.move(newPath, true, null);
                folder = folder.getParent().getFolder(newPath);
                selectedItem.setData("IRESOURCE", (Object)folder);
                this.reportManager.setTreeItem((IResource)folder, selectedItem);
                this.reportManager.refresh(this.getCurrentContainer());
            }
            catch (Exception e) {
                Debug.warning((Logger)logger, (String)SaveReportDialog.class.getName(), (String)"updateName", (Throwable)e, new HashMap());
                IAPlugin.getDefault().logError("Unable to rename folder", (Throwable)e);
            }
        } else {
            IFile iFile = (IFile)resource;
            Path path = new Path(newName);
            try {
                iFile.move((IPath)path, true, null);
            }
            catch (CoreException ex) {
                Debug.warning((Logger)logger, (String)SaveReportDialog.class.getName(), (String)"updateName", (Throwable)ex, new HashMap());
                IAPlugin.getDefault().logError("Unable to rename file", (Throwable)ex);
            }
        }
        Debug.exit((Logger)logger, (String)SaveReportDialog.class.getName(), (String)"updateName");
    }

    public String getFileName() {
        return this.fileName;
    }

    public IContainer getContainer() {
        return this.container;
    }

    public boolean isOverwriting() {
        return this.overwrite;
    }

    public boolean isDetailed() {
        return this.detailed;
    }
}

