/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.command.EngineShell;
import com.ibm.cics.dbfunc.ui.ScrollLimitManager;
import com.ibm.cics.eclipse.common.ui.JobWithCancelingSupport;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.commands.ResourceVisualizationByIACommand;
import com.ibm.cics.ia.commands.ResourceVisualizationByTSCommand;
import com.ibm.cics.ia.commands.ResourceVisualizationByTransactionsCommand;
import com.ibm.cics.ia.model.IAApplication;
import com.ibm.cics.ia.model.Platform;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.TSApplication;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.model.viz.INestedNode;
import com.ibm.cics.ia.model.viz.INode;
import com.ibm.cics.ia.model.viz.NestedNode;
import com.ibm.cics.ia.model.viz.Node;
import com.ibm.cics.ia.model.viz.RootNode;
import com.ibm.cics.ia.runtime.Version;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.CaptureEPSpecMenu;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.ResourceConnectionsView;
import com.ibm.cics.ia.ui.viz.ResourceConnEditorInput;
import com.ibm.cics.ia.ui.viz.ResourceVisualizationEditPartFactory;
import com.ibm.cics.ia.ui.viz.ResourceVizEditorInput;
import com.ibm.cics.ia.ui.viz.ResourceVizualizationKeyHandler;
import com.ibm.cics.ia.ui.viz.editparts.NestedResourceEditPart;
import com.ibm.cics.ia.ui.viz.editparts.ResourceNodeEditPart;
import com.ibm.cics.ia.ui.viz.editparts.RootNodeEditPart;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.draw2d.parts.Thumbnail;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.SelectionManager;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.print.PrintGraphicalViewerOperation;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class ResourceVisualizationView
extends GraphicalEditor {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ResourceVisualizationView.class.getPackage().getName());
    public static String ID = "com.ibm.cics.ia.ui.ResourceVisualizationView";
    private ScrollingGraphicalViewer viewer;
    private Display display;
    private IASQLCommand resourceVisualizationCommand;
    private EngineShell.EngineListener commandListener;
    ScrollLimitManager scrollLimitManager;
    private Action swapAction;
    private Action maximiseAction;
    private Action minimiseAction;
    private Action showConnectionsAction;
    private Action printAction;
    private String mode = ResourceVizEditorInput.MODE_TS_APPLICATIONS_BY_PLATFORMS;
    RootNode rootNode;
    Composite rootComp;
    Control viewerControl;
    Job discoverResourcesJob;
    private OutlinePage outlinePage;
    private ToolBar topToolbar;
    private ToolBarManager toolBar;
    private ConnectionServiceListener connectionServiceListener = new ConnectionServiceListener(){

        public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
            if ("com.ibm.cics.ia.connection.db2".equals(event.getConnectionCategoryId()) && event instanceof ConnectionServiceListener.DisconnectedEvent) {
                this.disconnected();
            }
        }

        public void disconnected() {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ResourceVisualizationView.this.clear();
                }
            });
        }
    };

    public void createPartControl(Composite parent) {
        Debug.enter((Logger)logger, (String)ResourceVisualizationView.class.getName(), (String)"createPartControl", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.display = parent.getDisplay();
        this.rootComp = new Composite(parent, 4);
        this.rootComp.setLayout((Layout)new GridLayout(1, true));
        this.topToolbar = new ToolBar(this.rootComp, 8388928);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.topToolbar.setLayoutData((Object)data);
        Composite viewComp = new Composite(this.rootComp, 2052);
        viewComp.setLayout((Layout)new GridLayout(1, true));
        viewComp.setBackground(ColorConstants.white);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        viewComp.setLayoutData((Object)data);
        this.viewer = new ScrollingGraphicalViewer();
        this.viewerControl = this.viewer.createControl(viewComp);
        this.viewer.getControl().setBackground(ColorConstants.white);
        this.viewer.setEditPartFactory((EditPartFactory)new ResourceVisualizationEditPartFactory());
        this.viewer.setRootEditPart((RootEditPart)new ScalableFreeformRootEditPart());
        this.viewer.setKeyHandler((KeyHandler)new ResourceVizualizationKeyHandler((GraphicalViewer)this.viewer));
        this.viewerControl.setLayoutData((Object)data);
        DefaultEditDomain eDomain = this.getEditDomain();
        eDomain.addViewer((EditPartViewer)this.viewer);
        this.viewer.setSelectionManager(new SelectionManager(){

            public void appendSelection(EditPart editpart) {
                this.deselectAll();
                super.appendSelection(editpart);
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Debug.enter((Logger)logger, (String)"ResourceVisualizationView.createPartControl.viewer.SelectionChangedListener", (String)"selectionChanged", (Object)("Thread ID: " + Thread.currentThread().getId()));
                ResourceVisualizationView.this.changeActionsEnablement();
                Debug.exit((Logger)logger, (String)"ResourceVisualizationView.createPartControl.viewer.SelectionChangedListener", (String)"selectionChanged");
            }
        });
        this.scrollLimitManager = new ScrollLimitManager(this.rootComp, Messages.getString("QueryResultsView.txt.resource"), (IWorkbenchPart)this){

            public void scrollLimitReached(Command command) {
                super.scrollLimitReached(command);
                ResourceVisualizationView.this.rootComp.layout(new Control[]{ResourceVisualizationView.this.viewerControl, ResourceVisualizationView.this.scrollLimitManager.scrollLimitComposite});
            }

            public void dispose() {
                ResourceVisualizationView.this.rootComp.layout(new Control[]{ResourceVisualizationView.this.viewerControl});
                super.dispose();
            }
        };
        this.scrollLimitManager.setTaskName(this.getTaskName());
        this.createActions();
        final MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Object object;
                menuMgr.add((IAction)ResourceVisualizationView.this.showConnectionsAction);
                menuMgr.add((IContributionItem)new Separator());
                ISelection selection = ResourceVisualizationView.this.viewer.getSelection();
                if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && ((object = ((IStructuredSelection)ResourceVisualizationView.this.viewer.getSelection()).getFirstElement()) instanceof NestedResourceEditPart || object instanceof ResourceNodeEditPart)) {
                    AbstractEditPart editPart = (AbstractEditPart)object;
                    INode resourceNode = (INode)editPart.getModel();
                    Resource resource = (Resource)resourceNode.getObject();
                    INestedNode parentNode = resourceNode.getParent();
                    Region region = null;
                    while (parentNode != null) {
                        Object parent = parentNode.getObject();
                        if (parent != null && parent instanceof Region) {
                            region = (Region)parent;
                            break;
                        }
                        parentNode = parentNode.getParent();
                    }
                    CaptureEPSpecMenu.createResourceActions(manager, resource, region);
                }
                menuMgr.add((IContributionItem)new Separator("additions"));
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.rootComp.pack();
        IWorkbenchHelpSystem helpSystem = this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)parent, "com.ibm.cics.ia.help.resource_visualization_view");
        Debug.exit((Logger)logger, (String)ResourceVisualizationView.class.getName(), (String)"createPartControl");
    }

    private void changeActionsEnablement() {
        Debug.enter((Logger)logger, (String)ResourceVisualizationView.class.getName(), (String)"changeActionsEnablement()", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.viewer != null && this.rootNode != null && this.rootNode.getChildren().size() > 0) {
            Object element;
            this.maximiseAction.setEnabled(true);
            this.minimiseAction.setEnabled(true);
            this.swapAction.setEnabled(true);
            ISelection selection = this.viewer.getSelection();
            if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && ((element = ((IStructuredSelection)selection).getFirstElement()) instanceof ResourceNodeEditPart || element instanceof NestedResourceEditPart)) {
                INode resourceNode = (INode)((AbstractGraphicalEditPart)element).getModel();
                if (resourceNode.getObject() instanceof Program || resourceNode.getObject() instanceof Transaction) {
                    this.showConnectionsAction.setEnabled(true);
                } else {
                    this.showConnectionsAction.setEnabled(false);
                }
            }
        } else {
            this.showConnectionsAction.setEnabled(false);
            this.maximiseAction.setEnabled(false);
            this.minimiseAction.setEnabled(false);
            this.swapAction.setEnabled(false);
        }
        Debug.exit((Logger)logger, (String)ResourceVisualizationView.class.getName(), (String)"changeActionsEnablement()", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    public void createActions() {
        Debug.enter((Logger)logger, (String)ResourceVisualizationView.class.getName(), (String)"createActions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.swapAction = new Action(){

            public void run() {
                ResourceVisualizationView.this.swapTopItems();
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageDescriptor.createFromImage((Image)ImageFactory.getSwapImage());
            }
        };
        this.swapAction.setToolTipText(Messages.getString("ResourceVisualizationView.action.swap.Tooltip"));
        this.swapAction.setId("ResourceVisualizationView.action.swap");
        this.maximiseAction = new Action(){

            public void run() {
                List children;
                Debug.enter((Logger)logger, (String)"ResourceVisualizationView.createActions().maximiseAction", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                RootEditPart rootPart = ResourceVisualizationView.this.viewer.getRootEditPart();
                if (rootPart != null && (children = rootPart.getChildren()) != null && children.size() > 0 && ResourceVisualizationView.this.rootNode != null && children.get(0) instanceof RootNodeEditPart) {
                    ((RootNodeEditPart)((Object)children.get(0))).setExpanded(true, true);
                }
                Debug.exit((Logger)logger, (String)"ResourceVisualizationView.createActions().maximiseAction", (String)"run");
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageDescriptor.createFromImage((Image)ImageFactory.getExpandImage());
            }
        };
        this.maximiseAction.setToolTipText(Messages.getString("Button.tooltip.maximise"));
        this.maximiseAction.setId("ResourceVisualizationView.action.maximise");
        this.minimiseAction = new Action(){

            public void run() {
                List children;
                Debug.enter((Logger)logger, (String)"ResourceVisualizationView.createActions().minimiseAction", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                RootEditPart rootPart = ResourceVisualizationView.this.viewer.getRootEditPart();
                if (rootPart != null && (children = rootPart.getChildren()) != null && children.size() > 0 && ResourceVisualizationView.this.rootNode != null && children.get(0) instanceof RootNodeEditPart) {
                    ((RootNodeEditPart)((Object)children.get(0))).setExpanded(false, true);
                }
                Debug.exit((Logger)logger, (String)"ResourceVisualizationView.createActions().minimiseAction", (String)"run");
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageDescriptor.createFromImage((Image)ImageFactory.getCollapseImage());
            }
        };
        this.minimiseAction.setToolTipText(Messages.getString("Button.tooltip.minimise"));
        this.minimiseAction.setId("ResourceVisualizationView.action.minimise");
        this.showConnectionsAction = new Action(){

            public void run() {
                Object element;
                Debug.enter((Logger)logger, (String)"ResourceVisualizationView.createActions().new Action() {...}", (String)"run()");
                ISelection selection = ResourceVisualizationView.this.viewer.getSelection();
                if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && ((element = ((IStructuredSelection)selection).getFirstElement()) instanceof ResourceNodeEditPart || element instanceof NestedResourceEditPart)) {
                    INode resourceNode = (INode)((AbstractGraphicalEditPart)element).getModel();
                    Resource programOrTransaction = null;
                    Region region = null;
                    Platform platform = null;
                    TSApplication tsApplication = null;
                    Transaction transaction = null;
                    while (resourceNode.getParent() != null) {
                        if (programOrTransaction == null && (resourceNode.getObject() instanceof Program || resourceNode.getObject() instanceof Transaction)) {
                            programOrTransaction = (Resource)resourceNode.getObject();
                        }
                        if (resourceNode.getObject() instanceof Transaction) {
                            transaction = (Transaction)resourceNode.getObject();
                        }
                        if (resourceNode.getObject() instanceof Platform) {
                            platform = (Platform)resourceNode.getObject();
                        }
                        if (resourceNode.getObject() instanceof TSApplication) {
                            tsApplication = (TSApplication)resourceNode.getObject();
                        }
                        if (resourceNode.getObject() instanceof Region) {
                            region = (Region)resourceNode.getObject();
                        }
                        resourceNode = resourceNode.getParent();
                    }
                    if (programOrTransaction != null) {
                        ResourceConnEditorInput input = new ResourceConnEditorInput(programOrTransaction, region, platform, tsApplication, transaction);
                        ResourceConnectionsView connectionsView = Activator.getResourceConnectionsView(input);
                        connectionsView.runSearch();
                    }
                }
                Debug.exit((Logger)logger, (String)"ResourceVisualizationView.createActions().new Action() {...}", (String)"run()");
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageDescriptor.createFromImage((Image)ImageFactory.getResourceConnectionsImage());
            }
        };
        this.showConnectionsAction.setToolTipText(Messages.getString("ResourceVisualizationView.action.showConnections.Tooltip"));
        this.showConnectionsAction.setText(Messages.getString("ResourceVisualizationView.action.showConnections.Tooltip"));
        this.showConnectionsAction.setId("ResourceVisualizationView.action.showConnections");
        this.printAction = new Action(){

            public void run() {
                int style = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getStyle();
                Shell shell = new Shell((style & 0x8000000) != 0 ? 0x4000000 : 0);
                PrintDialog dialog = new PrintDialog(shell, 0);
                PrinterData data = dialog.open();
                if (data != null) {
                    PrintGraphicalViewerOperation operation = new PrintGraphicalViewerOperation(new Printer(data), (GraphicalViewer)ResourceVisualizationView.this.viewer);
                    operation.setPrintMode(1);
                    operation.run(Messages.getString("Printing.Operation"));
                }
            }
        };
        this.printAction.setText(Messages.getString("Print.Action"));
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.PRINT.getId(), (IAction)this.printAction);
        this.printAction.setEnabled(true);
        this.changeActionsEnablement();
        if (this.topToolbar != null && !this.topToolbar.isDisposed()) {
            this.toolBar = new ToolBarManager(this.topToolbar);
            this.toolBar.add((IAction)this.showConnectionsAction);
            this.toolBar.add((IAction)this.swapAction);
            this.toolBar.add((IContributionItem)new Separator());
            this.toolBar.add((IAction)this.minimiseAction);
            this.toolBar.add((IAction)this.maximiseAction);
            this.toolBar.update(true);
            this.toolBar.getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    if (e.childID > -1) {
                        String id = ResourceVisualizationView.this.toolBar.getItems()[e.childID].getId();
                        ActionContributionItem action = (ActionContributionItem)ResourceVisualizationView.this.toolBar.getItems()[e.childID];
                        if (id.equals("ResourceVisualizationView.action.minimise")) {
                            e.result = String.valueOf(ResourceVisualizationView.this.getContentDescription()) + ResourceVisualizationView.this.minimiseAction.getToolTipText();
                        } else if (id.equals("ResourceVisualizationView.action.maximise")) {
                            e.result = String.valueOf(ResourceVisualizationView.this.getContentDescription()) + ResourceVisualizationView.this.maximiseAction.getToolTipText();
                        } else if (id.equals("ResourceVisualizationView.action.showConnections")) {
                            e.result = String.valueOf(ResourceVisualizationView.this.getContentDescription()) + ResourceVisualizationView.this.showConnectionsAction.getToolTipText();
                        } else if (id.equals("ResourceVisualizationView.action.swap")) {
                            e.result = String.valueOf(ResourceVisualizationView.this.getContentDescription()) + ResourceVisualizationView.this.swapAction.getToolTipText();
                        }
                    }
                }
            });
            this.topToolbar.pack();
        }
        Debug.exit((Logger)logger, (String)ResourceVisualizationView.class.getName(), (String)"createActions");
    }

    public void swapTopItems() {
        Debug.enter((Logger)logger, (String)ResourceVisualizationView.class.getName(), (String)"swapTopItems", (Object)("Thread ID: " + Thread.currentThread().getId()));
        RootNode newRootNode = new RootNode();
        Map rootChildren = this.rootNode.getChildren();
        for (INode level1Node : rootChildren.values()) {
            INode newLevel1Node;
            if (level1Node instanceof INestedNode) {
                Map level1NodeChildren = ((INestedNode)level1Node).getChildren();
                for (INode level2Node : level1NodeChildren.values()) {
                    INode newLevel2Node;
                    INestedNode newLevel1Node2 = (INestedNode)newRootNode.getChildren().get(level2Node.getObject());
                    if (newLevel1Node2 == null) {
                        newLevel1Node2 = new NestedNode();
                        newLevel1Node2.setObject(level2Node.getObject());
                        newLevel1Node2.setParent((INestedNode)newRootNode);
                        newRootNode.getChildren().put(newLevel1Node2.getObject(), newLevel1Node2);
                    }
                    if ((newLevel2Node = (INode)newLevel1Node2.getChildren().get(level1Node.getObject())) != null) continue;
                    if (level2Node instanceof INestedNode) {
                        newLevel2Node = new NestedNode();
                        LinkedHashMap level2Children = (LinkedHashMap)((INestedNode)level2Node).getChildren();
                        ((INestedNode)newLevel2Node).setChildren((Map)level2Children);
                    } else {
                        newLevel2Node = new Node();
                    }
                    newLevel2Node.setObject(level1Node.getObject());
                    newLevel2Node.setParent(newLevel1Node2);
                    newLevel1Node2.getChildren().put(newLevel2Node.getObject(), newLevel2Node);
                }
                continue;
            }
            if (!(level1Node instanceof INode) || (newLevel1Node = (INode)newRootNode.getChildren().get(level1Node.getObject())) != null) continue;
            newLevel1Node = new Node();
            newLevel1Node.setObject(level1Node.getObject());
            newLevel1Node.setParent((INestedNode)newRootNode);
            newRootNode.getChildren().put(newLevel1Node.getObject(), newLevel1Node);
        }
        this.viewer.setContents((Object)newRootNode);
        this.rootNode = newRootNode;
        Debug.exit((Logger)logger, (String)ResourceVisualizationView.class.getName(), (String)"swapTopItems");
    }

    public void setFocus() {
        if (this.rootComp != null && !this.rootComp.isDisposed()) {
            this.rootComp.setFocus();
        }
    }

    public void clear() {
        Debug.enter((Logger)logger, (String)ResourceVisualizationView.class.getName(), (String)"clear", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.resourceVisualizationCommand != null) {
            this.resourceVisualizationCommand.removeListener(this.getCommandListener());
            this.resourceVisualizationCommand.cancel();
            this.resourceVisualizationCommand = null;
        }
        if (this.discoverResourcesJob != null) {
            this.discoverResourcesJob.cancel();
            this.discoverResourcesJob = null;
        }
        if (this.viewer != null) {
            this.rootNode = null;
            this.viewer.setContents(null);
        }
        if (this.rootComp != null && !this.rootComp.isDisposed()) {
            this.rootComp.setCursor(null);
            if (this.scrollLimitManager != null) {
                this.scrollLimitManager.dispose();
            }
            this.changeActionsEnablement();
        }
        Debug.exit((Logger)logger, (String)ResourceVisualizationView.class.getName(), (String)"clear");
    }

    public Job runSearch() {
        Debug.enter((Logger)logger, (String)ResourceVisualizationView.class.getName(), (String)"runSearch", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.clear();
        IConnectable resourceManager = ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.ia.connection.db2");
        if (!resourceManager.isConnected()) {
            Debug.exit((Logger)logger, (String)ResourceVisualizationView.class.getName(), (String)"runSearch");
            return null;
        }
        this.mode = ((ResourceVizEditorInput)this.getEditorInput()).getMode();
        if (this.mode.equals(ResourceVizEditorInput.MODE_TS_APPLICATIONS_BY_REGIONS) && Version.getInstance().getDBVersion() < 5100) {
            Debug.exit((Logger)logger, (String)ResourceVisualizationView.class.getName(), (String)"runSearch");
            return null;
        }
        if (this.mode.equals(ResourceVizEditorInput.MODE_TS_APPLICATIONS_BY_PLATFORMS) && Version.getInstance().getDBVersion() < 5200) {
            Debug.exit((Logger)logger, (String)ResourceVisualizationView.class.getName(), (String)"runSearch");
            return null;
        }
        this.rootNode = new RootNode();
        Resource resource = ((ResourceVizEditorInput)this.getEditorInput()).getResource();
        if (this.mode.equals(ResourceVizEditorInput.MODE_TS_APPLICATIONS_BY_REGIONS)) {
            this.resourceVisualizationCommand = new ResourceVisualizationByTSCommand(resource, ResourceVisualizationByTSCommand.Mode.Regions);
        } else if (this.mode.equals(ResourceVizEditorInput.MODE_TS_APPLICATIONS_BY_PLATFORMS)) {
            this.resourceVisualizationCommand = new ResourceVisualizationByTSCommand(resource, ResourceVisualizationByTSCommand.Mode.Platforms);
        } else if (this.mode.equals(ResourceVizEditorInput.MODE_IA_APPLICATIONS)) {
            this.resourceVisualizationCommand = new ResourceVisualizationByIACommand(resource);
        } else if (this.mode.equals(ResourceVizEditorInput.MODE_TRANSACTIONS)) {
            this.resourceVisualizationCommand = new ResourceVisualizationByTransactionsCommand(resource);
        }
        this.resourceVisualizationCommand.addListener(this.getCommandListener());
        final String taskName = this.getTaskName();
        this.discoverResourcesJob = new JobWithCancelingSupport(taskName){

            protected IStatus runSub(IProgressMonitor monitor) {
                Debug.enter((Logger)logger, (String)"ResourceVisualizationView.runSearch().discoverResourcesJob", (String)"runSub", (Object)("Thread ID: " + Thread.currentThread().getId()));
                monitor.beginTask(taskName, -1);
                if (ResourceVisualizationView.this.resourceVisualizationCommand != null) {
                    ResourceVisualizationView.this.resourceVisualizationCommand.setAsync(false);
                    ResourceVisualizationView.this.resourceVisualizationCommand.start();
                }
                monitor.done();
                Debug.exit((Logger)logger, (String)"ResourceVisualizationView.runSearch().discoverResourcesJob", (String)"runSub");
                return Status.OK_STATUS;
            }

            protected void cancelingSub() {
                super.canceling();
            }
        };
        this.discoverResourcesJob.schedule();
        Debug.exit((Logger)logger, (String)ResourceVisualizationView.class.getName(), (String)"runSearch");
        return this.discoverResourcesJob;
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
    }

    private String getTaskName() {
        return Messages.getString("ResourceVisualizationView.task.Discovering.Text");
    }

    public void discoveredIA(Collection<Object> items) {
        Debug.enter((Logger)logger, (String)ResourceVisualizationView.class.getName(), (String)"discoveredIA", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Iterator<Object> iter = items.iterator();
        IAApplication iaApplication = null;
        Resource resource = null;
        while (iter.hasNext()) {
            Object item = iter.next();
            Resource[] resources = (Resource[])item;
            iaApplication = (IAApplication)resources[0];
            resource = resources[1];
            INestedNode applicationNode = (INestedNode)this.addResourceNode(true, (INestedNode)this.rootNode, (Resource)iaApplication);
            this.addResourceNode(false, applicationNode, resource);
        }
        Debug.exit((Logger)logger, (String)ResourceVisualizationView.class.getName(), (String)"discoveredIA");
    }

    public void discoveredTS(Collection<Object> items) {
        Debug.enter((Logger)logger, (String)ResourceVisualizationView.class.getName(), (String)"discoveredTS", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Iterator<Object> iter = items.iterator();
        Resource regionOrPlatform = null;
        TSApplication application = null;
        Transaction transaction = null;
        Program program = null;
        while (iter.hasNext()) {
            RootNode parentNode = this.rootNode;
            Object item = iter.next();
            Resource[] resources = (Resource[])item;
            regionOrPlatform = resources[0];
            application = (TSApplication)resources[1];
            transaction = (Transaction)resources[2];
            program = (Program)resources[3];
            INestedNode regionOrPlatformNode = (INestedNode)this.addResourceNode(true, (INestedNode)this.rootNode, regionOrPlatform);
            parentNode = regionOrPlatformNode;
            if (application != null) {
                INestedNode applicationNode = (INestedNode)this.addResourceNode(true, regionOrPlatformNode, (Resource)application);
                parentNode = applicationNode;
            }
            INestedNode transactionNode = (INestedNode)this.addResourceNode(true, (INestedNode)parentNode, (Resource)transaction);
            this.addResourceNode(false, transactionNode, (Resource)program);
            Debug.exit((Logger)logger, (String)ResourceVisualizationView.class.getName(), (String)"discoveredTS");
        }
    }

    public void discoveredTransactions(Collection<Object> items) {
        Debug.enter((Logger)logger, (String)ResourceVisualizationView.class.getName(), (String)"discoveredTransactions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Iterator<Object> iter = items.iterator();
        Region region = null;
        Transaction transaction = null;
        Program program = null;
        while (iter.hasNext()) {
            Object item = iter.next();
            Resource[] resources = (Resource[])item;
            region = (Region)resources[0];
            transaction = (Transaction)resources[1];
            program = (Program)resources[2];
            INestedNode regionNode = (INestedNode)this.addResourceNode(true, (INestedNode)this.rootNode, (Resource)region);
            INestedNode transactionNode = (INestedNode)this.addResourceNode(true, regionNode, (Resource)transaction);
            this.addResourceNode(false, transactionNode, (Resource)program);
            regionNode.fireModelChanged();
            transactionNode.fireModelChanged();
        }
        Debug.exit((Logger)logger, (String)ResourceVisualizationView.class.getName(), (String)"discoveredTransactions");
    }

    public INode addResourceNode(boolean nested, INestedNode parent, Resource resource) {
        Object result = (INode)parent.getChildren().get(resource);
        if (result == null) {
            result = nested ? new NestedNode() : new Node();
            result.setParent(parent);
            result.setObject((Object)resource);
            parent.getChildren().put(resource, result);
        }
        return result;
    }

    EngineShell.EngineListener getCommandListener() {
        if (this.commandListener == null) {
            this.commandListener = new EngineShell.EngineListener(){

                public void statusUpdate(EngineShell.EngineStatus es) {
                    switch (es) {
                        case Error: {
                            ResourceVisualizationView.this.display.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ResourceVisualizationView.this.clear();
                                }
                            });
                            break;
                        }
                        case Complete: {
                            ResourceVisualizationView.this.display.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if ((this).ResourceVisualizationView.this.scrollLimitManager != null) {
                                        (this).ResourceVisualizationView.this.scrollLimitManager.dispose();
                                    }
                                    if ((this).ResourceVisualizationView.this.rootComp != null && !(this).ResourceVisualizationView.this.rootComp.isDisposed()) {
                                        (this).ResourceVisualizationView.this.rootComp.setCursor(null);
                                        ResourceVisualizationView.this.viewer.setContents((Object)(this).ResourceVisualizationView.this.rootNode);
                                        ResourceVisualizationView.this.changeActionsEnablement();
                                    }
                                }
                            });
                            break;
                        }
                        case Paused: {
                            ResourceVisualizationView.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if ((this).ResourceVisualizationView.this.rootComp != null && !(this).ResourceVisualizationView.this.rootComp.isDisposed()) {
                                        ResourceVisualizationView.this.viewer.setContents((Object)(this).ResourceVisualizationView.this.rootNode);
                                        ResourceVisualizationView.this.changeActionsEnablement();
                                        if ((this).ResourceVisualizationView.this.scrollLimitManager != null) {
                                            (this).ResourceVisualizationView.this.scrollLimitManager.scrollLimitReached((Command)ResourceVisualizationView.this.resourceVisualizationCommand);
                                        }
                                        (this).ResourceVisualizationView.this.rootComp.setCursor(null);
                                    }
                                }
                            });
                        }
                    }
                }

                public void notifyResultCount(int count) {
                }

                public void dataAvailable(final Collection<Object> items) {
                    ResourceVisualizationView.this.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).ResourceVisualizationView.this.rootNode != null) {
                                if (ResourceVisualizationView.this.mode.equals(ResourceVizEditorInput.MODE_TS_APPLICATIONS_BY_REGIONS) || ResourceVisualizationView.this.mode.equals(ResourceVizEditorInput.MODE_TS_APPLICATIONS_BY_PLATFORMS)) {
                                    ResourceVisualizationView.this.discoveredTS(items);
                                } else if (ResourceVisualizationView.this.mode.equals(ResourceVizEditorInput.MODE_IA_APPLICATIONS)) {
                                    ResourceVisualizationView.this.discoveredIA(items);
                                } else if (ResourceVisualizationView.this.mode.equals(ResourceVizEditorInput.MODE_TRANSACTIONS)) {
                                    ResourceVisualizationView.this.discoveredTransactions(items);
                                }
                            }
                        }
                    });
                }
            };
        }
        return this.commandListener;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IContentOutlinePage.class) {
            this.outlinePage = new OutlinePage((EditPartViewer)new TreeViewer());
            return this.outlinePage;
        }
        return super.getAdapter(adapter);
    }

    public void dispose() {
        Debug.enter((Logger)logger, (String)ResourceVisualizationView.class.getName(), (String)"dispose", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.connectionServiceListener.makeStale();
        this.clear();
        super.dispose();
        Debug.exit((Logger)logger, (String)ResourceVisualizationView.class.getName(), (String)"dispose");
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        Debug.enter((Logger)logger, (String)ResourceVisualizationView.class.getName(), (String)"init", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
        ConnectionsPlugin.getDefault().getConnectionService().addConnectionServiceListener(this.connectionServiceListener);
        Debug.exit((Logger)logger, (String)ResourceVisualizationView.class.getName(), (String)"init");
    }

    protected void initializeGraphicalViewer() {
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public boolean isDirty() {
        return false;
    }

    public String getTitleToolTip() {
        return this.getTitle();
    }

    class OutlinePage
    extends ContentOutlinePage
    implements IAdaptable {
        private Canvas overview;
        private Thumbnail thumbnail;
        private DisposeListener disposeListener;
        final Logger logger;

        public OutlinePage(EditPartViewer viewer) {
            super(viewer);
            this.logger = Logger.getLogger(OutlinePage.class.getPackage().getName());
        }

        public void createControl(Composite parent) {
            Debug.enter((Logger)this.logger, (String)"ResourceVisualizationView.OutlinePage", (String)"createControl(parent)");
            this.overview = new Canvas(parent, 0);
            this.initializeOverview(this.overview);
            Debug.exit((Logger)this.logger, (String)"ResourceVisualizationView.OutlinePage", (String)"createControl(parent)");
        }

        public void dispose() {
            Debug.enter((Logger)this.logger, (String)"ResourceVisualizationView.OutlinePage", (String)"dispose()");
            this.unhookOutlineViewer();
            if (this.thumbnail != null) {
                this.thumbnail.deactivate();
                this.thumbnail = null;
            }
            super.dispose();
            Debug.exit((Logger)this.logger, (String)"ResourceVisualizationView.OutlinePage", (String)"dispose()");
        }

        public Object getAdapter(Class type) {
            if (type == ZoomManager.class) {
                return ResourceVisualizationView.this.viewer.getProperty(ZoomManager.class.toString());
            }
            if (type == IContentOutlinePage.class) {
                return ResourceVisualizationView.this.outlinePage;
            }
            return null;
        }

        public Control getControl() {
            return this.overview;
        }

        protected void initializeOverview(Canvas canvas) {
            Debug.enter((Logger)this.logger, (String)"ResourceVisualizationView.OutlinePage", (String)"initializeOverview(canvas)");
            LightweightSystem lws = new LightweightSystem(canvas);
            RootEditPart rep = ResourceVisualizationView.this.viewer.getRootEditPart();
            ScalableFreeformRootEditPart root = (ScalableFreeformRootEditPart)rep;
            this.thumbnail = new ScrollableThumbnail((Viewport)root.getFigure());
            this.thumbnail.setBorder((Border)new MarginBorder(3));
            this.thumbnail.setSource(root.getLayer((Object)"Printable Layers"));
            lws.setContents((IFigure)this.thumbnail);
            this.disposeListener = new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (OutlinePage.this.thumbnail != null) {
                        OutlinePage.this.thumbnail.deactivate();
                        OutlinePage.this.thumbnail = null;
                    }
                }
            };
            ResourceVisualizationView.this.viewer.getControl().addDisposeListener(this.disposeListener);
            Debug.exit((Logger)this.logger, (String)"ResourceVisualizationView.OutlinePage", (String)"initializeOverview(canvas)");
        }

        protected void unhookOutlineViewer() {
            if (this.disposeListener != null && ResourceVisualizationView.this.viewer.getControl() != null && !ResourceVisualizationView.this.viewer.getControl().isDisposed()) {
                ResourceVisualizationView.this.viewer.getControl().removeDisposeListener(this.disposeListener);
            }
        }

        public void refreshRootFromViewer() {
            this.unhookOutlineViewer();
            if (this.thumbnail != null) {
                this.thumbnail.deactivate();
                this.thumbnail = null;
            }
            this.initializeOverview(this.overview);
        }
    }
}

