/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.ia.commands.ResourceConnectionsAnalyzer;
import com.ibm.cics.ia.model.Platform;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.TSApplication;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.model.viz.IConnectionsAnalyzerListener;
import com.ibm.cics.ia.model.viz.IModelChangeListener;
import com.ibm.cics.ia.model.viz.INestedNode;
import com.ibm.cics.ia.model.viz.INode;
import com.ibm.cics.ia.model.viz.ResourceFilter;
import com.ibm.cics.ia.model.viz.RootNode;
import com.ibm.cics.ia.query.SQLDefinitions;
import com.ibm.cics.ia.runtime.Version;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.CaptureEPSpecMenu;
import com.ibm.cics.ia.ui.FilterContentProvider;
import com.ibm.cics.ia.ui.FilterLabelProvider;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.actions.RequestSchedulingRule;
import com.ibm.cics.ia.ui.viz.ResourceConnEditorInput;
import com.ibm.cics.ia.ui.viz.ResourceConnectionsEditPartFactory;
import com.ibm.cics.ia.ui.viz.ResourceConnectionsEditPartFactoryPresenter;
import com.ibm.cics.ia.ui.viz.ResourceVizualizationKeyHandler;
import com.ibm.cics.ia.ui.viz.editparts.ConnectionsDiagramRootEditPart;
import com.ibm.cics.ia.ui.viz.editparts.ResourceNodeGraphEditPart;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.draw2d.parts.Thumbnail;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.print.PrintGraphicalViewerOperation;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class ResourceConnectionsView
extends GraphicalEditor
implements IConnectionsAnalyzerListener {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ResourceConnectionsView.class.getPackage().getName());
    public static String ID = "com.ibm.cics.ia.ui.ResourceConnectionsView";
    private ScrollingGraphicalViewer viewer;
    private ResourceConnectionsEditPartFactoryPresenter resourceConnectionsEditPartFactoryPresenter;
    private Display display;
    private Text nameFilterText;
    private Action showFilters;
    private Action changeOrientation;
    private Action showOutgoingConnections;
    private Action printAction;
    ResourceConnectionsEditPartFactory resourceConnectionsEditPartFactory;
    private Resource programOrTransaction;
    private Region region;
    private Platform platform;
    private TSApplication tsApplication;
    private Transaction contextTransaction;
    private SashForm sash;
    private ContainerCheckedTreeViewer filterViewer;
    private ResourceFilter rootFilter;
    private boolean filterShown;
    private boolean vertical;
    private ResourceConnectionsAnalyzer connectionsAnalyzer;
    private RootNode rootNode;
    private OutlinePage outlinePage;
    private ToolBar topToolbar;
    private ToolBarManager toolBar;
    private Composite viewComp;
    private Composite rootComp;
    private ConnectionServiceListener connectionServiceListener;
    private static final RequestSchedulingRule mutexRule = new RequestSchedulingRule();

    public void createPartControl(Composite parent) {
        Debug.enter((Logger)logger, (String)ResourceConnectionsView.class.getName(), (String)"createPartControl", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.display = parent.getDisplay();
        this.rootComp = new Composite(parent, 4);
        this.rootComp.setLayout((Layout)new GridLayout(1, true));
        this.topToolbar = new ToolBar(this.rootComp, 8388928);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.topToolbar.setLayoutData((Object)data);
        this.nameFilterText = new Text(this.rootComp, 2048);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.nameFilterText.setLayoutData((Object)data);
        this.nameFilterText.setToolTipText(com.ibm.cics.ia.controller.Messages.getString("FindResourceContributionItem.tooltiptxt.usewildcardname"));
        this.sash = new SashForm(this.rootComp, 256);
        data = new GridData(4, 4, true, true);
        this.sash.setLayoutData((Object)data);
        this.viewComp = new Composite((Composite)this.sash, 2052);
        this.viewComp.setLayout((Layout)new GridLayout(1, true));
        this.viewComp.setBackground(ColorConstants.white);
        this.viewComp.setLayoutData((Object)data);
        this.viewer = new ScrollingGraphicalViewer();
        Control viewerControl = this.viewer.createControl(this.viewComp);
        viewerControl.setLayoutData((Object)data);
        this.filterViewer = new ContainerCheckedTreeViewer((Composite)this.sash, 2560);
        this.filterViewer.setLabelProvider((IBaseLabelProvider)new FilterLabelProvider());
        this.filterViewer.setContentProvider((IContentProvider)new FilterContentProvider());
        this.rootFilter = ResourceConnectionsView.initializeResourceFilters();
        IModelChangeListener listener = new IModelChangeListener(){

            public void onModelChanged(Object model) {
                if (model instanceof ResourceFilter && (((ResourceFilter)model).getName().equals("APPLID") || ((ResourceFilter)model).getName().equals("PLATFORM") || ((ResourceFilter)model).getName().equals("TS_APPLICATION") || ((ResourceFilter)model).getName().equals("TRANSID") || ((ResourceFilter)model).getName().equals("PROGRAM")) && ResourceConnectionsView.this.programOrTransaction != null) {
                    ResourceConnectionsView.this.runSearch();
                }
            }
        };
        this.rootFilter.addModelChangeListener(listener);
        this.rootFilter.getFilter("APPLID").addModelChangeListener(listener);
        if (this.rootFilter.getFilter("TS_APPLICATION") != null) {
            this.rootFilter.getFilter("TS_APPLICATION").addModelChangeListener(listener);
        }
        if (this.rootFilter.getFilter("PLATFORM") != null) {
            this.rootFilter.getFilter("PLATFORM").addModelChangeListener(listener);
        }
        this.rootFilter.getFilter("TRANSID").addModelChangeListener(listener);
        this.rootFilter.getFilter("PROGRAM").addModelChangeListener(listener);
        this.filterViewer.setInput((Object)new ResourceFilter[]{this.rootFilter});
        this.filterViewer.expandAll();
        this.filterViewer.setChecked((Object)this.rootFilter.getFilter("TRANSID"), this.rootFilter.getFilter("TRANSID").isChecked());
        this.filterViewer.setChecked((Object)this.rootFilter.getFilter("PROGRAM"), this.rootFilter.getFilter("PROGRAM").isChecked());
        this.sash.setWeights(new int[]{8, 2});
        this.sash.setMaximizedControl((Control)this.viewComp);
        this.filterShown = false;
        this.viewer.getControl().setBackground(ColorConstants.white);
        this.viewer.setRootEditPart((RootEditPart)new ScalableFreeformRootEditPart());
        ResourceConnectionsEditPartFactory resourceConnectionsEditPartFactory = new ResourceConnectionsEditPartFactory(this.rootFilter);
        this.resourceConnectionsEditPartFactoryPresenter = new ResourceConnectionsEditPartFactoryPresenterImpl();
        resourceConnectionsEditPartFactory.setPresenter(this.resourceConnectionsEditPartFactoryPresenter);
        this.viewer.setEditPartFactory((EditPartFactory)resourceConnectionsEditPartFactory);
        this.viewer.setKeyHandler((KeyHandler)new ResourceVizualizationKeyHandler((GraphicalViewer)this.viewer));
        DefaultEditDomain eDomain = new DefaultEditDomain(null);
        eDomain.addViewer((EditPartViewer)this.viewer);
        this.createActions();
        MenuManager menuMgr = new MenuManager();
        final Region scopeRegion = this.region;
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Object object;
                ISelection selection = ResourceConnectionsView.this.viewer.getSelection();
                if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && (object = ((IStructuredSelection)ResourceConnectionsView.this.viewer.getSelection()).getFirstElement()) instanceof ResourceNodeGraphEditPart) {
                    ResourceNodeGraphEditPart editPart = (ResourceNodeGraphEditPart)((Object)object);
                    INode resourceNode = (INode)editPart.getModel();
                    Resource resource = (Resource)resourceNode.getObject();
                    INestedNode parentNode = resourceNode.getParent();
                    Region region = null;
                    while (parentNode != null) {
                        Object parent = parentNode.getObject();
                        if (parent != null && parent instanceof Region) {
                            region = (Region)parent;
                            break;
                        }
                        parentNode = parentNode.getParent();
                    }
                    if (region == null) {
                        region = scopeRegion;
                    }
                    CaptureEPSpecMenu.createResourceActions(manager, resource, region);
                    if (resource instanceof Transaction) {
                        manager.add((IAction)ResourceConnectionsView.this.showOutgoingConnections);
                    }
                }
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.filterViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Debug.enter((Logger)logger, (String)"ResourceConnectionsView.createPartControl.filterViewer.checkStateListener", (String)"checkStateChanged", (Object)("Thread ID: " + Thread.currentThread().getId()));
                if (ResourceConnectionsView.this.connectionsAnalyzer == null) {
                    Debug.exit((Logger)logger, (String)"ResourceConnectionsView.createPartControl.filterViewer.checkStateListener", (String)"checkStateChanged");
                    return;
                }
                if (event.getElement() instanceof ResourceFilter) {
                    final ResourceFilter filter = (ResourceFilter)event.getElement();
                    filter.setCheckedSubtree(event.getChecked());
                    final ResourceFilter categoryFilter = filter.findFilterInPath(new String[]{ResourceFilter.CICS, ResourceFilter.DB2, ResourceFilter.IMS, ResourceFilter.MQ});
                    if (filter.isChecked() && categoryFilter != null) {
                        Job job = new Job(""){

                            protected IStatus run(IProgressMonitor monitor) {
                                ResourceConnectionsView.this.findResources(filter.getCheckedSubtreeLeafNames(), categoryFilter.getName());
                                return Status.OK_STATUS;
                            }
                        };
                        job.setRule((ISchedulingRule)mutexRule);
                        job.schedule();
                    }
                }
                Debug.exit((Logger)logger, (String)"ResourceConnectionsView.createPartControl.filterViewer.checkStateListener", (String)"checkStateChanged", (Object)("Thread ID: " + Thread.currentThread().getId()));
            }
        });
        this.nameFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ResourceConnectionsView.this.nameFilterText.getText();
                if (ResourceConnectionsView.this.rootNode != null && ResourceConnectionsView.this.viewer != null && ResourceConnectionsView.this.viewer.getControl() != null && !ResourceConnectionsView.this.viewer.getControl().isDisposed()) {
                    ConnectionsDiagramRootEditPart rootEditPart = (ConnectionsDiagramRootEditPart)ResourceConnectionsView.this.viewer.getContents();
                    text = "(.*)" + text.replace("*", "(.*)") + "(.*)";
                    rootEditPart.filterOut(text);
                }
            }
        });
        this.rootComp.pack();
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        IWorkbenchHelpSystem helpSystem = this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)parent, "com.ibm.cics.ia.help.resource_connections_view");
        this.connectionServiceListener = this.getConnectionServiceListener();
        ConnectionsPlugin.getDefault().getConnectionService().addConnectionServiceListener(this.connectionServiceListener);
        Debug.exit((Logger)logger, (String)ResourceConnectionsView.class.getName(), (String)"createPartControl");
    }

    public static ResourceFilter initializeResourceFilters() {
        ResourceFilter filter;
        String type;
        Debug.enter((Logger)logger, (String)ResourceConnectionsView.class.getName(), (String)"initializeResourceFilters", (Object)("Thread ID: " + Thread.currentThread().getId()));
        ResourceFilter rootFilter = new ResourceFilter();
        rootFilter.setChecked(true);
        rootFilter.setName(ResourceFilter.ROOT);
        rootFilter.setDescription(Messages.getString("ResourceConnectionsView.Filter.All.Text"));
        rootFilter.setParent(null);
        ResourceFilter emptyFilter = new ResourceFilter();
        emptyFilter.setName(ResourceFilter.EMPTY);
        emptyFilter.setDescription(Messages.getString("ResourceConnectionsView.Filter.Empty.Text"));
        emptyFilter.setChecked(false);
        rootFilter.getChildren().add(emptyFilter);
        emptyFilter.setParent(rootFilter);
        ResourceFilter regionFilter = new ResourceFilter();
        regionFilter.setChecked(false);
        regionFilter.setName("APPLID");
        regionFilter.setDescription(Messages.getString("ResourceConnectionsView.Filter.Regions.Text"));
        regionFilter.setParent(rootFilter);
        ResourceFilter platformFilter = new ResourceFilter();
        platformFilter.setChecked(false);
        platformFilter.setName("PLATFORM");
        platformFilter.setDescription(Messages.getString("ResourceConnectionsView.Filter.Platforms.Text"));
        platformFilter.setParent(rootFilter);
        ResourceFilter applicationFilter = new ResourceFilter();
        applicationFilter.setChecked(false);
        applicationFilter.setName("TS_APPLICATION");
        applicationFilter.setDescription(Messages.getString("ResourceConnectionsView.Filter.Applications.Text"));
        applicationFilter.setParent(rootFilter);
        ResourceFilter transactionFilter = new ResourceFilter();
        transactionFilter.setChecked(true);
        transactionFilter.setName("TRANSID");
        transactionFilter.setDescription(Messages.getString("ResourceConnectionsView.Filter.Transactions.Text"));
        transactionFilter.setParent(rootFilter);
        ResourceFilter programFilter = new ResourceFilter();
        programFilter.setChecked(true);
        programFilter.setName("PROGRAM");
        programFilter.setDescription(Messages.getString("ResourceConnectionsView.Filter.Programs.Text"));
        programFilter.setParent(rootFilter);
        ResourceFilter cicsResourceFilter = new ResourceFilter();
        cicsResourceFilter.setChecked(false);
        cicsResourceFilter.setName(ResourceFilter.CICS);
        cicsResourceFilter.setDescription(Messages.getString("ResourceConnectionsView.Fiter.CICS.Text"));
        cicsResourceFilter.setParent(rootFilter);
        ResourceFilter db2ResourceFilter = new ResourceFilter();
        db2ResourceFilter.setChecked(false);
        db2ResourceFilter.setName(ResourceFilter.DB2);
        db2ResourceFilter.setDescription(Messages.getString("ResourceConnectionsView.Filter.DB2.Text"));
        db2ResourceFilter.setParent(rootFilter);
        ResourceFilter imsResourceFilter = new ResourceFilter();
        imsResourceFilter.setChecked(false);
        imsResourceFilter.setName(ResourceFilter.IMS);
        imsResourceFilter.setDescription(Messages.getString("ResourceConnectionsView.Filter.IMS.Text"));
        imsResourceFilter.setParent(rootFilter);
        ResourceFilter mqResourceFilter = new ResourceFilter();
        mqResourceFilter.setChecked(false);
        mqResourceFilter.setName(ResourceFilter.MQ);
        mqResourceFilter.setDescription(Messages.getString("ResourceConnectionsView.Filter.MQ.Text"));
        mqResourceFilter.setParent(rootFilter);
        rootFilter.getChildren().add(regionFilter);
        if (Version.getInstance().getDBVersion() >= 5200) {
            rootFilter.getChildren().add(platformFilter);
        }
        if (Version.getInstance().getDBVersion() >= 5100) {
            rootFilter.getChildren().add(applicationFilter);
        }
        rootFilter.getChildren().add(transactionFilter);
        rootFilter.getChildren().add(programFilter);
        rootFilter.getChildren().add(cicsResourceFilter);
        rootFilter.getChildren().add(db2ResourceFilter);
        rootFilter.getChildren().add(imsResourceFilter);
        rootFilter.getChildren().add(mqResourceFilter);
        String[] stringArray = SQLDefinitions.CICS_TYPES;
        int n = SQLDefinitions.CICS_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            type = stringArray[n2];
            if (!type.equals("PROGRAM") && !type.equals("TRANSID")) {
                filter = new ResourceFilter();
                filter.setName(type);
                filter.setDescription(type);
                filter.setChecked(false);
                cicsResourceFilter.getChildren().add(filter);
                filter.setParent(cicsResourceFilter);
            }
            ++n2;
        }
        stringArray = SQLDefinitions.DB2_TYPES;
        n = SQLDefinitions.DB2_TYPES.length;
        n2 = 0;
        while (n2 < n) {
            type = stringArray[n2];
            filter = new ResourceFilter();
            filter.setName(type);
            filter.setDescription(type);
            filter.setChecked(false);
            db2ResourceFilter.getChildren().add(filter);
            filter.setParent(db2ResourceFilter);
            ++n2;
        }
        stringArray = SQLDefinitions.IMS_TYPES;
        n = SQLDefinitions.IMS_TYPES.length;
        n2 = 0;
        while (n2 < n) {
            type = stringArray[n2];
            filter = new ResourceFilter();
            filter.setName(type);
            filter.setDescription(type);
            filter.setChecked(false);
            imsResourceFilter.getChildren().add(filter);
            filter.setParent(imsResourceFilter);
            ++n2;
        }
        stringArray = SQLDefinitions.MQ_TYPES;
        n = SQLDefinitions.MQ_TYPES.length;
        n2 = 0;
        while (n2 < n) {
            type = stringArray[n2];
            filter = new ResourceFilter();
            filter.setName(type);
            filter.setDescription(type);
            filter.setChecked(false);
            mqResourceFilter.getChildren().add(filter);
            filter.setParent(mqResourceFilter);
            ++n2;
        }
        Debug.exit((Logger)logger, (String)ResourceConnectionsView.class.getName(), (String)"initializeResourceFilters");
        return rootFilter;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IContentOutlinePage.class) {
            this.outlinePage = new OutlinePage((EditPartViewer)new TreeViewer());
            return this.outlinePage;
        }
        return super.getAdapter(adapter);
    }

    public ResourceFilter getFilters() {
        return this.rootFilter;
    }

    public void setFocus() {
        if (this.rootComp != null && !this.rootComp.isDisposed()) {
            this.rootComp.setFocus();
        }
    }

    public void clear(boolean clearConnectionAnalyzer) {
        if (this.viewer != null) {
            this.viewer.setContents(null);
        }
        this.programOrTransaction = null;
        this.tsApplication = null;
        this.platform = null;
        this.region = null;
        this.cancelSearchJob();
        if (clearConnectionAnalyzer) {
            this.connectionsAnalyzer = null;
        }
        this.rootNode = null;
    }

    public void createActions() {
        Debug.enter((Logger)logger, (String)ResourceConnectionsView.class.getName(), (String)"createActions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.showFilters = new Action(Messages.getString("ResourceConnectionsView.Action.ShowFilters.Tooltip.Text"), 2){

            public void run() {
                if (ResourceConnectionsView.this.filterShown) {
                    ResourceConnectionsView.this.sash.setMaximizedControl((Control)ResourceConnectionsView.this.viewComp);
                    ResourceConnectionsView.this.filterShown = !ResourceConnectionsView.this.filterShown;
                } else {
                    ResourceConnectionsView.this.sash.setMaximizedControl(null);
                    ResourceConnectionsView.this.filterShown = !ResourceConnectionsView.this.filterShown;
                }
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageDescriptor.createFromImage((Image)ImageFactory.getFilterImage());
            }
        };
        this.showFilters.setId("ResourceConnections.action.showfilters");
        this.showFilters.setToolTipText(Messages.getString("ResourceConnectionsView.Action.ShowFilters.Tooltip.Text"));
        this.changeOrientation = new Action(Messages.getString("ResourceConnectionsView.Action.VerticalOrientation.Action.Text"), 0){

            public void run() {
                Debug.enter((Logger)logger, (String)"ResourceConnectionsView.createActions().changeOrientation", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                ResourceConnectionsView.this.vertical = !ResourceConnectionsView.this.vertical;
                if (ResourceConnectionsView.this.vertical) {
                    this.setToolTipText(Messages.getString("ResourceConnectionsView.Action.HorizontalOrientation.Action.Text"));
                    this.setImageDescriptor(ImageDescriptor.createFromImage((Image)ImageFactory.getHorizontalLayoutImage()));
                } else {
                    this.setToolTipText(Messages.getString("ResourceConnectionsView.Action.VerticalOrientation.Action.Text"));
                    this.setImageDescriptor(ImageDescriptor.createFromImage((Image)ImageFactory.getVerticalLayoutImage()));
                }
                ConnectionsDiagramRootEditPart diagram = (ConnectionsDiagramRootEditPart)ResourceConnectionsView.this.viewer.getContents();
                if (diagram != null) {
                    diagram.setDirection(ResourceConnectionsView.this.getLayoutOrientation());
                }
                Debug.exit((Logger)logger, (String)"ResourceConnectionsView.createActions().changeOrientation", (String)"run");
            }
        };
        this.changeOrientation.setToolTipText(Messages.getString("ResourceConnectionsView.Action.VerticalOrientation.Action.Text"));
        this.changeOrientation.setImageDescriptor(ImageDescriptor.createFromImage((Image)ImageFactory.getVerticalLayoutImage()));
        this.changeOrientation.setId("ResourceConnections.action.changeorientation");
        this.printAction = new Action(){

            public void run() {
                int style = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getStyle();
                Shell shell = new Shell((style & 0x8000000) != 0 ? 0x4000000 : 0);
                PrintDialog dialog = new PrintDialog(shell, 0);
                PrinterData data = dialog.open();
                if (data != null) {
                    PrintGraphicalViewerOperation operation = new PrintGraphicalViewerOperation(new Printer(data), (GraphicalViewer)ResourceConnectionsView.this.viewer);
                    operation.setPrintMode(1);
                    operation.run(Messages.getString("Printing.Operation"));
                }
            }
        };
        this.printAction.setText(Messages.getString("Print.Action"));
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.PRINT.getId(), (IAction)this.printAction);
        this.printAction.setEnabled(true);
        if (this.topToolbar != null && !this.topToolbar.isDisposed()) {
            this.toolBar = new ToolBarManager(this.topToolbar);
            this.toolBar.add((IAction)this.changeOrientation);
            this.toolBar.add((IAction)this.showFilters);
            this.toolBar.update(true);
            this.toolBar.getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    if (e.childID > -1) {
                        String id = ResourceConnectionsView.this.toolBar.getItems()[e.childID].getId();
                        ActionContributionItem action = (ActionContributionItem)ResourceConnectionsView.this.toolBar.getItems()[e.childID];
                        if (id.equals("ResourceConnections.action.changeorientation")) {
                            e.result = String.valueOf(ResourceConnectionsView.this.getContentDescription()) + ResourceConnectionsView.this.changeOrientation.getToolTipText();
                        } else if (id.equals("ResourceConnections.action.showfilters")) {
                            e.result = String.valueOf(ResourceConnectionsView.this.getContentDescription()) + ResourceConnectionsView.this.showFilters.getToolTipText();
                        }
                    }
                }
            });
            this.topToolbar.pack();
        }
        this.showOutgoingConnections = new Action(){

            public void run() {
                Object modelObject;
                Object model;
                Object element;
                Debug.enter((Logger)logger, (String)"ResourceVisualizationView.createActions().new Action()", (String)"run()");
                ISelection selection = ResourceConnectionsView.this.viewer.getSelection();
                if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof ResourceNodeGraphEditPart && (model = ((ResourceNodeGraphEditPart)((Object)element)).getModel()) instanceof INode && (modelObject = ((INode)model).getObject()) instanceof Transaction) {
                    Region region = null;
                    Platform platform = null;
                    TSApplication application = null;
                    Transaction transaction = (Transaction)modelObject;
                    INestedNode parent = ((INode)model).getParent();
                    while (parent != null) {
                        Object object = parent.getObject();
                        if (object != null) {
                            if (object instanceof Region) {
                                region = (Region)object;
                            } else if (object instanceof Platform) {
                                platform = (Platform)object;
                            } else if (object instanceof TSApplication) {
                                application = (TSApplication)object;
                            }
                        }
                        parent = parent.getParent();
                    }
                    if (region == null && ResourceConnectionsView.this.region != null) {
                        region = ResourceConnectionsView.this.region;
                    }
                    if (platform == null && ResourceConnectionsView.this.platform != null) {
                        platform = ResourceConnectionsView.this.platform;
                    }
                    if (application == null && ResourceConnectionsView.this.tsApplication != null) {
                        application = ResourceConnectionsView.this.tsApplication;
                    }
                    ResourceConnEditorInput input = new ResourceConnEditorInput((Resource)transaction, region, platform, application, transaction);
                    ResourceConnectionsView newView = Activator.getResourceConnectionsView(input);
                    newView.runSearch();
                }
                Debug.exit((Logger)logger, (String)"ResourceVisualizationView.createActions().new Action() {...}", (String)"run()");
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageDescriptor.createFromImage((Image)ImageFactory.getResourceConnectionsImage());
            }
        };
        this.showOutgoingConnections.setToolTipText(Messages.getString("ResourceVisualizationView.action.showConnections.Tooltip"));
        this.showOutgoingConnections.setText(Messages.getString("ResourceVisualizationView.action.showConnections.Tooltip"));
        this.showOutgoingConnections.setId("ResourceConnectionsView.action.showOutgoingConnections");
        Debug.exit((Logger)logger, (String)ResourceConnectionsView.class.getName(), (String)"createActions");
    }

    private int getLayoutOrientation() {
        if (this.vertical) {
            return 4;
        }
        return 16;
    }

    private void cancelSearchJob() {
        if (this.connectionsAnalyzer != null) {
            this.connectionsAnalyzer.canceling();
            this.connectionsAnalyzer.removeListener((IConnectionsAnalyzerListener)this);
        }
    }

    public Job runSearch() {
        boolean showApps;
        Debug.enter((Logger)logger, (String)ResourceConnectionsView.class.getName(), (String)"runSearch", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.clear(false);
        ResourceConnEditorInput input = (ResourceConnEditorInput)this.getEditorInput();
        this.programOrTransaction = input.getProgramOrTransaction();
        this.region = input.getRegion();
        this.tsApplication = input.getTsApplication();
        this.platform = input.getPlatform();
        this.rootNode = new RootNode();
        this.contextTransaction = input.getTransaction();
        if (this.programOrTransaction == null) {
            Debug.exit((Logger)logger, (String)ResourceConnectionsView.class.getName(), (String)"runSearch");
            return null;
        }
        IConnectable resourceManager = ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.ia.connection.db2");
        if (!resourceManager.isConnected()) {
            Debug.exit((Logger)logger, (String)ResourceConnectionsView.class.getName(), (String)"runSearch");
            return null;
        }
        boolean showRegions = this.rootFilter.getFilter("APPLID").isChecked();
        boolean showPlatforms = this.rootFilter.getFilter("PLATFORM") != null ? this.rootFilter.getFilter("PLATFORM").isChecked() : false;
        boolean bl = showApps = this.rootFilter.getFilter("TS_APPLICATION") != null ? this.rootFilter.getFilter("TS_APPLICATION").isChecked() : false;
        if (showRegions) {
            this.region = null;
        }
        if (showPlatforms) {
            this.platform = null;
        }
        if (showApps) {
            this.tsApplication = null;
        }
        this.cancelSearchJob();
        this.connectionsAnalyzer = new ResourceConnectionsAnalyzer(this.programOrTransaction, this.region, this.platform, this.tsApplication, this.contextTransaction, showRegions, showPlatforms, showApps);
        this.connectionsAnalyzer.addListener((IConnectionsAnalyzerListener)this);
        this.connectionsAnalyzer.setRule((ISchedulingRule)mutexRule);
        this.connectionsAnalyzer.schedule();
        Job job = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                List resources = ResourceConnectionsView.this.rootFilter.getFilter(ResourceFilter.CICS).getCheckedSubtreeLeafNames();
                if (resources.size() > 0) {
                    ResourceConnectionsView.this.findResources(resources, ResourceFilter.CICS);
                }
                if ((resources = ResourceConnectionsView.this.rootFilter.getFilter(ResourceFilter.DB2).getCheckedSubtreeLeafNames()).size() > 0) {
                    ResourceConnectionsView.this.findResources(resources, ResourceFilter.DB2);
                }
                if ((resources = ResourceConnectionsView.this.rootFilter.getFilter(ResourceFilter.IMS).getCheckedSubtreeLeafNames()).size() > 0) {
                    ResourceConnectionsView.this.findResources(resources, ResourceFilter.IMS);
                }
                if ((resources = ResourceConnectionsView.this.rootFilter.getFilter(ResourceFilter.MQ).getCheckedSubtreeLeafNames()).size() > 0) {
                    ResourceConnectionsView.this.findResources(resources, ResourceFilter.MQ);
                }
                if (ResourceConnectionsView.this.connectionsAnalyzer != null) {
                    ResourceConnectionsView.this.connectionsAnalyzer.notifyListeners();
                    ResourceConnectionsView.this.setRootStale();
                }
                return Status.OK_STATUS;
            }

            protected void canceling() {
                super.canceling();
                ResourceConnectionsView.this.connectionsAnalyzer.canceling();
            }
        };
        job.setRule((ISchedulingRule)mutexRule);
        job.schedule();
        Debug.exit((Logger)logger, (String)ResourceConnectionsView.class.getName(), (String)"runSearch");
        return this.connectionsAnalyzer;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        Debug.enter((Logger)logger, (String)ResourceConnectionsView.class.getName(), (String)"init", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.setSite((IWorkbenchPartSite)site);
        this.clear(true);
        this.setInput(input);
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
        this.setPartName(MessageFormat.format(Messages.getString("ResourceConnectionsView.name.resourceConnections"), input.getName()));
        Debug.exit((Logger)logger, (String)ResourceConnectionsView.class.getName(), (String)"init");
    }

    public void dispose() {
        Debug.enter((Logger)logger, (String)ResourceConnectionsView.class.getName(), (String)"dispose", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.connectionServiceListener.makeStale();
        this.clear(true);
        super.dispose();
        Debug.exit((Logger)logger, (String)ResourceConnectionsView.class.getName(), (String)"dispose");
    }

    private ConnectionServiceListener getConnectionServiceListener() {
        return new ConnectionServiceListener(){

            public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
                if ("com.ibm.cics.ia.connection.db2".equals(event.getConnectionCategoryId()) && event instanceof ConnectionServiceListener.DisconnectedEvent) {
                    this.disconnected();
                }
            }

            public void disconnected() {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ResourceConnectionsView.this.clear(true);
                    }
                });
            }
        };
    }

    public void onRootNodeUpdated(final RootNode rootNode) {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                Debug.enter((Logger)logger, (String)"ResourceConnectionsView.onRootNodeUpdated()", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                if (ResourceConnectionsView.this.viewer != null && ResourceConnectionsView.this.viewer.getControl() != null && !ResourceConnectionsView.this.viewer.getControl().isDisposed()) {
                    ResourceConnectionsView.this.resourceConnectionsEditPartFactoryPresenter.resetFigureCount();
                    ResourceConnectionsView.this.viewer.setContents((Object)rootNode);
                    ((ConnectionsDiagramRootEditPart)ResourceConnectionsView.this.viewer.getContents()).setDirection(ResourceConnectionsView.this.getLayoutOrientation());
                    ((ConnectionsDiagramRootEditPart)ResourceConnectionsView.this.viewer.getContents()).deepRefresh();
                    if (ResourceConnectionsView.this.outlinePage != null) {
                        ResourceConnectionsView.this.outlinePage.refreshRootFromViewer();
                    }
                }
                Debug.enter((Logger)logger, (String)"ResourceConnectionsView.onRootNodeUpdated()", (String)"run");
            }
        });
    }

    protected void initializeGraphicalViewer() {
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public boolean isDirty() {
        return false;
    }

    public String getTitleToolTip() {
        return this.getTitle();
    }

    private void setRootStale() {
        ConnectionsDiagramRootEditPart rootPart;
        if (this.rootNode != null && (rootPart = (ConnectionsDiagramRootEditPart)((Object)this.viewer.getEditPartRegistry().get(this.rootNode))) != null) {
            rootPart.setStale(true);
        }
    }

    void findResources(List<String> resourceNames, String category) {
        this.connectionsAnalyzer.findResources(resourceNames, category);
        this.setRootStale();
    }

    class OutlinePage
    extends ContentOutlinePage
    implements IAdaptable {
        private Canvas overview;
        private Thumbnail thumbnail;
        private DisposeListener disposeListener;
        final Logger logger;

        public OutlinePage(EditPartViewer viewer) {
            super(viewer);
            this.logger = Logger.getLogger(OutlinePage.class.getPackage().getName());
        }

        public void createControl(Composite parent) {
            Debug.enter((Logger)this.logger, (String)"ResourceConnectionsView.OutlinePage", (String)"createControl(parent)");
            this.overview = new Canvas(parent, 0);
            this.initializeOverview(this.overview);
            Debug.exit((Logger)this.logger, (String)"ResourceConnectionsView.OutlinePage", (String)"createControl(parent)");
        }

        public void dispose() {
            Debug.exit((Logger)this.logger, (String)"ResourceConnectionsView.OutlinePage", (String)"dispose()");
            this.unhookOutlineViewer();
            if (this.thumbnail != null) {
                this.thumbnail.deactivate();
                this.thumbnail = null;
            }
            super.dispose();
            Debug.exit((Logger)this.logger, (String)"ResourceConnectionsView.OutlinePage", (String)"dispose()");
        }

        public Object getAdapter(Class type) {
            if (type == ZoomManager.class) {
                return ResourceConnectionsView.this.viewer.getProperty(ZoomManager.class.toString());
            }
            if (type == IContentOutlinePage.class) {
                return ResourceConnectionsView.this.outlinePage;
            }
            return null;
        }

        public Control getControl() {
            return this.overview;
        }

        protected void initializeOverview(Canvas canvas) {
            Debug.enter((Logger)this.logger, (String)"ResourceConnectionsView.OutlinePage", (String)"initializeOverview(canvas)");
            LightweightSystem lws = new LightweightSystem(canvas);
            RootEditPart rep = ResourceConnectionsView.this.viewer.getRootEditPart();
            ScalableFreeformRootEditPart root = (ScalableFreeformRootEditPart)rep;
            this.thumbnail = new ScrollableThumbnail((Viewport)root.getFigure());
            this.thumbnail.setBorder((Border)new MarginBorder(3));
            this.thumbnail.setSource(root.getLayer((Object)"Printable Layers"));
            lws.setContents((IFigure)this.thumbnail);
            this.disposeListener = new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (OutlinePage.this.thumbnail != null) {
                        OutlinePage.this.thumbnail.deactivate();
                        OutlinePage.this.thumbnail = null;
                    }
                }
            };
            ResourceConnectionsView.this.viewer.getControl().addDisposeListener(this.disposeListener);
            Debug.exit((Logger)this.logger, (String)"ResourceConnectionsView.OutlinePage", (String)"initializeOverview(canvas)");
        }

        protected void unhookOutlineViewer() {
            if (this.disposeListener != null && ResourceConnectionsView.this.viewer.getControl() != null && !ResourceConnectionsView.this.viewer.getControl().isDisposed()) {
                ResourceConnectionsView.this.viewer.getControl().removeDisposeListener(this.disposeListener);
            }
        }

        public void refreshRootFromViewer() {
            this.unhookOutlineViewer();
            if (this.thumbnail != null) {
                this.thumbnail.deactivate();
                this.thumbnail = null;
            }
            this.initializeOverview(this.overview);
        }
    }

    class ResourceConnectionsEditPartFactoryPresenterImpl
    implements ResourceConnectionsEditPartFactoryPresenter {
        public long currentFigureCount;
        public long maxFigureCount;

        public ResourceConnectionsEditPartFactoryPresenterImpl() {
            int xmx512mInBytes = 0x20000000;
            int figuresForXmx512 = 100000;
            this.maxFigureCount = Runtime.getRuntime().maxMemory() * (long)figuresForXmx512 / (long)xmx512mInBytes;
        }

        @Override
        public void onFigureCreated() {
            if (++this.currentFigureCount >= this.maxFigureCount) {
                this.currentFigureCount = 0L;
                ResourceConnectionsView.this.cancelSearchJob();
                MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 40);
                messageBox.setText(Messages.getString("ResourceConnectionsView.msg.stopLoading.title"));
                messageBox.setMessage(MessageFormat.format(Messages.getString("ResourceConnectionsView.msg.stopLoading.body"), this.maxFigureCount));
                messageBox.open();
            }
        }

        @Override
        public void resetFigureCount() {
            this.currentFigureCount = 0L;
        }

        @Override
        public long getCurrentFigureCount() {
            return this.currentFigureCount;
        }
    }
}

