/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.ia.controller.AffinityBuildGenerator;
import com.ibm.cics.ia.controller.AffinityReportGenerator;
import com.ibm.cics.ia.controller.HTMLAffinityReportController;
import com.ibm.cics.ia.model.AffinityReport;
import com.ibm.cics.ia.model.threadsafe.ThreadsafeReportModel;
import com.ibm.cics.ia.model.threadsafe.ThreadsafeReportModelImpl;
import com.ibm.cics.ia.model.threadsafe.ThreadsafeReportModelListener;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.runtime.Version;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.AffinityReportEditorInput;
import com.ibm.cics.ia.ui.BuildAffinityReportsWizard;
import com.ibm.cics.ia.ui.CreateAffinityReportWizard;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.NavigatorView;
import com.ibm.cics.ia.ui.ReportBrowserInput;
import com.ibm.cics.ia.ui.ReportManager;
import com.ibm.cics.ia.ui.ThreadsafeReportPresenterImpl;
import com.ibm.cics.ia.ui.ThreadsafeReportViewInput;
import com.ibm.cics.ia.ui.UIUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.osgi.framework.Bundle;
import org.xml.sax.SAXException;

public class ReportExplorer {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ReportExplorer.class.getPackage().getName());
    private Display display;
    private Composite rootComp;
    private ReportManager reportManager;
    private Action maximiseTreeAction;
    private Action minimiseTreeAction;
    private Action refreshAction;
    private Action newFolderAction;
    private Action openAction;
    private Action copyAction;
    private Action pasteAction;
    private Action deleteAction;
    private Action renameAction;
    private Action newAffinityReportAction;
    private Action buildAffinityReportAction;
    private Action openInBrowserAction;
    private Action exportIntoHtmlAction;
    private Clipboard clipboard;
    private Composite editComposite;
    private TreeItem itemToRename;
    private TreeEditor treeEditor;
    private Tree tree;
    private TreeItem root;
    private ConnectionServiceListener connectionServiceListener;
    private NavigatorView navigatorView;

    public ReportExplorer(NavigatorView navigatorView) {
        this.navigatorView = navigatorView;
        this.tree = navigatorView.getTree();
        this.root = UIUtilities.createTreeItem(this.tree, Messages.getString("NavigatorView.category.reportExplorer"), ImageFactory.getReportsImage());
    }

    public void createPartControl(Composite parent) {
        Debug.enter((Logger)logger, (String)ReportExplorer.class.getName(), (String)"createPartControl", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.clipboard = new Clipboard(parent.getDisplay());
        this.display = parent.getDisplay();
        this.rootComp = parent;
        this.treeEditor = new TreeEditor(this.tree);
        this.reportManager = ReportManager.createReportManager(ReportManager.Type.filesAndFolders);
        this.reportManager.setTree(this.tree);
        this.reportManager.setRootItem(this.root);
        this.createActions();
        this.tree.addListener(8, new Listener(){

            public void handleEvent(Event e) {
                ReportExplorer.this.openAction.run();
            }
        });
        this.tree.addListener(4, new Listener(){

            public void handleEvent(Event e) {
                if (ReportExplorer.this.tree.getItem(new Point(e.x, e.y)) == null) {
                    ReportExplorer.this.tree.deselectAll();
                }
            }
        });
        this.tree.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                ReportExplorer.this.updateEnablement();
            }
        });
        this.connectionServiceListener = this.getConnectionServiceListener();
        ConnectionsPlugin.getDefault().getConnectionService().addConnectionServiceListener(this.connectionServiceListener);
        this.refresh(new Action(){});
        Debug.exit((Logger)logger, (String)ReportExplorer.class.getName(), (String)"createPartControl");
    }

    public void setFocus() {
    }

    public void refresh(Action afterRefreshAction) {
        Debug.enter((Logger)logger, (String)ReportExplorer.class.getName(), (String)"refresh", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.refreshAction != null) {
            this.refreshAction.setEnabled(false);
        }
        this.root.removeAll();
        this.reportManager.refresh();
        if (this.refreshAction != null) {
            this.refreshAction.setEnabled(true);
            afterRefreshAction.run();
        }
        Debug.exit((Logger)logger, (String)ReportExplorer.class.getName(), (String)"refresh");
    }

    public void refresh(IContainer container) {
        this.reportManager.refresh(container);
    }

    private void createActions() {
        final ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.maximiseTreeAction = new Action(Messages.getString("Button.tooltip.maximise")){

            public void run() {
                UIUtilities.expandTree(ReportExplorer.this.root, true);
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageDescriptor.createFromImage((Image)ImageFactory.getExpandImage());
            }
        };
        this.minimiseTreeAction = new Action(Messages.getString("Button.tooltip.minimise")){

            public void run() {
                UIUtilities.expandTree(ReportExplorer.this.root, false);
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageDescriptor.createFromImage((Image)ImageFactory.getCollapseImage());
            }
        };
        this.refreshAction = new Action(Messages.getString("ReportExplorer.Action.Refresh.text"), ImageDescriptor.createFromImage((Image)ImageFactory.getRefreshImage())){

            public void run() {
                ReportExplorer.this.tree.forceFocus();
                ReportExplorer.this.refresh(new Action(){});
            }
        };
        this.deleteAction = new Action(Messages.getString("ReportExplorer.Action.Delete.text"), ImageDescriptor.createFromImage((Image)ImageFactory.getDeleteImage())){

            public void run() {
                String warning;
                String text;
                Debug.enter((Logger)logger, (String)"ReportExplorer.createActions().deleteAction", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                MessageBox messageBox = null;
                if (ReportExplorer.this.tree.getSelectionCount() == 1) {
                    text = Messages.getString("ReportExplorer.Action.Delete.warning.text");
                    warning = MessageFormat.format(Messages.getString("ReportExplorer.Action.Delete.warning.message"), ReportExplorer.this.tree.getSelection()[0].getText());
                    messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 196);
                    messageBox.setMessage(warning);
                    messageBox.setText(text);
                } else if (ReportExplorer.this.tree.getSelectionCount() > 1) {
                    text = Messages.getString("ReportExplorer.Action.DeleteMultiple.warning.text");
                    warning = MessageFormat.format(Messages.getString("ReportExplorer.Action.DeleteMultiple.warning.message"), ReportExplorer.this.tree.getSelectionCount());
                    messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 196);
                    messageBox.setMessage(warning);
                    messageBox.setText(text);
                }
                if (messageBox == null) {
                    return;
                }
                if (messageBox.open() == 64) {
                    ArrayList<IContainer> parents = new ArrayList<IContainer>();
                    TreeItem[] treeItemArray = ReportExplorer.this.tree.getSelection();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem item = treeItemArray[n2];
                        IResource resource = (IResource)item.getData("IRESOURCE");
                        IContainer parent = resource.getParent();
                        try {
                            resource.delete(true, null);
                            if (!parents.contains(parent)) {
                                parents.add(parent);
                            }
                        }
                        catch (CoreException e) {
                            Debug.warning((Logger)logger, (String)ReportExplorer.class.getName(), (String)"deleteAction run", (String)"empty catch", (Throwable)e);
                        }
                        ++n2;
                    }
                    for (IContainer parent : parents) {
                        ReportExplorer.this.refresh(parent);
                    }
                }
                TreeItem[] treeItemArray = ReportExplorer.this.tree.getSelection();
                int n = treeItemArray.length;
                int n3 = 0;
                while (n3 < n) {
                    TreeItem treeItem = treeItemArray[n3];
                    ++n3;
                }
                Debug.exit((Logger)logger, (String)"ReportExplorer.createActions().deleteAction", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
            }
        };
        this.openAction = new Action(Messages.getString("ReportExplorer.Action.Open.text"), ImageDescriptor.createFromImage((Image)ImageFactory.getRunImage())){

            public void run() {
                Debug.enter((Logger)logger, (String)"ReportExplorer.createActions().openAction", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                TreeItem[] items = ReportExplorer.this.tree.getSelection();
                if (items.length == 1) {
                    if ("TYPE_REPORT_HTML".equals(items[0].getData("TYPE"))) {
                        IFile iFile = (IFile)items[0].getData("IRESOURCE");
                        String fullFileName = iFile.getLocation().toOSString();
                        File file = new File(fullFileName);
                        Activator.openEditor(new ReportBrowserInput(file.getName(), iFile.getProjectRelativePath().toString(), file), "com.ibm.cics.ia.ui.ReportBrowser", false);
                    } else if ("TYPE_REPORT_XML".equals(items[0].getData("TYPE"))) {
                        IFile iFile = (IFile)items[0].getData("IRESOURCE");
                        String fullFileName = iFile.getLocation().toOSString();
                        File file = new File(fullFileName);
                        AffinityReport report = AffinityReport.parse((File)file);
                        AffinityReportEditorInput input = new AffinityReportEditorInput();
                        input.setAffinityReport(report);
                        input.setReportFile(iFile);
                        Activator.getAffinityReportEditor(input);
                    } else if ("TYPE_REPORT_THREADSAFE".equals(items[0].getData("TYPE"))) {
                        IFile iFile = (IFile)items[0].getData("IRESOURCE");
                        String fullFileName = iFile.getLocation().toOSString();
                        File file = new File(fullFileName);
                        ThreadsafeReportModelImpl model = ThreadsafeReportModelImpl.getInstance();
                        ThreadsafeReportPresenterImpl presenter = ThreadsafeReportPresenterImpl.getInstance();
                        if (presenter.getModel() == null) {
                            presenter.setModel((ThreadsafeReportModel)model);
                            model.addListener((ThreadsafeReportModelListener)presenter);
                        }
                        ThreadsafeReportViewInput input = new ThreadsafeReportViewInput(presenter);
                        IEditorPart editor = Activator.openEditor(input, "com.ibm.cics.ia.ui.ThreadsafeReportView", false);
                        try {
                            model.loadReport(file);
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                        }
                        catch (MalformedURLException e) {
                            e.printStackTrace();
                        }
                        catch (JAXBException e) {
                            e.printStackTrace();
                        }
                        catch (SAXException e) {
                            e.printStackTrace();
                        }
                    } else if ("TYPE_BUILD".equals(items[0].getData("TYPE"))) {
                        IFile iFile = (IFile)items[0].getData("IRESOURCE");
                        FileEditorInput input = new FileEditorInput(iFile);
                        Activator.getAffinityBuildEditor((IEditorInput)input);
                    }
                }
                Debug.exit((Logger)logger, (String)"ReportExplorer.createActions().openAction", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
            }
        };
        this.openInBrowserAction = new Action(Messages.getString("ReportExplorer.Action.OpenInBrowser.text")){

            public void run() {
                Debug.enter((Logger)logger, (String)"ReportExplorer.createActions().openAction", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                TreeItem[] items = ReportExplorer.this.tree.getSelection();
                if (items.length == 1) {
                    IFile iFile = (IFile)items[0].getData("IRESOURCE");
                    String fullFileName = iFile.getLocation().toOSString();
                    File file = new File(fullFileName);
                    if ("TYPE_REPORT_XML".equals(items[0].getData("TYPE"))) {
                        AffinityReport report = AffinityReport.parse((File)file);
                        StringBuilder reportBuilder = HTMLAffinityReportController.generateReport(report);
                        Activator.openEditor(new ReportBrowserInput(file.getName(), iFile.getProjectRelativePath().toString(), reportBuilder.toString()), "com.ibm.cics.ia.ui.ReportBrowser", false);
                    } else if ("TYPE_REPORT_THREADSAFE".equals(items[0].getData("TYPE"))) {
                        String relativeFilePath = "$nl$/threadsafe-report-to-html.xsl";
                        Bundle plugin = Activator.getDefault().getBundle();
                        Path relativePath = new Path("$nl$/threadsafe-report-to-html.xsl");
                        try {
                            InputStream fis = FileLocator.openStream((Bundle)plugin, (IPath)relativePath, (boolean)true);
                            InputStreamReader in = new InputStreamReader(fis, "UTF-8");
                            Activator.openEditor(new ReportBrowserInput(file.getName(), iFile.getProjectRelativePath().toString(), IAUtilities.transformXml((File)file, (Reader)in, null)), "com.ibm.cics.ia.ui.ReportBrowser", false);
                        }
                        catch (Exception e) {
                            Debug.warning((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"onFinish", (String)"Unable to create HTML from the threadsafe report", (Throwable)e);
                            IAPlugin.getDefault().logError("Unable to create HTML from the threadsafe report", (Throwable)e);
                        }
                    }
                }
                Debug.exit((Logger)logger, (String)"ReportExplorer.createActions().openAction", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
            }
        };
        this.exportIntoHtmlAction = new Action(Messages.getString("ReportExplorer.Action.Export.exportToHtml")){

            public void run() {
                Debug.enter((Logger)logger, (String)"ReportExplorer.createActions().exportIntoHtmlAction", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                TreeItem[] items = ReportExplorer.this.tree.getSelection();
                FileDialog dialog = new FileDialog(Display.getDefault().getActiveShell(), 8192);
                String[] filterNames = new String[]{"HTML Files (*.html)"};
                String[] filterExtensions = new String[]{"*.html"};
                String filterPath = "/";
                String platform = SWT.getPlatform();
                if (platform.equals("win32")) {
                    filterPath = "c:\\";
                }
                dialog.setFilterNames(filterNames);
                dialog.setFilterExtensions(filterExtensions);
                dialog.setFilterPath(filterPath);
                String filePath = dialog.open();
                if (filePath != null && items.length == 1) {
                    IFile iFile = (IFile)items[0].getData("IRESOURCE");
                    String fullFileName = iFile.getLocation().toOSString();
                    File file = new File(fullFileName);
                    if ("TYPE_REPORT_XML".equals(items[0].getData("TYPE"))) {
                        AffinityReport report = AffinityReport.parse((File)file);
                        StringBuilder reportBuilder = HTMLAffinityReportController.generateReport(report);
                        try {
                            IAUtilities.transformStringToHtml((String)reportBuilder.toString(), (String)filePath);
                            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Info", (String)(String.valueOf(items[0].getText()) + " " + Messages.getString("ReportExplorer.infoMessage.Success.Export")));
                        }
                        catch (IOException e) {
                            IAPlugin.getDefault().logError("Unable to export Affinity report to HTML format", (Throwable)e);
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString("ReportExplorer.Error.DialogTitle"), (String)Messages.getString("ReportExplorer.Error.Affinity.DialogMessage"));
                        }
                    } else if ("TYPE_REPORT_THREADSAFE".equals(items[0].getData("TYPE"))) {
                        String relativeFilePath = "$nl$/threadsafe-report-to-html.xsl";
                        Bundle plugin = Activator.getDefault().getBundle();
                        Path relativePath = new Path("$nl$/threadsafe-report-to-html.xsl");
                        try {
                            InputStream fis = FileLocator.openStream((Bundle)plugin, (IPath)relativePath, (boolean)true);
                            InputStreamReader in = new InputStreamReader(fis, "UTF-8");
                            IAUtilities.transformXmlToHtml((File)file, (Reader)in, (String)filePath, null);
                            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Info", (String)(String.valueOf(items[0].getText()) + " " + Messages.getString("ReportExplorer.infoMessage.Success.Export")));
                        }
                        catch (Exception e) {
                            Debug.warning((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"onFinish", (String)"Unable to export Threadsafe report to HTML format", (Throwable)e);
                            IAPlugin.getDefault().logError("Unable to export Threadsafe report to HTML format", (Throwable)e);
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString("ReportExplorer.Error.DialogTitle"), (String)Messages.getString("ReportExplorer.Error.Threadsafe.DialogMessage"));
                        }
                    }
                }
                Debug.exit((Logger)logger, (String)"ReportExplorer.createActions().exportIntoHtmlAction", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
            }
        };
        this.newFolderAction = new Action(Messages.getString("ReportExplorer.Action.New.Folder.text"), ImageDescriptor.createFromImage((Image)ImageFactory.getNewWizard())){

            public void run() {
                Debug.enter((Logger)logger, (String)"ReportExplorer.createActions().newFolderAction", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                IContainer currentContainer = ReportExplorer.this.getCurrentContainer();
                try {
                    IResource resource;
                    Path path = new Path("/");
                    IFolder newFolder = currentContainer.getFolder(path.append(Messages.getString("ReportExplorer.IFolder.newfolder")));
                    int i = 2;
                    while (ReportExplorer.this.reportManager.folderExists(currentContainer, newFolder.getName())) {
                        newFolder = currentContainer.getFolder(path.append(MessageFormat.format(Messages.getString("ReportExplorer.IFolder.newFolderNum"), Integer.toString(i++))));
                    }
                    newFolder.create(true, true, null);
                    TreeItem[] items = ReportExplorer.this.tree.getSelection();
                    TreeItem item = null;
                    if (items.length > 0 && !((resource = (IResource)(item = items[0]).getData("IRESOURCE")) instanceof IFolder)) {
                        item = item.getParentItem();
                    }
                    ReportExplorer.this.reportManager.refresh(currentContainer);
                    TreeItem newFolderItem = ReportExplorer.this.reportManager.getTreeItem((IResource)newFolder);
                    ReportExplorer.this.fireRenameFocusEvent(newFolderItem);
                }
                catch (Exception e) {
                    IAPlugin.getDefault().logError("Unable to create new folder", (Throwable)e);
                    Debug.warning((Logger)logger, (String)ReportExplorer.class.getName(), (String)"createActions().newFolderAction run", (String)"Unable to create new folder", (Throwable)e);
                }
                Debug.exit((Logger)logger, (String)"ReportExplorer.createActions().newFolderAction", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
            }
        };
        this.renameAction = new Action(Messages.getString("ReportExplorer.Action.Rename.text")){

            public void run() {
                ReportExplorer.this.itemToRename = ReportExplorer.this.tree.getSelection()[0];
                ReportExplorer.this.fireRenameFocusEvent(ReportExplorer.this.itemToRename);
            }
        };
        this.copyAction = new Action(Messages.getString("ReportExplorer.Action.Copy.text"), sharedImages.getImageDescriptor("IMG_TOOL_COPY")){

            public void run() {
                ReportExplorer.this.doCopy();
            }

            public ImageDescriptor getDisabledImageDescriptor() {
                return sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED");
            }
        };
        this.pasteAction = new Action(Messages.getString("ReportExplorer.Action.Paste.text"), sharedImages.getImageDescriptor("IMG_TOOL_PASTE")){

            public void run() {
                block23: {
                    Debug.enter((Logger)logger, (String)"ReportExplorer.createActions().pasteAction", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                    if (ReportExplorer.this.editComposite != null && !ReportExplorer.this.editComposite.isDisposed()) {
                        TextTransfer textTransfer = TextTransfer.getInstance();
                        Object object = ReportExplorer.this.clipboard.getContents((Transfer)textTransfer);
                        if (object instanceof String) {
                            String text = (String)object;
                            Text editText = (Text)ReportExplorer.this.editComposite.getChildren()[0];
                            Point selection = editText.getSelection();
                            String oldText = editText.getText();
                            String newText = String.valueOf(oldText.substring(0, selection.x)) + text + oldText.substring(selection.y);
                            editText.setText(newText);
                            editText.setSelection(selection.x + text.length(), selection.x + text.length());
                        }
                    } else {
                        FileTransfer fileTransfer = FileTransfer.getInstance();
                        String[] fileData = (String[])ReportExplorer.this.clipboard.getContents((Transfer)fileTransfer);
                        if (fileData != null) {
                            try {
                                IResource resourceToCopy;
                                String fileToCopy;
                                IContainer container = ReportExplorer.this.getCurrentContainer();
                                boolean isCopyingIntoSubfolder = false;
                                int i = 0;
                                while (i < fileData.length) {
                                    fileToCopy = fileData[i];
                                    resourceToCopy = ReportExplorer.this.reportManager.getResource(fileToCopy);
                                    if (resourceToCopy instanceof IFolder && resourceToCopy.exists()) {
                                        IFolder iFolder = (IFolder)resourceToCopy;
                                        if (iFolder.equals((Object)container)) {
                                            isCopyingIntoSubfolder = true;
                                        } else {
                                            IResource[] members;
                                            IResource[] iResourceArray = members = iFolder.members();
                                            int n = members.length;
                                            int n2 = 0;
                                            while (n2 < n) {
                                                IResource iResource = iResourceArray[n2];
                                                if (iResource.equals((Object)container)) {
                                                    isCopyingIntoSubfolder = true;
                                                    break;
                                                }
                                                ++n2;
                                            }
                                        }
                                    }
                                    if (isCopyingIntoSubfolder) break;
                                    ++i;
                                }
                                if (isCopyingIntoSubfolder) {
                                    MessageBox box = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 40);
                                    box.setMessage(Messages.getString("ReportExplorer.Error.CopyIntoSubfolder.Message"));
                                    box.setText(Messages.getString("ReportExplorer.Error.CopyIntoSubfolder.Text"));
                                    box.open();
                                    break block23;
                                }
                                i = 0;
                                while (i < fileData.length) {
                                    block24: {
                                        fileToCopy = fileData[i];
                                        resourceToCopy = ReportExplorer.this.reportManager.getResource(fileToCopy);
                                        String newFileName = "";
                                        if (resourceToCopy != null) {
                                            try {
                                                newFileName = this.getCopiedFileName(resourceToCopy.getName(), container);
                                                String newFileLocation = container.getLocation().append(newFileName).toOSString();
                                                File sourceFile = new File(fileToCopy);
                                                if (!sourceFile.exists()) break block24;
                                                File destFile = new File(newFileLocation);
                                                if (!sourceFile.isDirectory()) {
                                                    destFile.createNewFile();
                                                    FileChannel source = null;
                                                    AbstractInterruptibleChannel dest = null;
                                                    try {
                                                        source = new FileInputStream(sourceFile).getChannel();
                                                        dest = new FileOutputStream(destFile).getChannel();
                                                        ((FileChannel)dest).transferFrom(source, 0L, source.size());
                                                        break block24;
                                                    }
                                                    finally {
                                                        if (source != null) {
                                                            source.close();
                                                        }
                                                        if (dest != null) {
                                                            dest.close();
                                                        }
                                                    }
                                                }
                                                this.copyDirectory(sourceFile, destFile);
                                            }
                                            catch (Exception e) {
                                                Debug.warning((Logger)logger, (String)ReportExplorer.class.getName(), (String)"createActions().pasteAction run", (String)"Unable to save report", (Throwable)e);
                                                IAPlugin.getDefault().logError("Unable to save new report " + newFileName, (Throwable)e);
                                            }
                                        }
                                    }
                                    ++i;
                                }
                                ReportExplorer.this.refresh(container);
                            }
                            catch (CoreException e) {
                                Debug.warning((Logger)logger, (String)ReportExplorer.class.getName(), (String)"createActions().pasteAction run", (String)"empty catch", (Throwable)e);
                            }
                        }
                    }
                }
                Debug.exit((Logger)logger, (String)"ReportExplorer.createActions().pasteAction", (String)"run");
            }

            public void copyDirectory(File sourceFile, File destFile) throws IOException {
                if (sourceFile.isDirectory()) {
                    if (!destFile.exists()) {
                        destFile.mkdir();
                    }
                    String[] children = sourceFile.list();
                    int i = 0;
                    while (i < children.length) {
                        this.copyDirectory(new File(sourceFile, children[i]), new File(destFile, children[i]));
                        ++i;
                    }
                } else {
                    int len;
                    FileInputStream in = new FileInputStream(sourceFile);
                    FileOutputStream out = new FileOutputStream(destFile);
                    byte[] buf = new byte[1024];
                    while ((len = ((InputStream)in).read(buf)) > 0) {
                        ((OutputStream)out).write(buf, 0, len);
                    }
                    ((InputStream)in).close();
                    ((OutputStream)out).close();
                }
            }

            public ImageDescriptor getDisabledImageDescriptor() {
                return sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED");
            }

            private String getCopiedFileName(String reportName, IContainer container) {
                Debug.enter((Logger)logger, (String)"ReportExplorer.createActions().pasteAction", (String)"getCopiedFileName", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "reportName: " + reportName, "container: " + container.getName()});
                if (!ReportExplorer.this.reportManager.fileExists(container, reportName)) {
                    Debug.exit((Logger)logger, (String)"ReportExplorer.createActions()getCopiedFileName", (String)"run", (Object)("return reportName: " + reportName));
                    return reportName;
                }
                if (reportName.startsWith(Messages.getString("ReportExplorer.txt.copyof"))) {
                    String rawName = reportName.substring(8);
                    reportName = String.valueOf(Messages.getString("ReportExplorer.txt.copy2of")) + rawName;
                } else if (reportName.startsWith(Messages.getString("ReportExplorer.txt.copynum"))) {
                    int indexOfCloseParen = reportName.indexOf(41);
                    int numberOfCopy = new Integer(reportName.substring(6, indexOfCloseParen));
                    reportName = String.valueOf(Messages.getString("ReportExplorer.txt.copynum")) + (numberOfCopy + 1) + reportName.substring(indexOfCloseParen);
                } else {
                    reportName = String.valueOf(Messages.getString("ReportExplorer.txt.copyof")) + reportName;
                }
                Debug.exit((Logger)logger, (String)"ReportExplorer.createActions()getCopiedFileName", (String)"run", (Object)("reportName: " + reportName));
                return this.getCopiedFileName(reportName, container);
            }
        };
        this.newAffinityReportAction = new Action(Messages.getString("ReportExplorer.Action.New.affinity.text"), ImageDescriptor.createFromImage((Image)ImageFactory.getAffinityReportImage())){

            public void run() {
                Debug.enter((Logger)logger, (String)ReportExplorer.class.getName(), (String)"createActions().run()", (Object)("ThreadId: " + Thread.currentThread().getId()));
                CreateAffinityReportWizard wizard = new CreateAffinityReportWizard();
                WizardDialog wizardDialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                wizardDialog.create();
                int result = wizardDialog.open();
                if (result == 0) {
                    AffinityReportGenerator generator = new AffinityReportGenerator(wizard.getRegions(), wizard.getAffinityTypes(), wizard.getRootFolder(), wizard.getTitle(), wizard.getDescription(), wizard.isAddTimeStamp());
                    generator.schedule();
                }
                Debug.exit((Logger)logger, (String)ReportExplorer.class.getName(), (String)"createActions().run()");
            }

            public ImageDescriptor getDisabledImageDescriptor() {
                return ImageDescriptor.createFromImage((Image)ImageFactory.getAffinityReportDisabledImage());
            }
        };
        this.newAffinityReportAction.setEnabled(Version.getInstance().getDBVersion() >= 3200);
        this.buildAffinityReportAction = new Action(Messages.getString("ReportExplorer.Action.Build.affinity.text"), ImageDescriptor.createFromImage((Image)ImageFactory.getBuildReportImage())){

            public void run() {
                Debug.enter((Logger)logger, (String)ReportExplorer.class.getName(), (String)"createActions().run()", (Object)("ThreadID: " + Thread.currentThread().getId()));
                TreeItem[] selectedItems = ReportExplorer.this.tree.getSelection();
                ArrayList<Object> resources = new ArrayList<IResource>();
                TreeItem[] treeItemArray = selectedItems;
                int n = selectedItems.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem treeItem = treeItemArray[n2];
                    IResource resource = (IResource)treeItem.getData("IRESOURCE");
                    if (resource instanceof IContainer || ((IFile)resource).getFileExtension().toLowerCase().equals("xml") || ((IFile)resource).getFileExtension().toLowerCase().equals("bld")) {
                        resources.add(resource);
                    }
                    ++n2;
                }
                BuildAffinityReportsWizard wizard = new BuildAffinityReportsWizard(resources);
                WizardDialog wizardDialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                wizardDialog.create();
                int result = wizardDialog.open();
                if (result == 0) {
                    resources = new ArrayList();
                    for (IResource iResource : wizard.getResources()) {
                        if (!(iResource instanceof IFile)) continue;
                        resources.add(iResource);
                    }
                    AffinityBuildGenerator generator = new AffinityBuildGenerator(resources, wizard.getContext(), wizard.getMatch(), wizard.getState());
                    generator.schedule();
                }
                Debug.exit((Logger)logger, (String)ReportExplorer.class.getName(), (String)"createActions().run()");
            }

            public ImageDescriptor getDisabledImageDescriptor() {
                return ImageDescriptor.createFromImage((Image)ImageFactory.getBuildReportDisabledImage());
            }
        };
        Debug.exit((Logger)logger, (String)ReportExplorer.class.getName(), (String)"createActions");
    }

    private IContainer getCurrentContainer() {
        TreeItem[] items = this.tree.getSelection();
        if (items.length > 0 && items[0] == this.root) {
            return (IContainer)this.tree.getData("IRESOURCE");
        }
        TreeItem item = items[0];
        IResource resource = (IResource)item.getData("IRESOURCE");
        return resource instanceof IFolder ? (IContainer)resource : resource.getParent();
    }

    protected void fireRenameFocusEvent(TreeItem newFolderItem) {
        Debug.enter((Logger)logger, (String)ReportExplorer.class.getName(), (String)"fireRenameFocusEvent", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "new folder item: " + newFolderItem.getText()});
        if (this.editComposite != null && !this.editComposite.isDisposed()) {
            this.editComposite.dispose();
        }
        Event e = new Event();
        e.item = newFolderItem;
        this.tree.setSelection(newFolderItem);
        this.renameTreeItem(newFolderItem);
        this.tree.setSelection(newFolderItem);
        Debug.exit((Logger)logger, (String)ReportExplorer.class.getName(), (String)"fireRenameFocusEvent");
    }

    private void renameTreeItem(final TreeItem aTreeItem) {
        Debug.enter((Logger)logger, (String)ReportExplorer.class.getName(), (String)"renameTreeItem", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "aTreeItem: " + aTreeItem.getText()});
        this.editComposite = new Composite((Composite)this.tree, 0);
        final Text editText = new Text(this.editComposite, 2048);
        this.editComposite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Rectangle rect = ReportExplorer.this.editComposite.getClientArea();
                editText.setBounds(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
            }
        });
        Listener focusOutListener = new Listener(){

            public void handleEvent(Event event) {
                Debug.enter((Logger)logger, (String)"ReportExplorer.renameTreeItem.focusOutListener", (String)"handleEvent", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId()});
                String name = editText.getText();
                IResource resource = (IResource)aTreeItem.getData("IRESOURCE");
                if (resource instanceof IFolder) {
                    ReportExplorer.this.itemToRename = aTreeItem;
                    IContainer parent2 = resource.getParent();
                    if (parent2.findMember(name) != null) {
                        ReportExplorer.this.editComposite.dispose();
                        event.doit = false;
                        Debug.exit((Logger)logger, (String)"ReportExplorer.renameTreeItem.focusOutListener", (String)"handleEvent");
                        return;
                    }
                    if (!ReportExplorer.this.checkUserInput(name, null, event)) {
                        Debug.exit((Logger)logger, (String)"ReportExplorer.renameTreeItem.focusOutListener", (String)"handleEvent");
                        return;
                    }
                    aTreeItem.setText(editText.getText());
                    ReportExplorer.this.updateName(editText.getText(), aTreeItem);
                    ReportExplorer.this.editComposite.dispose();
                    event.doit = false;
                    Debug.exit((Logger)logger, (String)"ReportExplorer.renameTreeItem.focusOutListener", (String)"handleEvent");
                    return;
                }
                IResource file = ReportExplorer.this.getCurrentContainer().findMember(String.valueOf(editText.getText()) + "." + "html");
                if (file != null) {
                    ReportExplorer.this.editComposite.dispose();
                    event.doit = false;
                    Debug.exit((Logger)logger, (String)"ReportExplorer.renameTreeItem.focusOutListener", (String)"handleEvent");
                    return;
                }
                if (!ReportExplorer.this.checkUserInput(name, "html", event)) {
                    Debug.exit((Logger)logger, (String)"ReportExplorer.renameTreeItem.focusOutListener", (String)"handleEvent");
                    return;
                }
                aTreeItem.setText(editText.getText());
                ReportExplorer.this.updateName(editText.getText(), aTreeItem);
                ReportExplorer.this.editComposite.dispose();
                event.doit = false;
                Debug.exit((Logger)logger, (String)"ReportExplorer.renameTreeItem.focusOutListener", (String)"handleEvent");
            }
        };
        Listener verifyListener = new Listener(){

            public void handleEvent(Event event) {
                Debug.enter((Logger)logger, (String)"ReportExplorer.renameTreeItem.verifyListener", (String)"handleEvent", (Object)("Thread ID: " + Thread.currentThread().getId()));
                String newText = editText.getText();
                String leftText = newText.substring(0, event.start);
                String rightText = newText.substring(event.end, newText.length());
                GC gc = new GC((Drawable)editText);
                Point size = gc.textExtent(String.valueOf(leftText) + event.text + rightText);
                gc.dispose();
                size = editText.computeSize(size.x, -1);
                ((ReportExplorer)ReportExplorer.this).treeEditor.horizontalAlignment = 16384;
                Rectangle itemRect = aTreeItem.getBounds();
                Rectangle rect = ReportExplorer.this.tree.getClientArea();
                ((ReportExplorer)ReportExplorer.this).treeEditor.minimumWidth = Math.max(size.x, itemRect.width) + 2;
                int left = itemRect.x;
                int right = rect.x + rect.width;
                ((ReportExplorer)ReportExplorer.this).treeEditor.minimumWidth = Math.min(((ReportExplorer)ReportExplorer.this).treeEditor.minimumWidth, right - left);
                ((ReportExplorer)ReportExplorer.this).treeEditor.minimumHeight = size.y + 2;
                ReportExplorer.this.treeEditor.layout();
                Debug.exit((Logger)logger, (String)"ReportExplorer.renameTreeItem.verifyListener", (String)"handleEvent");
            }
        };
        Listener traverseListener = new Listener(){

            public void handleEvent(Event event) {
                Debug.enter((Logger)logger, (String)"ReportExplorer.renameTreeItem.traverseListener", (String)"handleEvent", (Object)("Thread ID: " + Thread.currentThread().getId()));
                if (event.detail == 4) {
                    String name = editText.getText();
                    IResource resource = (IResource)aTreeItem.getData("IRESOURCE");
                    if (resource instanceof IFolder) {
                        ReportExplorer.this.itemToRename = aTreeItem;
                        IContainer parent2 = resource.getParent();
                        if (parent2.findMember(name) != null) {
                            ReportExplorer.this.editComposite.dispose();
                            event.doit = false;
                            Debug.exit((Logger)logger, (String)"ReportExplorer.renameTreeItem.traverseListener", (String)"handleEvent");
                            return;
                        }
                        if (!ReportExplorer.this.checkUserInput(name, null, event)) {
                            Debug.exit((Logger)logger, (String)"ReportExplorer.renameTreeItem.traverseListener", (String)"handleEvent");
                            return;
                        }
                        aTreeItem.setText(editText.getText());
                        ReportExplorer.this.updateName(editText.getText(), aTreeItem);
                        ReportExplorer.this.editComposite.dispose();
                        event.doit = false;
                        Debug.exit((Logger)logger, (String)"ReportExplorer.renameTreeItem.traverseListener", (String)"handleEvent");
                        return;
                    }
                    IResource file = ReportExplorer.this.getCurrentContainer().findMember(String.valueOf(editText.getText()) + "." + "html");
                    if (file == null) {
                        file = ReportExplorer.this.getCurrentContainer().findMember(String.valueOf(editText.getText()) + "." + "xml");
                    }
                    if (file == null) {
                        file = ReportExplorer.this.getCurrentContainer().findMember(String.valueOf(editText.getText()) + "." + "bld");
                    }
                    if (file != null) {
                        ReportExplorer.this.editComposite.dispose();
                        event.doit = false;
                        Debug.exit((Logger)logger, (String)"ReportExplorer.renameTreeItem.traverseListener", (String)"handleEvent");
                        return;
                    }
                    if (!ReportExplorer.this.checkUserInput(name, "html", event)) {
                        Debug.exit((Logger)logger, (String)"ReportExplorer.renameTreeItem.traverseListener", (String)"handleEvent");
                        return;
                    }
                    String timestamp = ReportManager.getUserTimeStamp((IFile)resource);
                    aTreeItem.setText(String.valueOf(editText.getText()) + timestamp);
                    ReportExplorer.this.updateName(editText.getText(), aTreeItem);
                    ReportExplorer.this.editComposite.dispose();
                    event.doit = false;
                    Debug.exit((Logger)logger, (String)"ReportExplorer.renameTreeItem.traverseListener", (String)"handleEvent");
                } else if (event.detail == 2) {
                    ReportExplorer.this.editComposite.dispose();
                    event.doit = false;
                }
                Debug.exit((Logger)logger, (String)"ReportExplorer.renameTreeItem.traverseListener", (String)"handleEvent");
            }
        };
        editText.addListener(16, focusOutListener);
        editText.addListener(25, verifyListener);
        editText.addListener(31, traverseListener);
        this.treeEditor.setEditor((Control)this.editComposite, aTreeItem);
        IResource resource = (IResource)aTreeItem.getData("IRESOURCE");
        if (resource instanceof IFile) {
            editText.setText(ReportManager.getNameWithoutTimestamp((IFile)resource));
        } else {
            editText.setText(aTreeItem.getText());
        }
        editText.selectAll();
        editText.setFocus();
        this.updatePasteActionState();
        Debug.exit((Logger)logger, (String)ReportExplorer.class.getName(), (String)"renameTreeItem");
    }

    private boolean checkUserInput(String name, String extension, Event event) {
        Debug.enter((Logger)logger, (String)ReportExplorer.class.getName(), (String)"checkUserInput", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "name: " + name, "extension: " + extension, "event: " + event.toString()});
        IPath fullPath = this.getCurrentContainer().getLocation().append(name);
        if (IAUtilities.hasContent((String)extension)) {
            fullPath = fullPath.addFileExtension(extension);
        }
        if (!(IAUtilities.hasContent((String)name) && IAUtilities.isValidFilename((String)name) && IAUtilities.isValidFilePath((String)fullPath.toOSString()))) {
            this.editComposite.dispose();
            event.doit = false;
            Debug.exit((Logger)logger, (String)ReportExplorer.class.getName(), (String)"checkUserInput", (Object)"return false");
            return false;
        }
        Debug.exit((Logger)logger, (String)ReportExplorer.class.getName(), (String)"checkUserInput", (Object)"return true");
        return true;
    }

    private IContainer getContainerForItemToRename() {
        Debug.enter((Logger)logger, (String)ReportExplorer.class.getName(), (String)"getContainerForItemToRename", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.itemToRename != null) {
            IResource resource = (IResource)this.itemToRename.getData("IRESOURCE");
            Debug.exit((Logger)logger, (String)ReportExplorer.class.getName(), (String)"getContainerForItemToRename", (Object)("return: " + (resource instanceof IFolder ? resource.getName() : resource.getParent().getName())));
            return resource instanceof IFolder ? (IContainer)resource : resource.getParent();
        }
        Debug.exit((Logger)logger, (String)ReportExplorer.class.getName(), (String)"getContainerForItemToRename", (Object)"return null");
        return null;
    }

    public void updateName(String newName, TreeItem selectedItem) {
        Debug.enter((Logger)logger, (String)ReportExplorer.class.getName(), (String)"updateName", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "newName: " + newName, "selectedItem: " + selectedItem.getText()});
        IResource resource = (IResource)selectedItem.getData("IRESOURCE");
        String oldName = resource.getFullPath().removeFileExtension().lastSegment();
        if (newName.equals(oldName)) {
            Debug.exit((Logger)logger, (String)ReportExplorer.class.getName(), (String)"updateName", (Object)"newName equals oldName");
            return;
        }
        if (resource instanceof IFolder) {
            IFolder folder = (IFolder)resource;
            Path path = new Path(newName);
            IPath newPath = path.addTrailingSeparator();
            try {
                this.reportManager.removeTreeItem((IResource)folder);
                folder.getParent().refreshLocal(2, null);
                folder.move(newPath, true, null);
                folder = folder.getParent().getFolder(newPath);
                selectedItem.setData("IRESOURCE", (Object)folder);
                this.reportManager.setTreeItem((IResource)folder, selectedItem);
                this.reportManager.refresh(this.getCurrentContainer());
            }
            catch (Exception e) {
                Debug.warning((Logger)logger, (String)ReportExplorer.class.getName(), (String)"updateName", (String)"Unable to rename folder", (Throwable)e);
                IAPlugin.getDefault().logError("Unable to rename folder", (Throwable)e);
            }
        } else {
            IFile iFile = (IFile)resource;
            String extension = iFile.getFileExtension();
            try {
                String timestamp = ReportManager.getRawTimeStamp(iFile);
                if (oldName.equals(String.valueOf(newName) + timestamp)) {
                    Debug.exit((Logger)logger, (String)ReportExplorer.class.getName(), (String)"updateName");
                    return;
                }
                Path path = new Path(String.valueOf(newName) + timestamp);
                path = path.addFileExtension(extension);
                IFile newFile = this.getCurrentContainer().getFile((IPath)path);
                iFile.move((IPath)path, true, null);
                this.reportManager.removeTreeItem((IResource)iFile);
                this.reportManager.setTreeItem((IResource)newFile, selectedItem);
                selectedItem.setData("IRESOURCE", (Object)newFile);
            }
            catch (CoreException ex) {
                Debug.warning((Logger)logger, (String)ReportExplorer.class.getName(), (String)"updateName", (String)"Unable to rename file", (Throwable)ex);
                IAPlugin.getDefault().logError("Unable to rename file", (Throwable)ex);
            }
        }
        Debug.exit((Logger)logger, (String)ReportExplorer.class.getName(), (String)"updateName");
    }

    public void doCopy() {
        Debug.enter((Logger)logger, (String)ReportExplorer.class.getName(), (String)"doCopy", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.editComposite != null && !this.editComposite.isDisposed()) {
            Text editText = (Text)this.editComposite.getChildren()[0];
            String text = editText.getSelectionText();
            if (IAUtilities.hasContent((String)text)) {
                this.clipboard.setContents((Object[])new String[]{text}, new Transfer[]{TextTransfer.getInstance()});
                this.updatePasteActionState();
            }
        } else {
            TreeItem[] selectedItems = this.tree.getSelection();
            String[] fileLocations = new String[selectedItems.length];
            if (fileLocations.length > 0) {
                int i = 0;
                while (i < selectedItems.length) {
                    IResource resource = (IResource)selectedItems[i].getData("IRESOURCE");
                    fileLocations[i] = resource.getLocation().toOSString();
                    ++i;
                }
                this.clipboard.setContents(new Object[]{fileLocations}, new Transfer[]{FileTransfer.getInstance()});
                this.updatePasteActionState();
            }
        }
        Debug.exit((Logger)logger, (String)ReportExplorer.class.getName(), (String)"doCopy");
    }

    private void updateEnablement() {
        Debug.enter((Logger)logger, (String)ReportExplorer.class.getName(), (String)"updateEnablement", (Object)("Thread ID: " + Thread.currentThread().getId()));
        boolean isOneItemSelected = this.tree.getSelectionCount() == 1;
        boolean isReportSelected = this.tree.getSelectionCount() == 1 && this.tree.getSelection()[0].getData("IRESOURCE") instanceof IFile;
        boolean isAffinityReportSelected = isReportSelected && "xml".equals(((IFile)this.tree.getSelection()[0].getData("IRESOURCE")).getFileExtension().toLowerCase());
        boolean isThreadsafeReportSelected = isReportSelected && "thr".equals(((IFile)this.tree.getSelection()[0].getData("IRESOURCE")).getFileExtension().toLowerCase());
        int buildInputsCount = 0;
        TreeItem[] treeItemArray = this.tree.getSelection();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            buildInputsCount += this.getBuildInputsCount(treeItem);
            ++n2;
        }
        boolean oneOrMoreBuildInputsSelected = buildInputsCount > 0;
        this.deleteAction.setEnabled(true);
        this.renameAction.setEnabled(isOneItemSelected);
        this.copyAction.setEnabled(true);
        if (isReportSelected) {
            this.openAction.setEnabled(true);
            this.exportIntoHtmlAction.setEnabled(true);
        } else {
            this.openAction.setEnabled(false);
            this.exportIntoHtmlAction.setEnabled(false);
        }
        if (isAffinityReportSelected || isThreadsafeReportSelected) {
            this.openInBrowserAction.setEnabled(true);
        } else {
            this.openInBrowserAction.setEnabled(false);
        }
        if (isAffinityReportSelected || oneOrMoreBuildInputsSelected) {
            this.buildAffinityReportAction.setEnabled(true);
        } else {
            this.buildAffinityReportAction.setEnabled(false);
        }
        this.updatePasteActionState();
        Debug.exit((Logger)logger, (String)ReportExplorer.class.getName(), (String)"updateEnablement");
    }

    private int getBuildInputsCount(TreeItem treeItem) {
        Debug.enter((Logger)logger, (String)ReportExplorer.class.getName(), (String)"getBuildInputsCount", (Object[])new String[]{"ThreadId: " + Thread.currentThread().getId(), "treeItem: " + treeItem.getText()});
        IResource resource = (IResource)treeItem.getData("IRESOURCE");
        if (resource instanceof IFile && (((IFile)resource).getFileExtension().toLowerCase().equals("xml") || ((IFile)resource).getFileExtension().toLowerCase().equals("bld"))) {
            Debug.exit((Logger)logger, (String)ReportExplorer.class.getName(), (String)"getBuildInputsCount", (Object)"return 1");
            return 1;
        }
        if (resource instanceof IFolder) {
            TreeItem[] items;
            int count = 0;
            TreeItem[] treeItemArray = items = treeItem.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem treeItem2 = treeItemArray[n2];
                count += this.getBuildInputsCount(treeItem2);
                ++n2;
            }
            Debug.exit((Logger)logger, (String)ReportExplorer.class.getName(), (String)"getBuildInputsCount", (Object)("return " + count));
            return count;
        }
        Debug.exit((Logger)logger, (String)ReportExplorer.class.getName(), (String)"getBuildInputsCount", (Object)"return 0");
        return 0;
    }

    private void updatePasteActionState() {
        Debug.enter((Logger)logger, (String)ReportExplorer.class.getName(), (String)"updatePasteActionState", (Object)("Thread ID: " + Thread.currentThread().getId()));
        boolean isOneItemSelected = this.tree.getSelectionCount() == 1;
        boolean canPaste = false;
        if (this.editComposite != null && !this.editComposite.isDisposed()) {
            TextTransfer textTransfer = TextTransfer.getInstance();
            Object object = this.clipboard.getContents((Transfer)textTransfer);
            if (object instanceof String) {
                canPaste = true;
            }
        } else {
            FileTransfer fileTransfer = FileTransfer.getInstance();
            String[] fileData = (String[])this.clipboard.getContents((Transfer)fileTransfer);
            if (fileData != null && fileData.length >= 1 && isOneItemSelected) {
                canPaste = true;
            }
        }
        this.pasteAction.setEnabled(canPaste);
        Debug.exit((Logger)logger, (String)ReportExplorer.class.getName(), (String)"updatePasteActionState", (Object)("canPaste: " + canPaste));
    }

    public void init(IViewSite site) throws PartInitException {
    }

    public void dispose() {
        ReportManager.removeReportManager(this.reportManager);
        this.connectionServiceListener.makeStale();
    }

    private ConnectionServiceListener getConnectionServiceListener() {
        return new ConnectionServiceListener(){

            public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
                if ("com.ibm.cics.ia.connection.db2".equals(event.getConnectionCategoryId())) {
                    if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                        this.connected();
                    } else if (event instanceof ConnectionServiceListener.DisconnectedEvent) {
                        this.disconnected();
                    }
                }
            }

            public void connected() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (Version.getInstance().getDBVersion() >= 3200 && ReportExplorer.this.newAffinityReportAction != null) {
                            ReportExplorer.this.newAffinityReportAction.setEnabled(true);
                        }
                    }
                });
            }

            public void disconnected() {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ReportExplorer.this.newAffinityReportAction != null) {
                            ReportExplorer.this.newAffinityReportAction.setEnabled(false);
                        }
                    }
                });
            }
        };
    }

    public TreeItem getRoot() {
        return this.root;
    }

    public void buildPopupMenu(IMenuManager manager, TreeItem[] selectedItems) {
        if (selectedItems.length > 0) {
            if (selectedItems[0] == this.root) {
                manager.add((IAction)this.newAffinityReportAction);
                manager.add((IAction)this.buildAffinityReportAction);
                manager.add((IAction)this.minimiseTreeAction);
                manager.add((IAction)this.maximiseTreeAction);
                manager.add((IAction)this.refreshAction);
            }
            MenuManager newMenu = new MenuManager(Messages.getString("ReportExplorer.Action.New.text"));
            newMenu.add((IAction)this.newFolderAction);
            manager.add((IContributionItem)newMenu);
            MenuManager exportMenu = new MenuManager(Messages.getString("ReportExplorer.Action.New.export"));
            exportMenu.add((IAction)this.exportIntoHtmlAction);
            if (selectedItems[0] != this.root) {
                manager.add((IAction)this.openAction);
                manager.add((IAction)this.openInBrowserAction);
                manager.add((IContributionItem)exportMenu);
                manager.add((IAction)this.buildAffinityReportAction);
                manager.add((IAction)this.copyAction);
                manager.add((IAction)this.pasteAction);
                manager.add((IAction)this.renameAction);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)this.deleteAction);
            }
        }
    }

    public void selected() {
        this.navigatorView.createDummyTopComposite();
    }
}

