/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.command.EngineShell;
import com.ibm.cics.dbfunc.command.SQLCommand;
import com.ibm.cics.ia.commands.FindRegionsCommand;
import com.ibm.cics.ia.model.AtomContent;
import com.ibm.cics.ia.model.CintCollector;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.runtime.AtomController;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.runtime.IAtomControllerListener;
import com.ibm.cics.ia.runtime.ICollectionIdListener;
import com.ibm.cics.ia.runtime.Version;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.DefaultRetrieveMorePresenterImpl;
import com.ibm.cics.ia.ui.DefaultRetrieveMoreViewImpl;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.NavigatorView;
import com.ibm.cics.ia.ui.Resource2CSV;
import com.ibm.cics.ia.ui.ResourceRenderer;
import com.ibm.cics.ia.ui.RetrieveMorePresenter;
import com.ibm.cics.ia.ui.RetrieveMoreView;
import com.ibm.cics.ia.ui.UIUtilities;
import com.ibm.cics.ia.ui.actions.AffinityReportAction;
import com.ibm.cics.ia.ui.actions.CollectorAction;
import com.ibm.cics.ia.ui.composites.HistoryBox;
import com.ibm.cics.ia.ui.composites.HistoryBoxModel;
import java.util.Collection;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;

public class RegionExplorer {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(RegionExplorer.class.getPackage().getName());
    private Tree tree;
    private FindRegionsCommand findRegionsCommand;
    private Display display;
    private HistoryBox searchHB;
    private HistoryBoxModel searchHbModel;
    private TreeItem dummyTreeItem;
    private ResourceFactory.Listener resourceFactoryListener;
    private EngineShell.EngineListener commandListener;
    private Action runAction;
    private Action copyAction;
    private MenuItem startCollector;
    private MenuItem stopCollector;
    private MenuItem pauseCollector;
    private MenuItem continueCollector;
    private Composite parent;
    private ICollectionIdListener collectionIdListener;
    private IAtomControllerListener atomControllerListener;
    private ContributionItem collectorContributionItem;
    private CollectorAction collectorStatusRefreshAction;
    private Action refreshAction;
    private TreeItem root;
    protected static final String RESOURCE_TYPE = "RESOURCE_TYPE";
    private ConnectionServiceListener connectionServiceListener;
    private NavigatorView navigatorView;
    private Composite topComposite;
    private RetrieveMoreView retrieveMoreRegionsView;
    private RetrieveMorePresenter retrieveMoreRegionsPresenter;

    public RegionExplorer(NavigatorView navigatorView) {
        this.navigatorView = navigatorView;
        this.tree = navigatorView.getTree();
        this.root = UIUtilities.createTreeItem(this.tree, Messages.getString("NavigatorView.category.regions"), ImageFactory.getRegionImage());
    }

    public void createPartControl(Composite parent) {
        Debug.enter((Logger)logger, (String)RegionExplorer.class.getName(), (String)"createPartControl", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.parent = parent;
        this.collectorStatusRefreshAction = new CollectorAction();
        this.collectorStatusRefreshAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)ImageFactory.getRefreshImage()));
        this.collectorStatusRefreshAction.setToolTipText(Messages.getString("RegionExplorer.button.refresh"));
        this.collectorStatusRefreshAction.setText(Messages.getString("RegionExplorer.button.refresh"));
        this.collectorStatusRefreshAction.setId(CollectorAction.REFRESH_ACTION);
        this.collectorStatusRefreshAction.setEnabled(true);
        this.display = parent.getDisplay();
        this.createActions();
        if (NavigatorView.isConnected()) {
            this.dummyTreeItem = UIUtilities.createDummyTreeItem(this.root);
        }
        this.tree.addKeyListener((KeyListener)new UIUtilities.CopyListener(){

            @Override
            public void copy() {
                if (RegionExplorer.this.copyAction.isEnabled()) {
                    Resource2CSV.parse(RegionExplorer.this.tree, RegionExplorer.this.display);
                }
            }
        });
        this.tree.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                RegionExplorer.this.copyAction.setEnabled(true);
            }

            public void focusGained(FocusEvent e) {
                if (RegionExplorer.this.tree.getSelection().length == 0 && RegionExplorer.this.tree.getItemCount() > 0) {
                    RegionExplorer.this.tree.setSelection(RegionExplorer.this.tree.getItem(0));
                }
                if (RegionExplorer.this.tree.getItemCount() == 0) {
                    RegionExplorer.this.copyAction.setEnabled(false);
                } else {
                    RegionExplorer.this.copyAction.setEnabled(true);
                }
            }
        });
        this.resourceFactoryListener = new ResourceFactory.Listener(){

            public void reset() {
                RegionExplorer.this.runSearch();
            }
        };
        this.retrieveMoreRegionsView = new DefaultRetrieveMoreViewImpl(this.tree, (IViewPart)this.navigatorView);
        this.retrieveMoreRegionsView.setParentItem(this.root);
        this.retrieveMoreRegionsPresenter = new DefaultRetrieveMorePresenterImpl(this.retrieveMoreRegionsView);
        this.retrieveMoreRegionsView.setPresenter(this.retrieveMoreRegionsPresenter);
        this.connectionServiceListener = this.getConnectionServiceListener();
        AtomController.getInstance().addAtomControllerListener(this.getAtomControllerListener());
        ConnectionsPlugin.getDefault().getConnectionService().addConnectionServiceListener(this.connectionServiceListener);
        IAPlugin.getDefault().addCollectionIDListener(this.getCollectionIDListener());
        Debug.exit((Logger)logger, (String)RegionExplorer.class.getName(), (String)"createPartControl");
    }

    private void clear() {
        Debug.enter((Logger)logger, (String)RegionExplorer.class.getName(), (String)"clear", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.tree != null && !this.tree.isDisposed()) {
            this.root.removeAll();
        }
        if (this.dummyTreeItem != null && !this.dummyTreeItem.isDisposed()) {
            this.dummyTreeItem.dispose();
        }
        if (this.retrieveMoreRegionsView != null) {
            this.retrieveMoreRegionsView.hide();
        }
        if (this.findRegionsCommand != null) {
            if (this.findRegionsCommand.status() == 0) {
                this.findRegionsCommand.removeListener(this.getCommandListener());
                this.findRegionsCommand.cancel();
            }
            this.findRegionsCommand = null;
        }
        this.navigatorView.getViewSite().getActionBars().getStatusLineManager().setErrorMessage(null);
        if (this.navigatorView.getSelectionProvider() != null) {
            this.navigatorView.getSelectionProvider().setSelection((ISelection)StructuredSelection.EMPTY);
        }
        Debug.exit((Logger)logger, (String)RegionExplorer.class.getName(), (String)"clear");
    }

    public Job runSearch() {
        Debug.enter((Logger)logger, (String)RegionExplorer.class.getName(), (String)"runSearch", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.clear();
        IConnectable resourceManager = ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.ia.connection.db2");
        if (!resourceManager.isConnected()) {
            Debug.exit((Logger)logger, (String)RegionExplorer.class.getName(), (String)"runSearch", (Object)"return null");
            return null;
        }
        if (this.tree != null && !this.tree.isDisposed()) {
            this.dummyTreeItem = UIUtilities.createDummyTreeItem(this.root);
            this.findRegionsCommand = new FindRegionsCommand();
            this.findRegionsCommand.setRegionMask(UIUtilities.widgetExists((Widget)this.searchHB) ? this.searchHB.getText(true) : "");
            this.findRegionsCommand.addListener(this.getCommandListener());
            this.retrieveMoreRegionsPresenter.setCommand((Command)this.findRegionsCommand);
            this.parent.setCursor(this.parent.getDisplay().getSystemCursor(3));
            final String taskName = Messages.getString("RegionExplorer.taskname");
            Job findRegionsJob = new Job(taskName){

                protected IStatus run(IProgressMonitor monitor) {
                    Debug.enter((Logger)logger, (String)"RegionExplorer.runSearch().findRegionsJob", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                    monitor.beginTask(taskName, -1);
                    RegionExplorer.this.refreshAction.setEnabled(false);
                    RegionExplorer.this.collectorStatusRefreshAction.setEnabled(false);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (UIUtilities.widgetExists((Widget)RegionExplorer.this.searchHB)) {
                                RegionExplorer.this.searchHB.setEnabled(false);
                            }
                        }
                    });
                    if (RegionExplorer.this.findRegionsCommand != null) {
                        RegionExplorer.this.findRegionsCommand.setAsync(false);
                        RegionExplorer.this.findRegionsCommand.start();
                    }
                    monitor.done();
                    RegionExplorer.this.refreshAction.setEnabled(true);
                    RegionExplorer.this.collectorStatusRefreshAction.setEnabled(true);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (UIUtilities.widgetExists((Widget)RegionExplorer.this.searchHB)) {
                                RegionExplorer.this.searchHB.setEnabled(true);
                            }
                        }
                    });
                    Debug.exit((Logger)logger, (String)"RegionExplorer.runSearch().findRegionsJob", (String)"run");
                    return Status.OK_STATUS;
                }

                protected void canceling() {
                    super.canceling();
                    RegionExplorer.this.findRegionsCommand.pause();
                }
            };
            findRegionsJob.schedule();
            this.retrieveMoreRegionsPresenter.setTaskName(taskName);
            Debug.exit((Logger)logger, (String)RegionExplorer.class.getName(), (String)"runSearch", (Object)("findRegionsJob: " + findRegionsJob.getName()));
            return findRegionsJob;
        }
        Debug.exit((Logger)logger, (String)RegionExplorer.class.getName(), (String)"runSearch", (Object)"return null");
        return null;
    }

    private EngineShell.EngineListener getCommandListener() {
        if (this.commandListener == null) {
            this.commandListener = new EngineShell.EngineListener(){

                public void dataAvailable(final Collection<Object> items) {
                    RegionExplorer.this.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            RegionExplorer.this.regionsFound(items);
                        }
                    });
                }

                public void notifyResultCount(int count) {
                }

                public void statusUpdate(EngineShell.EngineStatus es) {
                    switch (es) {
                        case Paused: {
                            RegionExplorer.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (RegionExplorer.this.parent != null && !RegionExplorer.this.parent.isDisposed()) {
                                        if (RegionExplorer.this.retrieveMoreRegionsView != null) {
                                            RegionExplorer.this.retrieveMoreRegionsView.show();
                                        }
                                        RegionExplorer.this.parent.setCursor(null);
                                    }
                                    RegionExplorer.this.collectorStatusRefreshAction.run();
                                }
                            });
                            break;
                        }
                        case Complete: {
                            RegionExplorer.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!RegionExplorer.this.parent.isDisposed()) {
                                        RegionExplorer.this.parent.setCursor(null);
                                    }
                                    RegionExplorer.this.collectorStatusRefreshAction.run();
                                }
                            });
                            break;
                        }
                        case Error: {
                            RegionExplorer.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!RegionExplorer.this.parent.isDisposed()) {
                                        RegionExplorer.this.parent.setCursor(null);
                                        RegionExplorer.this.clear();
                                    }
                                }
                            });
                        }
                        case Cancelled: {
                            RegionExplorer.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!RegionExplorer.this.parent.isDisposed()) {
                                        RegionExplorer.this.parent.setCursor(null);
                                        RegionExplorer.this.clear();
                                    }
                                }
                            });
                        }
                    }
                }
            };
        }
        return this.commandListener;
    }

    private void regionsFound(Collection items) {
        Debug.enter((Logger)logger, (String)RegionExplorer.class.getName(), (String)"regionsFound", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "items size: " + items.size()});
        this.tree.setRedraw(false);
        if (this.dummyTreeItem != null) {
            this.dummyTreeItem.dispose();
            this.dummyTreeItem = null;
        }
        for (Region region : items) {
            TreeItem item = new TreeItem(this.root, 0);
            item.setText(region.getName());
            item.setData((Object)region);
            item.setImage(ResourceRenderer.asImage(region));
            this.tree.setData(region.getName(), (Object)item);
        }
        this.tree.setRedraw(true);
        Debug.exit((Logger)logger, (String)RegionExplorer.class.getName(), (String)"regionsFound");
    }

    private void errorFound(Throwable e) {
    }

    public void setFocus() {
    }

    public void dispose() {
        Debug.enter((Logger)logger, (String)RegionExplorer.class.getName(), (String)"dispose", (Object)("Thread ID: " + Thread.currentThread().getId()));
        AtomController.getInstance().removeAtomControllerListener(this.getAtomControllerListener());
        IAPlugin.getDefault().removeCollectionIDListener(this.getCollectionIDListener());
        if (this.connectionServiceListener != null) {
            this.connectionServiceListener.makeStale();
        }
        Debug.exit((Logger)logger, (String)RegionExplorer.class.getName(), (String)"dispose");
    }

    public void init(IViewSite site) throws PartInitException {
    }

    private ConnectionServiceListener getConnectionServiceListener() {
        return new ConnectionServiceListener(){

            public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
                if ("com.ibm.cics.ia.connection.db2".equals(event.getConnectionCategoryId())) {
                    if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                        this.connected();
                    } else if (event instanceof ConnectionServiceListener.DisconnectedEvent) {
                        this.disconnected();
                    }
                }
            }

            public void connected() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ISelectionProvider provider;
                        RegionExplorer.this.clear();
                        RegionExplorer.this.dummyTreeItem = NavigatorView.createDummyIfNotExists(RegionExplorer.this.dummyTreeItem, RegionExplorer.this.root);
                        IWorkbenchPartSite site = RegionExplorer.this.navigatorView.getSite();
                        if (site != null && (provider = site.getSelectionProvider()) != null) {
                            provider.setSelection((ISelection)StructuredSelection.EMPTY);
                        }
                    }
                });
            }

            public void disconnected() {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ISelectionProvider provider;
                        RegionExplorer.this.clear();
                        IWorkbenchPartSite site = RegionExplorer.this.navigatorView.getSite();
                        if (site != null && (provider = site.getSelectionProvider()) != null) {
                            provider.setSelection((ISelection)StructuredSelection.EMPTY);
                        }
                    }
                });
            }
        };
    }

    private ICollectionIdListener getCollectionIDListener() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"getCollectionIDListener", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.collectionIdListener == null) {
            this.collectionIdListener = new ICollectionIdListener(){

                public void collectionIdChanged(String collectionId) {
                    if (NavigatorView.isConnected() && !UIUtilities.widgetExists((Widget)RegionExplorer.this.dummyTreeItem)) {
                        RegionExplorer.this.clear();
                        RegionExplorer.this.dummyTreeItem = UIUtilities.createDummyTreeItem(RegionExplorer.this.root);
                        UIUtilities.expandTree(RegionExplorer.this.root, false);
                    }
                }
            };
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"getCollectionIDListener");
        return this.collectionIdListener;
    }

    private void createActions() {
        this.runAction = new Action(){

            public void run() {
                RegionExplorer.this.runSearch();
            }
        };
        this.refreshAction = new Action(Messages.getString("RegionExplorer.refreshButtonText"), ImageDescriptor.createFromImage((Image)ImageFactory.getRefreshImage())){

            public void run() {
                RegionExplorer.this.runSearch();
            }
        };
        this.navigatorView.getViewSite().getActionBars().setGlobalActionHandler("com.ibm.cics.ia.action.run", (IAction)this.runAction);
        this.copyAction = new Action("Copy", null){

            public void run() {
                if (RegionExplorer.this.tree.isFocusControl()) {
                    Resource2CSV.parse(RegionExplorer.this.tree, RegionExplorer.this.display);
                }
            }
        };
        this.navigatorView.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
    }

    private IAtomControllerListener getAtomControllerListener() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"getAtomControllerListener", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.atomControllerListener == null) {
            this.atomControllerListener = new IAtomControllerListener(){

                public void disconnected(final IConnection connection) {
                    Debug.enter((Logger)logger, (String)(String.valueOf(RegionExplorer.class.getName()) + "." + this.getClass().getName()), (String)"disconnected", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "connection: " + connection.getName()});
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TreeItem[] treeItemArray = RegionExplorer.this.root.getItems();
                            int n = treeItemArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Region region;
                                CintCollector cintCollector;
                                TreeItem item = treeItemArray[n2];
                                if (item.getData() instanceof Region && ((cintCollector = (region = (Region)item.getData()).getCollector()) == null || cintCollector != null && connection.getConfiguration().getID().equals(cintCollector.getConnectionID()))) {
                                    region.setCintCollector(null);
                                    if (!item.isDisposed()) {
                                        item.setImage(ResourceRenderer.asImage(region));
                                    } else {
                                        RegionExplorer.this.tree.setData(region.getName(), null);
                                    }
                                }
                                ++n2;
                            }
                        }
                    });
                    Debug.exit((Logger)logger, (String)(String.valueOf(RegionExplorer.class.getName()) + "." + this.getClass().getName()), (String)"disconnected");
                }

                public void connected(IConnection connection) {
                    Debug.enter((Logger)logger, (String)(String.valueOf(RegionExplorer.class.getName()) + "." + this.getClass().getName()), (String)"connected", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "connection: " + connection.getName()});
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            RegionExplorer.this.collectorStatusRefreshAction.run();
                        }
                    });
                    Debug.exit((Logger)logger, (String)(String.valueOf(RegionExplorer.class.getName()) + "." + this.getClass().getName()), (String)"connected");
                }
            };
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"getAtomControllerListener");
        return this.atomControllerListener;
    }

    public void updateCollectorStatus(Collection<AtomContent> collectors) {
        Debug.enter((Logger)logger, (String)RegionExplorer.class.getName(), (String)"updateCollectorStatus", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "collectors size: " + collectors.size()});
        if (this.tree != null && !this.tree.isDisposed()) {
            for (AtomContent content : collectors) {
                CintCollector cintCollector;
                Region region;
                TreeItem item;
                if (!(content instanceof CintCollector) || (item = (TreeItem)this.tree.getData((region = (cintCollector = (CintCollector)content).getRegion()).getName())) == null) continue;
                if (!item.isDisposed()) {
                    item.setImage(ResourceRenderer.asImage(region));
                    continue;
                }
                this.tree.setData(region.getName(), null);
            }
        }
        Debug.exit((Logger)logger, (String)RegionExplorer.class.getName(), (String)"updateCollectorStatus");
    }

    public TreeItem getRoot() {
        return this.root;
    }

    public void buildPopupMenu(IMenuManager manager, TreeItem[] selectedItems) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"buildPopupMenu", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "selectedItems length: " + selectedItems.length});
        if (selectedItems.length > 0 && selectedItems[0] == this.root) {
            manager.add((IAction)this.refreshAction);
            manager.add((IAction)this.collectorStatusRefreshAction);
        }
        if (selectedItems.length > 1) {
            Region[] regions = new Region[selectedItems.length];
            int i = 0;
            while (i < selectedItems.length) {
                regions[i] = (Region)selectedItems[i].getData();
                ++i;
            }
            AffinityReportAction affinityReportAction = new AffinityReportAction(regions);
            affinityReportAction.setText(Messages.getString("RegionExplorer.AffinityReport.Action"));
            if (Version.getInstance().getDBVersion() < 3200) {
                affinityReportAction.setEnabled(false);
            }
            manager.add((IAction)affinityReportAction);
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"buildPopupMenu");
    }

    public void rootExpanded() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"rootExpanded", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (NavigatorView.canRunCommand((SQLCommand)this.findRegionsCommand) && UIUtilities.widgetExists((Widget)this.dummyTreeItem) && NavigatorView.isConnected()) {
            if (this.navigatorView.getTopComposite() != this.topComposite) {
                this.createTopComposite();
            }
            this.runSearch();
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"rootExpanded");
    }

    private void createTopComposite() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"createTopComposite", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.topComposite = new Composite(this.parent, 0);
        GridData data = new GridData(4, 0, true, false);
        this.topComposite.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 2;
        this.topComposite.setLayout((Layout)gridLayout);
        this.topComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RegionExplorer.this.searchHbModel = RegionExplorer.this.searchHB.getModel();
            }
        });
        Label filterName = new Label(this.topComposite, 0);
        filterName.setText(Messages.getString("NavigatorView.category.regions"));
        data = new GridData(4, 0x1000000, false, false);
        filterName.setLayoutData((Object)data);
        this.searchHB = new HistoryBox(this.topComposite, 128);
        if (this.searchHbModel != null) {
            this.searchHB.setModel(this.searchHbModel);
        }
        data = new GridData(4, 0x1000000, false, false);
        data.widthHint = 70;
        this.searchHB.setLayoutData(data);
        this.searchHB.setToolTipText(com.ibm.cics.ia.controller.Messages.getString("FindResourceContributionItem.txt.usewildcardregion"));
        this.searchHB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                IConnectable resourceManager = ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.ia.connection.db2");
                if (!resourceManager.isConnected()) {
                    Activator.getDefault().ensureConnected();
                } else {
                    RegionExplorer.this.runSearch();
                }
            }
        });
        this.searchHB.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                AccessibleEvent i = e;
                i.toString();
                e.result = Messages.getString("RegionExplorer.access.msg.filterbyname");
            }
        });
        this.navigatorView.setTopComposite(this.topComposite);
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"createTopComposite");
    }

    public void selected() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"selected", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.navigatorView.getTopComposite() != this.topComposite) {
            this.createTopComposite();
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"selected");
    }

    public void refresh(final Action afterRefreshAction) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"refresh", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Job runJob = this.runSearch();
        if (runJob != null) {
            runJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    afterRefreshAction.run();
                }
            });
        } else {
            afterRefreshAction.run();
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"refresh");
    }
}

