/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.command.EngineShell;
import com.ibm.cics.dbfunc.command.SQLCommand;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.dbfunc.ui.ScrollLimitManager;
import com.ibm.cics.eclipse.common.ui.JobWithCancelingSupport;
import com.ibm.cics.ia.commands.IColumnResultsCommand;
import com.ibm.cics.ia.commands.IQueryCommand;
import com.ibm.cics.ia.commands.QueryCommand;
import com.ibm.cics.ia.commands.QueryResultsCommand;
import com.ibm.cics.ia.controller.DisplayableData;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.query.QueryResultRow;
import com.ibm.cics.ia.query.QueryResults;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.CommandHistoryManager;
import com.ibm.cics.ia.ui.CompareResourcesDialog;
import com.ibm.cics.ia.ui.DefaultEditorInputImpl;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.LabelProviderFactory;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.QueryManager;
import com.ibm.cics.ia.ui.SelectionProvider;
import com.ibm.cics.ia.ui.TreeSelectionProvider;
import com.ibm.cics.ia.ui.UIUtilities;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.part.EditorPart;

public class QueryResultsView
extends EditorPart
implements ISaveablePart {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(QueryResultsView.class.getPackage().getName());
    public static final String ID = "com.ibm.cics.ia.ui.queryresultsview";
    private static final String ITEMS_MAP = "ITEMS_MAP";
    private static final String RESOURCE = "RESOURCE";
    public static final DefaultEditorInputImpl DEFAULT_EDITOR_INPUT = new DefaultEditorInputImpl(){};
    private Tree queryResultsTree;
    private Label titleLabel;
    private Label totalsLabel;
    private ToolBar toolBar;
    private Display display;
    private CommandHistoryManager commandHistoryManager;
    private Action saveResultsAction;
    private Action copyResultsAction;
    private ScrollLimitManager scrollLimitManager;
    private IColumnResultsCommand currentSearch;
    private EngineShell.EngineListener commandListener;
    private Map rootItems = new HashMap();
    private LabelProvider[] columnLabelProviders;
    protected Composite c;
    private Clipboard clipboard;
    private Composite parent;
    private TreeItem dummyTreeItem;
    private Job queryJob;
    private Action compareHistoryAction;
    private String currentTitle;
    private int searchTotal;
    private boolean isSaveAllowed;
    private boolean isDirty;
    private Action maximiseTreeAction;
    private Action minimiseTreeAction;
    private SelectionProvider selectionProvider;
    private ConnectionServiceListener connectionServiceListener;

    public void createPartControl(Composite parent) {
        Debug.enter((Logger)logger, (String)QueryResultsView.class.getName(), (String)"createPartControl", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId()});
        this.parent = parent;
        IWorkbenchHelpSystem helpSystem = this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)parent, "com.ibm.cics.ia.help.resources_explorer");
        this.clipboard = new Clipboard(parent.getDisplay());
        this.commandHistoryManager = new CommandHistoryManager(){

            @Override
            void executeCommand(Command aCommand) {
                QueryResultsView.this.cancelSearch(aCommand);
                QueryResultsView.this.executeSearch(aCommand);
            }
        };
        this.c = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 2;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.c.setLayout((Layout)gridLayout);
        this.toolBar = UIUtilities.createToolBar(this.c);
        Composite searchComposite = new Composite(this.c, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 2;
        searchComposite.setLayout((Layout)gridLayout);
        searchComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.titleLabel = new Label(searchComposite, 64);
        this.titleLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.totalsLabel = new Label(searchComposite, 0);
        GridData data = new GridData(0x1000008, 0, false, false);
        this.totalsLabel.setLayoutData((Object)data);
        this.totalsLabel.setText("    ");
        this.createResultsArea(this.c);
        this.scrollLimitManager = new ScrollLimitManager(this.c, Messages.getString("QueryResultsView.txt.resource"), (IWorkbenchPart)this){

            public void scrollLimitReached(Command command) {
                super.scrollLimitReached(command);
                QueryResultsView.this.c.layout(new Control[]{QueryResultsView.this.queryResultsTree, ((QueryResultsView)QueryResultsView.this).scrollLimitManager.scrollLimitComposite});
            }

            public void dispose() {
                QueryResultsView.this.c.layout(new Control[]{QueryResultsView.this.queryResultsTree});
                super.dispose();
            }
        };
        this.updateCompareHistoryActionState();
        this.connectionServiceListener = this.getConnectionServiceListener();
        ConnectionsPlugin.getDefault().getConnectionService().addConnectionServiceListener(this.connectionServiceListener);
        Debug.exit((Logger)logger, (String)QueryResultsView.class.getName(), (String)"createPartControl");
    }

    public String getTitleToolTip() {
        return this.getTitle();
    }

    private boolean updateCompareHistoryActionState() {
        boolean result;
        Debug.enter((Logger)logger, (String)QueryResultsView.class.getName(), (String)"updateCompareHistoryActionState", (Object)("Thread ID: " + Thread.currentThread().getId()));
        boolean bl = result = this.currentSearch != null && this.currentSearch.getResults() != null;
        if (this.currentSearch instanceof SQLCommand) {
            result = result && ((SQLCommand)this.currentSearch).status() == 1;
        }
        this.compareHistoryAction.setEnabled(result);
        Debug.exit((Logger)logger, (String)QueryResultsView.class.getName(), (String)"updateCompareHistoryActionState");
        return result;
    }

    public void dispose() {
        Debug.enter((Logger)logger, (String)QueryResultsView.class.getName(), (String)"dispose", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.connectionServiceListener != null) {
            this.connectionServiceListener.makeStale();
        }
        super.dispose();
        Debug.exit((Logger)logger, (String)QueryResultsView.class.getName(), (String)"dispose");
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"init", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "site:" + site.getRegisteredName(), "input: " + input.getName()});
        if (DEFAULT_EDITOR_INPUT != input) {
            throw new PartInitException("Invalid Input: Must be QueryResultsView.DEFAULT_EDITOR_INPUT");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"init");
    }

    private ConnectionServiceListener getConnectionServiceListener() {
        return new ConnectionServiceListener(){

            public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
                if ("com.ibm.cics.ia.connection.db2".equals(event.getConnectionCategoryId())) {
                    if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                        this.connected();
                    } else if (event instanceof ConnectionServiceListener.DisconnectedEvent) {
                        this.disconnected();
                    } else if (event instanceof ConnectionServiceListener.ExceptionEvent) {
                        this.exception();
                    }
                }
            }

            public void connected() {
                Debug.enter((Logger)logger, (String)QueryResultsView.class.getName(), (String)"connected", (Object)("ThreadID :" + Thread.currentThread().getId()));
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ISelectionProvider provider;
                        QueryResultsView.this.clear();
                        IWorkbenchPartSite site = QueryResultsView.this.getSite();
                        if (site != null && (provider = site.getSelectionProvider()) != null) {
                            provider.setSelection((ISelection)StructuredSelection.EMPTY);
                        }
                        if (QueryResultsView.this.queryResultsTree != null && !QueryResultsView.this.queryResultsTree.isDisposed()) {
                            if (QueryResultsView.this.scrollLimitManager != null) {
                                QueryResultsView.this.scrollLimitManager.dispose();
                            }
                            if (QueryResultsView.this.titleLabel != null && !QueryResultsView.this.titleLabel.isDisposed()) {
                                QueryResultsView.this.setTitleLabel("");
                            }
                            if (QueryResultsView.this.currentSearch != null) {
                                if (QueryResultsView.this.currentSearch instanceof SQLCommand) {
                                    SQLCommand search = (SQLCommand)QueryResultsView.this.currentSearch;
                                    if (search.status() != 1 && search.status() != 0 && search.status() != 3 && search.status() != 2) {
                                        QueryResultsView.this.rerun();
                                    }
                                } else {
                                    QueryResultsView.this.rerun();
                                }
                            }
                        }
                    }
                });
                Debug.exit((Logger)logger, (String)QueryResultsView.class.getName(), (String)"connected");
            }

            public void disconnected() {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ISelectionProvider provider;
                        QueryResultsView.this.commandHistoryManager.clear();
                        QueryResultsView.this.clear();
                        IWorkbenchPartSite site = QueryResultsView.this.getSite();
                        if (site != null && (provider = site.getSelectionProvider()) != null) {
                            provider.setSelection((ISelection)StructuredSelection.EMPTY);
                        }
                        if (QueryResultsView.this.queryResultsTree != null && !QueryResultsView.this.queryResultsTree.isDisposed()) {
                            QueryResultsView.this.scrollLimitManager.dispose();
                        }
                        if (QueryResultsView.this.titleLabel != null && !QueryResultsView.this.titleLabel.isDisposed()) {
                            QueryResultsView.this.setTitleLabel("");
                        }
                    }
                });
            }

            public void exception() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (QueryResultsView.this.currentSearch != null && QueryResultsView.this.currentSearch instanceof SQLCommand) {
                            SQLCommand search = (SQLCommand)QueryResultsView.this.currentSearch;
                            if (search.status() != 1) {
                                search.cancel();
                            }
                            search.removeListener(QueryResultsView.this.getCommandListener());
                        }
                    }
                });
            }
        };
    }

    protected void rerun() {
        this.c.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (QueryResultsView.this.currentSearch != null) {
                    if (QueryResultsView.this.currentSearch instanceof SQLCommand) {
                        ((SQLCommand)QueryResultsView.this.currentSearch).reset();
                    }
                    QueryResultsView.this.clear();
                    QueryResultsView.this.executeSearch((Command)QueryResultsView.this.currentSearch);
                }
            }
        });
    }

    private Control createResultsArea(Composite aComposite) {
        Debug.enter((Logger)logger, (String)QueryResultsView.class.getName(), (String)"createResultsArea", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId()});
        this.display = aComposite.getDisplay();
        this.queryResultsTree = new Tree(aComposite, 2564);
        GridData data = new GridData(4, 4, true, true);
        this.queryResultsTree.setLayoutData((Object)data);
        this.selectionProvider = new TreeSelectionProvider(this.queryResultsTree, RESOURCE);
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        MenuManager menuMgr = new MenuManager();
        Menu popupMenu = menuMgr.createContextMenu((Control)this.queryResultsTree);
        this.queryResultsTree.setMenu(popupMenu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.selectionProvider);
        this.createActions();
        this.queryResultsTree.addKeyListener((KeyListener)new UIUtilities.CopyListener(){

            @Override
            public void copy() {
                QueryResultsView.this.doCopy();
            }
        });
        this.queryResultsTree.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.result == null) {
                    e.result = Messages.getString("QueryResultsView.noResultsAccessText");
                }
                StringBuffer buffer = new StringBuffer();
                if (QueryResultsView.this.currentSearch != null) {
                    buffer.append(MessageFormat.format(Messages.getString("QueryResultsView.searchresultsAccessText"), QueryResultsView.this.currentTitle, Integer.toString(QueryResultsView.this.searchTotal)));
                } else {
                    buffer.append(Messages.getString("QueryResultsView.noSearchTextAccessibility"));
                }
                buffer.append(". ");
                buffer.append(e.result);
                e.result = buffer.toString();
                super.getName(e);
            }
        });
        Debug.exit((Logger)logger, (String)QueryResultsView.class.getName(), (String)"createResultsArea");
        return this.queryResultsTree;
    }

    private void setTitleLabel(final String aString) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (QueryResultsView.this.titleLabel != null) {
                    QueryResultsView.this.titleLabel.setText(aString);
                    QueryResultsView.this.titleLabel.getParent().getParent().layout(true);
                }
            }
        });
    }

    public void showDummyTree() {
        this.clear();
        this.dummyTreeItem = UIUtilities.createDummyTreeItem(this.queryResultsTree);
    }

    public synchronized Job executeSearch(Command aCommand) {
        Debug.enter((Logger)logger, (String)QueryResultsView.class.getName(), (String)"executeSearch", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "command: " + aCommand.getDescription()});
        this.clear();
        this.scrollLimitManager.dispose();
        DisplayableData data = (DisplayableData)aCommand.getAdapter(DisplayableData.class);
        if (data != null) {
            this.currentTitle = data.getDescription();
            this.setTitleLabel(this.currentTitle);
            aCommand.setDescription(this.currentTitle);
        } else {
            this.setTitleLabel(IAUtilities.EMPTY_STRING);
        }
        this.currentSearch = (IColumnResultsCommand)aCommand;
        IConnectable resourceManager = ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.ia.connection.db2");
        if (!resourceManager.isConnected()) {
            return this.queryJob;
        }
        this.setSearchInProgress(true);
        this.commandHistoryManager.searchStarted(aCommand);
        if (this.currentSearch instanceof IQueryCommand) {
            IQueryCommand iQueryCommand = (IQueryCommand)this.currentSearch;
        }
        if (this.columnLabelProviders == null) {
            this.columnLabelProviders = new LabelProvider[this.currentSearch.getColumns().length];
            String[] columnLabels = this.currentSearch.getColumns();
            int i = 0;
            while (i < columnLabels.length) {
                String columnID = columnLabels[i];
                this.columnLabelProviders[i] = LabelProviderFactory.getLabelProvider(columnID);
                ++i;
            }
        }
        if (this.currentSearch instanceof SQLCommand) {
            final SQLCommand currentSQLSearch = (SQLCommand)this.currentSearch;
            if (currentSQLSearch.status() == -1) {
                currentSQLSearch.addListener(this.getCommandListener());
                this.dummyTreeItem = UIUtilities.createDummyTreeItem(this.queryResultsTree);
                final String jobName = data != null ? this.currentTitle : "";
                this.queryJob = new JobWithCancelingSupport(jobName){

                    protected IStatus runSub(IProgressMonitor monitor) {
                        Debug.enter((Logger)logger, (String)"QueryResultsView.executeSearch.queryJob", (String)"run", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId()});
                        monitor.beginTask(jobName, -1);
                        currentSQLSearch.setAsync(false);
                        currentSQLSearch.start();
                        monitor.done();
                        IAPlugin.getDefault().taskEnded();
                        Debug.exit((Logger)logger, (String)"QueryResultsView.executeSearch.queryJob", (String)"run");
                        return Status.OK_STATUS;
                    }

                    protected void cancelingSub() {
                        super.canceling();
                        IAPlugin.getDefault().taskEnded();
                    }
                };
                this.scrollLimitManager.setTaskName(jobName);
                UIUtilities.scheduleWorkbenchPartJob((IWorkbenchPart)this, this.queryJob);
            } else {
                List results = currentSQLSearch.getResults();
                if (results == null) {
                    List listeners = currentSQLSearch.getListeners();
                    if (!listeners.contains(this.getCommandListener())) {
                        currentSQLSearch.addListener(this.getCommandListener());
                    }
                    this.dummyTreeItem = UIUtilities.createDummyTreeItem(this.queryResultsTree);
                    if (data != null) {
                        data.setStatus(-1);
                        this.currentTitle = data.getDescription();
                        this.setTitleLabel(this.currentTitle);
                        aCommand.setDescription(this.currentTitle);
                    } else {
                        this.setTitleLabel(IAUtilities.EMPTY_STRING);
                    }
                    final String jobName = data != null ? this.currentTitle : "";
                    this.queryJob = new JobWithCancelingSupport(jobName){

                        protected IStatus runSub(IProgressMonitor monitor) {
                            Debug.enter((Logger)logger, (String)"QueryResultsView.executeSearch.queryJob", (String)"run", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId()});
                            monitor.beginTask(jobName, -1);
                            currentSQLSearch.reset();
                            currentSQLSearch.start();
                            monitor.done();
                            IAPlugin.getDefault().taskEnded();
                            Debug.exit((Logger)logger, (String)"QueryResultsView.executeSearch.queryJob", (String)"run");
                            return Status.OK_STATUS;
                        }

                        protected void cancelingSub() {
                            super.canceling();
                            IAPlugin.getDefault().taskEnded();
                        }
                    };
                    this.scrollLimitManager.setTaskName(jobName);
                    UIUtilities.scheduleWorkbenchPartJob((IWorkbenchPart)this, this.queryJob);
                } else {
                    this.insertResults(results);
                    this.processCommandResults(true);
                }
            }
        } else {
            if (aCommand.status() == -1) {
                aCommand.start();
            }
            this.insertResults(aCommand.getResults());
            this.processCommandResults(true);
        }
        this.checkIfNoResultsFound();
        Debug.exit((Logger)logger, (String)QueryResultsView.class.getName(), (String)"executeSearch");
        return this.queryJob;
    }

    private void clear() {
        Debug.enter((Logger)logger, (String)QueryResultsView.class.getName(), (String)"clear", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.queryResultsTree != null && !this.queryResultsTree.isDisposed()) {
            this.queryResultsTree.removeAll();
        }
        this.rootItems.clear();
        this.columnLabelProviders = null;
        if (this.titleLabel != null && !this.titleLabel.isDisposed()) {
            this.titleLabel.setText("");
        }
        if (this.totalsLabel != null && !this.totalsLabel.isDisposed()) {
            this.totalsLabel.setText("");
        }
        this.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(null);
        if (this.selectionProvider != null) {
            this.selectionProvider.setSelection((ISelection)StructuredSelection.EMPTY);
        }
        Debug.exit((Logger)logger, (String)QueryResultsView.class.getName(), (String)"clear");
    }

    private void queryCompleted() {
        Debug.enter((Logger)logger, (String)QueryResultsView.class.getName(), (String)"queryCompleted", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.scrollLimitManager.dispose();
        this.processCommandResults(false);
        this.checkIfNoResultsFound();
        Debug.exit((Logger)logger, (String)QueryResultsView.class.getName(), (String)"queryCompleted");
    }

    private void checkIfNoResultsFound() {
        Debug.enter((Logger)logger, (String)QueryResultsView.class.getName(), (String)"checkIfNoResultsFound", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.queryResultsTree.getItemCount() == 0) {
            this.dummyTreeItem = new TreeItem(this.queryResultsTree, 0);
            this.dummyTreeItem.setText(Messages.getString("QueryResultsView.noResultsText"));
        }
        Debug.exit((Logger)logger, (String)QueryResultsView.class.getName(), (String)"checkIfNoResultsFound");
    }

    private EngineShell.EngineListener getCurrentCommandListener() {
        return this.commandListener;
    }

    private EngineShell.EngineListener getCommandListener() {
        Debug.enter((Logger)logger, (String)QueryResultsView.class.getName(), (String)"getCommandListener", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.commandListener == null) {
            this.commandListener = new EngineShell.EngineListener(){

                public void dataAvailable(final Collection<Object> items) {
                    final 11 localListener = this;
                    if (this == QueryResultsView.this.getCommandListener()) {
                        QueryResultsView.this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (localListener != QueryResultsView.this.getCurrentCommandListener()) {
                                    return;
                                }
                                try {
                                    try {
                                        if (!(this).QueryResultsView.this.c.isDisposed()) {
                                            QueryResultsView.this.queryResultsTree.setRedraw(false);
                                            QueryResultsView.this.insertResults(items);
                                        }
                                    }
                                    catch (Exception e) {
                                        Debug.warning((Logger)logger, (String)QueryResultsView.class.getName(), (String)"getCommandListener", (String)"Unable to insert results", (Throwable)e);
                                        IAPlugin.getDefault().logError("Unable to insert results", (Throwable)e);
                                        QueryResultsView.this.updateTotals(false);
                                        if (!(this).QueryResultsView.this.c.isDisposed()) {
                                            QueryResultsView.this.queryResultsTree.setRedraw(true);
                                        }
                                    }
                                }
                                finally {
                                    QueryResultsView.this.updateTotals(false);
                                    if (!(this).QueryResultsView.this.c.isDisposed()) {
                                        QueryResultsView.this.queryResultsTree.setRedraw(true);
                                    }
                                }
                            }
                        });
                    }
                }

                public void notifyResultCount(int count) {
                }

                public void statusUpdate(EngineShell.EngineStatus es) {
                    switch (es) {
                        case Paused: {
                            QueryResultsView.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!(this).QueryResultsView.this.c.isDisposed()) {
                                        QueryResultsView.this.updateCompareHistoryActionState();
                                        QueryResultsView.this.scrollLimitManager.scrollLimitReached((Command)QueryResultsView.this.currentSearch);
                                        (this).QueryResultsView.this.c.setCursor(null);
                                    }
                                }
                            });
                            break;
                        }
                        case Complete: {
                            QueryResultsView.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!(this).QueryResultsView.this.c.isDisposed()) {
                                        QueryResultsView.this.queryCompleted();
                                    }
                                }
                            });
                            break;
                        }
                        case Error: {
                            if (QueryResultsView.this.c.isDisposed()) break;
                            QueryResultsView.this.setSearchInProgress(false);
                            break;
                        }
                        case Cancelled: {
                            if (QueryResultsView.this.c.isDisposed()) break;
                            QueryResultsView.this.setSearchInProgress(false);
                        }
                    }
                }
            };
        }
        Debug.exit((Logger)logger, (String)QueryResultsView.class.getName(), (String)"getCommandListener");
        return this.commandListener;
    }

    private void updateTotals(boolean isComplete) {
        Debug.enter((Logger)logger, (String)QueryResultsView.class.getName(), (String)"updateTotals", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "isComplete: " + isComplete});
        if (!this.c.isDisposed()) {
            int total = this.updateTotals(this.queryResultsTree.getItems());
            this.totalsLabel.setText("(" + total + ")");
            this.totalsLabel.getParent().layout(true);
            DisplayableData displayableData = DisplayableData.getDisplayableData((IAdaptable)this.currentSearch);
            displayableData.setSize(total);
            this.searchTotal = total;
        }
        Debug.exit((Logger)logger, (String)QueryResultsView.class.getName(), (String)"updateTotals");
    }

    private int updateTotals(TreeItem[] treeItems) {
        Debug.enter((Logger)logger, (String)QueryResultsView.class.getName(), (String)"updateTotals", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "treeItems: " + treeItems.toString()});
        int total = 0;
        int i = 0;
        while (i < treeItems.length) {
            TreeItem item = treeItems[i];
            int childCount = item.getItemCount();
            String itemText = this.getItemText(item);
            if (childCount > 0) {
                item.setText(String.valueOf(itemText) + "  (" + childCount + ")");
                total += this.updateTotals(item.getItems());
            } else {
                ++total;
            }
            ++i;
        }
        Debug.exit((Logger)logger, (String)QueryResultsView.class.getName(), (String)"updateTotals");
        return total;
    }

    private String getItemText(TreeItem aTreeItem) {
        Debug.enter((Logger)logger, (String)QueryResultsView.class.getName(), (String)"getItemText", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "atreeItem: " + aTreeItem.toString()});
        String itemText = (String)aTreeItem.getData("TEXT");
        if (itemText == null) {
            itemText = aTreeItem.getText();
            aTreeItem.setData("TEXT", (Object)itemText);
        }
        Debug.exit((Logger)logger, (String)QueryResultsView.class.getName(), (String)"getItemText");
        return itemText;
    }

    private void insertResults(Collection results) {
        Debug.enter((Logger)logger, (String)QueryResultsView.class.getName(), (String)"insertResults", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "results: " + results.toString()});
        if (this.dummyTreeItem != null) {
            this.dummyTreeItem.dispose();
        }
        this.queryResultsTree.setRedraw(false);
        if (this.currentSearch instanceof IQueryCommand) {
            Object queryRows;
            String[] userColumns;
            IQueryCommand queryCommand = (IQueryCommand)this.currentSearch;
            Presentation presentationObject = queryCommand.getQuery();
            if (this.currentSearch instanceof QueryResultsCommand) {
                userColumns = ((QueryResultsCommand)this.currentSearch).getColumns();
            } else {
                Iterator iter = presentationObject.getSelection().getOrderBy().getColumns().iterator();
                int i = 0;
                userColumns = new String[presentationObject.getSelection().getOrderBy().getColumns().size()];
                while (iter.hasNext()) {
                    userColumns[i] = ((ColumnReference)iter.next()).getColumnName();
                    ++i;
                }
                iter = presentationObject.getSelection().getOrderBy().getColumns().iterator();
                i = 0;
                ArrayList<String> groupByColumns = new ArrayList<String>();
                while (iter.hasNext()) {
                    groupByColumns.add(((ColumnReference)iter.next()).getColumnName());
                }
            }
            if (userColumns.length == 1) {
                queryRows = QueryResultRow.getRows((Collection)results);
                this.insertResults((List)queryRows, null, 0);
            } else {
                queryRows = QueryResultRow.getRowsByColumn((String[])this.currentSearch.getColumns(), (Collection)results);
                this.insertResults((Map)queryRows, null, 0);
            }
        } else {
            String[] columns = this.currentSearch.getColumns();
            if (columns.length == 1) {
                List queryRows = QueryResultRow.getRows((Collection)results);
                this.insertResults(queryRows, null, 0);
            } else {
                Map queryRows = QueryResultRow.getRowsByColumn((String[])columns, (Collection)results);
                this.insertResults(queryRows, null, 0);
            }
        }
        this.queryResultsTree.setRedraw(true);
        this.updateCompareHistoryActionState();
        Debug.exit((Logger)logger, (String)QueryResultsView.class.getName(), (String)"insertResults");
    }

    private void insertResults(Map results, TreeItem parentItem, int depth) {
        Debug.enter((Logger)logger, (String)QueryResultsView.class.getName(), (String)"insertResults", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "results: " + results, "parentItem: " + parentItem, "depth: " + depth});
        for (Map.Entry keyAndValue : results.entrySet()) {
            TreeItem keyItem;
            Object key = keyAndValue.getKey();
            Object value = keyAndValue.getValue();
            TreeItem treeItem = keyItem = parentItem == null ? (TreeItem)this.rootItems.get(key) : (TreeItem)((Map)parentItem.getData(ITEMS_MAP)).get(key);
            if (keyItem == null) {
                if (parentItem == null) {
                    keyItem = UIUtilities.createTreeItem(this.queryResultsTree, this.asText(depth, key), this.asImage(depth, key));
                    this.rootItems.put(key, keyItem);
                } else {
                    keyItem = UIUtilities.createTreeItem(parentItem, this.asText(depth, key), this.asImage(depth, key));
                    Map itemsMap = (Map)parentItem.getData(ITEMS_MAP);
                    itemsMap.put(key, keyItem);
                }
                if (key instanceof Resource) {
                    keyItem.setData(RESOURCE, key);
                }
                keyItem.setData(ITEMS_MAP, new HashMap());
            }
            if (value instanceof Map) {
                this.insertResults((Map)value, keyItem, depth + 1);
                continue;
            }
            if (!(value instanceof List)) continue;
            this.insertResults((List)value, keyItem, depth + 1);
        }
        Debug.exit((Logger)logger, (String)QueryResultsView.class.getName(), (String)"insertResults");
    }

    private String asText(int columnNumber, Object column) {
        if (this.columnLabelProviders[columnNumber] == null) {
            return column.toString();
        }
        return this.columnLabelProviders[columnNumber].getText(column);
    }

    private Image asImage(int columnNumber, Object column) {
        if (this.columnLabelProviders[columnNumber] == null) {
            return ImageFactory.getFolderImage();
        }
        return this.columnLabelProviders[columnNumber].getImage(column);
    }

    private void insertResults(List results, TreeItem parentItem, int depth) {
        Debug.enter((Logger)logger, (String)QueryResultsView.class.getName(), (String)"insertResults", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "results: " + results, "parentItem: " + parentItem, "depth: " + depth});
        for (Object value : results) {
            TreeItem treeItem = parentItem == null ? UIUtilities.createTreeItem(this.queryResultsTree, this.asText(depth, value), this.asImage(depth, value)) : UIUtilities.createTreeItem(parentItem, this.asText(depth, value), this.asImage(depth, value));
            treeItem.setText(this.asText(depth, value));
            treeItem.setImage(this.asImage(depth, value));
            if (!(value instanceof Resource)) continue;
            treeItem.setData(RESOURCE, value);
        }
        this.updateCompareHistoryActionState();
        Debug.exit((Logger)logger, (String)QueryResultsView.class.getName(), (String)"insertResults");
    }

    private void processCommandResults(boolean isHistoricSearch) {
        Debug.enter((Logger)logger, (String)QueryResultsView.class.getName(), (String)"processCommandResults", (Object[])new String[]{"ThreadID: " + Thread.currentThread().getId(), "isHistoricSearch: " + isHistoricSearch});
        this.setSearchInProgress(false);
        this.updateTotals(true);
        Debug.exit((Logger)logger, (String)QueryResultsView.class.getName(), (String)"processCommandResults");
    }

    private void setSearchInProgress(final boolean aBool) {
        Debug.enter((Logger)logger, (String)QueryResultsView.class.getName(), (String)"setSearchInProgress", (Object[])new String[]{"ThreadID: " + Thread.currentThread().getId(), "aBool: " + aBool});
        Runnable r = new Runnable(){

            @Override
            public void run() {
                SQLCommand currentSQLSearch;
                Throwable error;
                QueryResultsView.this.totalsLabel.setEnabled(!aBool);
                QueryResultsView.this.copyResultsAction.setEnabled(!aBool);
                if (QueryResultsView.this.currentSearch instanceof QueryCommand) {
                    QueryCommand queryCommand = (QueryCommand)QueryResultsView.this.currentSearch;
                    QueryResultsView.this.saveResultsAction.setEnabled(!aBool && queryCommand.isSaveable());
                } else {
                    QueryResultsView.this.saveResultsAction.setEnabled(false);
                }
                if (aBool) {
                    QueryResultsView.this.c.setCursor(QueryResultsView.this.parent.getDisplay().getSystemCursor(3));
                } else {
                    QueryResultsView.this.c.setCursor(null);
                }
                if (QueryResultsView.this.currentSearch instanceof SQLCommand && (error = (currentSQLSearch = (SQLCommand)QueryResultsView.this.currentSearch).getError()) != null) {
                    QueryResultsView.this.clear();
                    QueryResultsView.this.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(MessageFormat.format(Messages.getString("QueryResultsView.errorMessage"), error.toString()));
                    DisplayableData displayableData = DisplayableData.getDisplayableData((IAdaptable)currentSQLSearch);
                    displayableData.setStatus(currentSQLSearch.status());
                    QueryResultsView.this.setTitleLabel(displayableData.getDescription());
                }
            }
        };
        if (Display.getCurrent() == null) {
            this.display.asyncExec(r);
        } else {
            r.run();
        }
        Debug.exit((Logger)logger, (String)QueryResultsView.class.getName(), (String)"setSearchInProgress");
    }

    private void createActions() {
        this.maximiseTreeAction = new Action(){

            public void run() {
                UIUtilities.expandTree(QueryResultsView.this.queryResultsTree, true);
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageDescriptor.createFromImage((Image)ImageFactory.getExpandImage());
            }
        };
        this.maximiseTreeAction.setToolTipText(Messages.getString("Button.tooltip.maximise"));
        this.minimiseTreeAction = new Action(){

            public void run() {
                UIUtilities.expandTree(QueryResultsView.this.queryResultsTree, false);
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageDescriptor.createFromImage((Image)ImageFactory.getCollapseImage());
            }
        };
        this.minimiseTreeAction.setToolTipText(Messages.getString("Button.tooltip.minimise"));
        this.compareHistoryAction = new Action(Messages.getString("QueryResultsView.compareResourcesText"), ImageDescriptor.createFromImage((Image)ImageFactory.getSearchHistoryImage())){

            public void run() {
                CompareResourcesDialog compareDialog = new CompareResourcesDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                compareDialog.setCurrentSearch(QueryResultsView.this.currentSearch);
                compareDialog.setSearchHistory(((QueryResultsView)QueryResultsView.this).commandHistoryManager.searchHistory);
                compareDialog.open();
            }

            public int getStyle() {
                return 4;
            }
        };
        this.compareHistoryAction.setMenuCreator(this.commandHistoryManager.getHistoryMenuCreator());
        this.copyResultsAction = new Action(Messages.getString("QueryResultsView.action.copy"), ImageDescriptor.createFromImage((Image)ImageFactory.getSaveImage())){

            public void run() {
                QueryResultsView.this.doCopy();
            }
        };
        this.saveResultsAction = new Action(Messages.getString("QueryResultsView.action.save"), ImageDescriptor.createFromImage((Image)ImageFactory.getSaveImage())){
            private boolean oldenabled;

            public String getId() {
                return ActionFactory.SAVE.getId();
            }

            public void run() {
                QueryResultsView.this.doSave(null);
            }

            public ImageDescriptor getDisabledImageDescriptor() {
                return ImageDescriptor.createFromImage((Image)ImageFactory.getSaveImage());
            }

            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                QueryResultsView.this.isDirty = enabled;
                QueryResultsView.this.isSaveAllowed = enabled;
                if (this.oldenabled != enabled) {
                    QueryResultsView.this.fireDirty();
                }
                this.oldenabled = enabled;
            }
        };
        this.saveResultsAction.setEnabled(false);
        this.copyResultsAction.setEnabled(false);
        ToolBarManager toolBarManager = new ToolBarManager(this.toolBar);
        toolBarManager.add((IAction)this.minimiseTreeAction);
        toolBarManager.add((IAction)this.maximiseTreeAction);
        this.commandHistoryManager.createActions((IToolBarManager)toolBarManager);
        toolBarManager.add((IAction)this.compareHistoryAction);
        toolBarManager.update(true);
        this.toolBar.pack();
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyResultsAction);
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.SAVE.getId(), (IAction)this.saveResultsAction);
    }

    protected void fireDirty() {
        this.firePropertyChange(257);
    }

    public void setFocus() {
        this.queryResultsTree.setFocus();
    }

    public void cancelSearch(Command command) {
        SQLCommand currentSQLSearch;
        Debug.enter((Logger)logger, (String)QueryResultsView.class.getName(), (String)"cancelSearch", (Object[])new String[]{"ThreadId: " + Thread.currentThread().getId(), "command: " + command.getDescription()});
        if (this.queryJob != null) {
            currentSQLSearch = (SQLCommand)this.currentSearch;
            UIUtilities.cancel((Command)currentSQLSearch);
            this.setTitleLabel(DisplayableData.getDisplayableData((IAdaptable)currentSQLSearch).getDescription());
            this.queryJob.cancel();
            this.queryJob = null;
        }
        if (this.currentSearch instanceof SQLCommand) {
            currentSQLSearch = (SQLCommand)this.currentSearch;
            UIUtilities.cancel((Command)currentSQLSearch);
            currentSQLSearch.removeListener(this.getCommandListener());
        }
        this.currentSearch = (IColumnResultsCommand)command;
        Debug.exit((Logger)logger, (String)QueryResultsView.class.getName(), (String)"cancelSearch");
    }

    public void doSave(IProgressMonitor monitor) {
        Debug.enter((Logger)logger, (String)QueryResultsView.class.getName(), (String)"doSave", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String resultName = Messages.getString("QueryResultsView.txt.saveresult.enterdescription");
        InputDialog inputDialog = new InputDialog(this.queryResultsTree.getShell(), Messages.getString("QueryResultsView.dialog.savequeryresults"), Messages.getString("QueryResultsView.dialog.enterdesc"), resultName, null);
        if (inputDialog.open() == 0) {
            ArrayList results = new ArrayList(this.currentSearch.getResults().size());
            results.addAll(this.currentSearch.getResults());
            QueryCommand queryCommand = (QueryCommand)this.currentSearch;
            Presentation presentationObject = queryCommand.getQuery();
            try {
                String description = queryCommand.getDescription();
                QueryResults result = new QueryResults(inputDialog.getValue(), queryCommand.getResults(), presentationObject, queryCommand.getCollectionIdAtRuntime());
                QueryManager.getSingleton().saveQueryResults(presentationObject, result);
            }
            catch (IOException e) {
                Debug.warning((Logger)logger, (String)QueryResultsView.class.getName(), (String)"doSave", (String)"Unable to save results", (Throwable)e);
                IAPlugin.getDefault().logError("Unable to save results for query " + presentationObject.getTitle(), (Throwable)e);
            }
            catch (CoreException e) {
                Debug.warning((Logger)logger, (String)QueryResultsView.class.getName(), (String)"doSave", (String)"Unable to save results", (Throwable)e);
                IAPlugin.getDefault().logError("Unable to save results for query " + presentationObject.getTitle(), (Throwable)e);
            }
        }
        Debug.exit((Logger)logger, (String)QueryResultsView.class.getName(), (String)"doSave");
    }

    public void doCopy() {
        Debug.enter((Logger)logger, (String)QueryResultsView.class.getName(), (String)"doCopy", (Object)("ThreadId: " + Thread.currentThread().getId()));
        List results = null;
        if (this.currentSearch != null && !this.rootItems.isEmpty()) {
            results = this.currentSearch.getResults();
        }
        if (results != null && results.size() > 0) {
            String copyString = UIUtilities.getClipboardData(this.currentSearch.getColumns(), this.currentSearch.getResults());
            this.clipboard.setContents(new Object[]{copyString}, new Transfer[]{TextTransfer.getInstance()});
        }
        Debug.exit((Logger)logger, (String)QueryResultsView.class.getName(), (String)"doCopy");
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    public String getPartProperty(String key) {
        if (IConnectionCategory.class.getName().equals(key)) {
            return "com.ibm.cics.ia.connection.db2";
        }
        return super.getPartProperty(key);
    }

    public Command getCurrentSearch() {
        return (Command)this.currentSearch;
    }

    public void unDirty() {
        this.isDirty = false;
        this.fireDirty();
    }
}

