/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.PurgeDataCollector;
import com.ibm.cics.ia.model.PurgeRunnable;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.ui.PurgeProcessPage;
import com.ibm.cics.ia.ui.PurgeTablesSelectionPage;
import com.ibm.cics.ia.ui.actions.Messages;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class PurgeWizard
extends Wizard {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(PurgeWizard.class.getPackage().getName());
    private PurgeTablesSelectionPage tablesSelectionPage;
    private PurgeProcessPage processPage;
    private PurgeDataCollector data;

    public boolean performFinish() {
        Debug.enter((Logger)logger, (String)PurgeWizard.class.getName(), (String)"performFinish", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.processPage.getData().getRowsCount() != 0) {
            try {
                new ProgressMonitorDialog(null).run(true, true, (IRunnableWithProgress)new PurgeRunnable(this.data));
            }
            catch (InvocationTargetException e) {
                Debug.error((Logger)logger, (String)PurgeWizard.class.getName(), (String)"performFinish", (Throwable)e);
                MessageDialog.openError(null, (String)"Error", (String)e.getMessage());
            }
            catch (InterruptedException e) {
                Debug.event((Logger)logger, (Level)Level.FINE, (String)PurgeWizard.class.getName(), (String)"performFinish", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), e.getMessage()});
                MessageDialog.openInformation(null, (String)"Cancelled", (String)e.getMessage());
            }
        }
        Debug.exit((Logger)logger, (String)PurgeWizard.class.getName(), (String)"performFinish");
        return true;
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage() == this.processPage;
    }

    public PurgeWizard(Program program, Region region) {
        Debug.enter((Logger)logger, (String)PurgeWizard.class.getName(), (String)"PurgeWizard()", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "program: " + (program == null ? program : program.getName()), "region: " + (region == null ? region : region.getName())});
        this.setWindowTitle(Messages.getString("PurgeWizard.title"));
        this.data = new PurgeDataCollector();
        this.data.setProgram(program);
        if (region == null) {
            this.data.setRegions(program.getRegions());
        } else {
            this.data.setRegions(region);
        }
        this.addPages();
        Debug.exit((Logger)logger, (String)PurgeWizard.class.getName(), (String)"PurgeWizard()");
    }

    public void addPages() {
        this.tablesSelectionPage = new PurgeTablesSelectionPage("Select tables", this.data.getProgram());
        this.processPage = new PurgeProcessPage("Purge process", this.data.getProgram());
        this.processPage.setPageComplete(false);
        this.addPage((IWizardPage)this.tablesSelectionPage);
        this.addPage((IWizardPage)this.processPage);
        this.tablesSelectionPage.setData(this.data);
    }

    public IWizardPage getNextPage(IWizardPage currentPage) {
        String pageName = currentPage.getName();
        if (currentPage.getClass() == PurgeTablesSelectionPage.class) {
            this.data = this.tablesSelectionPage.getData();
            this.processPage.setData(this.data);
            return this.processPage;
        }
        return super.getNextPage(currentPage);
    }
}

