/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.PurgeDataCollector;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.storedproc.ProcedureCIUSPDPG;
import com.ibm.cics.ia.ui.actions.Messages;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class PurgeTablesSelectionPage
extends WizardPage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(PurgeTablesSelectionPage.class.getPackage().getName());
    private Program program;
    private Table targetTables;
    private List<String> selectedTables;
    public PurgeDataCollector data;
    private static final String[] items = new String[]{"CICS", "DB2", "IMS", "MQ", "NATURAL"};

    public PurgeTablesSelectionPage(String pageName, Program program) {
        super(pageName);
        this.program = program;
        this.selectedTables = new ArrayList<String>();
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.selectedTables.add("CIU_" + name + "_DATA");
            ++n2;
        }
        this.setTitle(Messages.getString("PurgeWizard.tableSelect.label.text"));
    }

    public void createControl(Composite parent) {
        Debug.enter((Logger)logger, (String)PurgeTablesSelectionPage.class.getName(), (String)"createControl()", (Object)("Thread ID: " + Thread.currentThread().getId()));
        ProcedureCIUSPDPG procedure = new ProcedureCIUSPDPG();
        boolean available = procedure.isAvailable(this.program.getName(), IAUtilities.getDB2DataTableName());
        if (!available) {
            MessageDialog.openError((Shell)parent.getShell(), (String)"PurgeWizard.IsNotAvailable.title", (String)"PurgeWizard.IsNotAvailable.text");
            Debug.exit((Logger)logger, (String)PurgeTablesSelectionPage.class.getName(), (String)"createControl");
            return;
        }
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)parent, "com.ibm.cics.ia.help.purge_wizard");
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)gridLayout);
        this.targetTables = this.createTable(composite, 32, items);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 1;
        this.targetTables.setLayoutData((Object)gridData);
        this.targetTables.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = PurgeTablesSelectionPage.this.targetTables.getItems();
                boolean hasChecked = false;
                PurgeTablesSelectionPage.this.selectedTables.clear();
                TableItem[] tableItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (item.getChecked()) {
                        PurgeTablesSelectionPage.this.selectedTables.add("CIU_" + item.getText() + "_DATA");
                        hasChecked = true;
                    }
                    ++n2;
                }
                PurgeTablesSelectionPage.this.data.setSelectedTables(PurgeTablesSelectionPage.this.selectedTables);
                PurgeTablesSelectionPage.this.setPageComplete(hasChecked);
            }
        });
        this.setControl((Control)composite);
        Debug.exit((Logger)logger, (String)PurgeTablesSelectionPage.class.getName(), (String)"createControl");
    }

    public Table createTable(Composite parent, int mode, Object[] contents) {
        Table table = new Table(parent, 2852);
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        this.createTableColumn(table, 1, Messages.getString("PurgeWizard.Column.TABLE"));
        this.addTableContents(table, contents);
        table.getColumn(0).pack();
        return table;
    }

    public TableColumn createTableColumn(Table table, int style, String title) {
        TableColumn tc = new TableColumn(table, style);
        tc.setText(title);
        tc.setResizable(true);
        return tc;
    }

    public void addTableContents(Table table, Object[] items) {
        int i = 0;
        while (i < items.length) {
            String item = (String)items[i];
            TableItem ti = new TableItem(table, 0);
            ti.setText(item);
            ti.setChecked(true);
            ++i;
        }
    }

    public PurgeDataCollector getData() {
        if (this.data.getSelectedTables().isEmpty()) {
            this.data.setSelectedTables(this.selectedTables);
        }
        return this.data;
    }

    public List<String> getSelectedTables() {
        return this.selectedTables;
    }

    public void setSelectedTables(List<String> selectedTables) {
        this.selectedTables = selectedTables;
    }

    public void setData(PurgeDataCollector data) {
        this.data = data;
    }
}

