/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.StoredProcedureCommand;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.dbfunc.model.StoredProcedure;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.PurgeDataCollector;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.storedproc.ProcedureCIUSPDPG;
import com.ibm.cics.ia.ui.SelectRowsForPurgeCommand;
import com.ibm.cics.ia.ui.actions.Messages;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class PurgeProcessPage
extends WizardPage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(PurgeProcessPage.class.getPackage().getName());
    private TreeViewer viewer;
    private PurgeDataCollector data;
    protected SelectionObject selection;
    private List<HashMap<String, String>> resultsList;
    private List<RowForPurge> listOfRows;
    private List<String> notEmptyTables;
    public Runnable fillTable = new Runnable(){

        @Override
        public void run() {
            Debug.enter((Logger)logger, (String)PurgeProcessPage.class.getName(), (String)"fillTable.run()", (Object)("ThreadID = " + Thread.currentThread().getId()));
            Program program = PurgeProcessPage.this.data.getProgram();
            PurgeProcessPage.this.notEmptyTables = new ArrayList();
            final String programName = program.getName();
            PurgeProcessPage.this.resultsList.clear();
            int i = 0;
            while (i < PurgeProcessPage.this.data.getRegions().size()) {
                int j = 0;
                while (j < PurgeProcessPage.this.data.getSelectedTables().size()) {
                    ArrayList<HashMap> tempResultsList = new ArrayList<HashMap>();
                    final Region region = (Region)PurgeProcessPage.this.data.getRegions().get(i);
                    final String table = (String)PurgeProcessPage.this.data.getSelectedTables().get(j);
                    StoredProcedureCommand command = new StoredProcedureCommand(){
                        private SelectionObject selectionObject;

                        public Object processRow(ResultSet resultSet) throws SQLException {
                            return null;
                        }

                        public SelectionObject getSelectionObject() {
                            ProcedureCIUSPDPG procedure = new ProcedureCIUSPDPG();
                            (this).PurgeProcessPage.this.selection = this.selectionObject = procedure.getSelectionObject("L", region.getName(), programName, table);
                            return this.selectionObject;
                        }
                    };
                    command.setCategory("com.ibm.cics.ia.connection.db2");
                    command.setAsync(false);
                    command.start();
                    if (command.status() != 1 && command.status() != 3) {
                        if (command.status() == 2) {
                            MessageDialog.open((int)1, null, (String)"Error", (String)Messages.getString("PurgeWizard.procedureExecuteError.message"), (int)1);
                            Debug.exit((Logger)logger, (String)PurgeProcessPage.class.getName(), (String)"fillTable.run()", (Object)Messages.getString("PurgeWizard.procedureExecuteError.message"));
                            return;
                        }
                    } else if (command.status() == 1) {
                        Map outputParameters = ((StoredProcedure)PurgeProcessPage.this.selection).getOutputValues();
                        if ((Integer)outputParameters.get("RC") != 0) {
                            String message = (String)outputParameters.get("ERRMSG");
                            Debug.event((Logger)logger, (Level)Level.FINE, (String)PurgeProcessPage.class.getName(), (String)"fillTable.run()", (Object)message);
                        } else {
                            SelectRowsForPurgeCommand rowsForPurge = new SelectRowsForPurgeCommand();
                            rowsForPurge.setAsync(false);
                            rowsForPurge.start();
                            if (rowsForPurge.status() == 1) {
                                List results = rowsForPurge.getResults();
                                if (results.size() != 0 && !PurgeProcessPage.this.notEmptyTables.contains(table)) {
                                    PurgeProcessPage.this.notEmptyTables.add(table);
                                }
                                int k = 0;
                                while (k < results.size()) {
                                    HashMap temp = (HashMap)results.get(k);
                                    temp.put("TABLE", table);
                                    if (!tempResultsList.contains(temp)) {
                                        tempResultsList.add(temp);
                                    }
                                    ++k;
                                }
                                results.clear();
                            }
                            PurgeProcessPage.this.resultsList.addAll(tempResultsList);
                            tempResultsList.clear();
                        }
                    }
                    ++j;
                }
                ++i;
            }
            PurgeProcessPage.this.listOfRows.clear();
            for (HashMap recordFromTable : PurgeProcessPage.this.resultsList) {
                RowForPurge parentRow = new RowForPurge((String)recordFromTable.get("TABLE"));
                RowForPurge childRow = new RowForPurge((String)recordFromTable.get("COLLECTION_ID"), (String)recordFromTable.get("APPLID"), (String)recordFromTable.get("PROGRAM"), (String)recordFromTable.get("PROGLEN"), (String)recordFromTable.get("FIRST_RUN"), (String)recordFromTable.get("LAST_RUN"));
                if (!PurgeProcessPage.this.listOfRows.contains(parentRow)) {
                    parentRow.children.add(childRow);
                    childRow.setParent(parentRow);
                    PurgeProcessPage.this.listOfRows.add(parentRow);
                    continue;
                }
                ((RowForPurge)PurgeProcessPage.this.listOfRows.get(PurgeProcessPage.this.listOfRows.indexOf(parentRow))).children.add(childRow);
                childRow.setParent((RowForPurge)PurgeProcessPage.this.listOfRows.get(PurgeProcessPage.this.listOfRows.indexOf(parentRow)));
            }
            PurgeProcessPage.this.data.setRowsCount(PurgeProcessPage.this.listOfRows.size());
            Debug.exit((Logger)logger, (String)PurgeProcessPage.class.getName(), (String)"fillTable.run()");
        }
    };

    public PurgeProcessPage(String pageName, Program program) {
        super(pageName);
        this.data = new PurgeDataCollector();
        this.data.setProgram(program);
        this.resultsList = new ArrayList<HashMap<String, String>>();
        this.listOfRows = new ArrayList<RowForPurge>();
        this.setTitle(Messages.getString("PurgeWizard.purgedRows.label"));
    }

    public PurgeProcessPage() {
        super("PurgeWizardProcessPage");
        this.data = new PurgeDataCollector();
        this.listOfRows = new ArrayList<RowForPurge>();
    }

    public PurgeDataCollector getData() {
        return this.data;
    }

    public void setData(PurgeDataCollector data) {
        this.data = data;
        this.listOfRows = new ArrayList<RowForPurge>();
    }

    public void createControl(Composite parent) {
        Debug.enter((Logger)logger, (String)PurgeProcessPage.class.getName(), (String)"createControl", (Object)("ThreadID = " + Thread.currentThread().getId()));
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)parent, "com.ibm.cics.ia.help.purge_wizard");
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)gridLayout);
        this.viewer = new TreeViewer(composite, 2820);
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ContentProvider());
        String[] columns = new String[]{Messages.getString("PurgeWizard.Column.TABLE"), Messages.getString("PurgeWizard.Column.COLLECTION_ID"), Messages.getString("PurgeWizard.Column.APPLID"), Messages.getString("PurgeWizard.Column.PROGLEN"), Messages.getString("PurgeWizard.Column.FIRST_RUN"), Messages.getString("PurgeWizard.Column.LAST_RUN")};
        LabelProvider[] labelProviders = new LabelProvider[]{new TableLabelProvider(), new CollectionLabelProvider(), new RegionLabelProvider(), new ProglenLabelProvider(), new FirstRunLabelProvider(), new LastRunLabelProvider()};
        int i = 0;
        while (i < columns.length) {
            TreeViewerColumn Column = new TreeViewerColumn(this.viewer, 4);
            Column.getColumn().setText(columns[i]);
            Column.getColumn().pack();
            Column.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)labelProviders[i]));
            ++i;
        }
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                final TreeItem treeItem = (TreeItem)e.item;
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TreeColumn[] treeColumnArray = treeItem.getParent().getColumns();
                        int n = treeColumnArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeColumn tc = treeColumnArray[n2];
                            tc.pack();
                            ++n2;
                        }
                    }
                });
            }
        };
        this.viewer.getTree().addListener(18, listener);
        this.viewer.getTree().addListener(17, listener);
        this.setControl((Control)composite);
        Debug.exit((Logger)logger, (String)PurgeProcessPage.class.getName(), (String)"createControl");
    }

    public Control getControl() {
        BusyIndicator.showWhile((Display)this.getContainer().getShell().getDisplay(), (Runnable)this.fillTable);
        int i = 0;
        while (i < this.data.getSelectedTables().size()) {
            if (!this.notEmptyTables.contains(this.data.getSelectedTables().get(i))) {
                this.data.getSelectedTables().remove(i);
                --i;
            }
            ++i;
        }
        this.viewer.setInput(this.listOfRows);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.viewer.getTree().setLayoutData((Object)gridData);
        return super.getControl();
    }

    class CollectionLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        CollectionLabelProvider() {
        }

        public StyledString getStyledText(Object element) {
            if (element instanceof RowForPurge) {
                return new StyledString(((RowForPurge)element).collectionID);
            }
            return null;
        }
    }

    class ContentProvider
    implements ITreeContentProvider {
        ContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof RowForPurge) {
                RowForPurge row = (RowForPurge)inputElement;
                return row.getChildren();
            }
            ArrayList rows = (ArrayList)inputElement;
            Object[] res = rows.toArray(new RowForPurge[rows.size()]);
            return res;
        }

        public Object[] getChildren(Object parentElement) {
            return this.getElements(parentElement);
        }

        public Object getParent(Object element) {
            RowForPurge row = (RowForPurge)element;
            return row.getParent();
        }

        public boolean hasChildren(Object element) {
            RowForPurge row = (RowForPurge)element;
            return row.getChildren() != null;
        }
    }

    class FirstRunLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        FirstRunLabelProvider() {
        }

        public StyledString getStyledText(Object element) {
            if (element instanceof RowForPurge) {
                return new StyledString(((RowForPurge)element).firstRun);
            }
            return null;
        }
    }

    class LastRunLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        LastRunLabelProvider() {
        }

        public StyledString getStyledText(Object element) {
            if (element instanceof RowForPurge) {
                return new StyledString(((RowForPurge)element).lastRun);
            }
            return null;
        }
    }

    class ProglenLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        ProglenLabelProvider() {
        }

        public StyledString getStyledText(Object element) {
            if (element instanceof RowForPurge) {
                return new StyledString(((RowForPurge)element).proglen);
            }
            return null;
        }
    }

    class RegionLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        RegionLabelProvider() {
        }

        public StyledString getStyledText(Object element) {
            if (element instanceof RowForPurge) {
                return new StyledString(((RowForPurge)element).applID);
            }
            return null;
        }
    }

    class RowForPurge {
        private String collectionID;
        private String applID;
        private String program;
        private String proglen;
        private String firstRun;
        private String lastRun;
        private String table;
        private RowForPurge parent;
        private List<RowForPurge> children;

        public RowForPurge(String table) {
            if (!table.isEmpty()) {
                this.table = table;
            }
            this.collectionID = "";
            this.applID = "";
            this.program = "";
            this.proglen = "";
            this.firstRun = "";
            this.lastRun = "";
            this.parent = null;
            this.children = new ArrayList<RowForPurge>();
        }

        public RowForPurge(String collectionID, String applID, String program, String proglen, String firstRun, String lastRun) {
            this("");
            this.collectionID = collectionID;
            this.applID = applID;
            this.program = program;
            this.proglen = proglen;
            this.firstRun = firstRun;
            this.lastRun = lastRun;
        }

        public RowForPurge getParent() {
            return this.parent;
        }

        public void setParent(RowForPurge parent) {
            if (parent.getTable() != null) {
                this.table = parent.table;
            }
            this.parent = parent;
        }

        public String getTable() {
            return this.table;
        }

        public boolean equals(Object o) {
            if (o instanceof RowForPurge) {
                RowForPurge row = (RowForPurge)o;
                if (this.collectionID == row.collectionID && this.applID == row.applID && this.table == row.table && this.program == row.program && this.proglen == row.proglen && this.firstRun == row.firstRun && this.lastRun == row.lastRun) {
                    return true;
                }
            }
            return false;
        }

        public RowForPurge[] getChildren() {
            if (!this.children.isEmpty()) {
                return this.children.toArray(new RowForPurge[this.children.size()]);
            }
            return null;
        }

        public void setChildren(List<RowForPurge> children) {
            this.children = children;
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        TableLabelProvider() {
        }

        public StyledString getStyledText(Object element) {
            if (element instanceof RowForPurge) {
                RowForPurge row = (RowForPurge)element;
                StyledString styledString = new StyledString(row.table);
                RowForPurge[] rows = row.getChildren();
                if (rows != null) {
                    styledString.append(" (" + rows.length + ") ", StyledString.COUNTER_STYLER);
                }
                return styledString;
            }
            return null;
        }

        public void dispose() {
        }
    }
}

