/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.TreeNode;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.LabeledHistoryBox;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.ProgramFlowsContentProvider;
import com.ibm.cics.ia.ui.ProgramFlowsLabelProvider;
import com.ibm.cics.ia.ui.ProgramFlowsPresenter;
import com.ibm.cics.ia.ui.ProgramFlowsView;
import com.ibm.cics.ia.ui.ProgramFlowsViewInput;
import com.ibm.cics.ia.ui.ShowDetailsStrategy;
import com.ibm.cics.ia.ui.TreeSelectionProvider;
import com.ibm.cics.ia.ui.UIUtilities;
import com.ibm.cics.ia.ui.composites.HistoryBox;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.part.EditorPart;

public class ProgramFlowsViewImpl
extends EditorPart
implements ProgramFlowsView {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ProgramFlowsViewImpl.class.getPackage().getName());
    public static final String ID = "com.ibm.cics.ia.ui.ProgramFlowsViewImpl";
    private Composite parent;
    private TreeViewer treeViewer;
    private LabeledHistoryBox regionField;
    private LabeledHistoryBox cmdFlowIdField;
    private LabeledHistoryBox transactionField;
    private Action runAction;
    private Action expandTreeAction;
    private Action collapseTreeAction;
    private ProgramFlowsPresenter presenter;

    public void createPartControl(Composite parent) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"createPartControl", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.parent = parent;
        this.setPresenter(((ProgramFlowsViewInput)this.getEditorInput()).getPresenter());
        this.presenter.setView(this);
        this.setPartName(this.getEditorInput().getName());
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        this.createToolBar(parent);
        this.createViewer(parent);
        TreeSelectionProvider selectionProvider = new TreeSelectionProvider(this.treeViewer.getTree(), new String[0]){

            @Override
            public Object extractTreeNodeData(SelectionEvent e) {
                Object object = null;
                Tree tree = (Tree)e.widget;
                if (tree.getSelectionCount() == 1 && (object = tree.getSelection()[0].getData()) != null) {
                    Object[] objects;
                    if (object instanceof TreeNode) {
                        object = ((TreeNode)object).getData();
                    } else if (object instanceof Object[] && (objects = (Object[])object).length == 2 && objects[0] instanceof TreeNode) {
                        object = ((TreeNode)objects[0]).getData();
                    }
                }
                return object;
            }
        };
        selectionProvider.registerTree(this.treeViewer.getTree());
        this.getSite().setSelectionProvider((ISelectionProvider)selectionProvider);
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        Menu popupMenu = menuMgr.createContextMenu((Control)this.treeViewer.getTree());
        this.treeViewer.getTree().setMenu(popupMenu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)selectionProvider);
        new ShowDetailsStrategy((Control)this.treeViewer.getTree()){

            @Override
            public Object extractSource() {
                ISelection selection = ProgramFlowsViewImpl.this.treeViewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object object = ((IStructuredSelection)selection).getFirstElement();
                    if (object != null) {
                        Object[] objects;
                        if (object instanceof TreeNode) {
                            object = ((TreeNode)object).getData();
                        } else if (object instanceof Object[] && (objects = (Object[])object).length == 2 && objects[0] instanceof TreeNode) {
                            object = ((TreeNode)objects[0]).getData();
                        }
                    }
                    return object;
                }
                return null;
            }
        };
        this.presenter.onViewCreation();
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"createPartControl");
    }

    @Override
    public void setHelp(String contextHelpId) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"setHelp", (Object)("Thread ID: " + Thread.currentThread().getId()));
        IWorkbenchHelpSystem helpSystem = this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)this.parent, contextHelpId);
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"setHelp");
    }

    public String getTitleToolTip() {
        if (this.presenter != null) {
            return this.presenter.getViewTitle();
        }
        return super.getTitleToolTip();
    }

    private void createToolBar(Composite parent) {
        ToolBar toolBar = UIUtilities.createToolBar(parent);
        ToolBarManager toolBarManager = new ToolBarManager(toolBar);
        SelectionAdapter selectionRunListener = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ProgramFlowsViewImpl.this.presenter.onRun();
            }
        };
        toolBarManager.add((IContributionItem)new ControlContribution("ProgramFlowsViewImpl.filters.cmdFlowId", (SelectionListener)selectionRunListener){
            private final /* synthetic */ SelectionListener val$selectionRunListener;
            {
                this.val$selectionRunListener = selectionListener;
                super($anonymous0);
            }

            protected Control createControl(Composite parent) {
                ProgramFlowsViewImpl.this.cmdFlowIdField = new LabeledHistoryBox(Messages.getString("ProgramFlowsViewImpl.filters.cmdFlowId"), parent, 0);
                ProgramFlowsViewImpl.this.cmdFlowIdField.getHistoryBox().addSelectionListener(this.val$selectionRunListener);
                return ProgramFlowsViewImpl.this.cmdFlowIdField;
            }
        });
        toolBarManager.add((IContributionItem)new ControlContribution("ProgramFlowsViewImpl.filters.region", (SelectionListener)selectionRunListener){
            private final /* synthetic */ SelectionListener val$selectionRunListener;
            {
                this.val$selectionRunListener = selectionListener;
                super($anonymous0);
            }

            protected Control createControl(Composite parent) {
                ProgramFlowsViewImpl.this.regionField = new LabeledHistoryBox(Messages.getString("ProgramFlowsViewImpl.filters.region"), parent, 0);
                ProgramFlowsViewImpl.this.regionField.getHistoryBox().addSelectionListener(this.val$selectionRunListener);
                return ProgramFlowsViewImpl.this.regionField;
            }
        });
        toolBarManager.add((IContributionItem)new ControlContribution("ProgramFlowsViewImpl.filters.transId", (SelectionListener)selectionRunListener){
            private final /* synthetic */ SelectionListener val$selectionRunListener;
            {
                this.val$selectionRunListener = selectionListener;
                super($anonymous0);
            }

            protected Control createControl(Composite parent) {
                ProgramFlowsViewImpl.this.transactionField = new LabeledHistoryBox(Messages.getString("ProgramFlowsViewImpl.filters.transId"), parent, 0);
                ProgramFlowsViewImpl.this.transactionField.getHistoryBox().addSelectionListener(this.val$selectionRunListener);
                ProgramFlowsViewImpl.this.transactionField.getHistoryBox().setToolTipText(Messages.getString("ProgramFlowsViewImpl.filters.transId.tooltip"));
                return ProgramFlowsViewImpl.this.transactionField;
            }
        });
        this.runAction = new Action(Messages.getString("ProgramFlowsViewImpl.createReport"), ImageDescriptor.createFromImage((Image)ImageFactory.getRunImage())){

            public void run() {
                ProgramFlowsViewImpl.this.presenter.onRun();
            }
        };
        toolBarManager.add((IAction)this.runAction);
        this.expandTreeAction = new Action(Messages.getString("Button.tooltip.maximise")){

            public void run() {
                ProgramFlowsViewImpl.this.treeViewer.expandAll();
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageDescriptor.createFromImage((Image)ImageFactory.getExpandImage());
            }
        };
        this.expandTreeAction.setToolTipText(Messages.getString("Button.tooltip.maximise"));
        toolBarManager.add((IAction)this.expandTreeAction);
        this.collapseTreeAction = new Action(Messages.getString("Button.tooltip.minimise")){

            public void run() {
                ProgramFlowsViewImpl.this.treeViewer.collapseAll();
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageDescriptor.createFromImage((Image)ImageFactory.getCollapseImage());
            }
        };
        this.collapseTreeAction.setToolTipText(Messages.getString("Button.tooltip.minimise"));
        toolBarManager.add((IAction)this.collapseTreeAction);
        toolBarManager.update(true);
        toolBar.pack();
    }

    private void createViewer(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 68356);
        this.treeViewer.setContentProvider((IContentProvider)new ProgramFlowsContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ProgramFlowsLabelProvider());
        this.treeViewer.setUseHashlookup(true);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        this.treeViewer.getControl().setLayoutData((Object)gridData);
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"createViewer");
    }

    @Override
    public void setInput(final Object input) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"setInput", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ProgramFlowsViewImpl.this.treeViewer.setInput(input);
            }
        });
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"setInput");
    }

    public void dispose() {
        this.presenter.onDispose();
        super.dispose();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public void setFocus() {
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    @Override
    public void clear() {
        this.treeViewer.setInput(new ArrayList());
    }

    @Override
    public HistoryBox getRegionField() {
        return this.regionField.getHistoryBox();
    }

    @Override
    public HistoryBox getCmdFlowIdField() {
        return this.cmdFlowIdField.getHistoryBox();
    }

    @Override
    public HistoryBox getTransactionField() {
        return this.transactionField.getHistoryBox();
    }

    @Override
    public Action getRunAction() {
        return this.runAction;
    }

    @Override
    public Action getExpandTreeAction() {
        return this.expandTreeAction;
    }

    @Override
    public Action getCollapseTreeAction() {
        return this.collapseTreeAction;
    }

    @Override
    public void showErrorMessage(String errMsg) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"showErrorMessage", (Object)("Thread ID: " + Thread.currentThread().getId()));
        MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 65);
        messageBox.setMessage(errMsg);
        messageBox.open();
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"showErrorMessage");
    }

    @Override
    public void setTransactionName(String transactionName) {
        this.getTransactionField().setText(transactionName);
    }

    @Override
    public String getTransactionName() {
        return this.getTransactionField().getText(false);
    }

    @Override
    public void setCmdFlowId(String cmdFlowId) {
        this.getCmdFlowIdField().setText(cmdFlowId);
    }

    @Override
    public String getCmdFlowId() {
        return this.getCmdFlowIdField().getText(false);
    }

    @Override
    public void setRegionName(String regionName) {
        this.getRegionField().setText(regionName);
    }

    @Override
    public String getRegionName() {
        return this.getRegionField().getText(false);
    }

    @Override
    public void enableControls(final boolean enabled) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"enableControls", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ProgramFlowsViewImpl.this.cmdFlowIdField.setEnabled(enabled);
                ProgramFlowsViewImpl.this.regionField.setEnabled(enabled);
                ProgramFlowsViewImpl.this.transactionField.setEnabled(enabled);
                ProgramFlowsViewImpl.this.runAction.setEnabled(enabled);
                ProgramFlowsViewImpl.this.collapseTreeAction.setEnabled(enabled);
                ProgramFlowsViewImpl.this.expandTreeAction.setEnabled(enabled);
            }
        });
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"enableControls");
    }

    @Override
    public void setPresenter(ProgramFlowsPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public ProgramFlowsPresenter getPresenter() {
        return this.presenter;
    }
}

