/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.ia.model.ProgramFlowsModel;
import com.ibm.cics.ia.model.ProgramFlowsModelListener;
import com.ibm.cics.ia.model.TreeNode;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.runtime.Version;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.ProgramFlowsPresenter;
import com.ibm.cics.ia.ui.ProgramFlowsView;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Display;

public class ProgramFlowsPresenterImpl
implements ProgramFlowsPresenter,
ProgramFlowsModelListener {
    private static final Logger logger = Logger.getLogger(ProgramFlowsPresenterImpl.class.getPackage().getName());
    private static ProgramFlowsPresenterImpl instance;
    private ProgramFlowsModel model;
    private ProgramFlowsView view;
    private ConnectionServiceListener connectionServiceListener = this.getConnectionServiceListener();

    private ProgramFlowsPresenterImpl() {
        ConnectionsPlugin.getDefault().getConnectionService().addConnectionServiceListener(this.connectionServiceListener);
    }

    public static ProgramFlowsPresenterImpl getInstance() {
        if (instance == null) {
            instance = new ProgramFlowsPresenterImpl();
        }
        return instance;
    }

    @Override
    public void setModel(ProgramFlowsModel model) {
        if (this.model != model) {
            this.model = model;
            model.addListener((ProgramFlowsModelListener)this);
        }
    }

    @Override
    public ProgramFlowsModel getModel() {
        return this.model;
    }

    @Override
    public void setView(ProgramFlowsView view) {
        this.view = view;
    }

    @Override
    public ProgramFlowsView getView() {
        return this.view;
    }

    public void onConnect() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"onConnect", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.checkDbVersion();
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"onConnect");
    }

    public void onDisconnect() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"onDisconnect", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.checkDbVersion();
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"onDisconnect");
    }

    @Override
    public void onViewCreation() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"onViewCreation", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.view.setHelp("com.ibm.cics.ia.help.ProgramFlowsView");
        this.checkDbVersion();
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"onViewCreation");
    }

    private void checkDbVersion() {
        if (Version.getInstance().getDBVersion() >= 5300) {
            this.view.clear();
            this.view.enableControls(true);
        } else {
            this.view.enableControls(false);
            ArrayList<Object[]> input = new ArrayList<Object[]>();
            input.add(new Object[]{new TreeNode((Object)Messages.getString("ProgramFlowsViewImpl.access.msg.dblevel")), 0});
            this.view.setInput(input);
        }
    }

    @Override
    public String getViewTitle() {
        return Messages.getString("ProgramFlowsViewImpl.title");
    }

    @Override
    public void onRun() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"onRun", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String cmdFlowId = this.view.getCmdFlowId().trim();
        if (cmdFlowId.isEmpty()) {
            cmdFlowId = IAUtilities.USER_WILD_STR;
        }
        this.view.setCmdFlowId(cmdFlowId);
        String regionName = this.view.getRegionName().trim();
        if (regionName.isEmpty()) {
            regionName = IAUtilities.USER_WILD_STR;
        }
        this.view.setRegionName(regionName);
        String transactionName = this.view.getTransactionName().trim();
        this.view.setTransactionName(transactionName);
        String errMsg = this.validateUserInput();
        if (errMsg != null) {
            this.view.showErrorMessage(errMsg);
        } else {
            regionName = this.view.getRegionName();
            this.view.setRegionName(regionName.toUpperCase());
            regionName = regionName.replace(IAUtilities.USER_WILD_STR, IAUtilities.DB2_WILD_STR);
            cmdFlowId = this.view.getCmdFlowId();
            this.view.setCmdFlowId(cmdFlowId.toUpperCase());
            cmdFlowId = cmdFlowId.replace(IAUtilities.USER_WILD_STR, IAUtilities.DB2_WILD_STR);
            transactionName = this.view.getTransactionName().toUpperCase();
            this.view.setTransactionName(transactionName);
            this.model.setRegionName(regionName);
            this.model.setCmdFlowId(cmdFlowId);
            this.model.setTransactionName(transactionName);
            this.view.enableControls(false);
            this.model.runSearch();
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"onRun");
    }

    @Override
    public void onDispose() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"onDispose", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.connectionServiceListener != null) {
            this.connectionServiceListener.makeStale();
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"onDispose");
    }

    public void onProgramFlowsAvailable() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"onProgramFlowsAvailable", (Object)("Thread ID: " + Thread.currentThread().getId()));
        List input = this.model.getProgramFlows();
        this.view.setInput(input);
        this.view.enableControls(true);
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"onProgramFlowsAvailable");
    }

    private String validateUserInput() {
        String pattern;
        String regionName = this.view.getRegionName();
        if (!regionName.matches(pattern = "^([a-zA-Z][\\w$@#]*|\\*)$")) {
            return Messages.getString("ProcedureCIUSPTF1.input.error.regionName");
        }
        if (regionName.length() > 8) {
            return Messages.getString("ProcedureCIUSPTF1.input.error.regionLength");
        }
        String transactionName = this.view.getTransactionName();
        if (!transactionName.matches(pattern = "^[\\w$@#\\./\\-_%&\\?!:\\|\"\u00ac=,;<>]+$")) {
            return Messages.getString("ProcedureCIUSPTF1.input.error.transactionName");
        }
        if (transactionName.length() > 4) {
            return Messages.getString("ProcedureCIUSPTF1.input.error.transactionLength");
        }
        return null;
    }

    private ConnectionServiceListener getConnectionServiceListener() {
        return new ConnectionServiceListener(){

            public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
                Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"event", (Object)("Thread ID: " + Thread.currentThread().getId()));
                if ("com.ibm.cics.ia.connection.db2".equals(event.getConnectionCategoryId())) {
                    if (event instanceof ConnectionServiceListener.DisconnectedEvent) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                ProgramFlowsPresenterImpl.this.onDisconnect();
                            }
                        });
                    } else if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                ProgramFlowsPresenterImpl.this.onConnect();
                            }
                        });
                    }
                }
                Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"event");
            }
        };
    }
}

