/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.viz.ResourceFilter;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.runtime.ICollectionIdListener;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.DefaultLabelProvider;
import com.ibm.cics.ia.ui.DetailsPresenter;
import com.ibm.cics.ia.ui.DetailsSheet;
import com.ibm.cics.ia.ui.DetailsView;
import com.ibm.cics.ia.ui.DetailsViewPreferencePage;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.ProgramAttributesPresenter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;

public class ProgramDetailsPresenter
extends DetailsPresenter {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ProgramDetailsPresenter.class.getPackage().getName());
    protected static Map<String, String[]> attrsToGroupAndHelp = new HashMap<String, String[]>();
    private static final String BASIC_GROUP = Messages.getString("ProgramDetailsPresenter.attributes.group.basic");
    private static final String APPLICATION_GROUP = Messages.getString("ProgramDetailsPresenter.attributes.group.application");
    private static final String CICS_IA_GROUP = Messages.getString("ProgramDetailsPresenter.attributes.group.cicsia");
    private static final String DETAILS_GROUP = Messages.getString("ProgramDetailsPresenter.attributes.group.details");
    private static final String REMOTE_GROUP = Messages.getString("ProgramDetailsPresenter.attributes.group.remote");
    private static final String UNSORTED_GROUP = Messages.getString("ProgramDetailsPresenter.attributes.group.unsorted");
    private static final String HELP_PREFIX = "com.ibm.cics.core.ui.property_";
    private Program program;
    private DetailsView view;
    private IPropertyChangeListener propertyChangeListener;
    private ICollectionIdListener collectionIdListener;

    static {
        String[] stringArray = new String[2];
        stringArray[0] = BASIC_GROUP;
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)"HOMESYSID"), stringArray);
        String[] stringArray2 = new String[2];
        stringArray2[0] = BASIC_GROUP;
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)"HOLD_STATUS"), stringArray2);
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)"LIB_DATASET_NAME"), new String[]{BASIC_GROUP, "com.ibm.cics.core.ui.property_PROGRAM_LIBRARYDSN"});
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)"LIB_NAME"), new String[]{BASIC_GROUP, "com.ibm.cics.core.ui.property_PROGRAM_LIBRARY"});
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)"MODULE_TYPE"), new String[]{BASIC_GROUP, "com.ibm.cics.core.ui.property_PROGRAM_PROGTYPE"});
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)"PROGRAM_LENGTH"), new String[]{BASIC_GROUP, "com.ibm.cics.core.ui.property_PROGRAM_LENGTH"});
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)"PROGRAM_TYPE"), new String[]{BASIC_GROUP, "com.ibm.cics.core.ui.property_PROGRAM_SHARESTATUS"});
        String[] stringArray3 = new String[2];
        stringArray3[0] = BASIC_GROUP;
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)"SPECIFIED_AMODE"), stringArray3);
        String[] stringArray4 = new String[2];
        stringArray4[0] = BASIC_GROUP;
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)"SPECIFIED_RMODE"), stringArray4);
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)"APPL_NAME"), new String[]{APPLICATION_GROUP, "com.ibm.cics.core.ui.property_PROGRAM_APPLICATION"});
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)"APPL_VER1"), new String[]{APPLICATION_GROUP, "com.ibm.cics.core.ui.property_PROGRAM_APPLMAJORVER"});
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)"APPL_VER2"), new String[]{APPLICATION_GROUP, "com.ibm.cics.core.ui.property_PROGRAM_APPLMINORVER"});
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)"APPL_VER3"), new String[]{APPLICATION_GROUP, "com.ibm.cics.core.ui.property_PROGRAM_APPLMICROVER"});
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)"APPL_OPER"), new String[]{APPLICATION_GROUP, "com.ibm.cics.core.ui.property_PROGRAM_OPERATION"});
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)"PLATFORM"), new String[]{APPLICATION_GROUP, "com.ibm.cics.core.ui.property_PROGRAM_PLATFORM"});
        String[] stringArray5 = new String[2];
        stringArray5[0] = CICS_IA_GROUP;
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)Program.COLLECTION_ID), stringArray5);
        String[] stringArray6 = new String[2];
        stringArray6[0] = CICS_IA_GROUP;
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)"FIRST_RUN"), stringArray6);
        String[] stringArray7 = new String[2];
        stringArray7[0] = CICS_IA_GROUP;
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)"LAST_RUN"), stringArray7);
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)"APIST"), new String[]{DETAILS_GROUP, "com.ibm.cics.core.ui.property_PROGRAM_APIST"});
        String[] stringArray8 = new String[2];
        stringArray8[0] = DETAILS_GROUP;
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)"ACCESS"), stringArray8);
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)"CONCURRENCY"), new String[]{DETAILS_GROUP, "com.ibm.cics.core.ui.property_PROGRAM_CONCURRENCY"});
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)"DATA_LOCATION"), new String[]{DETAILS_GROUP, "com.ibm.cics.core.ui.property_PROGRAM_DATALOCATION"});
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)"EXECUTION_KEY"), new String[]{DETAILS_GROUP, "com.ibm.cics.core.ui.property_PROGRAM_EXECKEY"});
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)"INSTALL_TYPE"), new String[]{DETAILS_GROUP, "com.ibm.cics.core.ui.property_PROGRAM_INSTALLAGENT"});
        String[] stringArray9 = new String[2];
        stringArray9[0] = DETAILS_GROUP;
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)"LANGUAGE_DEDUCED"), stringArray9);
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)"LANGUAGE_DEFINED"), new String[]{DETAILS_GROUP, "com.ibm.cics.core.ui.property_PROGRAM_LANGUAGE"});
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)"LOCATION"), new String[]{DETAILS_GROUP, "com.ibm.cics.core.ui.property_PROGRAM_CURRENTLOC"});
        String[] stringArray10 = new String[2];
        stringArray10[0] = DETAILS_GROUP;
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)"LOAD_STATUS"), stringArray10);
        String[] stringArray11 = new String[2];
        stringArray11[0] = DETAILS_GROUP;
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)"PROGRAM_ATTRIBUTE"), stringArray11);
        String[] stringArray12 = new String[2];
        stringArray12[0] = DETAILS_GROUP;
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)"PROGRAM_USAGE"), stringArray12);
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)"DYNAMIC_STATUS"), new String[]{REMOTE_GROUP, "com.ibm.cics.core.ui.property_PROGRAM_DYNAMSTATUS"});
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)"EXECUTION_SET"), new String[]{REMOTE_GROUP, "com.ibm.cics.core.ui.property_PROGRAM_EXECUTIONSET"});
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)"REMOTE_PROGID"), new String[]{REMOTE_GROUP, "com.ibm.cics.core.ui.property_PROGRAM_REMOTENAME"});
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)"REMOTE_SYSID"), new String[]{REMOTE_GROUP, "com.ibm.cics.core.ui.property_PROGRAM_REMOTESYSTEM"});
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)"REMOTE_TRANID"), new String[]{REMOTE_GROUP, "com.ibm.cics.core.ui.property_PROGRAM_TRANSID"});
        String[] stringArray13 = new String[2];
        stringArray13[0] = REMOTE_GROUP;
        attrsToGroupAndHelp.put(com.ibm.cics.ia.model.Messages.getString((String)"REMOTE_DEFINITION"), stringArray13);
    }

    public ProgramDetailsPresenter(Program program) {
        this.program = program;
    }

    @Override
    public void handleViewClosing() {
        Debug.enter((Logger)logger, (String)ProgramDetailsPresenter.class.getName(), (String)"handleViewClosing", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
        if (this.collectionIdListener != null) {
            IAPlugin.getDefault().removeCollectionIDListener(this.collectionIdListener);
        }
        Debug.exit((Logger)logger, (String)ProgramDetailsPresenter.class.getName(), (String)"handleViewClosing");
    }

    @Override
    public void handleViewCreation() {
        Debug.enter((Logger)logger, (String)ProgramDetailsPresenter.class.getName(), (String)"handleViewCreation", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("DETAILS_VIEW_HIGHLIGHT_COLOR_PREF")) {
                    ProgramDetailsPresenter.this.view.refresh();
                }
            }
        };
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
        if (this.getCurrentVersion().getDBVersion() >= 3200) {
            this.collectionIdListener = new ICollectionIdListener(){

                public void collectionIdChanged(String collectionId) {
                    List attributes = ProgramDetailsPresenter.this.program.getProperties();
                    if (ProgramDetailsPresenter.this.view.getPage(0).getFilter() != null) {
                        if (!attributes.isEmpty()) {
                            DetailsSheet sheet = ProgramDetailsPresenter.createProgramDetailsSheet("DetailsView.page.title.program.attributes", attributes, com.ibm.cics.ia.model.Messages.getString((String)"APPLID"), "APPLID");
                            ResourceFilter[] filters = ProgramDetailsPresenter.createFilters(sheet, com.ibm.cics.ia.model.Messages.getString((String)Program.COLLECTION_ID));
                            DetailsView.DetailsPage page = ProgramDetailsPresenter.this.view.getPage(0);
                            page.getDetailsStructure().setInput(sheet.getColumnIds().toArray(new String[sheet.getColumnIds().size()]), sheet.getHeaders().toArray(new String[sheet.getHeaders().size()]), ProgramDetailsPresenter.this.createGroupedAttributes(sheet));
                            page.getFilter().setInput((Object)filters);
                            page.checkAllFilters();
                            page.getFilter().expandAll();
                            page.showFilteredColumns();
                            ProgramDetailsPresenter.this.view.setActivePage(0);
                        } else {
                            ProgramDetailsPresenter.this.view.removePage(0);
                        }
                    } else if (!attributes.isEmpty()) {
                        if (ProgramDetailsPresenter.this.view.getPage(0).getDetailsStructure() == null) {
                            ProgramDetailsPresenter.this.view.removePage(0);
                        }
                        ProgramDetailsPresenter.this.createAttributesPage(attributes);
                    }
                    if (ProgramDetailsPresenter.this.view.getPageCount() == 0) {
                        ProgramDetailsPresenter.this.view.addEmptyPage();
                        ProgramDetailsPresenter.this.view.setActivePage(0);
                    }
                }
            };
            IAPlugin.getDefault().addCollectionIDListener(this.collectionIdListener);
        }
        this.createPages();
        this.view.refresh();
        Debug.exit((Logger)logger, (String)ProgramDetailsPresenter.class.getName(), (String)"handleViewCreation");
    }

    @Override
    public Color getHighlightColor() {
        return DetailsViewPreferencePage.getHighlightColor();
    }

    @Override
    public String getViewTitle() {
        return MessageFormat.format(Messages.getString("DetailsView.title.program"), this.program.getName());
    }

    @Override
    public void setView(DetailsView view) {
        this.view = view;
    }

    private void createAttributesPage(List<Map<String, String>> attributes) {
        if (!attributes.isEmpty()) {
            DetailsSheet sheet = ProgramDetailsPresenter.createProgramDetailsSheet("DetailsView.page.title.program.attributes", attributes, com.ibm.cics.ia.model.Messages.getString((String)"APPLID"), "APPLID");
            ResourceFilter[] filters = null;
            if (this.getCurrentVersion().getDBVersion() >= 3200) {
                filters = ProgramDetailsPresenter.createFilters(sheet, com.ibm.cics.ia.model.Messages.getString((String)Program.COLLECTION_ID));
            }
            DetailsView.DetailsPage page = this.view.addFirstDataPage(sheet.getName(), sheet.getColumnIds(), sheet.getHeaders(), this.createGroupedAttributes(sheet), filters);
            DetailsView.DetailsTree detailsTree = (DetailsView.DetailsTree)page.getDetailsStructure();
            page.getDetailsStructure().setLabelProvider(new ProgramAttributesLabelProvider(page.getDetailsStructure()));
            ProgramAttributesPresenter presenter = new ProgramAttributesPresenter();
            presenter.setView(detailsTree);
            detailsTree.setPresenter(presenter);
            if (filters != null) {
                page.checkAllFilters();
                ProgramDetailsPresenter.addFiltersListener(page);
                page.showFilteredColumns();
            } else {
                page.getDetailsStructure().showColumns(sheet.getColumnIds());
            }
            this.view.setActivePage(0);
        }
    }

    private void createPages() {
        List csectProperties;
        Debug.enter((Logger)logger, (String)ProgramDetailsPresenter.class.getName(), (String)"createPages", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.createAttributesPage(this.program.getProperties());
        List scannerProperties = this.program.getSummaryProperties();
        if (!scannerProperties.isEmpty()) {
            DetailsSheet sheet = ProgramDetailsPresenter.createProgramDetailsSheet("DetailsView.page.title.program.scanner", scannerProperties, com.ibm.cics.ia.model.Messages.getString((String)"LIB_DATASET"), "DSNAME");
            DetailsView.DetailsPage page = this.view.addLastDataPage(sheet.getName(), sheet.getColumnIds(), sheet.getHeaders(), sheet.getRowValues(), null);
            page.getDetailsStructure().setLabelProvider(new DefaultLabelProvider(page.getDetailsStructure(), this));
            page.getDetailsStructure().showColumns(sheet.getColumnIds());
        }
        if (!(csectProperties = this.program.getCsectProperties()).isEmpty()) {
            DetailsSheet sheet = ProgramDetailsPresenter.createProgramDetailsSheet("DetailsView.page.title.program.csects", csectProperties, "CSECT", "CSECT_NAME");
            ResourceFilter[] filters = ProgramDetailsPresenter.createFilters(sheet, com.ibm.cics.ia.model.Messages.getString((String)"DSNAME"));
            DetailsView.DetailsPage page = this.view.addLastDataPage(sheet.getName(), sheet.getColumnIds(), sheet.getHeaders(), sheet.getRowValues(), filters);
            page.getDetailsStructure().setLabelProvider(new DefaultLabelProvider(page.getDetailsStructure(), this));
            for (String columnId : sheet.getColumnIds()) {
                if (!columnId.startsWith(this.program.getName())) continue;
                page.checkChildFilters(columnId);
            }
            ProgramDetailsPresenter.addFiltersListener(page);
            page.showFilteredColumns();
        }
        if (this.view.getPageCount() == 0) {
            this.view.addEmptyPage();
            this.view.setActivePage(0);
            Debug.exit((Logger)logger, (String)ProgramDetailsPresenter.class.getName(), (String)"createPages");
            return;
        }
        Debug.exit((Logger)logger, (String)ProgramDetailsPresenter.class.getName(), (String)"createPages");
    }

    private static DetailsSheet createProgramDetailsSheet(String nameMsg, List<Map<String, String>> properties, String headerPrefix, String property2Header) {
        Debug.enter((Logger)logger, (String)ProgramDetailsPresenter.class.getName(), (String)"createProgramDetailsSheet", (Object)("Thread ID: " + Thread.currentThread().getId()));
        DetailsSheet detailSheet = new DetailsSheet(Messages.getString(nameMsg));
        int columnId = 0;
        detailSheet.getHeaders().add(Messages.getString("DetailsView.column.detail"));
        detailSheet.getColumnIds().add(String.valueOf(Messages.getString("DetailsView.column.detail")) + columnId++);
        int row = 0;
        while (row < properties.get(0).size() - 1) {
            detailSheet.getRowValues().add(new String[properties.size() + 1]);
            ++row;
        }
        row = 0;
        while (row < properties.size()) {
            Map<String, String> map = properties.get(row);
            int property = 0;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (entry.getKey().equals(property2Header)) {
                    detailSheet.getHeaders().add(String.valueOf(headerPrefix) + " " + entry.getValue());
                    detailSheet.getColumnIds().add(String.valueOf(entry.getValue()) + columnId++);
                    continue;
                }
                detailSheet.getRowValues().get((int)property)[0] = com.ibm.cics.ia.model.Messages.getString((String)entry.getKey());
                detailSheet.getRowValues().get((int)property)[row + 1] = entry.getValue();
                ++property;
            }
            ++row;
        }
        Debug.exit((Logger)logger, (String)ProgramDetailsPresenter.class.getName(), (String)"createProgramDetailsSheet");
        return detailSheet;
    }

    private static List<String> createAttributesGroup(String ... attributes) {
        ArrayList<String> group = new ArrayList<String>();
        String[] stringArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            group.add(com.ibm.cics.ia.model.Messages.getString((String)attribute));
            ++n2;
        }
        return group;
    }

    private Map<String, List<String[]>> createGroupedAttributes(DetailsSheet sheet) {
        HashMap<String, List<String[]>> groupedAttributes = new HashMap<String, List<String[]>>();
        groupedAttributes.put(BASIC_GROUP, new ArrayList());
        groupedAttributes.put(APPLICATION_GROUP, new ArrayList());
        groupedAttributes.put(CICS_IA_GROUP, new ArrayList());
        groupedAttributes.put(DETAILS_GROUP, new ArrayList());
        groupedAttributes.put(REMOTE_GROUP, new ArrayList());
        for (String[] row : sheet.getRowValues()) {
            String group;
            String[] groupAndHelpId = attrsToGroupAndHelp.get(row[0]);
            if (groupAndHelpId != null) {
                group = groupAndHelpId[0];
            } else {
                if (!groupedAttributes.containsKey(UNSORTED_GROUP)) {
                    groupedAttributes.put(UNSORTED_GROUP, new ArrayList());
                }
                group = UNSORTED_GROUP;
            }
            ((List)groupedAttributes.get(group)).add(row);
        }
        Iterator iterator = groupedAttributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!((List)entry.getValue()).isEmpty()) continue;
            iterator.remove();
        }
        return groupedAttributes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.program == null ? 0 : this.program.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProgramDetailsPresenter other = (ProgramDetailsPresenter)obj;
        return !(this.program == null ? other.program != null : !this.program.equals((Object)other.program));
    }

    @Override
    public String getViewContextHelpId() {
        return "com.ibm.cics.ia.help.program_details_view";
    }

    class ProgramAttributesLabelProvider
    extends DefaultLabelProvider {
        public ProgramAttributesLabelProvider(DetailsView.DetailsStructure structure) {
            super(structure, ProgramDetailsPresenter.this);
        }

        @Override
        public Color getHighlightingColor(Object element, int columnIndex) {
            String[] row = (String[])element;
            if (row[0].equals(com.ibm.cics.ia.model.Messages.getString((String)Program.COLLECTION_ID))) {
                return null;
            }
            return super.getHighlightingColor(element, columnIndex);
        }
    }
}

