/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.eclipse.common.editor.EditorHelper;
import com.ibm.cics.eclipse.common.ui.JobWithCancelingSupport;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.actions.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class MoreUsersDialog
extends TitleAreaDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(MoreUsersDialog.class.getPackage().getName());
    private Transaction transid;
    private Table userIdsTable;
    protected List userIds;
    private JobWithCancelingSupport job;
    private TableItem dummyTableItem;
    private List<String> selection;
    private Button selectAllButton;
    private boolean searchAllAlowed;

    protected MoreUsersDialog(Shell parentShell) {
        super(parentShell);
    }

    public MoreUsersDialog(Shell parentShell, Transaction aTransaction, boolean isSearchAllowed) {
        super(parentShell);
        this.setTitle(MessageFormat.format(Messages.getString("MoreUserIdsDialog.title"), this.transid));
        this.setTitleImage(ImageFactory.getCincUsersImage());
        this.searchAllAlowed = isSearchAllowed;
        this.transid = aTransaction;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(MessageFormat.format(Messages.getString("MoreUserIdsDialog.title"), this.transid));
    }

    protected void okPressed() {
        super.okPressed();
    }

    public Resource getTransid() {
        return this.transid;
    }

    private void fillTableWithUserIds() {
        Debug.enter((Logger)logger, (String)MoreUsersDialog.class.getName(), (String)"fillTableWithUserIds", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String fetchUserIdsMsg = Messages.getString("FetchUserIdsFor.msg");
        final String fetchUserIdsForResourceMsg = MessageFormat.format(fetchUserIdsMsg, this.transid.getName());
        this.dummyTableItem = new TableItem(this.userIdsTable, 0);
        this.dummyTableItem.setText(Messages.getString("MoreUserIdsDialog.dummyTableItem.text"));
        this.dummyTableItem.setImage(ImageFactory.getDatabaseBusyImage());
        this.job = new JobWithCancelingSupport(fetchUserIdsForResourceMsg){

            protected IStatus runSub(IProgressMonitor monitor) {
                Debug.enter((Logger)logger, (String)"MoreUsersDialog.fillTableWithUserIds().JobWithCancelingSupport()", (String)"runSub", (Object)("Thread ID: " + Thread.currentThread().getId()));
                monitor.beginTask(fetchUserIdsForResourceMsg, -1);
                MoreUsersDialog.this.userIds = MoreUsersDialog.this.transid.getOwnerUserIds();
                if (MoreUsersDialog.this.userIdsTable != null && !MoreUsersDialog.this.userIdsTable.isDisposed()) {
                    MoreUsersDialog.this.userIdsTable.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Debug.enter((Logger)logger, (String)"MoreUsersDialog.fillTableWithUserIds().JobWithCancelingSupport().runSub.asyncExec()", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                            MoreUsersDialog.this.dummyTableItem.dispose();
                            MoreUsersDialog.this.dummyTableItem = null;
                            if ((this).MoreUsersDialog.this.userIds.size() > 0) {
                                for (String userId : (this).MoreUsersDialog.this.userIds) {
                                    TableItem item = new TableItem(MoreUsersDialog.this.userIdsTable, 0);
                                    item.setImage(ImageFactory.getResourceImage());
                                    item.setText(userId);
                                    item.setData((Object)userId);
                                }
                            }
                            Debug.exit((Logger)logger, (String)"MoreUsersDialog.fillTableWithUserIds().JobWithCancelingSupport().runSub.asyncExec()", (String)"run");
                        }
                    });
                }
                Debug.exit((Logger)logger, (String)"MoreUsersDialog.fillTableWithUserIds().JobWithCancelingSupport()", (String)"runSub");
                return Status.OK_STATUS;
            }

            protected void cancelingSub() {
                IAPlugin.getDefault().taskEnded();
            }
        };
        this.job.schedule();
    }

    private void setSelection(List<String> aSelection) {
        this.selection = aSelection;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setText(MessageFormat.format(Messages.getString("MoreUserIdsDialog.label.text"), this.transid));
        FormToolkit toolkit = EditorHelper.getFormToolkit();
        this.userIdsTable = toolkit.createTable(composite, 2852);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        this.userIdsTable.setLayoutData((Object)gridData);
        this.fillTableWithUserIds();
        this.userIdsTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selection = MoreUsersDialog.this.userIdsTable.getSelection();
                if (selection.length > 0 && selection[0] == MoreUsersDialog.this.dummyTableItem) {
                    return;
                }
                MoreUsersDialog.this.setSelectedUserIds();
                MoreUsersDialog.this.updateOkStatus();
            }
        });
        if (this.searchAllAlowed) {
            this.selectAllButton = new Button(composite, 32);
            this.selectAllButton.setText(Messages.getString("MoreUserIdsDialog.selectAllButton.text"));
            this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean selected = MoreUsersDialog.this.selectAllButton.getSelection();
                    MoreUsersDialog.this.userIdsTable.setEnabled(!selected);
                    MoreUsersDialog.this.setSelectedUserIds();
                    MoreUsersDialog.this.updateOkStatus();
                }
            });
        }
        this.setHelpAvailable(false);
        return composite;
    }

    protected void updateOkStatus() {
        if (this.userIdsTable.isEnabled() && this.selection != null && this.selection.size() > 0 || this.selectAllButton.getSelection()) {
            this.getButton(0).setEnabled(true);
        } else {
            this.getButton(0).setEnabled(false);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control createButtonBar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return createButtonBar;
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.setMessage(Messages.getString("MoreUserIdsDialog.message"));
        return result;
    }

    public List<String> getSelection() {
        return this.selection;
    }

    private void setSelectedUserIds() {
        if (this.userIdsTable.isEnabled()) {
            TableItem[] items = this.userIdsTable.getItems();
            ArrayList<String> selectedUserIds = new ArrayList<String>();
            int i = 0;
            while (i < items.length) {
                if (items[i].getChecked()) {
                    selectedUserIds.add((String)items[i].getData());
                }
                ++i;
            }
            this.setSelection(selectedUserIds);
        } else {
            this.setSelection(null);
        }
    }
}

