/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.eclipse.common.editor.EditorHelper;
import com.ibm.cics.eclipse.common.ui.JobWithCancelingSupport;
import com.ibm.cics.ia.model.Platform;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.actions.Messages;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class MorePlatformsDialog
extends TitleAreaDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(MorePlatformsDialog.class.getPackage().getName());
    private Resource resource;
    private Table platformsTable;
    protected List<Platform> platforms;
    private JobWithCancelingSupport job;
    private Platform platform;
    private TableItem dummyTableItem;
    private String titleMessage;
    private Button selectAllButton;
    private boolean searchAllAlowed;
    private static final String PLATFORM = "PLATFORM";

    protected MorePlatformsDialog(Shell parentShell) {
        super(parentShell);
    }

    public MorePlatformsDialog(Shell parentShell, Resource aResource, String aTitleMessage, boolean isSerchAllAlowed) {
        super(parentShell);
        this.setTitle(Messages.getString("MorePlatformsDialog.title.text"));
        this.setTitleImage(ImageFactory.getPlatformWizardImage());
        this.titleMessage = aTitleMessage;
        this.searchAllAlowed = isSerchAllAlowed;
        this.resource = aResource;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(String.valueOf(this.titleMessage) + " " + this.resource);
    }

    protected void okPressed() {
        super.okPressed();
    }

    public Resource getResource() {
        return this.resource;
    }

    private void fillTableWithPlatforms() {
        Debug.enter((Logger)logger, (String)MorePlatformsDialog.class.getName(), (String)"fillTableWithPlatforms", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String fetchPlatformsMsg = Messages.getString("FetchPlatformsFor.msg");
        final String fetchPlatformsForResourceMsg = MessageFormat.format(fetchPlatformsMsg, this.resource.getName());
        this.dummyTableItem = new TableItem(this.platformsTable, 0);
        this.dummyTableItem.setText(Messages.getString("MorePlatformsDialog.dummyTableItem.text"));
        this.dummyTableItem.setImage(ImageFactory.getDatabaseBusyImage());
        this.job = new JobWithCancelingSupport(fetchPlatformsForResourceMsg){

            protected IStatus runSub(IProgressMonitor monitor) {
                Debug.enter((Logger)logger, (String)"MorePlatformsDialog.fillTableWithPlatforms().JobWithCancellingSupport", (String)"runSub", (Object)("Thread ID: " + Thread.currentThread().getId()));
                monitor.beginTask(fetchPlatformsForResourceMsg, -1);
                MorePlatformsDialog.this.platforms = MorePlatformsDialog.this.resource.getPlatforms();
                if (MorePlatformsDialog.this.platformsTable != null && !MorePlatformsDialog.this.platformsTable.isDisposed()) {
                    MorePlatformsDialog.this.platformsTable.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Debug.enter((Logger)logger, (String)"MorePlatformsDialog.fillTableWithPlatforms().JobWithCancellingSupport.run.asyncExec", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                            MorePlatformsDialog.this.dummyTableItem.dispose();
                            MorePlatformsDialog.this.dummyTableItem = null;
                            if ((this).MorePlatformsDialog.this.platforms.size() > 0) {
                                for (Platform platform : (this).MorePlatformsDialog.this.platforms) {
                                    TableItem item = new TableItem(MorePlatformsDialog.this.platformsTable, 0);
                                    item.setImage(ImageFactory.getPlatformImage());
                                    item.setText(platform.getName());
                                    item.setData(MorePlatformsDialog.PLATFORM, (Object)platform);
                                }
                            } else {
                                MorePlatformsDialog.this.dummyTableItem = new TableItem(MorePlatformsDialog.this.platformsTable, 0);
                                MorePlatformsDialog.this.dummyTableItem.setText(Messages.getString("MorePlatformsDialog.dummyTableItem.NotFound.text"));
                            }
                            Debug.exit((Logger)logger, (String)"MorePlatformsDialog.fillTableWithPlatforms().JobWithCancellingSupport.run.asyncExec", (String)"run");
                        }
                    });
                }
                Debug.exit((Logger)logger, (String)"MorePlatformsDialog.fillTableWithPlatforms().JobWithCancellingSupport", (String)"runSub");
                return Status.OK_STATUS;
            }

            protected void cancelingSub() {
                IAPlugin.getDefault().taskEnded();
            }
        };
        this.job.schedule();
        Debug.exit((Logger)logger, (String)MorePlatformsDialog.class.getName(), (String)"fillTableWithPlatforms");
    }

    private void setPlatform(Platform aPlatform) {
        this.platform = aPlatform;
    }

    protected Control createDialogArea(Composite parent) {
        Debug.enter((Logger)logger, (String)MorePlatformsDialog.class.getName(), (String)"createDialogArea", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("MorePlatformsDialog.label.text"));
        FormToolkit toolkit = EditorHelper.getFormToolkit();
        this.platformsTable = toolkit.createTable(composite, 2820);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        this.platformsTable.setLayoutData((Object)gridData);
        this.fillTableWithPlatforms();
        this.platformsTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selection = MorePlatformsDialog.this.platformsTable.getSelection();
                if (selection.length > 0 && selection[0] == MorePlatformsDialog.this.dummyTableItem) {
                    return;
                }
                MorePlatformsDialog.this.setSelectedPlatform();
                MorePlatformsDialog.this.updateOkStatus();
            }
        });
        if (this.searchAllAlowed) {
            this.selectAllButton = new Button(composite, 32);
            this.selectAllButton.setText(Messages.getString("MorePlatformsDialog.selectAllButton.text"));
            this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean selected = MorePlatformsDialog.this.selectAllButton.getSelection();
                    MorePlatformsDialog.this.platformsTable.setEnabled(!selected);
                    MorePlatformsDialog.this.setSelectedPlatform();
                    MorePlatformsDialog.this.updateOkStatus();
                }
            });
        }
        this.setHelpAvailable(false);
        Debug.exit((Logger)logger, (String)MorePlatformsDialog.class.getName(), (String)"createDialogArea");
        return composite;
    }

    protected void updateOkStatus() {
        if (this.platformsTable.isEnabled() && this.platformsTable.getSelectionCount() == 1 || this.selectAllButton.getSelection()) {
            this.getButton(0).setEnabled(true);
        } else {
            this.getButton(0).setEnabled(false);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control createButtonBar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return createButtonBar;
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.setMessage(Messages.getString("MorePlatformsDialog.message"));
        return result;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    private void setSelectedPlatform() {
        if (this.platformsTable.isEnabled() && this.platformsTable.getSelectionCount() == 1) {
            this.setPlatform((Platform)this.platformsTable.getSelection()[0].getData(PLATFORM));
        } else {
            this.setPlatform(null);
        }
    }
}

