/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.eclipse.common.editor.EditorHelper;
import com.ibm.cics.eclipse.common.ui.JobWithCancelingSupport;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.actions.Messages;
import com.ibm.cics.model.ICICSplex;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class MoreCICSPlexesDialog
extends TitleAreaDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(MoreCICSPlexesDialog.class.getPackage().getName());
    private Region region;
    private Table cicsPlexesTable;
    private JobWithCancelingSupport job;
    private TableItem dummyTableItem;
    private ICICSplex selection;
    private List<ICICSplex> cicsPlexes;

    protected MoreCICSPlexesDialog(Shell parentShell) {
        super(parentShell);
    }

    public MoreCICSPlexesDialog(Shell parentShell, Region aRegion, List<ICICSplex> cicsPlexes) {
        super(parentShell);
        this.setTitle(MessageFormat.format(Messages.getString("MoreCICSPlexesDialog.title"), aRegion));
        this.setTitleImage(ImageFactory.getCICSPlexesWizardImage());
        this.region = aRegion;
        this.cicsPlexes = cicsPlexes;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(MessageFormat.format(Messages.getString("MoreCICSPlexesDialog.title"), this.region));
    }

    private void fillTableWitCICSPlexes() {
        Debug.enter((Logger)logger, (String)MoreCICSPlexesDialog.class.getName(), (String)"fillTableWitCICSPlexes", (Object)("Thread ID: " + Thread.currentThread().getId()));
        for (ICICSplex cicsPlex : this.cicsPlexes) {
            TableItem item = new TableItem(this.cicsPlexesTable, 0);
            item.setImage(ImageFactory.getCICSPlexImage());
            item.setText(cicsPlex.getName());
            item.setData((Object)cicsPlex);
        }
        Debug.exit((Logger)logger, (String)MoreCICSPlexesDialog.class.getName(), (String)"fillTableWitCICSPlexes");
    }

    private void setSelection(ICICSplex aSelection) {
        this.selection = aSelection;
    }

    protected Control createDialogArea(Composite parent) {
        Debug.enter((Logger)logger, (String)MoreCICSPlexesDialog.class.getName(), (String)"createDialogArea", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setText(MessageFormat.format(Messages.getString("MoreCICSPlexesDialog.label.text"), this.region));
        FormToolkit toolkit = EditorHelper.getFormToolkit();
        this.cicsPlexesTable = toolkit.createTable(composite, 2820);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        this.cicsPlexesTable.setLayoutData((Object)gridData);
        this.fillTableWitCICSPlexes();
        this.cicsPlexesTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = MoreCICSPlexesDialog.this.cicsPlexesTable.getSelection();
                if (items.length > 0) {
                    if (items[0] == MoreCICSPlexesDialog.this.dummyTableItem) {
                        return;
                    }
                    MoreCICSPlexesDialog.this.selection = (ICICSplex)items[0].getData();
                }
                MoreCICSPlexesDialog.this.updateOkStatus();
            }
        });
        this.setHelpAvailable(false);
        Debug.enter((Logger)logger, (String)MoreCICSPlexesDialog.class.getName(), (String)"createDialogArea", (Object)("Thread ID: " + Thread.currentThread().getId()));
        return composite;
    }

    protected void updateOkStatus() {
        if (this.selection != null) {
            this.getButton(0).setEnabled(true);
        } else {
            this.getButton(0).setEnabled(false);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control createButtonBar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return createButtonBar;
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.setMessage(MessageFormat.format(Messages.getString("MoreCICSPlexesDialog.message"), this.region.getName()));
        return result;
    }

    public ICICSplex getSelection() {
        return this.selection;
    }
}

