/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.dbfunc.DB2Host;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.UIUtilities;
import java.text.MessageFormat;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class IAConnectionStatus
extends Composite {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    Label imageLabel = new Label((Composite)this, 0);
    Hyperlink serverLabel;
    private int serverLabelMinimumWidth;

    public IAConnectionStatus(Composite parent, int style) {
        super(parent, style);
        this.imageLabel.setImage(ImageFactory.getInactiveConnectionImage());
        this.imageLabel.setLayoutData((Object)new GridData(0, 0x1000000, false, true));
        this.serverLabel = new Hyperlink((Composite)this, 0);
        this.serverLabel.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (IAConnectionStatus.this.imageLabel.getImage().equals((Object)ImageFactory.getErrorImage())) {
                    e.result = MessageFormat.format(Messages.getString("ConnectionStatusTrimWidget.connError"), IAConnectionStatus.this.serverLabel.getText(), IAConnectionStatus.this.serverLabel.getToolTipText());
                }
                if (IAConnectionStatus.this.imageLabel.getImage().equals((Object)ImageFactory.getInactiveConnectionImage())) {
                    e.result = MessageFormat.format(Messages.getString("ConnectionStatusTrimWidget.connInactive"), IAConnectionStatus.this.serverLabel.getText(), IAConnectionStatus.this.serverLabel.getToolTipText());
                }
                if (IAConnectionStatus.this.imageLabel.getImage().equals((Object)ImageFactory.getActiveConnectionImage())) {
                    e.result = MessageFormat.format(Messages.getString("ConnectionStatusTrimWidget.connActive"), IAConnectionStatus.this.serverLabel.getText());
                }
                if (IAConnectionStatus.this.imageLabel.getImage().equals((Object)ImageFactory.getProgressConnectionImage())) {
                    e.result = MessageFormat.format(Messages.getString("ConnectionStatusTrimWidget.connInProgress"), IAConnectionStatus.this.serverLabel.getText(), IAConnectionStatus.this.serverLabel.getToolTipText());
                }
            }
        });
        this.serverLabel.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                UIUtilities.openConnectionPreferences();
            }
        });
        if (DB2Host.getDefault((String)"com.ibm.cics.ia.connection.db2") != null) {
            this.updateConnectionStatus(DB2Host.getDefault((String)"com.ibm.cics.ia.connection.db2"));
        }
        this.serverLabel.setText(this.getEmptyString(38));
        this.serverLabelMinimumWidth = this.serverLabel.computeSize((int)-1, (int)-1).x;
        this.setLayout(new Layout(){

            protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                Point preferredSize = new Point(0, 0);
                Point imageLabelSize = IAConnectionStatus.this.imageLabel.computeSize(wHint, hHint);
                preferredSize.x = imageLabelSize.x;
                preferredSize.y = imageLabelSize.y;
                Point hyperlinkSize = IAConnectionStatus.this.serverLabel.computeSize(wHint, hHint);
                int minX = Math.max(hyperlinkSize.x, IAConnectionStatus.this.serverLabelMinimumWidth);
                preferredSize.x += minX;
                return preferredSize;
            }

            protected void layout(Composite composite, boolean flushCache) {
                Point imageLabelPreferredSize = IAConnectionStatus.this.imageLabel.computeSize(-1, -1);
                IAConnectionStatus.this.imageLabel.setSize(imageLabelPreferredSize);
                Point serverLabelPreferredSize = IAConnectionStatus.this.serverLabel.computeSize(-1, -1);
                int y = (IAConnectionStatus.this.computeSize((int)-1, (int)-1).y - serverLabelPreferredSize.y) / 2;
                IAConnectionStatus.this.serverLabel.setLocation(imageLabelPreferredSize.x, y);
                Point newServerLabelSize = new Point(serverLabelPreferredSize.x, serverLabelPreferredSize.y);
                IAConnectionStatus.this.serverLabel.setSize(newServerLabelSize);
            }
        });
    }

    void updateConnectionStatus(DB2Host aHost) {
        if (this.imageLabel.isDisposed()) {
            return;
        }
        this.imageLabel.setToolTipText(IAUtilities.EMPTY_STRING);
        this.serverLabel.setToolTipText(IAUtilities.EMPTY_STRING);
        int connectionStatus = aHost.getConnectionStatus();
        if (connectionStatus == DB2Host.CONNECTED) {
            this.serverLabel.setText(aHost.getServerName());
            this.imageLabel.setImage(ImageFactory.getActiveConnectionImage());
        } else if (connectionStatus == DB2Host.CONNECTING) {
            this.serverLabel.setText(aHost.getServerName());
            this.imageLabel.setImage(ImageFactory.getProgressConnectionImage());
        } else {
            String serverName = aHost.getServerName();
            if (!IAUtilities.hasContent((String)serverName)) {
                serverName = Messages.getString("ConnectionStatusItem.txt.nohost");
            }
            this.serverLabel.setText(serverName);
            String connectionError = aHost.getConnectionErrorMessage();
            if (IAUtilities.hasContent((String)connectionError)) {
                this.imageLabel.setToolTipText(connectionError);
                this.serverLabel.setToolTipText(connectionError);
                this.imageLabel.setImage(ImageFactory.getErrorImage());
            } else {
                this.imageLabel.setImage(ImageFactory.getInactiveConnectionImage());
            }
        }
    }

    protected String getEmptyString(int numberOfCharacters) {
        StringBuffer sb = new StringBuffer();
        int i = 1;
        while (i <= numberOfCharacters) {
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }

    static interface Controller {
    }
}

