/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.ui.Messages;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class GeneralPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Preferences pluginPreferences;
    private Table typesTable;

    protected Control createContents(Composite parent) {
        Composite clientArea = new Composite(parent, 0);
        clientArea.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label(clientArea, 16384);
        l.setText(Messages.getString("GeneralPreferencePage.label.defaultresources"));
        GridData data = new GridData(4, 0, true, false);
        l.setLayoutData((Object)data);
        Group g = new Group(clientArea, 0);
        data = new GridData(4, 0, false, false);
        data.horizontalSpan = 2;
        g.setLayoutData((Object)data);
        g.setText(Messages.getString("GeneralPreferencePage.group.reosurcetypestoinclude"));
        g.setLayout((Layout)new GridLayout(1, false));
        this.typesTable = new Table((Composite)g, 2080);
        this.typesTable.setLayoutData((Object)new GridData(4, 4, true, false));
        this.addTypeItem("DB2_DATA");
        this.addTypeItem("IMS_DATA");
        this.addTypeItem("MQ_DATA");
        Label spacer = new Label(clientArea, 0);
        data = new GridData(4, 0, false, false);
        data.horizontalSpan = 2;
        spacer.setLayoutData((Object)data);
        this.initializeControls();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.cics.ia.help.general_preference_page");
        return clientArea;
    }

    private void addTypeItem(String aType) {
        TableItem newTypeItem = new TableItem(this.typesTable, 0);
        newTypeItem.setData((Object)aType);
        newTypeItem.setText(Messages.getString(aType));
    }

    private void initializeControls() {
        this.pluginPreferences = IAPlugin.getDefault().getPluginPreferences();
        TableItem[] typeItems = this.typesTable.getItems();
        int i = 0;
        while (i < typeItems.length) {
            TableItem typeItem = typeItems[i];
            typeItem.setChecked(this.pluginPreferences.getBoolean((String)typeItem.getData()));
            ++i;
        }
    }

    protected void performDefaults() {
        TableItem[] typeItems = this.typesTable.getItems();
        int i = 0;
        while (i < typeItems.length) {
            TableItem typeItem = typeItems[i];
            typeItem.setChecked(this.pluginPreferences.getDefaultBoolean((String)typeItem.getData()));
            ++i;
        }
        super.performDefaults();
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        TableItem[] typeItems = this.typesTable.getItems();
        int i = 0;
        while (i < typeItems.length) {
            TableItem typeItem = typeItems[i];
            String data = (String)typeItem.getData();
            this.pluginPreferences.setValue(data, typeItem.getChecked());
            ++i;
        }
        IAPlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }
}

