/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.ia.ui.ExplorerQueryContext;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.composites.HistoryBox;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ExplorerQueryContextComposite
extends Composite {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Label contextLabel;
    Text contextText;
    private ExplorerQueryContext currentContext;
    HistoryBox contextHB;
    private List<Listener> listeners = new ArrayList<Listener>();
    private ToolItem typeToolItem;
    private ToolBar toolBar;
    private ToolBarManager manager;

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.contextText != null) {
            this.contextText.setEnabled(enabled);
        }
        this.contextLabel.setEnabled(enabled);
        this.typeToolItem.setEnabled(enabled);
    }

    public void setContextTypeEnabled(boolean enabled) {
        this.typeToolItem.setEnabled(enabled);
    }

    public ExplorerQueryContextComposite(Composite parent, Set<ExplorerQueryContext> contexts, ExplorerQueryContext initialContext, boolean useHistoryBox) {
        super(parent, 0);
        if (!contexts.contains((Object)initialContext)) {
            throw new IllegalArgumentException("The initial context is incorrect");
        }
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        ExplorerQueryContext longestContext = initialContext;
        for (ExplorerQueryContext context : contexts) {
            if (longestContext.getContextLabel().length() >= context.getContextLabel().length()) continue;
            longestContext = context;
        }
        this.contextLabel = new Label((Composite)this, 0);
        this.contextLabel.setText(longestContext.getContextLabel());
        GridData data = new GridData(1, 0x1000000, false, false);
        data.widthHint = this.contextLabel.computeSize((int)-1, (int)-1).x;
        this.contextLabel.setLayoutData((Object)data);
        this.toolBar = new ToolBar((Composite)this, 0x800000);
        data = new GridData(1, 0x1000000, false, true);
        this.toolBar.setLayoutData((Object)data);
        this.manager = new ToolBarManager(this.toolBar);
        this.manager.getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == 0) {
                    e.result = ExplorerQueryContextComposite.this.typeToolItem.getToolTipText();
                }
            }
        });
        this.typeToolItem = new ToolItem(this.toolBar, 0x800008);
        this.typeToolItem.setImage(ImageFactory.getDropDownArrowImage());
        this.typeToolItem.setToolTipText(Messages.getString("ExplorerQueryContextComposite.typeToolItem.text"));
        SelectionAdapter typeSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem selectedMenuItem = (MenuItem)e.getSource();
                ExplorerQueryContext context = (ExplorerQueryContext)((Object)selectedMenuItem.getData());
                ExplorerQueryContextComposite.this.fireContextChanged(context);
                ExplorerQueryContextComposite.this.updateToolBarMenu(context);
            }
        };
        final Menu menu = new Menu((Decorations)this.getShell(), 8);
        for (ExplorerQueryContext context : contexts) {
            MenuItem menuItem = new MenuItem(menu, 8);
            menuItem.setData((Object)context);
            menuItem.setText(context.getContextLabel());
            menuItem.setImage(context.getImage());
            menuItem.addSelectionListener((SelectionListener)typeSelectionListener);
        }
        this.typeToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Rectangle rect = ExplorerQueryContextComposite.this.contextLabel.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = ExplorerQueryContextComposite.this.toDisplay(pt);
                menu.setLocation(pt.x, pt.y);
                menu.setVisible(true);
            }
        });
        if (useHistoryBox) {
            this.contextHB = new HistoryBox(this, 128);
            this.contextHB.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    AccessibleEvent i = e;
                    i.toString();
                    e.result = ExplorerQueryContextComposite.this.contextLabel.getText();
                }
            });
        } else {
            this.contextHB = null;
            this.contextText = new Text((Composite)this, 2048);
            data = new GridData(4, 0x1000000, false, false);
            data.widthHint = this.contextText.computeSize((int)-1, (int)-1).x;
            this.contextText.setLayoutData((Object)data);
            this.contextText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    AccessibleEvent i = e;
                    i.toString();
                    e.result = ExplorerQueryContextComposite.this.contextLabel.getText();
                }
            });
        }
        this.addListener(new Listener(){

            @Override
            public void contextChanged(ExplorerQueryContext context) {
                ExplorerQueryContextComposite.this.currentContext = context;
            }
        });
        this.setContext(initialContext);
    }

    protected void updateToolBarMenu(ExplorerQueryContext context) {
        this.contextLabel.setText(context.getContextLabel());
        this.toolBar.getParent().getParent().layout(true);
    }

    private void fireContextChanged(ExplorerQueryContext aContext) {
        for (Listener listener : this.listeners) {
            listener.contextChanged(aContext);
        }
    }

    void addListener(Listener aListener) {
        this.listeners.add(aListener);
    }

    void removeListener(Listener aListener) {
        this.listeners.remove(aListener);
    }

    public void forceContext(ExplorerQueryContext context) {
        this.updateToolBarMenu(context);
    }

    public ExplorerQueryContext getContext() {
        return this.currentContext;
    }

    public void setContext(ExplorerQueryContext context) {
        if (context != this.currentContext) {
            this.currentContext = context;
            this.forceContext(context);
            this.fireContextChanged(context);
        }
    }

    static interface Listener {
        public void contextChanged(ExplorerQueryContext var1);
    }
}

