/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.ia.commands.AbstractFindCICSObjectType;
import com.ibm.cics.ia.commands.FindProgramsCommand;
import com.ibm.cics.ia.commands.FindProgramsForApplicationCommand;
import com.ibm.cics.ia.commands.FindTransactionsCommand;
import com.ibm.cics.ia.commands.FindTransactionsForApplicationCommand;
import com.ibm.cics.ia.commands.FindWebservicesCommand;
import com.ibm.cics.ia.commands.FindWebservicesForApplicationCommand;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.Messages;
import org.eclipse.swt.graphics.Image;

public enum ExplorerQueryContext {
    REGION(Messages.getString("ResourceExplorer.label.inregion"), 0),
    APPLICATION(Messages.getString("ResourceExplorer.label.inapplication"), 1),
    PROGRAM(Messages.getString("ThreadsafeReportWizard.SearchProgram.Label"), 2),
    TRANSACTION(Messages.getString("ThreadsafeReportWizard.SearchTransaction.Label"), 3);

    private String contextLabel;
    private int relativePosition;

    private ExplorerQueryContext(String contextLabel, int relativePosition) {
        this.contextLabel = contextLabel;
        this.relativePosition = relativePosition;
    }

    public AbstractFindCICSObjectType getTransactionFindCommand() {
        switch (this) {
            case REGION: {
                return new FindTransactionsCommand();
            }
        }
        return new FindTransactionsForApplicationCommand();
    }

    public AbstractFindCICSObjectType getProgramFindCommand() {
        switch (this) {
            case REGION: {
                return new FindProgramsCommand();
            }
        }
        return new FindProgramsForApplicationCommand();
    }

    public AbstractFindCICSObjectType getWebserviceFindCommand() {
        switch (this) {
            case REGION: {
                return new FindWebservicesCommand();
            }
        }
        return new FindWebservicesForApplicationCommand();
    }

    public int getPosition() {
        return this.relativePosition;
    }

    public String getContextLabel() {
        return this.contextLabel;
    }

    public boolean isRegion() {
        return this.equals((Object)REGION);
    }

    public boolean isApplication() {
        return this.equals((Object)APPLICATION);
    }

    public boolean isProgram() {
        return this.equals((Object)PROGRAM);
    }

    public boolean isTransaction() {
        return this.equals((Object)TRANSACTION);
    }

    public Image getImage() {
        switch (this) {
            case REGION: {
                return ImageFactory.getRegionImage();
            }
            case APPLICATION: {
                return ImageFactory.getApplicationImage();
            }
            case PROGRAM: {
                return ImageFactory.getProgramImage();
            }
            case TRANSACTION: {
                return ImageFactory.getTransactionImage();
            }
        }
        return null;
    }
}

