/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.eclipse.common.ui.JobWithCancelingSupport;
import com.ibm.cics.ia.controller.DisplayableData;
import com.ibm.cics.ia.controller.ExecutionTreeFinder;
import com.ibm.cics.ia.model.ExecutionAnalyzer;
import com.ibm.cics.ia.model.Interaction;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.model.Verb;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.CSVUtils;
import com.ibm.cics.ia.ui.CaptureEPSpecMenu;
import com.ibm.cics.ia.ui.CommandHistoryManager;
import com.ibm.cics.ia.ui.DefaultEditorInputImpl;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.ResourceRenderer;
import com.ibm.cics.ia.ui.ResourceTypeRenderer;
import com.ibm.cics.ia.ui.ShowDetailsStrategy;
import com.ibm.cics.ia.ui.TreeSelectionProvider;
import com.ibm.cics.ia.ui.UIUtilities;
import com.ibm.cics.ia.ui.VerbLabelProvider;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.part.EditorPart;

public class ExecutionTree
extends EditorPart {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ExecutionTree.class.getPackage().getName());
    public static final String ID = "com.ibm.cics.ia.ui.executiontree";
    private static final String RESOURCES_LIST = "RESOURCES_LIST";
    private static final String POPULATED = "POPULATED";
    private static final String DUPLICATEITEM = "DUPLICATEITEM";
    private static final String VERBS_LIST = "VERBS_LIST";
    private static final String TEXT = "TEXT";
    private static final String VERB_CHILDREN = "VERB_CHILDREN";
    private static final String TARGET_CHILDREN = "TARGET_CHILDREN";
    protected static final String VERB = "VERB";
    private static final String SOURCES = "SOURCES";
    protected static final String MENU_RESOURCE = "MENU_RESOURCE";
    private static final String BLANK = "";
    public static final DefaultEditorInputImpl DEFAULT_EDITOR_INPUT = new DefaultEditorInputImpl(){};
    private Display display;
    private SashForm sashForm;
    private Tree resourcesTree;
    private Label totalsLabel;
    private Table resourcesTable;
    private TableColumn resourcesTableCol;
    private Tree executionTree;
    private Map itemsMap = new HashMap();
    private Map<Region, Map<Resource, Map<String, List<Resource>>>> regionsToResourceToVerbTargetMaps = new HashMap<Region, Map<Resource, Map<String, List<Resource>>>>();
    private Label searchLabel;
    private Map<Resource, List<TreeItem>> resourceToItems = new HashMap<Resource, List<TreeItem>>();
    private CommandHistoryManager commandHistoryManager;
    private ExecutionAnalyzer.Listener executionAnalyzerListener;
    private Map<Resource, List<TreeItem>> treeItemsWaitingForModelCompletion = new HashMap<Resource, List<TreeItem>>();
    private Map<TreeItem, TreeItem> regionTreeItemMappedtoRootResourceTreeItems = new HashMap<TreeItem, TreeItem>();
    private Map<String, TreeItem> regionTreeItemMappedByApplid = new HashMap<String, TreeItem>();
    private Map<String, Region> regionResourceMappedByApplid = new HashMap<String, Region>();
    private ExecutionTreeFinder executionTreeFinder;
    private Label executionSearchLabel;
    private List<Resource> selectedResources = new ArrayList<Resource>();
    private String currentSearch = "";
    private VerbLabelProvider verbLabelProvider = new VerbLabelProvider();
    private boolean sortByResource = true;
    private Action sortByVerbsAction;
    private List<Resource> resourcesCompleted = new ArrayList<Resource>();
    private List<ExecutionAnalyzer.ResourceAnalysis> analysedResourcesToProcess = new ArrayList<ExecutionAnalyzer.ResourceAnalysis>();
    private ArrayList clearedResourcesAnalyzed = new ArrayList();
    private ExecutionAnalyzer currentAnalyzer;
    private ToolBar topToolBar;
    private ToolBar toolBar;
    private Composite parent;
    private Composite c;
    private Job executionJob;
    private TreeSelectionProvider selectionProvider;
    private ConnectionServiceListener connectionServiceListener;

    public void createPartControl(final Composite parent) {
        Debug.enter((Logger)logger, (String)ExecutionTree.class.getName(), (String)"createPartControl", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.parent = parent;
        this.commandHistoryManager = new CommandHistoryManager(){

            @Override
            void executeCommand(Command aCommand) {
                ExecutionTree.this.execute((ExecutionAnalyzer)aCommand);
            }
        };
        this.createPartControl(parent, this.getPreferredOrientation(parent));
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int newPreferredOrientation = ExecutionTree.this.getPreferredOrientation(parent);
                ExecutionTree.this.sashForm.setOrientation(newPreferredOrientation);
                ExecutionTree.this.sashForm.layout();
            }
        });
        new ShowDetailsStrategy((Control)this.resourcesTree){

            @Override
            public Object extractSource() {
                return 4.extractSourceFromTree(ExecutionTree.this.resourcesTree, "RESOURCE");
            }
        };
        new ShowDetailsStrategy((Control)this.resourcesTable){

            @Override
            public Object extractSource() {
                return 5.extractSourceFromTable(ExecutionTree.this.resourcesTable, "RESOURCE");
            }
        };
        new ShowDetailsStrategy((Control)this.executionTree){

            @Override
            public Object extractSource() {
                return 6.extractSourceFromTree(ExecutionTree.this.executionTree, "RESOURCE");
            }
        };
        this.connectionServiceListener = this.getConnectionServiceListener();
        ConnectionsPlugin.getDefault().getConnectionService().addConnectionServiceListener(this.connectionServiceListener);
        IWorkbenchHelpSystem helpSystem = this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)parent, "com.ibm.cics.ia.help.execution_tree");
        Debug.exit((Logger)logger, (String)ExecutionTree.class.getName(), (String)"createPartControl");
    }

    private int getPreferredOrientation(Composite parent) {
        Point size = parent.getSize();
        if (size.x > size.y) {
            return 256;
        }
        return 512;
    }

    private void createPartControl(Composite parent, int orientation) {
        Debug.enter((Logger)logger, (String)ExecutionTree.class.getName(), (String)"createPartControl", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.c = new Composite(parent, 0);
        this.c.setLayout((Layout)new GridLayout());
        this.topToolBar = UIUtilities.createToolBar(this.c);
        this.sashForm = new SashForm(this.c, orientation);
        GridData data = new GridData(4, 4, true, true);
        this.sashForm.setLayoutData((Object)data);
        Composite resourcesComposite = new Composite((Composite)this.sashForm, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 2;
        resourcesComposite.setLayout((Layout)gridLayout);
        Composite topResourcesComposite = new Composite(resourcesComposite, 0);
        data = new GridData(4, 0, true, false);
        topResourcesComposite.setLayoutData((Object)data);
        gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 2;
        topResourcesComposite.setLayout((Layout)gridLayout);
        SashForm resourcesSash = new SashForm(resourcesComposite, 256);
        data = new GridData(4, 4, true, true);
        resourcesSash.setLayoutData((Object)data);
        this.resourcesTree = new Tree((Composite)resourcesSash, 2564);
        final TreeColumn resourcesTreeCol1 = new TreeColumn(this.resourcesTree, 0);
        this.resourcesTree.setHeaderVisible(true);
        String resourcesUsedTitle = Messages.getString("ExecutionTree.text.resourcesused");
        resourcesTreeCol1.setText(resourcesUsedTitle);
        resourcesTreeCol1.setToolTipText(resourcesUsedTitle);
        this.resourcesTree.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                resourcesTreeCol1.setWidth(((ExecutionTree)ExecutionTree.this).resourcesTree.getClientArea().width);
            }
        });
        this.resourcesTree.addKeyListener((KeyListener)new UIUtilities.CopyListener(){

            @Override
            public void copy() {
                ExecutionTree.this.doCopy();
            }
        });
        this.resourcesTable = new Table((Composite)resourcesSash, 2564);
        this.resourcesTableCol = new TableColumn(this.resourcesTable, 0);
        String byResourceTitle = Messages.getString("ExecutionTree.txt.byProgramOrTransaction");
        this.resourcesTableCol.setText(byResourceTitle);
        this.resourcesTableCol.setToolTipText(byResourceTitle);
        this.resourcesTable.setHeaderVisible(true);
        this.resourcesTable.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int tableWidth = ((ExecutionTree)ExecutionTree.this).resourcesTable.getClientArea().width;
                ExecutionTree.this.resourcesTableCol.setWidth(tableWidth);
            }
        });
        resourcesSash.setWeights(new int[]{6, 4});
        Composite executionComposite = new Composite((Composite)this.sashForm, 0);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        executionComposite.setLayout((Layout)gridLayout);
        Composite topExecutionComposite = new Composite(executionComposite, 0);
        data = new GridData(4, 0, true, false);
        topExecutionComposite.setLayoutData((Object)data);
        topExecutionComposite.setLayout((Layout)new GridLayout(3, false));
        this.executionTree = new Tree(executionComposite, 2820);
        data = new GridData(4, 4, true, true);
        this.executionTree.setLayoutData((Object)data);
        executionComposite.setTabList(new Control[]{topExecutionComposite, this.executionTree});
        this.searchLabel = new Label(topResourcesComposite, 0);
        data = new GridData(4, 0, true, false);
        data.verticalAlignment = 2;
        this.searchLabel.setLayoutData((Object)data);
        this.totalsLabel = new Label(topResourcesComposite, 0);
        data = new GridData(4, 0, false, false);
        data.verticalAlignment = 2;
        data.horizontalAlignment = 3;
        this.totalsLabel.setLayoutData((Object)data);
        this.totalsLabel.setText("    ");
        this.toolBar = new ToolBar(topExecutionComposite, 0x800000);
        ToolItem searchNextItem = new ToolItem(this.toolBar, 0x800000);
        searchNextItem.setImage(ImageFactory.getNextItemImage());
        searchNextItem.setDisabledImage(ImageFactory.getNextItemImage_DISABLED());
        searchNextItem.setEnabled(false);
        searchNextItem.setToolTipText(Messages.getString("ExecutionTree.tooltip.getnextitem"));
        ToolItem searchPreviousItem = new ToolItem(this.toolBar, 0x800000);
        searchPreviousItem.setImage(ImageFactory.getPreviousItemImage());
        searchPreviousItem.setDisabledImage(ImageFactory.getPreviousItemImage_DISABLED());
        searchPreviousItem.setEnabled(false);
        searchPreviousItem.setToolTipText(Messages.getString("ExecutionTree.tooltip.getprevitem"));
        searchPreviousItem.getToolTipText();
        this.toolBar.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID != -1) {
                    try {
                        String toolTip;
                        ToolItem item = ExecutionTree.this.toolBar.getItem(e.childID);
                        if (item != null && (toolTip = item.getToolTipText()) != null) {
                            e.result = toolTip;
                        }
                    }
                    catch (IllegalArgumentException ee) {
                        IAPlugin.getDefault().logError("Unable to get toolbar item", (Throwable)ee);
                    }
                }
            }
        });
        ToolItem minimiseTreeItem = new ToolItem(this.toolBar, 0x800000);
        minimiseTreeItem.setImage(ImageFactory.getCollapseImage());
        minimiseTreeItem.setToolTipText(Messages.getString("Button.tooltip.minimise"));
        minimiseTreeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIUtilities.expandTree(ExecutionTree.this.executionTree, false);
            }
        });
        ToolItem maximiseTreeItem = new ToolItem(this.toolBar, 0x800000);
        maximiseTreeItem.setImage(ImageFactory.getExpandImage());
        maximiseTreeItem.setToolTipText(Messages.getString("Button.tooltip.maximise"));
        maximiseTreeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExecutionTree.this.currentAnalyzer != null && ExecutionTree.this.currentAnalyzer.status() == 1) {
                    ExecutionTree.this.populateExecutionTree();
                }
                UIUtilities.expandTree(ExecutionTree.this.executionTree, true);
            }
        });
        this.executionTreeFinder = new ExecutionTreeFinder(this.executionTree, searchNextItem, searchPreviousItem, this);
        this.executionSearchLabel = new Label(topExecutionComposite, 0);
        data = new GridData(4, 0x1000000, true, false);
        this.executionSearchLabel.setLayoutData((Object)data);
        this.display = parent.getDisplay();
        this.executionTree.addKeyListener((KeyListener)new UIUtilities.CopyListener(){

            @Override
            public void copy() {
                ExecutionTree.this.doCopy();
            }
        });
        this.resourcesTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ExecutionTree.this.sortByResource) {
                    Object itemData = e.item.getData("RESOURCE");
                    if (itemData instanceof Resource) {
                        Verb verb = (Verb)((TreeItem)e.item).getParentItem().getData(ExecutionTree.VERB);
                        String verbName = verb.getName();
                        Resource resource = (Resource)e.item.getData("RESOURCE");
                        List sources = (List)e.item.getData(ExecutionTree.SOURCES);
                        ExecutionTree.this.selectResources(sources, String.valueOf(ExecutionTree.this.verbLabelProvider.getText(verbName)) + " " + resource);
                    } else {
                        itemData = e.item.getData(ExecutionTree.VERB);
                        if (itemData instanceof Verb) {
                            String verbName = ((Verb)itemData).getName();
                            TreeItem[] resourceItems = ((TreeItem)e.item).getItems();
                            ArrayList sources = new ArrayList();
                            int i = 0;
                            while (i < resourceItems.length) {
                                List childSources = (List)resourceItems[i].getData(ExecutionTree.SOURCES);
                                IAUtilities.addAllUnique(sources, (Collection)childSources);
                                ++i;
                            }
                            ExecutionTree.this.selectResources(sources, MessageFormat.format(Messages.getString("ExecutionTree.programsUsing"), verbName));
                        }
                    }
                } else {
                    Object itemData = e.item.getData("RESOURCE");
                    if (itemData instanceof Resource) {
                        ArrayList resources = new ArrayList();
                        TreeItem[] verbItems = ((TreeItem)e.item).getItems();
                        int i = 0;
                        while (i < verbItems.length) {
                            for (Object resource : (List)verbItems[i].getData(ExecutionTree.SOURCES)) {
                                if (resources.contains(resource)) continue;
                                resources.add(resource);
                            }
                            ++i;
                        }
                        ExecutionTree.this.selectResources(resources, MessageFormat.format(Messages.getString("ExecutionTree.programsUsing"), ((Resource)itemData).getName()));
                    } else {
                        Verb verb = (Verb)e.item.getData(ExecutionTree.VERB);
                        if (verb != null) {
                            String verbName = verb.getName();
                            TreeItem verbItem = (TreeItem)e.item;
                            List sources = (List)e.item.getData(ExecutionTree.SOURCES);
                            Resource resource = (Resource)verbItem.getParentItem().getData("RESOURCE");
                            ExecutionTree.this.selectResources(sources, MessageFormat.format(Messages.getString("ExecutionTree.programsUsing2"), verbName, resource.getName()));
                        }
                    }
                }
            }
        });
        this.resourcesTree.addListener(17, new Listener(){

            public void handleEvent(Event e) {
                TreeItem treeItem = (TreeItem)e.item;
                TreeItem[] treeItemArray = treeItem.getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem childItem = treeItemArray[n2];
                    Verb verb = (Verb)childItem.getData(ExecutionTree.VERB);
                    if (verb != null) {
                        String verbName = verb.getName();
                        Resource resource = (Resource)treeItem.getData("RESOURCE");
                        List events = null;
                        if (resource != null) {
                            events = resource.getEvents(verbName);
                        }
                        if (events != null && childItem.getItemCount() <= 0) {
                            for (com.ibm.cics.ia.model.Event event : events) {
                                String eventLabel = "EVENT " + event.getName() + ", " + event.getCaptureSpec() + ", " + event.getBinding();
                                TreeItem eventItem = UIUtilities.createEBCDICSortedTreeItem(childItem, eventLabel, ImageFactory.getEventImage());
                                eventItem.setData("EVENT", (Object)event);
                            }
                        }
                    }
                    ++n2;
                }
            }
        });
        this.createActions();
        this.sortByVerbsAction.setEnabled(false);
        Debug.exit((Logger)logger, (String)ExecutionTree.class.getName(), (String)"createPartControl");
    }

    private void selectResources(List resources, String searchString) {
        Debug.enter((Logger)logger, (String)ExecutionTree.class.getName(), (String)"selectResources", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.resourcesTable.removeAll();
        boolean transactionDetected = false;
        boolean programDetected = false;
        for (Object object : resources) {
            Resource resource = (Resource)object;
            if (resource instanceof Program) {
                programDetected = true;
            } else if (resource instanceof Transaction) {
                transactionDetected = true;
            }
            TableItem resourceItem = new TableItem(this.resourcesTable, 0);
            resourceItem.setData("RESOURCE", (Object)resource);
            resourceItem.setText(ResourceRenderer.asText(resource));
            boolean eventable = resource.isEventable();
            resourceItem.setImage(ResourceRenderer.getOverLaidImage(ResourceRenderer.asImage(resource), false, false, eventable));
        }
        if (programDetected && !transactionDetected) {
            this.resourcesTableCol.setText(Messages.getString("ExecutionTree.txt.byProgram"));
        } else if (transactionDetected && !programDetected) {
            this.resourcesTableCol.setText(Messages.getString("ExecutionTree.txt.byTransaction"));
        } else {
            this.resourcesTableCol.setText(Messages.getString("ExecutionTree.txt.byProgramOrTransaction"));
        }
        this.executionTreeSearch(resources, searchString);
        Debug.exit((Logger)logger, (String)ExecutionTree.class.getName(), (String)"enclosing_method");
    }

    private void executionTreeSearch(List resources, String searchString) {
        Debug.enter((Logger)logger, (String)ExecutionTree.class.getName(), (String)"executionTreeSearch", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.currentAnalyzer.status() == 1) {
            this.executionTreeFinder.clear();
            this.executionTreeFinder.setResources(resources);
            this.executionTreeFinder.findNext();
            this.executionSearchLabel.setText(searchString);
            this.executionSearchLabel.setToolTipText(searchString);
        } else {
            this.selectedResources = resources;
            this.currentSearch = searchString;
        }
        Debug.exit((Logger)logger, (String)ExecutionTree.class.getName(), (String)"executionTreeSearch");
    }

    private void createActions() {
        Debug.enter((Logger)logger, (String)ExecutionTree.class.getName(), (String)"createActions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.sortByVerbsAction = new Action(Messages.getString("ExecutionTree.action.grpbyverb"), ImageDescriptor.createFromImage((Image)ImageFactory.getVerbImage())){

            public void run() {
                ExecutionTree.this.sortByResource = !this.isChecked();
                ExecutionTree.this.resourcesTable.removeAll();
                TreeItem[] typeItems = ExecutionTree.this.resourcesTree.getItems();
                int i = 0;
                while (i < typeItems.length) {
                    typeItems[i].removeAll();
                    typeItems[i].setData(ExecutionTree.TARGET_CHILDREN, null);
                    typeItems[i].setData(ExecutionTree.VERB_CHILDREN, null);
                    ++i;
                }
                ExecutionTree.this.resourceToItems.clear();
                ExecutionTree.this.treeItemsWaitingForModelCompletion.clear();
                ExecutionTree.this.executionTreeFinder.clear();
                if (ExecutionTree.this.currentAnalyzer != null) {
                    ExecutionTree.this.insertResources(((ExecutionTree)ExecutionTree.this).currentAnalyzer.totalInteractions);
                }
                ExecutionTree.this.updateRootTreeItems(true);
            }

            public int getStyle() {
                return 2;
            }
        };
        ToolBarManager toolBarManager = new ToolBarManager(this.topToolBar);
        toolBarManager.add((IAction)this.sortByVerbsAction);
        toolBarManager.add((IContributionItem)new Separator());
        this.commandHistoryManager.createActions((IToolBarManager)toolBarManager);
        toolBarManager.update(true);
        this.topToolBar.pack();
        this.selectionProvider = new TreeSelectionProvider(this.executionTree, "RESOURCE", "EVENT");
        this.selectionProvider.registerTable(this.resourcesTable);
        this.selectionProvider.registerTree(this.resourcesTree);
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        Action copyAction = new Action("Copy", null){

            public void run() {
                ExecutionTree.this.doCopy();
            }
        };
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)copyAction);
        MenuManager menuMgr = new MenuManager();
        Menu popupMenu = menuMgr.createContextMenu((Control)this.executionTree);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TreeItem[] items = ExecutionTree.this.executionTree.getSelection();
                if (items.length == 1) {
                    Resource resource = (Resource)items[0].getData("RESOURCE");
                    Region region = (Region)items[0].getData("REGION");
                    if (resource != null) {
                        CaptureEPSpecMenu.createResourceActions(manager, resource, region);
                    }
                }
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        this.executionTree.setMenu(popupMenu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.selectionProvider);
        menuMgr = new MenuManager();
        popupMenu = menuMgr.createContextMenu((Control)this.resourcesTable);
        this.resourcesTable.setMenu(popupMenu);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Resource resource;
                TableItem[] items = ExecutionTree.this.resourcesTable.getSelection();
                if (items.length == 1 && (resource = (Resource)items[0].getData("RESOURCE")) != null) {
                    CaptureEPSpecMenu.createResourceActions(manager, resource, null);
                }
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.selectionProvider);
        menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        popupMenu = menuMgr.createContextMenu((Control)this.resourcesTree);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TreeItem[] items = ExecutionTree.this.resourcesTree.getSelection();
                if (items.length == 1) {
                    Resource resource = null;
                    Object region = null;
                    Verb verb = (Verb)items[0].getData(ExecutionTree.VERB);
                    if (verb != null && verb.isEventable()) {
                        ArrayList resources = (ArrayList)items[0].getData(ExecutionTree.SOURCES);
                        if (resources != null) {
                            CaptureEPSpecMenu.createCommandActions(manager, verb.getName(), resources);
                        }
                    } else {
                        resource = (Resource)items[0].getData("RESOURCE");
                        if (resource != null) {
                            CaptureEPSpecMenu.createResourceActions(manager, resource, null);
                        }
                    }
                }
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        this.resourcesTree.setMenu(popupMenu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.selectionProvider);
        Debug.exit((Logger)logger, (String)ExecutionTree.class.getName(), (String)"createActions");
    }

    private void setSearchInProgress(boolean aBool) {
        Debug.enter((Logger)logger, (String)ExecutionTree.class.getName(), (String)"setSearchInProgress", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (!this.c.isDisposed()) {
            this.totalsLabel.setEnabled(!aBool);
            this.searchLabel.setEnabled(!aBool);
            this.sortByVerbsAction.setEnabled(!aBool);
        }
        Debug.exit((Logger)logger, (String)ExecutionTree.class.getName(), (String)"enclosing_method");
    }

    private void clear() {
        Debug.enter((Logger)logger, (String)ExecutionTree.class.getName(), (String)"clear", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.resourcesTable != null && !this.resourcesTable.isDisposed()) {
            this.resourcesTable.removeAll();
        }
        if (this.totalsLabel != null && !this.totalsLabel.isDisposed()) {
            this.totalsLabel.setText(BLANK);
            this.sortByVerbsAction.setEnabled(false);
        }
        if (this.executionSearchLabel != null && !this.executionSearchLabel.isDisposed()) {
            this.executionSearchLabel.setText(BLANK);
        }
        this.itemsMap.clear();
        this.resourceToItems.clear();
        this.treeItemsWaitingForModelCompletion.clear();
        this.resourcesCompleted.clear();
        this.analysedResourcesToProcess.clear();
        if (this.resourcesTree != null && !this.resourcesTree.isDisposed()) {
            this.resourcesTree.removeAll();
        }
        if (this.executionTree != null && !this.executionTree.isDisposed()) {
            this.executionTree.removeAll();
        }
        if (this.executionTreeFinder != null) {
            this.executionTreeFinder.clear();
        }
        this.currentSearch = BLANK;
        this.selectedResources.clear();
        this.clearedResourcesAnalyzed.clear();
        this.setTitleLabel(BLANK);
        this.regionsToResourceToVerbTargetMaps.clear();
        this.regionResourceMappedByApplid.clear();
        this.regionTreeItemMappedByApplid.clear();
        this.regionTreeItemMappedtoRootResourceTreeItems.clear();
        if (this.selectionProvider != null) {
            this.selectionProvider.setSelection((ISelection)StructuredSelection.EMPTY);
        }
        if (this.currentAnalyzer != null) {
            if (this.currentAnalyzer.status() != 1) {
                this.currentAnalyzer.cancel();
            }
            this.currentAnalyzer.clearInteractions();
        }
        Debug.exit((Logger)logger, (String)ExecutionTree.class.getName(), (String)"clear");
    }

    public Job setInput(Resource aProgramOrTransaction, Region aRegion) {
        Debug.enter((Logger)logger, (String)ExecutionTree.class.getName(), (String)"setInput", (Object)("Thread ID: " + Thread.currentThread().getId()));
        ExecutionAnalyzer executionAnalyzer = new ExecutionAnalyzer();
        executionAnalyzer.setRoot(aProgramOrTransaction);
        executionAnalyzer.setRegion(aRegion);
        DisplayableData displayableData = DisplayableData.getDisplayableData((IAdaptable)executionAnalyzer);
        displayableData.setImage(ImageFactory.getUsesImage());
        if (aRegion == null) {
            displayableData.setDescription(MessageFormat.format(Messages.getString("ExecutionTree.desc.inallregions"), ResourceRenderer.asQualifiedName(aProgramOrTransaction)));
        } else {
            displayableData.setDescription(MessageFormat.format(Messages.getString("ExecutionTree.desc.inregion"), ResourceRenderer.asQualifiedName(aProgramOrTransaction), aRegion.getName()));
        }
        Job result = this.execute(executionAnalyzer);
        Debug.exit((Logger)logger, (String)ExecutionTree.class.getName(), (String)"setInput");
        return result;
    }

    private void setTitleLabel(final String aString) {
        Debug.enter((Logger)logger, (String)ExecutionTree.class.getName(), (String)"setTitleLabel", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ExecutionTree.this.c != null && !ExecutionTree.this.c.isDisposed()) {
                    ExecutionTree.this.searchLabel.setText(aString);
                    ExecutionTree.this.searchLabel.setToolTipText(aString);
                    ExecutionTree.this.searchLabel.getParent().getParent().layout(true);
                }
            }
        });
        Debug.exit((Logger)logger, (String)ExecutionTree.class.getName(), (String)"setTitleLabel");
    }

    protected Job execute(ExecutionAnalyzer executionAnalyzer) {
        Debug.enter((Logger)logger, (String)ExecutionTree.class.getName(), (String)"execute", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.clear();
        this.setSearchInProgress(true);
        if (!this.c.isDisposed()) {
            this.c.setCursor(this.parent.getDisplay().getSystemCursor(3));
        }
        final String searchText = DisplayableData.getDisplayableData((IAdaptable)executionAnalyzer).getDescription();
        this.commandHistoryManager.searchStarted((Command)executionAnalyzer);
        if (this.executionJob != null) {
            this.executionJob.cancel();
            try {
                this.executionJob.join();
            }
            catch (InterruptedException e1) {
                logger.throwing(((Object)((Object)this)).getClass().getName(), "execute", e1);
            }
            this.executionJob = null;
            if (this.currentAnalyzer != null) {
                this.currentAnalyzer.removeListener(this.getExecutionAnalyzerListener());
                if (this.currentAnalyzer.status() == 0) {
                    UIUtilities.cancel((Command)this.currentAnalyzer);
                }
            }
        }
        this.setTitleLabel(searchText);
        this.currentAnalyzer = executionAnalyzer;
        this.currentAnalyzer.addListener(this.getExecutionAnalyzerListener());
        Resource aProgramOrTransaction = executionAnalyzer.getRoot();
        Region aRegion = executionAnalyzer.getRegion();
        ArrayList<Region> regions = null;
        if (aRegion == null) {
            regions = aProgramOrTransaction.getRegions();
        } else {
            regions = new ArrayList<Region>();
            regions.add(aRegion);
        }
        if (regions != null && regions.size() >= 1) {
            ArrayList<Region> genRegions = regions;
            for (Region next : genRegions) {
                String nextApplid = next.getName();
                this.regionResourceMappedByApplid.put(nextApplid, next);
                this.regionsToResourceToVerbTargetMaps.put(next, new HashMap());
            }
        }
        if (!this.regionResourceMappedByApplid.keySet().isEmpty()) {
            Set<String> keySet = this.regionResourceMappedByApplid.keySet();
            List<String> sortedApplids = Arrays.asList(keySet.toArray(new String[keySet.size()]));
            Collections.sort(sortedApplids);
            for (String applId : sortedApplids) {
                Region region = this.regionResourceMappedByApplid.get(applId);
                TreeItem regionTreeItem = new TreeItem(this.executionTree, 0);
                regionTreeItem.setText(ResourceRenderer.asText((Resource)region));
                regionTreeItem.setImage(ResourceRenderer.asImage(region));
                regionTreeItem.setData("RESOURCE", (Object)region);
                regionTreeItem.setData("REGION", (Object)region);
                regionTreeItem.setData(POPULATED, (Object)false);
                ArrayList<TreeItem> regionResourceItems = new ArrayList<TreeItem>();
                regionResourceItems.add(regionTreeItem);
                this.resourceToItems.put((Resource)region, regionResourceItems);
                this.regionTreeItemMappedByApplid.put(applId, regionTreeItem);
                TreeItem resourceItem = new TreeItem(regionTreeItem, 0);
                resourceItem.setText(ResourceRenderer.asText(aProgramOrTransaction));
                boolean eventable = aProgramOrTransaction.isEventable();
                resourceItem.setImage(ResourceRenderer.getOverLaidImage(ResourceRenderer.asImage(aProgramOrTransaction), false, false, eventable));
                resourceItem.setData("RESOURCE", (Object)aProgramOrTransaction);
                resourceItem.setData("REGION", (Object)region);
                resourceItem.setData(POPULATED, (Object)false);
                List<TreeItem> resourceItems = this.resourceToItems.get(aProgramOrTransaction);
                if (resourceItems == null) {
                    resourceItems = new ArrayList<TreeItem>();
                    this.resourceToItems.put(aProgramOrTransaction, resourceItems);
                }
                resourceItems.add(resourceItem);
                this.regionTreeItemMappedtoRootResourceTreeItems.put(regionTreeItem, resourceItem);
            }
        }
        this.executionTree.addListener(17, new Listener(){

            public void handleEvent(Event e) {
                TreeItem node;
                boolean populated;
                if (e.item instanceof TreeItem && !(populated = ((Boolean)(node = (TreeItem)e.item).getData(ExecutionTree.POPULATED)).booleanValue())) {
                    ExecutionTree.this.populateExecutionNodeChildren(node);
                }
            }
        });
        this.executionTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item instanceof TreeItem) {
                    TreeItem treeItem = (TreeItem)((TreeItem)e.item).getData(ExecutionTree.DUPLICATEITEM);
                }
                super.widgetSelected(e);
            }
        });
        if (this.currentAnalyzer.status() == -1) {
            this.executionJob = new JobWithCancelingSupport(searchText){

                protected IStatus runSub(IProgressMonitor monitor) {
                    monitor.beginTask(searchText, -1);
                    ExecutionTree.this.currentAnalyzer.start();
                    monitor.done();
                    IAPlugin.getDefault().taskEnded();
                    return Status.OK_STATUS;
                }

                protected void cancelingSub() {
                    super.canceling();
                    IAPlugin.getDefault().taskEnded();
                    UIUtilities.cancel((Command)ExecutionTree.this.currentAnalyzer);
                    ExecutionTree.this.setTitleLabel(DisplayableData.getDisplayableData((IAdaptable)ExecutionTree.this.currentAnalyzer).getDescription());
                }
            };
            UIUtilities.scheduleWorkbenchPartJob((IWorkbenchPart)this, this.executionJob);
        } else {
            this.processCompletedCommand(true);
        }
        Debug.exit((Logger)logger, (String)ExecutionTree.class.getName(), (String)"execute");
        return this.executionJob;
    }

    private void processCompletedCommand(final boolean isComplete) {
        Debug.enter((Logger)logger, (String)ExecutionTree.class.getName(), (String)"processCompletedCommand", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                Debug.enter((Logger)logger, (String)"ExecutionTree.processCompletedCommand.syncExec.Runnable()", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                ExecutionTree.this.setSearchInProgress(false);
                if (isComplete) {
                    ExecutionTree.this.insertResources(ExecutionTree.this.currentAnalyzer.getResults());
                    for (Object object : ((ExecutionTree)ExecutionTree.this).currentAnalyzer.totalResourcesAnalyzed) {
                        ExecutionTree.this.processResource((ExecutionAnalyzer.ResourceAnalysis)object);
                    }
                    ExecutionTree.this.updateRootTreeItems(false);
                    ExecutionTree.this.executionTreeSearch(ExecutionTree.this.selectedResources, ExecutionTree.this.currentSearch);
                }
                if (!ExecutionTree.this.c.isDisposed()) {
                    ExecutionTree.this.c.setCursor(null);
                }
                ExecutionTree.this.currentAnalyzer.removeListener(ExecutionTree.this.getExecutionAnalyzerListener());
                ExecutionTree.this.sortByVerbsAction.setEnabled(ExecutionTree.this.resourcesTree.getItemCount() > 0);
                Debug.exit((Logger)logger, (String)"ExecutionTree.processCompletedCommand.syncExec.Runnable()", (String)"run");
            }
        });
        Debug.exit((Logger)logger, (String)ExecutionTree.class.getName(), (String)"getExecutionAnalyzerListener");
    }

    private ExecutionAnalyzer.Listener getExecutionAnalyzerListener() {
        if (this.executionAnalyzerListener == null) {
            this.executionAnalyzerListener = new ExecutionAnalyzer.Listener(){

                public void completed() {
                    Debug.enter((Logger)logger, (String)"ExecutionTree.getExecutionAnalyzerListener", (String)"completed", (Object)("Thread ID: " + Thread.currentThread().getId()));
                    ExecutionTree.this.processCompletedCommand(false);
                    Debug.exit((Logger)logger, (String)"ExecutionTree.getExecutionAnalyzerListener", (String)"completed");
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void resourceAnalyzed(ExecutionAnalyzer.ResourceAnalysis aResourceAnalysis) {
                    26 var2_2 = this;
                    synchronized (var2_2) {
                        ExecutionTree.this.analysedResourcesToProcess.add(aResourceAnalysis);
                    }
                }

                public void itemsAdded(final Collection interactions) {
                    ExecutionTree.this.display.syncExec(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Debug.enter((Logger)logger, (String)"ExecutionTree.getExecutionAnalyzerListener.itemsAdded", (String)"syncExec", (Object)("Thread ID: " + Thread.currentThread().getId()));
                            1 var1_1 = this;
                            synchronized (var1_1) {
                                ((ExecutionTree)(this).ExecutionTree.this).currentAnalyzer.totalInteractions.addAll(interactions);
                                ExecutionTree.this.insertResources(interactions);
                                ExecutionTree.this.updateRootTreeItems(false);
                            }
                            Debug.exit((Logger)logger, (String)"ExecutionTree.getExecutionAnalyzerListener.itemsAdded", (String)"syncExec");
                        }
                    });
                }

                public void resourceComplete(final Resource r) {
                    if (!ExecutionTree.this.resourcesCompleted.contains(r)) {
                        ExecutionTree.this.resourcesCompleted.add(r);
                    }
                    ExecutionTree.this.display.syncExec(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            2 var1_1 = this;
                            synchronized (var1_1) {
                                ExecutionTree.this.tryPopulatingWaitingTreeItems(r);
                            }
                        }
                    });
                }
            };
        }
        return this.executionAnalyzerListener;
    }

    private void tryPopulatingWaitingTreeItems(Resource r) {
        List<TreeItem> waitingNodes;
        if (!this.c.isDisposed() && (waitingNodes = this.treeItemsWaitingForModelCompletion.get(r)) != null && !waitingNodes.isEmpty()) {
            for (TreeItem ti : waitingNodes) {
                this.populateExecutionNodeChildren(ti);
            }
            this.treeItemsWaitingForModelCompletion.remove(r);
        }
    }

    private List<TreeItem> getExecutionTreeRoots() {
        Debug.enter((Logger)logger, (String)ExecutionTree.class.getName(), (String)"getExecutionTreeRoots", (Object)("Thread ID: " + Thread.currentThread().getId()));
        ArrayList<TreeItem> roots = null;
        Set<String> regions = this.regionResourceMappedByApplid.keySet();
        if (regions != null && regions.size() > 0) {
            roots = new ArrayList<TreeItem>();
            for (String applid : regions) {
                TreeItem resourceItem = this.getRootTreeItemByApplid(applid);
                if (resourceItem == null) continue;
                roots.add(resourceItem);
            }
        }
        Debug.exit((Logger)logger, (String)ExecutionTree.class.getName(), (String)"getExecutionTreeRoots");
        return roots;
    }

    private TreeItem getRootTreeItemByApplid(String applid) {
        TreeItem regionTreeItem = this.regionTreeItemMappedByApplid.get(applid);
        return this.regionTreeItemMappedtoRootResourceTreeItems.get(regionTreeItem);
    }

    public void populateExecutionTree() {
        List<TreeItem> roots;
        if (!this.c.isDisposed() && (roots = this.getExecutionTreeRoots()) != null) {
            for (TreeItem root : roots) {
                this.populateExecutionTreeBranch(root);
            }
        }
    }

    private void populateExecutionTreeBranch(TreeItem startItem) {
        Debug.enter((Logger)logger, (String)ExecutionTree.class.getName(), (String)"populateExecutionTreeBranch", (Object)("Thread ID: " + Thread.currentThread().getId()));
        ArrayList<TreeItem> populationQueue = new ArrayList<TreeItem>();
        if (!((Boolean)startItem.getData(POPULATED)).booleanValue()) {
            populationQueue.add(startItem);
        } else {
            populationQueue.addAll(Arrays.asList(startItem.getItems()));
        }
        while (!populationQueue.isEmpty()) {
            TreeItem next = (TreeItem)populationQueue.get(0);
            if (!((Boolean)next.getData(POPULATED)).booleanValue()) {
                this.populateExecutionNodeChildren(next);
            }
            if (next.getData("RESOURCE") != null) {
                populationQueue.addAll(Arrays.asList(next.getItems()));
            }
            populationQueue.remove(next);
        }
        Debug.exit((Logger)logger, (String)ExecutionTree.class.getName(), (String)"enclosing_method");
    }

    private void populateExecutionNodeChildren(TreeItem inputItem) {
        TreeItem rootTemp;
        Debug.enter((Logger)logger, (String)ExecutionTree.class.getName(), (String)"populateExecutionNodeChildren", (Object)("Thread ID: " + Thread.currentThread().getId()));
        TreeItem ti = inputItem;
        Resource resourceNode = (Resource)ti.getData("RESOURCE");
        if (resourceNode instanceof Region && (rootTemp = this.regionTreeItemMappedtoRootResourceTreeItems.get(this.regionTreeItemMappedByApplid.get(resourceNode.getName()))) != null) {
            ti = rootTemp;
            resourceNode = (Resource)ti.getData("RESOURCE");
        }
        Region region = (Region)ti.getData("REGION");
        Map<Resource, Map<String, List<Resource>>> resourcesToVerbTargetMaps = null;
        Map verbsToTargets = null;
        if (region != null) {
            resourcesToVerbTargetMaps = this.regionsToResourceToVerbTargetMaps.get(region);
        }
        if (resourcesToVerbTargetMaps != null) {
            verbsToTargets = (Map)resourcesToVerbTargetMaps.get(resourceNode);
        }
        if (this.currentAnalyzer.isResourceCompleted(resourceNode) && verbsToTargets != null) {
            List<TreeItem> parentChain = this.getParentChain(ti);
            this.clearChildTreeItems(ti);
            for (String currentVerb : verbsToTargets.keySet()) {
                List currentResources = (List)verbsToTargets.get(currentVerb);
                for (Resource current : currentResources) {
                    TreeItem child = this.createChildTreeItem(currentVerb, current, ti);
                    TreeItem duplicateItem = this.resourceIsInParentChain(current, parentChain);
                    if (duplicateItem != null) {
                        child.setData(POPULATED, (Object)true);
                        TreeItem loopItem = new TreeItem(child, 0);
                        loopItem.setText(Messages.getString("ExecutionTree.loop"));
                        loopItem.setData(DUPLICATEITEM, (Object)duplicateItem);
                        loopItem.setData(POPULATED, (Object)true);
                        child.setExpanded(true);
                        continue;
                    }
                    child.setData(POPULATED, (Object)false);
                    if (this.currentAnalyzer.isResourceCompleted(current) && !this.resourceHasChildren(current, region)) continue;
                    TreeItem phantomItem = new TreeItem(child, 0);
                    phantomItem.setText(Messages.getString("ExecutionTree.fetching"));
                    phantomItem.setData(POPULATED, (Object)true);
                    child.setExpanded(false);
                }
            }
            ti.setData(POPULATED, (Object)true);
        } else {
            List<TreeItem> waitingNodes = this.treeItemsWaitingForModelCompletion.get(resourceNode);
            if (waitingNodes == null) {
                waitingNodes = new ArrayList<TreeItem>();
                this.treeItemsWaitingForModelCompletion.put(resourceNode, waitingNodes);
            }
            waitingNodes.add(ti);
        }
        Debug.exit((Logger)logger, (String)ExecutionTree.class.getName(), (String)"populateExecutionNodeChildren");
    }

    private boolean resourceHasChildren(Resource input, Region applid) {
        Debug.enter((Logger)logger, (String)ExecutionTree.class.getName(), (String)"resourceHasChildren", (Object)("Thread ID: " + Thread.currentThread().getId()));
        boolean result = false;
        Map<Resource, Map<String, List<Resource>>> resourcesToVerbTargetMaps = this.regionsToResourceToVerbTargetMaps.get(applid);
        Map<String, List<Resource>> verbsToTargets = resourcesToVerbTargetMaps.get(input);
        if (verbsToTargets != null) {
            for (List<Resource> targets : verbsToTargets.values()) {
                if (targets.isEmpty()) continue;
                result = true;
                break;
            }
        }
        Debug.exit((Logger)logger, (String)ExecutionTree.class.getName(), (String)"resourceHasChildren");
        return result;
    }

    private void clearChildTreeItems(TreeItem ti) {
        TreeItem[] children = ti.getItems();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
    }

    private List<TreeItem> getParentChain(TreeItem leaf) {
        TreeItem parentItem = leaf.getParentItem();
        List<Object> parentChain = parentItem != null ? this.getParentChain(leaf.getParentItem()) : new ArrayList();
        parentChain.add(leaf);
        return parentChain;
    }

    private TreeItem resourceIsInParentChain(Resource resource, List<TreeItem> parentChain) {
        Debug.enter((Logger)logger, (String)ExecutionTree.class.getName(), (String)"resourceIsInParentChain", (Object)("Thread ID: " + Thread.currentThread().getId()));
        TreeItem result = null;
        List<TreeItem> items = this.resourceToItems.get(resource);
        if (items != null && parentChain != null && !items.isEmpty()) {
            for (TreeItem current : items) {
                if (!parentChain.contains(current)) continue;
                result = current;
                break;
            }
        }
        Debug.exit((Logger)logger, (String)ExecutionTree.class.getName(), (String)"resourceIsInParentChain");
        return result;
    }

    private TreeItem createChildTreeItem(String verbName, Resource node, TreeItem parent) {
        List<TreeItem> items;
        Program initial;
        Debug.enter((Logger)logger, (String)ExecutionTree.class.getName(), (String)"createChildTreeItem", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String verb = verbName == null ? BLANK : Messages.getVerb(verbName);
        Region region = (Region)parent.getData("REGION");
        TreeItem childItem = new TreeItem(parent, 0);
        childItem.setData("RESOURCE", (Object)node);
        childItem.setData("REGION", (Object)region);
        childItem.setText(String.valueOf(verb) + " " + ResourceRenderer.asText(node));
        childItem.setImage(ResourceRenderer.getOverLaidImage(ResourceRenderer.asImage(node), false, false, node.isEventable()));
        Resource aResource = (Resource)parent.getData("RESOURCE");
        if (aResource instanceof Transaction && node instanceof Program && (initial = ((Transaction)aResource).getFirstProgram(region)) != null && initial.equals((Object)node)) {
            childItem.setText(ResourceRenderer.asText(node));
        }
        if ((items = this.resourceToItems.get(node)) == null) {
            items = new ArrayList<TreeItem>();
            this.resourceToItems.put(node, items);
        }
        items.add(childItem);
        Debug.exit((Logger)logger, (String)ExecutionTree.class.getName(), (String)"createChildTreeItem");
        return childItem;
    }

    private void processResource(ExecutionAnalyzer.ResourceAnalysis resourceAnalysis) {
        Debug.enter((Logger)logger, (String)ExecutionTree.class.getName(), (String)"processResource", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Resource aResource = resourceAnalysis.resource;
        String verbName = resourceAnalysis.verb;
        ArrayList resources = resourceAnalysis.resources == null ? new ArrayList() : new ArrayList(resourceAnalysis.resources);
        ArrayList<String> ignoredVerbs = new ArrayList<String>();
        ignoredVerbs.add("LOAD");
        if (!ignoredVerbs.contains(verbName)) {
            List<Resource> resourcesPerVerb;
            Map<String, List<Resource>> verbToUsedResources;
            int depth = resourceAnalysis.depth;
            Map<Resource, Map<String, List<Resource>>> resourcesToVerbTargetMaps = this.regionsToResourceToVerbTargetMaps.get(resourceAnalysis.region);
            if (resourcesToVerbTargetMaps == null) {
                resourcesToVerbTargetMaps = new HashMap<Resource, Map<String, List<Resource>>>();
                this.regionsToResourceToVerbTargetMaps.put(resourceAnalysis.region, resourcesToVerbTargetMaps);
            }
            if ((verbToUsedResources = resourcesToVerbTargetMaps.get(aResource)) == null) {
                verbToUsedResources = new HashMap<String, List<Resource>>();
                resourcesToVerbTargetMaps.put(aResource, verbToUsedResources);
            }
            if ((resourcesPerVerb = verbToUsedResources.get(verbName)) == null) {
                verbToUsedResources.put(verbName, resources);
            } else {
                this.addUniqueEntriesToCollection(resourcesPerVerb, resources);
            }
        }
        Debug.exit((Logger)logger, (String)ExecutionTree.class.getName(), (String)"processResource");
    }

    private void addUniqueEntriesToCollection(Collection master, Collection additions) {
        for (Object o : additions) {
            if (master.contains(o)) continue;
            master.add(o);
        }
    }

    private TreeItem getTypeItem(String type) {
        Debug.enter((Logger)logger, (String)ExecutionTree.class.getName(), (String)"getTypeItem", (Object)("Thread ID: " + Thread.currentThread().getId()));
        TreeItem typeItem = (TreeItem)this.itemsMap.get(type);
        if (typeItem == null) {
            typeItem = new TreeItem(this.resourcesTree, 0);
            typeItem.setText(ResourceTypeRenderer.asText(type));
            typeItem.setImage(ResourceTypeRenderer.asImage(type));
            this.itemsMap.put(type, typeItem);
        }
        Debug.exit((Logger)logger, (String)ExecutionTree.class.getName(), (String)"getTypeItem");
        return typeItem;
    }

    private Map getMapChildren(TreeItem treeItem, String dataKey) {
        Debug.enter((Logger)logger, (String)ExecutionTree.class.getName(), (String)"getMapChildren", (Object)("Thread ID: " + Thread.currentThread().getId()));
        HashMap mapChildren = (HashMap)treeItem.getData(dataKey);
        if (mapChildren == null) {
            mapChildren = new HashMap();
            treeItem.setData(dataKey, mapChildren);
        }
        Debug.exit((Logger)logger, (String)ExecutionTree.class.getName(), (String)"getMapChildren");
        return mapChildren;
    }

    private synchronized void insertResources(Collection interactions) {
        Debug.enter((Logger)logger, (String)ExecutionTree.class.getName(), (String)"insertResources", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (!this.c.isDisposed()) {
            Map.Entry o2;
            Iterator iterator;
            TreeItem typeItem;
            String type;
            Map.Entry o1;
            Iterator iterator2;
            if (this.sortByResource) {
                iterator2 = Interaction.getTargetsAndVerbsAndSourcesByType((Collection)interactions).entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry targetAndVerbsByType = o1 = iterator2.next();
                    type = (String)targetAndVerbsByType.getKey();
                    typeItem = this.getTypeItem(type);
                    Map targetChildren = this.getMapChildren(typeItem, TARGET_CHILDREN);
                    iterator = ((Map)targetAndVerbsByType.getValue()).entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry targetAndVerbs = o2 = iterator.next();
                        Resource target = (Resource)targetAndVerbs.getKey();
                        Map targets = (Map)targetAndVerbs.getValue();
                        TreeItem targetItem = (TreeItem)targetChildren.get(target);
                        if (targetItem == null) {
                            boolean eventable = target.isEventable();
                            targetItem = UIUtilities.createEBCDICSortedTreeItem(typeItem, ResourceRenderer.asText(target), ResourceRenderer.getOverLaidImage(ResourceRenderer.asImage(target), false, false, eventable));
                            targetChildren.put(target, targetItem);
                            targetItem.setData("RESOURCE", (Object)target);
                        }
                        Map verbs = this.getMapChildren(targetItem, VERBS_LIST);
                        for (Map.Entry o3 : targets.entrySet()) {
                            Map.Entry entry = o3;
                            Verb verb = (Verb)entry.getKey();
                            TreeItem verbItem = (TreeItem)verbs.get(verb);
                            if (verbItem == null) {
                                String verbName = verb.getName().trim();
                                if (verbName.isEmpty()) {
                                    verbName = "INIT";
                                }
                                String appendixText = BLANK;
                                if (this.currentAnalyzer.getRegion() != null && verb.getRemoteName() != null && verb.getRemoteSysid() != null) {
                                    appendixText = " (" + verb.getRemoteName() + ", " + verb.getRemoteSysid() + ")";
                                }
                                verbItem = UIUtilities.createEBCDICSortedTreeItem(targetItem, String.valueOf(verbName) + appendixText, ImageFactory.getVerbImage());
                                verbItem.setData(VERB, (Object)verb);
                                verbItem.setData(SOURCES, entry.getValue());
                                verbs.put(verb, verbItem);
                                continue;
                            }
                            List sources = (List)verbItem.getData(SOURCES);
                            Collection newValues = (Collection)entry.getValue();
                            for (Object o4 : newValues) {
                                Resource current = (Resource)o4;
                                if (sources.contains(current)) continue;
                                sources.add(current);
                            }
                        }
                    }
                }
            } else {
                iterator2 = Interaction.getVerbsAndTargetsAndSourcesByType((Collection)interactions).entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry verbAndTargetsByType = o1 = iterator2.next();
                    type = (String)verbAndTargetsByType.getKey();
                    typeItem = this.getTypeItem(type);
                    Map verbChildren = this.getMapChildren(typeItem, VERB_CHILDREN);
                    iterator = ((Map)verbAndTargetsByType.getValue()).entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry verbAndTargets = o2 = iterator.next();
                        Verb verb = (Verb)verbAndTargets.getKey();
                        String verbName = verb.getName().trim();
                        Map targets = (Map)verbAndTargets.getValue();
                        TreeItem verbItem = (TreeItem)verbChildren.get(verb.getName());
                        if (verbItem == null) {
                            if (verbName.isEmpty()) {
                                verbName = "INIT";
                            }
                            verbItem = new TreeItem(typeItem, 0);
                            verbChildren.put(verb.getName(), verbItem);
                            String appendixText = BLANK;
                            if (this.currentAnalyzer.getRegion() != null && verb.getRemoteName() != null && verb.getRemoteSysid() != null) {
                                appendixText = " (" + verb.getRemoteName() + ", " + verb.getRemoteSysid() + ")";
                            }
                            verbItem.setText(String.valueOf(verbName) + appendixText);
                            verbItem.setImage(ImageFactory.getVerbImage());
                            verbItem.setData(VERB, (Object)verb);
                            verbItem.setData((Object)verb);
                        }
                        Map resources = this.getMapChildren(verbItem, RESOURCES_LIST);
                        for (Map.Entry o3 : targets.entrySet()) {
                            Map.Entry entry = o3;
                            Object target = entry.getKey();
                            TreeItem resourceItem = (TreeItem)resources.get(target);
                            if (resourceItem == null) {
                                resourceItem = new TreeItem(verbItem, 0);
                                resourceItem.setImage(ResourceRenderer.asImage(target));
                                resourceItem.setText(ResourceRenderer.asText((Resource)target));
                                resourceItem.setData("RESOURCE", target);
                                resourceItem.setData(SOURCES, entry.getValue());
                                resources.put(target, resourceItem);
                                continue;
                            }
                            List sources = (List)resourceItem.getData(SOURCES);
                            sources.addAll((Collection)entry.getValue());
                        }
                    }
                }
            }
            HashSet<Region> searchedRegions = new HashSet<Region>();
            ArrayList copyOfResourcesAnalyzed = (ArrayList)((ArrayList)this.analysedResourcesToProcess).clone();
            try {
                for (ExecutionAnalyzer.ResourceAnalysis resourceAnalysis : copyOfResourcesAnalyzed) {
                    if (this.clearedResourcesAnalyzed.contains(resourceAnalysis)) continue;
                    this.clearedResourcesAnalyzed.add(resourceAnalysis);
                    this.analysedResourcesToProcess.remove(resourceAnalysis);
                    this.processResource(resourceAnalysis);
                    if (resourceAnalysis.region == null) continue;
                    searchedRegions.add(resourceAnalysis.region);
                }
                for (Region found : searchedRegions) {
                    TreeItem root = this.regionTreeItemMappedtoRootResourceTreeItems.get(found);
                    if (root == null || ((Boolean)root.getData(POPULATED)).booleanValue()) continue;
                    this.populateExecutionNodeChildren(root);
                    root.setExpanded(true);
                }
            }
            catch (Exception e) {
                Debug.warning((Logger)logger, (String)ExecutionTree.class.getName(), (String)"insertResources", (Throwable)e, new HashMap());
                IAPlugin.getDefault().logError("error processing resources", (Throwable)e);
            }
        }
        Debug.exit((Logger)logger, (String)ExecutionTree.class.getName(), (String)"insertResources");
    }

    private void updateRootTreeItems(boolean isComplete) {
        Debug.enter((Logger)logger, (String)ExecutionTree.class.getName(), (String)"updateRootTreeItems", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (!this.c.isDisposed()) {
            int totalResources = 0;
            TreeItem[] typeItems = this.resourcesTree.getItems();
            int i = 0;
            while (i < typeItems.length) {
                int resourceCountForType = 0;
                TreeItem[] childItems = typeItems[i].getItems();
                List<Object> resources = new ArrayList();
                int j = 0;
                while (j < childItems.length) {
                    String childText = this.getItemText(childItems[j]);
                    if (this.sortByResource) {
                        resources.add(childItems[j].getData("RESOURCE"));
                    } else {
                        TreeItem[] resourceItems = childItems[j].getItems();
                        int k = 0;
                        while (k < resourceItems.length) {
                            resources.add(resourceItems[k].getData("RESOURCE"));
                            ++k;
                        }
                    }
                    childItems[j].setText(String.valueOf(childText) + " (" + childItems[j].getItemCount() + ")");
                    ++j;
                }
                resources = IAUtilities.asUniqueCollection(resources);
                totalResources += resources.size();
                String itemText = this.getItemText(typeItems[i]);
                typeItems[i].setText(String.valueOf(itemText) + "  (" + (resourceCountForType += resources.size()) + ")");
                ++i;
            }
            this.totalsLabel.setText("(" + totalResources + ")");
            this.totalsLabel.getParent().layout();
        }
        Debug.exit((Logger)logger, (String)ExecutionTree.class.getName(), (String)"updateRootTreeItems");
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"init", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (DEFAULT_EDITOR_INPUT != input) {
            throw new PartInitException("Invalid Input: Must be ExecutionTree.DEFAULT_EDITOR_INPUT");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"init");
    }

    private ConnectionServiceListener getConnectionServiceListener() {
        return new ConnectionServiceListener(){

            public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
                if ("com.ibm.cics.ia.connection.db2".equals(event.getConnectionCategoryId())) {
                    if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                        this.connected();
                    } else if (event instanceof ConnectionServiceListener.DisconnectedEvent) {
                        this.disconnected();
                    } else if (event instanceof ConnectionServiceListener.ExceptionEvent) {
                        this.exception();
                    }
                }
            }

            public void connected() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ISelectionProvider provider;
                        ExecutionTree.this.clear();
                        IWorkbenchPartSite site = ExecutionTree.this.getSite();
                        if (site != null && (provider = site.getSelectionProvider()) != null) {
                            provider.setSelection((ISelection)StructuredSelection.EMPTY);
                        }
                    }
                });
            }

            public void disconnected() {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ISelectionProvider provider;
                        ExecutionTree.this.currentAnalyzer.clear();
                        ExecutionTree.this.commandHistoryManager.clear();
                        ExecutionTree.this.clear();
                        IWorkbenchPartSite site = ExecutionTree.this.getSite();
                        if (site != null && (provider = site.getSelectionProvider()) != null) {
                            provider.setSelection((ISelection)StructuredSelection.EMPTY);
                        }
                    }
                });
            }

            public void exception() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ExecutionTree.this.currentAnalyzer != null) {
                            if (ExecutionTree.this.currentAnalyzer.status() != 1) {
                                ExecutionTree.this.currentAnalyzer.cancel();
                            }
                            ExecutionTree.this.currentAnalyzer.removeListener(ExecutionTree.this.getExecutionAnalyzerListener());
                        }
                    }
                });
            }
        };
    }

    private void rerun() {
        if (this.c != null && !this.c.isDisposed()) {
            this.c.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ExecutionTree.this.currentAnalyzer != null) {
                        Resource resource = ExecutionTree.this.currentAnalyzer.getRoot();
                        Region region = ExecutionTree.this.currentAnalyzer.getRegion();
                        ExecutionTree.this.currentAnalyzer.reset(resource, region);
                        ExecutionTree.this.execute(ExecutionTree.this.currentAnalyzer);
                    }
                }
            });
        }
    }

    private String getItemText(TreeItem aTreeItem) {
        String itemText = (String)aTreeItem.getData(TEXT);
        if (itemText == null) {
            itemText = aTreeItem.getText();
            aTreeItem.setData(TEXT, (Object)itemText);
        }
        return itemText;
    }

    public void setFocus() {
        this.sashForm.setFocus();
    }

    public String getPartProperty(String key) {
        if (IConnectionCategory.class.getName().equals(key)) {
            return "com.ibm.cics.ia.connection.db2";
        }
        return super.getPartProperty(key);
    }

    public void dispose() {
        Debug.enter((Logger)logger, (String)ExecutionTree.class.getName(), (String)"dispose", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.connectionServiceListener != null) {
            this.connectionServiceListener.makeStale();
        }
        super.dispose();
        Debug.exit((Logger)logger, (String)ExecutionTree.class.getName(), (String)"dispose");
    }

    private void doCopy() {
        Clipboard clipboard = new Clipboard(this.display);
        StringBuffer result = new StringBuffer();
        String columnNames = BLANK;
        columnNames = this.sortByResource ? "Resource,Verb," : "Verb,Resource,";
        TreeItem[] typeItems = this.resourcesTree.getItems();
        int i = 0;
        while (i < typeItems.length) {
            TreeItem[] level1 = typeItems[i].getItems();
            int j = 0;
            while (j < level1.length) {
                TreeItem[] level2 = level1[j].getItems();
                int k = 0;
                while (k < level2.length) {
                    result.append(String.valueOf((String)typeItems[i].getData(TEXT)) + ",");
                    if (this.sortByResource) {
                        result.append(String.valueOf((String)level1[j].getData(TEXT)) + ",");
                    } else {
                        result.append(String.valueOf((String)level1[j].getData(VERB)) + ",");
                    }
                    result.append(String.valueOf(level2[k].getText()) + ",");
                    result.append(IAUtilities.LINE_SEPARATOR);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        StringBuffer treeResult = new StringBuffer(String.valueOf(IAUtilities.LINE_SEPARATOR) + IAUtilities.LINE_SEPARATOR + "Execution Tree" + IAUtilities.LINE_SEPARATOR);
        for (String line : CSVUtils.createCSV(this.executionTree, "RESOURCE")) {
            treeResult.append(String.valueOf(line) + IAUtilities.LINE_SEPARATOR);
        }
        clipboard.setContents(new Object[]{"Type," + columnNames + IAUtilities.LINE_SEPARATOR + result + treeResult}, new Transfer[]{TextTransfer.getInstance()});
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public String getTitleToolTip() {
        return this.getTitle();
    }
}

