/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.ia.model.EntryPointTreeItem;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.Messages;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class EntryPointsTreeByAppWithDepLabelProvider
extends LabelProvider
implements ITableColorProvider,
ITableLabelProvider {
    protected static final Color ERROR_COLOR = new Color((Device)Display.getDefault(), 255, 170, 170);
    protected static final Color DISABLED_COLOR = Display.getDefault().getSystemColor(22);
    private final Image enabledAndCheckedCheckboxImage = ImageFactory.getEnabledAndCheckedCheckboxImage();
    private final Image enabledAndUncheckedCheckboxImage = ImageFactory.getEnabledAndUncheckedCheckboxImage();
    private final Image disabledAndCheckedCheckboxImage = ImageFactory.getDisabledAndCheckedCheckboxImage();
    private final Image disabledAndUncheckedCheckboxImage = ImageFactory.getDisabledAndUncheckedCheckboxImage();

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public Color getForeground(Object element, int columnIndex) {
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return null;
        }
        EntryPointTreeItem entryPointTreeItem = (EntryPointTreeItem)element;
        if (entryPointTreeItem.isEnabled() && entryPointTreeItem.isSelected() && entryPointTreeItem.getError() != null) {
            return ERROR_COLOR;
        }
        if (!entryPointTreeItem.getEntryPoint().isEnabled() && entryPointTreeItem.getChildren().isEmpty()) {
            return DISABLED_COLOR;
        }
        return null;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return columnIndex == 0 ? this.getCheckboxImage((EntryPointTreeItem)element) : null;
    }

    public String getColumnText(Object element, int columnIndex) {
        EntryPointTreeItem item = (EntryPointTreeItem)element;
        String styledString = null;
        switch (columnIndex) {
            case 0: {
                return null;
            }
            case 1: {
                if (item.getParent() == null) {
                    return item.getCollectionID();
                }
                return "";
            }
            case 2: {
                if (!item.getChildren().isEmpty()) {
                    return item.getPlatform();
                }
                return "";
            }
            case 3: {
                if (!item.getChildren().isEmpty()) {
                    return item.getApplication();
                }
                return "";
            }
            case 4: {
                if (!item.getChildren().isEmpty()) {
                    return item.getOperation();
                }
                return "";
            }
            case 5: {
                if (!item.getName().equals("")) {
                    if (item.getIsDependency()) {
                        return Messages.getString("ApplicationCreationWizard.table.column.entryType.dependency");
                    }
                    return Messages.getString("ApplicationCreationWizard.table.column.entryType.entryPoint");
                }
                if (!item.getType().equals("")) {
                    return Messages.getString("ApplicationCreationWizard.table.column.entryType.dependency");
                }
            }
            case 6: {
                return item.getName();
            }
            case 7: {
                return item.getType();
            }
            case 8: {
                return item.getRegion();
            }
            case 9: {
                return item.getApplOperation();
            }
            case 10: {
                return item.getObject();
            }
        }
        return styledString;
    }

    private Image getCheckboxImage(EntryPointTreeItem entryPoint) {
        if (entryPoint.isEnabled()) {
            if (entryPoint.isSelected()) {
                return this.enabledAndCheckedCheckboxImage;
            }
            return this.enabledAndUncheckedCheckboxImage;
        }
        if (entryPoint.isSelected()) {
            return this.disabledAndCheckedCheckboxImage;
        }
        return this.disabledAndUncheckedCheckboxImage;
    }
}

