/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.EntryPointTreeItem;
import com.ibm.cics.ia.ui.AdvancedWizardPage;
import com.ibm.cics.ia.ui.CiuspdepPresenter;
import com.ibm.cics.ia.ui.EntryPointContentProvider;
import com.ibm.cics.ia.ui.EntryPointsPresenter;
import com.ibm.cics.ia.ui.EntryPointsTreeByRegionLabelProvider;
import com.ibm.cics.ia.ui.EntryPointsTreeUtilities;
import com.ibm.cics.ia.ui.EntryPointsView;
import com.ibm.cics.ia.ui.Messages;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.TreeViewerFocusCellManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;

public class EntryPointsPage
extends AdvancedWizardPage {
    private static final Logger logger = Logger.getLogger(EntryPointsPage.class.getPackage().getName());
    protected Composite container;
    private Label combo1Label;
    private String combo1LabelText;
    private Combo combo1;
    protected Label cicsTsLevelLabel;
    protected Combo cicsTsLevel;
    protected Label projectsLabel;
    protected Combo projects;
    protected TreeViewer viewer;
    protected Tree tree;
    protected Combo treeTypes;
    protected EntryPointsPresenter presenter;
    protected List<EntryPointTreeItem> cachedTreeItems;

    public EntryPointsPage() {
        super("CicsBundleResourcesPage");
        this.setTitle(Messages.getString("ApplicationCreationWizard.entryPointsPage.title"));
        this.setDescription(Messages.getString("ApplicationCreationWizard.entryPointsPage.description"));
        this.combo1LabelText = "";
        this.cachedTreeItems = new ArrayList<EntryPointTreeItem>();
    }

    public void setCombo1Label(String text) {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"setCombo1Label", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.combo1Label == null || this.combo1Label.isDisposed()) {
            this.combo1LabelText = text;
        } else {
            this.combo1Label.setText(text);
            this.container.layout();
        }
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"setCombo1Label");
    }

    public void createControl(Composite parent) {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"createControl", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.presenter = ((EntryPointsView)this.getWizard()).getPresenter();
        this.container = new Composite(parent, 4);
        this.setControl((Control)this.container);
        GridLayout layout = new GridLayout(6, false);
        this.container.setLayout((Layout)layout);
        this.combo1Label = new Label(this.container, 0);
        this.combo1Label.setText(this.combo1LabelText);
        this.combo1 = new Combo(this.container, 8);
        this.combo1.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EntryPointsPage.this.presenter.combo1Selected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.cicsTsLevelLabel = new Label(this.container, 0);
        GridData gridData = new GridData(131072, 0x1000000, false, false, 1, 1);
        gridData.horizontalIndent = 30;
        this.cicsTsLevelLabel.setLayoutData((Object)gridData);
        this.cicsTsLevelLabel.setText(Messages.getString("ApplicationCreationWizard.cicsLevel"));
        this.createCicsTsLevelCombo();
        this.createCommonControls(2);
        new Label(this.container, 0);
        new Label(this.container, 0);
        new Label(this.container, 0);
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"createControl");
    }

    protected void createCicsTsLevelCombo() {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"createCicsTsLevelCombo", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.cicsTsLevel = new Combo(this.container, 8);
        this.cicsTsLevel.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EntryPointsPage.this.presenter.cicsTsLevelSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"createCicsTsLevelCombo");
    }

    protected void createCommonControls(int selectAllButtonHorizontalSpan) {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"createCommonControls", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.projectsLabel = new Label(this.container, 0);
        this.projectsLabel.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        this.projectsLabel.setText(Messages.getString("ApplicationCreationWizard.selectProject"));
        this.projects = new Combo(this.container, 8);
        GridData gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
        GC gc = new GC((Drawable)Display.getDefault());
        gridData.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)11);
        this.projects.setLayoutData((Object)gridData);
        this.projects.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EntryPointsPage.this.presenter.projectSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label treeTypeLabel = new Label(this.container, 0);
        treeTypeLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        treeTypeLabel.setText(Messages.getString("ApplicationCreationWizard.selectTreeType"));
        gridData = new GridData(16384, 0x1000000, false, false, 3, 1);
        this.treeTypes = new Combo(this.container, 8);
        this.treeTypes.setLayoutData((Object)gridData);
        if (this.presenter instanceof CiuspdepPresenter) {
            this.treeTypes.setItems(new String[]{EntryPointsTreeUtilities.TreeTypes.ByRegion.toString(), EntryPointsTreeUtilities.TreeTypes.ByApp.toString()});
        } else {
            this.treeTypes.setItems(new String[]{EntryPointsTreeUtilities.TreeTypes.ByRegion.toString(), EntryPointsTreeUtilities.TreeTypes.ByApp.toString(), EntryPointsTreeUtilities.TreeTypes.ByAppWithDep.toString()});
        }
        this.treeTypes.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EntryPointsPage.this.presenter.treeTypeSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.treeTypes.select(0);
        this.viewer = new TreeViewer(this.container, 68356);
        this.viewer.setUseHashlookup(true);
        this.viewer.setContentProvider((IContentProvider)new EntryPointContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new EntryPointsTreeByRegionLabelProvider());
        this.tree = this.viewer.getTree();
        this.tree.setLayoutData((Object)new GridData(4, 4, true, true, 6, 1));
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(true);
        Button btnSelectAll = new Button(this.container, 0);
        btnSelectAll.setLayoutData((Object)new GridData(4, 0x1000000, false, false, selectAllButtonHorizontalSpan, 1));
        btnSelectAll.setText(Messages.getString("ApplicationCreationWizard.selectAll"));
        btnSelectAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EntryPointsPage.this.presenter.onSelectAll();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button btnDeselectAll = new Button(this.container, 0);
        btnDeselectAll.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnDeselectAll.setText(Messages.getString("ApplicationCreationWizard.deselectAll"));
        btnDeselectAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EntryPointsPage.this.presenter.onDeselectAll();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"createCommonControls");
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.viewer.setLabelProvider(labelProvider);
    }

    public void setProjectComboContents(String[] items) {
        this.projects.setItems(items);
        this.container.layout();
    }

    public void setCicsTsLevelComboContents(String[] items) {
        this.cicsTsLevel.setItems(items);
        this.cicsTsLevel.pack();
    }

    public void setCombo1Items(String[] items) {
        this.combo1.setItems(items);
        this.container.layout();
    }

    public String getSelectedProject() {
        return EntryPointsPage.getSelectedComboItemText(this.projects);
    }

    public int getSelectedProjectComboIndex() {
        return this.projects.getSelectionIndex();
    }

    public String getTreeType() {
        return this.treeTypes.getItem(this.treeTypes.getSelectionIndex());
    }

    public TreeViewer getTreeViewer() {
        return this.viewer;
    }

    public String getSelectedCombo1Item() {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"getSelectedCombo1Item", (Object)("Thread ID: " + Thread.currentThread().getId()));
        int index = this.combo1.getSelectionIndex();
        if (index >= 0) {
            Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"getSelectedCombo1Item");
            return this.combo1.getItem(index);
        }
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"getSelectedCombo1Item");
        return null;
    }

    public void setProjectComboEnabled(boolean enabled) {
        this.projects.setEnabled(enabled);
    }

    public void addVerifyListener(int columnIndex, VerifyListener listener) {
        ((Text)this.viewer.getCellEditors()[columnIndex].getControl()).addVerifyListener(listener);
    }

    public void initTable(String[] columnNames, Map<Integer, ICellEditorValidator> validators, Map<Integer, ICellEditorListener> listeners, Object input) {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"initTable", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.removeColumns();
        this.viewer.setColumnProperties(columnNames);
        String[] stringArray = columnNames;
        int n = columnNames.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            TreeColumn col = new TreeColumn(this.tree, 16384);
            col.setText(columnName);
            ++n2;
        }
        List<EntryPointTreeItem> inputTreeList = EntryPointsTreeUtilities.prepareTreeInput(input, this.treeTypes.getItem(this.treeTypes.getSelectionIndex()));
        this.viewer.setInput(inputTreeList);
        this.cachedTreeItems = new ArrayList<EntryPointTreeItem>(inputTreeList);
        if (!this.getTreeType().equals(EntryPointsTreeUtilities.TreeTypes.ByAppWithDep.toString()) && !(this.presenter instanceof CiuspdepPresenter)) {
            int i = 0;
            while (i < this.cachedTreeItems.size()) {
                if (this.cachedTreeItems.get(i).getIsDependency()) {
                    this.cachedTreeItems.remove(i);
                    --i;
                }
                ++i;
            }
        }
        CellEditor[] editors = new CellEditor[columnNames.length];
        editors[0] = new CheckboxCellEditor((Composite)this.tree);
        if (validators != null) {
            for (Map.Entry entry : validators.entrySet()) {
                TextCellEditor textEditor = new TextCellEditor((Composite)this.tree);
                textEditor.setValidator((ICellEditorValidator)entry.getValue());
                textEditor.addListener(listeners.get(entry.getKey()));
                editors[((Integer)entry.getKey()).intValue()] = textEditor;
            }
        }
        this.viewer.setCellEditors(editors);
        TreeViewerFocusCellManager treeViewerFocusCellManager = new TreeViewerFocusCellManager(this.viewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.viewer));
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 2 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        TreeViewerEditor.create((TreeViewer)this.viewer, (SWTFocusCellManager)treeViewerFocusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EntryPointsPage.this.presenter.onRowSelection();
            }
        });
        this.viewer.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                TreeColumn[] treeColumnArray = EntryPointsPage.this.tree.getColumns();
                int n = treeColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeColumn column = treeColumnArray[n2];
                    column.pack();
                    ++n2;
                }
            }

            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        this.refresh();
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"initTable");
    }

    public ISelection getSelectedRow() {
        return this.viewer.getSelection();
    }

    public void setCellModifier(ICellModifier cellModifier) {
        this.viewer.setCellModifier(cellModifier);
    }

    private void refresh() {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"refresh", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.viewer.setInput(this.cachedTreeItems);
        this.viewer.expandAll();
        TreeColumn[] treeColumnArray = this.tree.getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            column.pack();
            ++n2;
        }
        this.viewer.refresh();
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"refresh");
    }

    private void removeColumns() {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"removeColumns", (Object)("Thread ID: " + Thread.currentThread().getId()));
        while (this.tree.getColumnCount() > 0) {
            this.tree.getColumn(this.tree.getColumnCount() - 1).dispose();
        }
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"removeColumns");
    }

    @Override
    public void nextPressed() {
    }

    public void selectProjectComboItem(String name) {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"selectProjectComboItem", (Object)("Thread ID: " + Thread.currentThread().getId()));
        int i = 0;
        while (i < this.projects.getItems().length) {
            if (this.projects.getItems()[i].equals(name)) {
                this.projects.select(i);
                this.setProjectComboToolTip(name);
                Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"selectProjectComboItem");
                return;
            }
            ++i;
        }
        this.projects.deselectAll();
        this.setProjectComboToolTip(null);
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"selectProjectComboItem");
    }

    public void setProjectComboToolTip(String toolTip) {
        this.projects.setToolTipText(toolTip);
    }

    public void refreshTable() {
        this.refresh();
        this.viewer.expandAll();
        TreeColumn[] treeColumnArray = this.tree.getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            column.pack();
            ++n2;
        }
        this.viewer.refresh();
    }

    public void updateElem(Object data, String[] properties) {
        this.viewer.update(data, properties);
        if (data instanceof EntryPointTreeItem) {
            EntryPointTreeItem entryPointTreeItem = (EntryPointTreeItem)data;
        }
        this.viewer.expandAll();
        TreeColumn[] treeColumnArray = this.tree.getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            column.pack();
            ++n2;
        }
        this.viewer.refresh();
    }

    public void setInput(Object input) {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"setInput", (Object)("Thread ID: " + Thread.currentThread().getId()));
        List<EntryPointTreeItem> inputTreeList = EntryPointsTreeUtilities.prepareTreeInput(input, this.treeTypes.getItem(this.treeTypes.getSelectionIndex()));
        this.cachedTreeItems = new ArrayList<EntryPointTreeItem>(inputTreeList);
        if (!this.getTreeType().equals(EntryPointsTreeUtilities.TreeTypes.ByAppWithDep.toString()) && !(this.presenter instanceof CiuspdepPresenter)) {
            int i = 0;
            while (i < this.cachedTreeItems.size()) {
                if (this.cachedTreeItems.get(i).getIsDependency()) {
                    this.cachedTreeItems.remove(i);
                    --i;
                }
                ++i;
            }
        }
        this.viewer.setInput(this.cachedTreeItems);
        this.viewer.expandAll();
        TreeColumn[] treeColumnArray = this.tree.getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            column.pack();
            ++n2;
        }
        this.viewer.refresh();
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"setInput");
    }

    public String getSelectedCicsTsLevel() {
        return EntryPointsPage.getSelectedComboItemText(this.cicsTsLevel);
    }

    private static String getSelectedComboItemText(Combo combo) {
        Debug.enter((Logger)logger, (String)EntryPointsPage.class.getName(), (String)"getSelectedComboItemText", (Object)("Thread ID: " + Thread.currentThread().getId()));
        int index = combo.getSelectionIndex();
        if (index >= 0) {
            Debug.exit((Logger)logger, (String)EntryPointsPage.class.getName(), (String)"getSelectedComboItemText");
            return combo.getItem(index);
        }
        Debug.exit((Logger)logger, (String)EntryPointsPage.class.getName(), (String)"getSelectedComboItemText");
        return null;
    }

    public void setCicsTsLevel(int i) {
        this.cicsTsLevel.select(i);
    }

    public void setHelpContextId(String helpContextId) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), helpContextId);
    }
}

