/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.Clause;
import com.ibm.cics.dbfunc.model.ClauseGroup;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.ConstraintElement;
import com.ibm.cics.dbfunc.model.Direction;
import com.ibm.cics.dbfunc.model.OrderBy;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.eclipse.common.editor.EditorHelper;
import com.ibm.cics.eclipse.common.ui.TextInput;
import com.ibm.cics.ia.query.ClauseToStringHelper;
import com.ibm.cics.ia.query.SQLDefinitions;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.LabelProviderFactory;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.QueryManager;
import com.ibm.cics.ia.ui.UIUtilities;
import com.ibm.cics.ia.ui.composites.ExpressionComposite;
import com.ibm.cics.ia.ui.composites.ExpressionCompositeFactory;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public abstract class EditQueryDialog
extends TitleAreaDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(EditQueryDialog.class.getPackage().getName());
    private final Presentation presentation;
    protected boolean isNew = false;
    private final IContainer container;
    private Table expressionsTable;
    private Text nameText;
    private Group valueComposite;
    private StackLayout expressionsStack;
    private ExpressionCompositeFactory expressionCompositeFactory;
    private ExpressionComposite.Listener expressionCompositeListener;
    private ExpressionComposite expressionComposite;
    private TableItem currentTableItem;
    private ToolItem deleteToolItem;
    private String oldName;
    private String queryTableName;
    private Tree groupTree;
    private ToolItem deleteGroupToolItem;
    private ToolItem downGroupToolItem;
    private ToolItem upGroupToolItem;
    protected String type;
    protected boolean compositeError;
    private boolean inError;
    protected String compositeErrorMessage;
    private String errorMessage;

    protected EditQueryDialog(Shell parentShell, Presentation presentationObject, IContainer queryFolderOnDisc, String queryType) {
        super(parentShell);
        Debug.enter((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"EditQueryDialog", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x10 | 0x100000);
        this.type = queryType;
        if (this.type.equals("com.ibm.cics.query.type.cics")) {
            this.queryTableName = IAUtilities.getCICSDataTableName();
        } else if (this.type.equals("com.ibm.cics.query.type.scanner")) {
            this.queryTableName = IAUtilities.getScannerTableName();
        } else if (this.type.equals("com.ibm.cics.query.type.affinity")) {
            this.queryTableName = IAUtilities.getAffinityViewTableName();
        } else if (this.type.equals("com.ibm.cics.query.type.db2")) {
            this.queryTableName = IAUtilities.getDB2DataTableName();
        } else if (this.type.equals("com.ibm.cics.query.type.ims")) {
            this.queryTableName = IAUtilities.getIMSDataTableName();
        } else if (this.type.equals("com.ibm.cics.query.type.mq")) {
            this.queryTableName = IAUtilities.getMQDataTableName();
        } else if (this.type.equals("com.ibm.cics.query.type.natural")) {
            this.queryTableName = IAUtilities.getNaturalTableName();
        } else if (this.type.equals("com.ibm.cics.query.type.commandflow")) {
            this.queryTableName = IAUtilities.getCommandFlowTableName();
        }
        if (presentationObject == null) {
            presentationObject = PresentationFactory.getInstance().createPresentation("", "", "", PresentationFactory.getInstance().createSelectAllForTable(this.queryTableName, ""));
            presentationObject.getSelection().getSelect().setDistinct(true);
            presentationObject.addParameter("query_type", queryType);
            this.isNew = true;
        }
        this.container = queryFolderOnDisc;
        this.presentation = presentationObject;
        Debug.exit((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"EditQueryDialog");
    }

    protected Control createDialogArea(Composite parent) {
        Debug.enter((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"createDialogArea", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.isNew) {
            this.setTitle(Messages.getString("EditQueryDialog.txt.createquery"));
        } else {
            this.setTitle(MessageFormat.format(Messages.getString("EditQueryDialog.title.editquery"), this.presentation.getTitle()));
        }
        this.setMessage(Messages.getString("EditQueryDialog.msg.desc.addchangeorremovecriteria"));
        this.setTitleImage(ImageFactory.getQueryWizardBanner());
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)data);
        Composite c = new Composite(composite, 0);
        data = new GridData(4, 0, true, false);
        data.horizontalSpan = 3;
        c.setLayoutData((Object)data);
        c.setLayout((Layout)new GridLayout(3, false));
        Label l = new Label(c, 0);
        l.setText(Messages.getString("EditQueryDialog.txt.name"));
        this.nameText = new Text(c, 2048);
        TextInput.setAccessibleLabel((Text)this.nameText, (Label)l);
        data = new GridData();
        data.widthHint = 250;
        this.nameText.setLayoutData((Object)data);
        this.createGroupTree(composite);
        this.createExpressionsTable(composite);
        this.valueComposite = new Group(composite, 0);
        this.expressionsStack = new StackLayout();
        this.valueComposite.setLayout((Layout)this.expressionsStack);
        data = new GridData(4, 4, true, true);
        data.widthHint = 230;
        data.heightHint = 200;
        this.valueComposite.setLayoutData((Object)data);
        this.expressionCompositeFactory = new ExpressionCompositeFactory((Composite)this.valueComposite);
        this.initialize();
        this.createGroupByItems();
        this.createTableItems();
        Dialog.applyDialogFont((Control)parent);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditQueryDialog.this.validate();
            }
        });
        Debug.exit((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"createDialogArea");
        return composite;
    }

    private void initialize() {
        this.nameText.setText(this.presentation.getTitle());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Debug.enter((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"createButtonsForButtonBar", (Object)("Thread ID: " + Thread.currentThread().getId()));
        super.createButtonsForButtonBar(parent);
        if (this.isNew) {
            this.getButton(0).setEnabled(false);
        }
        this.validate();
        Debug.exit((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"validate");
    }

    private void validate() {
        Debug.enter((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"validate", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String name = this.nameText.getText();
        this.enableDisableButtons();
        if (!IAUtilities.hasContent((String)name)) {
            this.inError = true;
            this.errorMessage = Messages.getString("EditQueryDialog.msg.querynamemustbeentered");
            this.setErrorMessage(this.errorMessage);
            this.getButton(0).setEnabled(false);
            Debug.exit((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"validate");
            return;
        }
        if (IAUtilities.startsWithANumber((String)name)) {
            this.inError = true;
            this.errorMessage = Messages.getString("EditQueryDialog.querynamecannotbeginwithnumber");
            this.setErrorMessage(this.errorMessage);
            this.getButton(0).setEnabled(false);
            Debug.exit((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"validate");
            return;
        }
        if (!IAUtilities.isValidFilename((String)name)) {
            this.inError = true;
            this.errorMessage = Messages.getString("EditQueryDialog.querynamecontainsillegalchars");
            this.setErrorMessage(this.errorMessage);
            this.getButton(0).setEnabled(false);
            Debug.exit((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"validate");
            return;
        }
        if (!this.isNew && name.equals(this.presentation.getTitle())) {
            this.inError = false;
            this.clearErrorMessage();
            Debug.exit((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"validate");
            return;
        }
        if (QueryManager.getSingleton().existsXML(this.container, name)) {
            this.inError = true;
            this.errorMessage = Messages.getString("EditQueryDialog.msg.querynamealreadyused");
            this.setErrorMessage(this.errorMessage);
            this.getButton(0).setEnabled(false);
            Debug.exit((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"validate");
            return;
        }
        String fullPath = this.container.getLocation().append(name).addFileExtension("xml").toOSString();
        if (!IAUtilities.isValidFilePath((String)fullPath)) {
            this.inError = true;
            this.errorMessage = Messages.getString("EditQueryDialog.msg.queryPathIsInvalid");
            this.setErrorMessage(this.errorMessage);
            this.getButton(0).setEnabled(false);
            Debug.exit((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"validate");
            return;
        }
        if (this.groupTree.getItemCount() == 0) {
            this.inError = true;
            this.errorMessage = Messages.getString("EditQueryDialog.errormsg.oneattributemustbeshown");
            this.setErrorMessage(this.errorMessage);
            this.getButton(0).setEnabled(false);
            Debug.exit((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"validate");
            return;
        }
        this.oldName = this.presentation.getTitle();
        this.inError = false;
        this.clearErrorMessage();
        Debug.exit((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"clearErrorMessage");
    }

    private void clearErrorMessage() {
        Debug.enter((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"clearErrorMessage", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (!this.compositeError && !this.inError) {
            this.setErrorMessage(null);
        } else if (this.compositeError) {
            this.setErrorMessage(this.compositeErrorMessage);
        } else if (this.inError) {
            this.setErrorMessage(this.errorMessage);
        }
        Debug.exit((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"createGroupTree");
    }

    private void createGroupTree(Composite composite) {
        Debug.enter((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"createGroupTree", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Group c = new Group(composite, 0);
        c.setText(Messages.getString("EditQueryDialog.grp.show"));
        c.setLayout((Layout)new GridLayout(1, false));
        GridData data = new GridData(4, 4, true, true);
        c.setLayoutData((Object)data);
        final ToolBar toolBar = new ToolBar((Composite)c, 0x800000);
        final ToolItem addGroupToolItem = new ToolItem(toolBar, 0x800004);
        addGroupToolItem.setImage(ImageFactory.getAddImage());
        addGroupToolItem.setToolTipText(Messages.getString("EditQueryDialog.tooltip.neewcolumn"));
        SelectionAdapter addGroupItemListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Debug.enter((Logger)logger, (String)"EditQueryDialog.createGroupTree().addGroupMenuListener", (String)"widgetSelected", (Object)("Thread ID: " + Thread.currentThread().getId()));
                MenuItem selectedMenuItem = (MenuItem)e.getSource();
                TreeItem parentItem = null;
                if (EditQueryDialog.this.groupTree.getSelection().length > 0) {
                    parentItem = EditQueryDialog.this.groupTree.getSelection()[0];
                } else {
                    parentItem = EditQueryDialog.this.groupTree.getItemCount() > 0 ? EditQueryDialog.this.groupTree.getItem(0) : null;
                    while (parentItem != null && parentItem.getItemCount() > 0) {
                        parentItem = parentItem.getItem(0);
                    }
                }
                TreeItem newGroupItem = null;
                if (parentItem == null) {
                    newGroupItem = new TreeItem(EditQueryDialog.this.groupTree, 0);
                } else {
                    TreeItem childItem = parentItem.getItemCount() > 0 ? parentItem.getItem(0) : null;
                    TreeItem currentParentItem = newGroupItem = new TreeItem(parentItem, 0);
                    while (childItem != null) {
                        TreeItem newChildItem = new TreeItem(currentParentItem, 0);
                        currentParentItem.setExpanded(true);
                        currentParentItem = newChildItem;
                        newChildItem.setText(childItem.getText());
                        newChildItem.setImage(childItem.getImage());
                        newChildItem.setData(childItem.getData());
                        TreeItem treeItem = childItem = childItem.getItemCount() == 0 ? null : childItem.getItem(0);
                    }
                    TreeItem treeItem = childItem = parentItem.getItemCount() > 1 ? parentItem.getItem(0) : null;
                    if (childItem != null) {
                        childItem.dispose();
                    }
                }
                if (newGroupItem.getParentItem() != null) {
                    newGroupItem.getParentItem().setExpanded(true);
                }
                EditQueryDialog.this.groupTree.setSelection(newGroupItem);
                newGroupItem.setText(selectedMenuItem.getText());
                LabelProvider labelProvider = LabelProviderFactory.getLabelProvider((String)selectedMenuItem.getData());
                newGroupItem.setImage(labelProvider.getImage(selectedMenuItem.getData()));
                newGroupItem.setData(selectedMenuItem.getData());
                EditQueryDialog.this.validate();
                Debug.exit((Logger)logger, (String)"EditQueryDialog.createGroupTree().addGroupMenuListener", (String)"widgetSelected", (Object)("Thread ID: " + Thread.currentThread().getId()));
            }
        };
        final Menu menu = new Menu((Decorations)composite.getShell(), 8);
        String queryType = this.presentation.getParameter("query_type");
        Map<String, String> displayNameMap = queryType.equals("com.ibm.cics.query.type.cics") ? UIUtilities.getCICSDisplayNameMap(this.getGroupByAttributes()) : UIUtilities.getDisplayNameMap(this.getGroupByAttributes());
        for (Map.Entry<String, String> entry : displayNameMap.entrySet()) {
            MenuItem menuItem = new MenuItem(menu, 8);
            menuItem.setData((Object)entry.getValue());
            menuItem.setText(entry.getKey());
            menuItem.addSelectionListener((SelectionListener)addGroupItemListener);
        }
        addGroupToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Rectangle rect = addGroupToolItem.getBounds();
                Point pt = toolBar.toDisplay(new Point(rect.x, rect.y + rect.height));
                menu.setLocation(pt.x, pt.y);
                menu.setVisible(true);
            }
        });
        this.addToolBarAccessibleListener(toolBar);
        this.deleteGroupToolItem = new ToolItem(toolBar, 8);
        this.deleteGroupToolItem.setImage(ImageFactory.getDeleteImage());
        this.deleteGroupToolItem.setDisabledImage(ImageFactory.getDeleteImage_DISABLED());
        this.deleteGroupToolItem.setEnabled(false);
        this.deleteGroupToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditQueryDialog.this.deleteItem(EditQueryDialog.this.groupTree.getSelection()[0]);
                EditQueryDialog.this.validate();
            }
        });
        this.deleteGroupToolItem.setToolTipText(Messages.getString("EditQueryDialog.tooltip.deletecolumn"));
        this.upGroupToolItem = new ToolItem(toolBar, 0x800000);
        this.upGroupToolItem.setImage(ImageFactory.getPreviousItemImage());
        this.upGroupToolItem.setDisabledImage(ImageFactory.getPreviousItemImage_DISABLED());
        this.upGroupToolItem.setToolTipText(Messages.getString("EditQueryDialog.tooltip.moveup"));
        this.upGroupToolItem.setEnabled(false);
        this.upGroupToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem itemToMoveUp = EditQueryDialog.this.groupTree.getSelection()[0];
                EditQueryDialog.this.moveItemUp(itemToMoveUp);
                itemToMoveUp.getParentItem().dispose();
                EditQueryDialog.this.expand(EditQueryDialog.this.groupTree);
            }
        });
        this.downGroupToolItem = new ToolItem(toolBar, 0x800000);
        this.downGroupToolItem.setImage(ImageFactory.getNextItemImage());
        this.downGroupToolItem.setDisabledImage(ImageFactory.getNextItemImage_DISABLED());
        this.downGroupToolItem.setToolTipText(Messages.getString("EditQueryDialog.tooltip.movedown"));
        this.downGroupToolItem.setEnabled(false);
        this.downGroupToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem itemToMoveDown = EditQueryDialog.this.groupTree.getSelection()[0];
                EditQueryDialog.this.moveItemUp(itemToMoveDown.getItem(0));
                TreeItem movedItem = itemToMoveDown.getParentItem() == null ? EditQueryDialog.this.groupTree.getItem(1) : itemToMoveDown.getParentItem().getItem(1);
                itemToMoveDown.dispose();
                EditQueryDialog.this.groupTree.setSelection(movedItem.getItem(0));
                EditQueryDialog.this.expand(EditQueryDialog.this.groupTree);
            }
        });
        FormToolkit toolkit = EditorHelper.getFormToolkit();
        this.groupTree = toolkit.createTree((Composite)c, 2308);
        data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.widthHint = 175;
        this.groupTree.setLayoutData((Object)data);
        this.groupTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditQueryDialog.this.validate();
            }
        });
        this.groupTree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (EditQueryDialog.this.groupTree.getSelectionCount() > 0 && e.keyCode == 127) {
                    EditQueryDialog.this.deleteItem(EditQueryDialog.this.groupTree.getSelection()[0]);
                    EditQueryDialog.this.validate();
                }
            }
        });
        Debug.exit((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"createGroupTree");
    }

    private void addToolBarAccessibleListener(final ToolBar toolBar) {
        toolBar.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID != -1) {
                    try {
                        String toolTip;
                        ToolItem item = toolBar.getItem(e.childID);
                        if (item != null && (toolTip = item.getToolTipText()) != null) {
                            e.result = toolTip;
                        }
                    }
                    catch (IllegalArgumentException ee) {
                        IAPlugin.getDefault().logError("Unable to get toolbar item", (Throwable)ee);
                    }
                }
            }
        });
    }

    private void enableDisableButtons() {
        Debug.enter((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"enableDisableButtons", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.groupTree.getSelectionCount() > 0) {
            this.deleteGroupToolItem.setEnabled(true);
            TreeItem selectedItem = this.groupTree.getSelection()[0];
            this.upGroupToolItem.setEnabled(selectedItem.getParentItem() != null);
            this.downGroupToolItem.setEnabled(selectedItem.getItemCount() > 0);
        } else {
            this.downGroupToolItem.setEnabled(false);
            this.upGroupToolItem.setEnabled(false);
            this.deleteGroupToolItem.setEnabled(false);
        }
        this.getButton(0).setEnabled(this.groupTree.getItemCount() > 0);
        Debug.exit((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"moveItemUp");
    }

    private void moveItemUp(TreeItem itemToMove) {
        TreeItem newParent = itemToMove.getParentItem().getParentItem();
        TreeItem newItem = newParent == null ? new TreeItem(this.groupTree, 0) : new TreeItem(newParent, 0);
        newItem.setText(itemToMove.getText());
        newItem.setImage(itemToMove.getImage());
        newItem.setData(itemToMove.getData());
        newItem = new TreeItem(newItem, 0);
        newItem.setText(itemToMove.getParentItem().getText());
        newItem.setImage(itemToMove.getParentItem().getImage());
        newItem.setData(itemToMove.getParentItem().getData());
        while (itemToMove.getItemCount() > 0) {
            itemToMove = itemToMove.getItem(0);
            newItem = new TreeItem(newItem, 0);
            newItem.setText(itemToMove.getText());
            newItem.setImage(itemToMove.getImage());
            newItem.setData(itemToMove.getData());
        }
    }

    private void deleteItem(TreeItem itemToDelete) {
        TreeItem itemToMove;
        TreeItem treeItem = itemToMove = itemToDelete.getItemCount() > 0 ? itemToDelete.getItem(0) : null;
        if (itemToDelete.getItemCount() > 0) {
            TreeItem newParentItem = itemToDelete.getParentItem() == null ? new TreeItem(this.groupTree, 0) : new TreeItem(itemToDelete.getParentItem(), 0);
            newParentItem.setText(itemToMove.getText());
            newParentItem.setImage(itemToMove.getImage());
            newParentItem.setData(itemToMove.getData());
            while (itemToMove.getItemCount() > 0) {
                itemToMove = itemToMove.getItem(0);
                newParentItem = new TreeItem(newParentItem, 0);
                newParentItem.setText(itemToMove.getText());
                newParentItem.setImage(itemToMove.getImage());
                newParentItem.setData(itemToMove.getData());
            }
        }
        itemToDelete.dispose();
        this.expand(this.groupTree);
    }

    private void expand(Tree aTree) {
        if (aTree.getItemCount() > 0) {
            TreeItem item = aTree.getItem(0);
            while (item != null) {
                item.setExpanded(true);
                TreeItem treeItem = item = item.getItemCount() > 0 ? item.getItem(0) : null;
            }
        } else {
            this.validate();
        }
    }

    protected abstract String[] getGroupByAttributes();

    private void createExpressionsTable(Composite composite) {
        Debug.enter((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"createExpressionsTable", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Group c = new Group(composite, 0);
        c.setText(Messages.getString("EditQueryDialog.group.filteresults"));
        c.setLayout((Layout)new GridLayout(1, false));
        GridData data = new GridData(4, 4, true, true);
        c.setLayoutData((Object)data);
        final ToolBar toolBar = new ToolBar((Composite)c, 0x800000);
        final ToolItem addToolItem = new ToolItem(toolBar, 0x800004);
        addToolItem.setImage(ImageFactory.getAddImage());
        addToolItem.setToolTipText(Messages.getString("EditQueryDialog.tooltip.newexpr"));
        this.addToolBarAccessibleListener(toolBar);
        SelectionAdapter addExpressionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] values;
                Clause simpleCondition;
                Debug.enter((Logger)logger, (String)"EditQueryDialog.createExpressionsTable().addExpressionListener", (String)"widgetSelected", (Object)("Thread ID: " + Thread.currentThread().getId()));
                MenuItem selectedMenuItem = (MenuItem)e.getSource();
                String fieldName = (String)selectedMenuItem.getData();
                String valueType = EditQueryDialog.this.getValueType(fieldName);
                if (valueType.equals("DATE")) {
                    Date date = new Date();
                    Timestamp timestamp = new Timestamp(date.getTime());
                    Object[] values2 = new Object[]{timestamp};
                    simpleCondition = PresentationFactory.getInstance().createSimpleCondition(fieldName, EditQueryDialog.this.queryTableName, ColumnReference.DataType.Timestamp, Comparator.LT, values2, false);
                } else if (valueType.equals("DECIMAL")) {
                    values = new Object[]{new Integer(0)};
                    simpleCondition = PresentationFactory.getInstance().createSimpleCondition(fieldName, EditQueryDialog.this.queryTableName, ColumnReference.DataType.Integer, Comparator.EQ, values, false);
                } else if (valueType.equals("HEX")) {
                    values = new Object[]{new Long(0L)};
                    simpleCondition = PresentationFactory.getInstance().createSimpleCondition(fieldName, EditQueryDialog.this.queryTableName, ColumnReference.DataType.Long, Comparator.EQ, new Object[]{values}, false);
                } else {
                    values = new Object[]{""};
                    simpleCondition = PresentationFactory.getInstance().createSimpleCondition(fieldName, EditQueryDialog.this.queryTableName, ColumnReference.DataType.String, Comparator.EQ, values, false);
                }
                TableItem newlyCreatedItem = new TableItem(EditQueryDialog.this.expressionsTable, 0);
                newlyCreatedItem.setData((Object)simpleCondition);
                newlyCreatedItem.setData("VALUE_TYPE", (Object)valueType);
                newlyCreatedItem.setText(EditQueryDialog.this.getExpressionText(simpleCondition, valueType));
                newlyCreatedItem.setImage(ImageFactory.getColumnImage());
                EditQueryDialog.this.expressionsTable.setSelection(newlyCreatedItem);
                EditQueryDialog.this.setCurrentTableItem(newlyCreatedItem);
                Debug.enter((Logger)logger, (String)"EditQueryDialog.createExpressionsTable().addExpressionListener", (String)"widgetSelected");
            }
        };
        final Menu menu = new Menu((Decorations)composite.getShell(), 8);
        String queryType = this.presentation.getParameter("query_type");
        Map<String, String> displayNamesToSQLNames = queryType.equals("com.ibm.cics.query.type.cics") ? UIUtilities.getCICSDisplayNameMap(this.getFilterAttributes()) : UIUtilities.getDisplayNameMap(this.getFilterAttributes());
        for (Map.Entry<String, String> entry : displayNamesToSQLNames.entrySet()) {
            MenuItem menuItem = new MenuItem(menu, 8);
            menuItem.setData((Object)entry.getValue());
            menuItem.setText(entry.getKey());
            menuItem.addSelectionListener((SelectionListener)addExpressionListener);
        }
        addToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Rectangle rect = addToolItem.getBounds();
                Point pt = toolBar.toDisplay(new Point(rect.x, rect.y + rect.height));
                menu.setLocation(pt.x, pt.y);
                menu.setVisible(true);
            }
        });
        this.deleteToolItem = new ToolItem(toolBar, 8);
        this.deleteToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditQueryDialog.this.expressionComposite.reset();
                EditQueryDialog.this.currentTableItem.dispose();
                EditQueryDialog.this.setCurrentTableItem(null);
            }
        });
        this.deleteToolItem.setImage(ImageFactory.getDeleteImage());
        this.deleteToolItem.setDisabledImage(ImageFactory.getDeleteImage_DISABLED());
        this.deleteToolItem.setEnabled(false);
        this.deleteToolItem.setToolTipText(Messages.getString("EditQueryDialog.tooltip.deleteexpr"));
        FormToolkit toolkit = EditorHelper.getFormToolkit();
        this.expressionsTable = toolkit.createTable((Composite)c, 2308);
        data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.widthHint = 300;
        this.expressionsTable.setLayoutData((Object)data);
        this.expressionsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EditQueryDialog.this.expressionsTable.getSelectionCount() >= 1) {
                    EditQueryDialog.this.setCurrentTableItem(EditQueryDialog.this.expressionsTable.getSelection()[0]);
                } else {
                    EditQueryDialog.this.setCurrentTableItem(null);
                }
            }
        });
        final TableColumn column = new TableColumn(this.expressionsTable, 0);
        column.setWidth(this.expressionsTable.getSize().x);
        this.expressionsTable.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                Rectangle area = EditQueryDialog.this.expressionsTable.getClientArea();
                column.setWidth(area.width);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.expressionsTable.layout();
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)composite.getShell(), "com.ibm.cics.ia.help.query_editor");
        Debug.exit((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"createExpressionsTable");
    }

    protected abstract String[] getFilterAttributes();

    private String getValueType(String fieldName) {
        Debug.enter((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"getValueType", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String result = null;
        result = fieldName.equals("FIRST_RUN") || fieldName.equals("LAST_RUN") || fieldName.equals("CMD_TIME_LOCAL") ? "DATE" : (fieldName.equals("USECOUNT") || fieldName.equals("FILE_NUMBER") || fieldName.equals("OBJLENGTH") || fieldName.equals("APP_VER1") || fieldName.equals("APP_VER2") || fieldName.equals("APP_VER3") || fieldName.equals("APPL_VER1") || fieldName.equals("APPL_VER2") || fieldName.equals("APPL_VER3") || fieldName.equals("PROGCOUNT") || fieldName.equals("TRANCOUNT") || fieldName.equals("SECTION") || fieldName.equals("AFFINITY_COUNT") || fieldName.equals("DEPENDENCY_COUNT") || fieldName.equals("MVS_POST_COUNT") || fieldName.equals("STATEMENT") || fieldName.equals("DATABASE_ID") || fieldName.equals("TCB_SWITCH_BEFORE_COUNT") || fieldName.equals("TCB_SWITCH_AFTER_COUNT") || fieldName.equals("LEVEL") ? "DECIMAL" : (fieldName.equals("OFFSET") && this.presentation.getParameter("query_type").equals("com.ibm.cics.query.type.scanner") ? "HEX" : "STRING"));
        Debug.exit((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"getValueType");
        return result;
    }

    private void setCurrentTableItem(TableItem aTableItem) {
        this.currentTableItem = aTableItem;
        this.deleteToolItem.setEnabled(aTableItem != null);
        this.showExpressionComposite();
    }

    private void showExpressionComposite() {
        Debug.enter((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"showExpressionComposite", (Object)("Thread ID: " + Thread.currentThread().getId()));
        ConstraintElement condition = null;
        if (this.currentTableItem != null) {
            condition = (ConstraintElement)this.currentTableItem.getData();
        }
        if (condition != null) {
            String queryType = this.presentation.getParameter("query_type");
            ColumnReference column = condition instanceof Clause ? (ColumnReference)((Clause)condition).getColumns().get(0) : (ColumnReference)((Clause)((ClauseGroup)condition).getClauses().get(0)).getColumns().get(0);
            String title = "";
            if (queryType.equals("com.ibm.cics.query.type.cics")) {
                title = SQLDefinitions.getCICSColumnDescription((String)column.getColumnName());
                this.valueComposite.setText(title);
                this.valueComposite.setToolTipText(title);
            } else {
                title = SQLDefinitions.getColumnDescription((String)column.getColumnName());
                this.valueComposite.setText(title);
                this.valueComposite.setToolTipText(title);
            }
        }
        if (this.expressionCompositeListener == null) {
            this.expressionCompositeListener = new ExpressionComposite.Listener(){

                @Override
                public void setError(String errorMessage) {
                    if (errorMessage == null) {
                        EditQueryDialog.this.compositeError = false;
                        EditQueryDialog.this.getButton(0).setEnabled(true);
                        EditQueryDialog.this.clearErrorMessage();
                        EditQueryDialog.this.validate();
                    } else {
                        EditQueryDialog.this.compositeError = true;
                        EditQueryDialog.this.setErrorMessage(errorMessage);
                        EditQueryDialog.this.getButton(0).setEnabled(false);
                        EditQueryDialog.this.compositeErrorMessage = errorMessage;
                    }
                }

                @Override
                public void expressionChanged(ConstraintElement newConstraint) {
                    EditQueryDialog.this.currentTableItem.setData((Object)newConstraint);
                    String valueType = (String)EditQueryDialog.this.currentTableItem.getData("VALUE_TYPE");
                    EditQueryDialog.this.currentTableItem.setText(EditQueryDialog.this.getExpressionText(newConstraint, valueType));
                }
            };
        } else {
            this.expressionComposite.removeListener(this.expressionCompositeListener);
        }
        this.compositeError = false;
        this.expressionComposite = this.expressionCompositeFactory.getComposite(condition, this.type);
        this.expressionsStack.topControl = this.expressionComposite.getComposite();
        this.valueComposite.layout();
        this.expressionComposite.addListener(this.expressionCompositeListener);
        this.expressionComposite.initialize();
        this.validate();
        Debug.exit((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"getExpressionText");
    }

    protected String getExpressionText(Object expression, String valueType) {
        Debug.enter((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"getExpressionText", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (expression instanceof Clause) {
            String result = ClauseToStringHelper.ClauseToUserString((Clause)((Clause)expression), (String)valueType);
            Debug.exit((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"getExpressionText");
            return result;
        }
        String result = ClauseToStringHelper.ClauseGroupToUserString((ClauseGroup)((ClauseGroup)expression), (String)valueType);
        Debug.exit((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"getExpressionText");
        return result;
    }

    private void createTableItems() {
        Selection selection = this.presentation.getSelection();
        this.createTableItems(selection.getCondition());
    }

    private void createTableItems(ConstraintElement condition) {
        Debug.enter((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"createTableItems", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (condition instanceof ClauseGroup) {
            ClauseGroup conditions = (ClauseGroup)condition;
            boolean allAreClauses = false;
            for (ConstraintElement constraint : conditions.getClauses()) {
                allAreClauses = true;
                if (constraint instanceof Clause) continue;
                allAreClauses = false;
                break;
            }
            if (conditions.getPredicate().equals((Object)QueryElement.Predicate.OR) && allAreClauses) {
                this.createTableItem((ConstraintElement)conditions);
            } else {
                for (ConstraintElement constraint : conditions.getClauses()) {
                    this.createTableItems(constraint);
                }
            }
        } else if (condition instanceof Clause) {
            this.createTableItem((ConstraintElement)((Clause)condition));
        }
        Debug.exit((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"createTableItems");
    }

    private void createTableItem(ConstraintElement condition) {
        Debug.enter((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"createTableItem", (Object)("Thread ID: " + Thread.currentThread().getId()));
        ColumnReference column = condition instanceof Clause ? (ColumnReference)((Clause)condition).getColumns().get(0) : (ColumnReference)((Clause)((ClauseGroup)condition).getClauses().get(0)).getColumns().get(0);
        TableItem item = new TableItem(this.expressionsTable, 0);
        item.setImage(ImageFactory.getColumnImage());
        item.setData((Object)condition);
        String valueType = this.getValueType(column.getColumnName());
        item.setData("VALUE_TYPE", (Object)valueType);
        item.setText(this.getExpressionText(condition, valueType));
        Debug.exit((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"createTableItem");
    }

    private void createGroupByItems() {
        Debug.enter((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"createGroupByItems", (Object)("Thread ID: " + Thread.currentThread().getId()));
        OrderBy orderBy = this.presentation.getSelection().getOrderBy();
        String param = this.presentation.getParameter("query_type");
        if (orderBy == null) {
            Selection selection = this.presentation.getSelection();
            if (param.equals("com.ibm.cics.query.type.cics")) {
                selection.addOrderByCondition("TYPE", this.queryTableName, Direction.ASC);
                selection.addOrderByCondition("OBJECT", this.queryTableName, Direction.ASC);
            } else if (param.equals("com.ibm.cics.query.type.affinity")) {
                selection.addOrderByCondition("AFFTYPE", this.queryTableName, Direction.ASC);
                selection.addOrderByCondition("GROUPTYPE", this.queryTableName, Direction.ASC);
                selection.addOrderByCondition("PROGRAM", this.queryTableName, Direction.ASC);
            } else if (param.equals("com.ibm.cics.query.type.db2")) {
                selection.addOrderByCondition("RESTYPE", this.queryTableName, Direction.ASC);
                selection.addOrderByCondition("RESNAME", this.queryTableName, Direction.ASC);
            } else if (param.equals("com.ibm.cics.query.type.ims")) {
                selection.addOrderByCondition("TYPE", this.queryTableName, Direction.ASC);
                selection.addOrderByCondition("OBJECT", this.queryTableName, Direction.ASC);
            } else if (param.equals("com.ibm.cics.query.type.mq")) {
                selection.addOrderByCondition("TYPE", this.queryTableName, Direction.ASC);
                selection.addOrderByCondition("OBJECT", this.queryTableName, Direction.ASC);
            } else if (param.equals("com.ibm.cics.query.type.natural")) {
                selection.addOrderByCondition("TRANSID", this.queryTableName, Direction.ASC);
                selection.addOrderByCondition("PROGRAM", this.queryTableName, Direction.ASC);
            } else if (param.equals("com.ibm.cics.query.type.commandflow")) {
                selection.addOrderByCondition("USERID", this.queryTableName, Direction.ASC);
                selection.addOrderByCondition("TRANSID", this.queryTableName, Direction.ASC);
                selection.addOrderByCondition("TASKID", this.queryTableName, Direction.ASC);
            } else if (param.equals("com.ibm.cics.query.type.scanner")) {
                selection.addOrderByCondition("DSNAME", this.queryTableName, Direction.ASC);
                selection.addOrderByCondition("PROGRAM", this.queryTableName, Direction.ASC);
            } else {
                selection.addOrderByCondition("OBJECT", this.queryTableName, Direction.ASC);
            }
            orderBy = selection.getOrderBy();
        }
        List columns = orderBy.getColumns();
        ArrayList<String> columnNames = new ArrayList<String>();
        for (ColumnReference columnReference : columns) {
            columnNames.add(columnReference.getColumnName());
        }
        TreeItem currentItem = null;
        int i = 0;
        while (i < columnNames.size()) {
            String columnID = (String)columnNames.get(i);
            currentItem = currentItem == null ? new TreeItem(this.groupTree, 0) : new TreeItem(currentItem, 0);
            LabelProvider labelProvider = LabelProviderFactory.getLabelProvider(columnID);
            String columnDescription = param.equals("com.ibm.cics.query.type.cics") ? SQLDefinitions.getCICSColumnDescription((String)columnID) : SQLDefinitions.getColumnDescription((String)columnID);
            currentItem.setText(columnDescription);
            currentItem.setImage(labelProvider.getImage((Object)columnID));
            currentItem.setData((Object)columnID);
            if (currentItem.getParentItem() != null) {
                currentItem.getParentItem().setExpanded(true);
            }
            ++i;
        }
        Debug.exit((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"createGroupByItems");
    }

    protected Control createHelpControl(Composite parent) {
        if (JFaceResources.getImage((String)"dialog_help_image") == null) {
            JFaceResources.getImageRegistry().put("dialog_help_image", ImageFactory.getHelpLinkImage());
        }
        return super.createHelpControl(parent);
    }

    protected void okPressed() {
        Debug.enter((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"okPressed", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.presentation.setTitle(this.nameText.getText());
        this.presentation.setSelection(PresentationFactory.getInstance().createSelectForTable(this.queryTableName, ""));
        this.presentation.getSelection().getSelect().setDistinct(true);
        this.presentation.setCode("");
        TableItem[] items = this.expressionsTable.getItems();
        int i = 0;
        while (i < items.length) {
            Object itemData = items[i].getData();
            if (itemData instanceof Clause) {
                Clause condition = (Clause)itemData;
                if (condition != null && condition.getValues() != null) {
                    this.presentation.getSelection().appendCondition((ConstraintElement)condition, QueryElement.Predicate.AND);
                }
            } else {
                ClauseGroup clauseGroup = (ClauseGroup)itemData;
                this.presentation.getSelection().appendCondition((ConstraintElement)clauseGroup, QueryElement.Predicate.AND);
            }
            ++i;
        }
        ArrayList<Object> groupKeys = new ArrayList<Object>();
        TreeItem treeItem = null;
        if (this.groupTree.getItemCount() > 0) {
            treeItem = this.groupTree.getItem(0);
        }
        while (treeItem != null) {
            groupKeys.add(treeItem.getData());
            TreeItem treeItem2 = treeItem = treeItem.getItemCount() > 0 ? treeItem.getItem(0) : null;
        }
        Object[] objects = groupKeys.toArray();
        String[] keys = new String[objects.length];
        System.arraycopy(objects, 0, keys, 0, keys.length);
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            this.presentation.getSelection().addOrderByCondition(columnName, this.queryTableName, Direction.ASC);
            ++n2;
        }
        this.adjustColumns();
        if (this.isNew) {
            try {
                QueryManager.getSingleton().saveXMLQuery(this.presentation, this.container);
            }
            catch (Exception e) {
                Debug.warning((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"okPressed", (Throwable)e, new HashMap());
                IAPlugin.getDefault().logError("Unable to save query", (Throwable)e);
            }
        } else {
            try {
                QueryManager.getSingleton().updateXMLQuery(this.presentation, this.container, this.oldName);
            }
            catch (Exception e) {
                Debug.warning((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"okPressed", (Throwable)e, new HashMap());
                IAPlugin.getDefault().logError("Unable to update query", (Throwable)e);
            }
        }
        super.okPressed();
        Debug.exit((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"adjustColumns");
    }

    private void adjustColumns() {
        Debug.enter((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"adjustColumns", (Object)("Thread ID: " + Thread.currentThread().getId()));
        List orderByColumns = this.presentation.getSelection().getOrderBy().getColumns();
        ArrayList<String> selectionColumnNames = new ArrayList<String>();
        Iterator iter = orderByColumns.iterator();
        while (iter.hasNext()) {
            selectionColumnNames.add(((ColumnReference)iter.next()).getColumnName());
        }
        if (selectionColumnNames.contains("OBJECT") && !selectionColumnNames.contains("TYPE")) {
            selectionColumnNames.add("TYPE");
        }
        if (selectionColumnNames.contains("TASKID") && !selectionColumnNames.contains("TRANSID")) {
            selectionColumnNames.add("TRANSID");
        }
        if (selectionColumnNames.contains("TASKID") && !selectionColumnNames.contains("APPLID")) {
            selectionColumnNames.add("APPLID");
        }
        this.presentation.getSelection().getSelect().getColumns().clear();
        for (String columnName : selectionColumnNames) {
            this.presentation.getSelection().getSelect().addSelectionColumn(columnName, this.queryTableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        }
        Debug.exit((Logger)logger, (String)EditQueryDialog.class.getName(), (String)"enclosing_method");
    }

    public Presentation getPresentation() {
        return this.presentation;
    }
}

