/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.Messages;
import java.util.logging.Logger;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class DetailsViewPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(DetailsViewPreferencePage.class.getPackage().getName());
    public static final String DETAILS_VIEW_HIGHLIGHT_COLOR_PREF = "DETAILS_VIEW_HIGHLIGHT_COLOR_PREF";
    private static final Color DEFAULT_HIGHLIGHT_COLOR = Display.getDefault().getSystemColor(29);
    private ColorSelector colorSelector;
    private IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Debug.enter((Logger)logger, (String)DetailsViewPreferencePage.class.getName(), (String)"createContents", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 16384);
        label.setText(Messages.getString("DetailsViewPreferencePage.label.highlightColor"));
        this.colorSelector = new ColorSelector(composite);
        if (!this.preferenceStore.contains(DETAILS_VIEW_HIGHLIGHT_COLOR_PREF)) {
            PreferenceConverter.setDefault((IPreferenceStore)this.preferenceStore, (String)DETAILS_VIEW_HIGHLIGHT_COLOR_PREF, (RGB)DEFAULT_HIGHLIGHT_COLOR.getRGB());
        }
        this.colorSelector.setColorValue(PreferenceConverter.getColor((IPreferenceStore)this.preferenceStore, (String)DETAILS_VIEW_HIGHLIGHT_COLOR_PREF));
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "com.ibm.cics.ia.help.details_preference_page");
        Debug.exit((Logger)logger, (String)DetailsViewPreferencePage.class.getName(), (String)"createContents");
        return composite;
    }

    public boolean performOk() {
        Debug.enter((Logger)logger, (String)DetailsViewPreferencePage.class.getName(), (String)"performOk", (Object)("Thread ID: " + Thread.currentThread().getId()));
        PreferenceConverter.setValue((IPreferenceStore)this.preferenceStore, (String)DETAILS_VIEW_HIGHLIGHT_COLOR_PREF, (RGB)this.colorSelector.getColorValue());
        Debug.exit((Logger)logger, (String)DetailsViewPreferencePage.class.getName(), (String)"performOk");
        return super.performOk();
    }

    protected void performDefaults() {
        Debug.enter((Logger)logger, (String)DetailsViewPreferencePage.class.getName(), (String)"performDefaults", (Object)("Thread ID: " + Thread.currentThread().getId()));
        PreferenceConverter.setValue((IPreferenceStore)this.preferenceStore, (String)DETAILS_VIEW_HIGHLIGHT_COLOR_PREF, (RGB)DEFAULT_HIGHLIGHT_COLOR.getRGB());
        this.colorSelector.setColorValue(DEFAULT_HIGHLIGHT_COLOR.getRGB());
        super.performDefaults();
        Debug.exit((Logger)logger, (String)DetailsViewPreferencePage.class.getName(), (String)"performDefaults");
    }

    public static Color getHighlightColor() {
        Debug.enter((Logger)logger, (String)DetailsViewPreferencePage.class.getName(), (String)"getHighlightColor", (Object)("Thread ID: " + Thread.currentThread().getId()));
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        if (!preferenceStore.contains(DETAILS_VIEW_HIGHLIGHT_COLOR_PREF)) {
            PreferenceConverter.setDefault((IPreferenceStore)preferenceStore, (String)DETAILS_VIEW_HIGHLIGHT_COLOR_PREF, (RGB)DEFAULT_HIGHLIGHT_COLOR.getRGB());
            Debug.exit((Logger)logger, (String)DetailsViewPreferencePage.class.getName(), (String)"getHighlightColor");
            return DEFAULT_HIGHLIGHT_COLOR;
        }
        Debug.exit((Logger)logger, (String)DetailsViewPreferencePage.class.getName(), (String)"getHighlightColor");
        return new Color((Device)Display.getCurrent(), PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)DETAILS_VIEW_HIGHLIGHT_COLOR_PREF));
    }
}

