/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.eclipse.common.editor.HelpAction;
import com.ibm.cics.ia.model.viz.ResourceFilter;
import com.ibm.cics.ia.ui.DetailsPresenter;
import com.ibm.cics.ia.ui.DetailsTreePresenter;
import com.ibm.cics.ia.ui.DetailsViewInput;
import com.ibm.cics.ia.ui.FilterContentProvider;
import com.ibm.cics.ia.ui.FilterLabelProvider;
import com.ibm.cics.ia.ui.FiltersAction;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.UIUtilities;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.part.MultiPageEditorPart;

public class DetailsView
extends MultiPageEditorPart {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(DetailsView.class.getPackage().getName());
    public static String ID = "com.ibm.cics.ia.ui.DetailsView";
    private DetailsPresenter presenter;
    private List<DetailsPage> pages;

    protected void createPages() {
        Debug.enter((Logger)logger, (String)DetailsView.class.getName(), (String)"createPages", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.pages = new LinkedList<DetailsPage>();
        this.setPresenter(((DetailsViewInput)this.getEditorInput()).getPresenter());
        this.presenter.setView(this);
        this.setPartName(this.getEditorInput().getName());
        this.presenter.handleViewCreation();
        IWorkbenchHelpSystem helpSystem = this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)this.getContainer(), this.presenter.getViewContextHelpId());
        Debug.exit((Logger)logger, (String)DetailsView.class.getName(), (String)"createPages");
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void dispose() {
        Debug.enter((Logger)logger, (String)DetailsView.class.getName(), (String)"dispose", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.presenter.handleViewClosing();
        super.dispose();
        Debug.exit((Logger)logger, (String)DetailsView.class.getName(), (String)"dispose");
    }

    public DetailsPage addEmptyPage() {
        Debug.enter((Logger)logger, (String)DetailsView.class.getName(), (String)"addEmptyPage", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Composite pageComposite = new Composite(this.getContainer(), 4);
        pageComposite.setLayout((Layout)new GridLayout(1, true));
        ToolBar toolbar = UIUtilities.createToolBar(pageComposite);
        final ToolBarManager toolBarManager = new ToolBarManager(toolbar);
        toolBarManager.add((IAction)new HelpAction(this.presenter.getViewContextHelpId()));
        toolBarManager.getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID > -1) {
                    ActionContributionItem action = (ActionContributionItem)toolBarManager.getItems()[e.childID];
                    e.result = String.valueOf(DetailsView.this.getContentDescription()) + action.getAction().getToolTipText();
                }
            }
        });
        toolBarManager.update(true);
        toolbar.pack();
        Label label = new Label(pageComposite, 0);
        label.setText(Messages.getString("DetailsView.page.empty"));
        this.addPage((Control)pageComposite);
        DetailsPage page = new DetailsPage();
        this.pages.add(page);
        Debug.exit((Logger)logger, (String)DetailsView.class.getName(), (String)"addEmptyPage");
        return page;
    }

    public DetailsPage addFirstDataPage(String tabName, List<String> columnIds, List<String> headers, List<String[]> rows, ResourceFilter[] filters) {
        return this.addDataPage(0, tabName, columnIds, headers, rows, filters);
    }

    public DetailsPage addLastDataPage(String tabName, List<String> columnIds, List<String> headers, List<String[]> rows, ResourceFilter[] filters) {
        return this.addDataPage(this.pages.size(), tabName, columnIds, headers, rows, filters);
    }

    public DetailsPage addFirstDataPage(String tabName, List<String> columnIds, List<String> headers, Map<String, List<String[]>> rows, ResourceFilter[] filters) {
        return this.addDataPage(0, tabName, columnIds, headers, rows, filters);
    }

    public DetailsPage addLastDataPage(String tabName, List<String> columnIds, List<String> headers, Map<String, List<String[]>> rows, ResourceFilter[] filters) {
        return this.addDataPage(this.pages.size(), tabName, columnIds, headers, rows, filters);
    }

    private DetailsPage addDataPage(int index, String tabName, List<String> columnIds, List<String> headers, Object rows, ResourceFilter[] filters) {
        DetailsPage page;
        FiltersAction showFilters;
        Debug.enter((Logger)logger, (String)DetailsView.class.getName(), (String)"addDataPage", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Composite pageComposite = new Composite(this.getContainer(), 4);
        pageComposite.setLayout((Layout)new GridLayout(1, true));
        ToolBar toolbar = UIUtilities.createToolBar(pageComposite);
        Composite viewComp = new Composite(pageComposite, 4);
        viewComp.setLayout((Layout)new GridLayout(1, true));
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        viewComp.setLayoutData((Object)data);
        if (filters == null) {
            DetailsStructure structure = rows instanceof List ? new DetailsTable(viewComp, columnIds.toArray(new String[columnIds.size()]), headers.toArray(new String[headers.size()]), (List)rows) : new DetailsTree(viewComp, columnIds.toArray(new String[columnIds.size()]), headers.toArray(new String[headers.size()]), (Map)rows);
            showFilters = new FiltersAction();
            showFilters.setEnabled(false);
            page = new DetailsPage(structure);
        } else {
            final SashForm cmdSash = new SashForm(viewComp, 256);
            final DetailsStructure structure = rows instanceof List ? new DetailsTable((Composite)cmdSash, columnIds.toArray(new String[columnIds.size()]), headers.toArray(new String[headers.size()]), (List)rows) : new DetailsTree((Composite)cmdSash, columnIds.toArray(new String[columnIds.size()]), headers.toArray(new String[headers.size()]), (Map)rows);
            cmdSash.setMaximizedControl(structure.getControl());
            data = new GridData(4, 4, true, true);
            cmdSash.setLayoutData((Object)data);
            ContainerCheckedTreeViewer filterViewer = new ContainerCheckedTreeViewer((Composite)cmdSash);
            filterViewer.setLabelProvider((IBaseLabelProvider)new FilterLabelProvider());
            filterViewer.setContentProvider((IContentProvider)new FilterContentProvider());
            cmdSash.setWeights(new int[]{8, 2});
            showFilters = new FiltersAction(){
                private boolean filterHidden;

                public void run() {
                    cmdSash.setMaximizedControl(this.filterHidden ? structure.getControl() : null);
                    this.filterHidden ^= true;
                }
            };
            filterViewer.setInput((Object)filters);
            filterViewer.expandAll();
            page = new DetailsPage(structure, filterViewer);
        }
        final ToolBarManager toolBarManager = new ToolBarManager(toolbar);
        toolBarManager.add((IAction)showFilters);
        toolBarManager.add((IAction)new HelpAction(this.presenter.getViewContextHelpId()));
        toolBarManager.getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID > -1) {
                    ActionContributionItem action = (ActionContributionItem)toolBarManager.getItems()[e.childID];
                    e.result = String.valueOf(DetailsView.this.getContentDescription()) + action.getAction().getToolTipText();
                }
            }
        });
        toolBarManager.update(true);
        toolbar.pack();
        this.addPage(index, (Control)pageComposite);
        this.setPageText(index, tabName);
        this.pages.add(index, page);
        Debug.exit((Logger)logger, (String)DetailsView.class.getName(), (String)"addDataPage");
        return page;
    }

    public void removePage(int index) {
        this.pages.remove(index);
        super.removePage(index);
    }

    public void removeAllPages() {
        Debug.enter((Logger)logger, (String)DetailsView.class.getName(), (String)"removeAllPages", (Object)("Thread ID: " + Thread.currentThread().getId()));
        while (this.getPageCount() > 0) {
            this.removePage(this.getPageCount() - 1);
        }
        this.pages.clear();
        Debug.exit((Logger)logger, (String)DetailsView.class.getName(), (String)"removeAllPages");
    }

    public int getPageCount() {
        return super.getPageCount();
    }

    public void setActivePage(int index) {
        super.setActivePage(index);
    }

    public DetailsPage getPage(int index) {
        Debug.enter((Logger)logger, (String)DetailsView.class.getName(), (String)"getPage", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (index >= 0 && this.pages.size() > index) {
            Debug.exit((Logger)logger, (String)DetailsView.class.getName(), (String)"getPage");
            return this.pages.get(index);
        }
        Debug.exit((Logger)logger, (String)DetailsView.class.getName(), (String)"getPage");
        return null;
    }

    public void refresh() {
        Debug.enter((Logger)logger, (String)DetailsView.class.getName(), (String)"refresh", (Object)("Thread ID: " + Thread.currentThread().getId()));
        for (DetailsPage page : this.pages) {
            if (page.getDetailsStructure() == null) continue;
            page.getDetailsStructure().refresh();
        }
        Debug.exit((Logger)logger, (String)DetailsView.class.getName(), (String)"refresh");
    }

    public void setPresenter(DetailsPresenter presenter) {
        this.presenter = presenter;
    }

    public String getTitleToolTip() {
        if (this.presenter != null) {
            return this.presenter.getViewTitle();
        }
        return super.getTitleToolTip();
    }

    public static class DetailsLabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        protected final DetailsStructure structure;

        public DetailsLabelProvider(DetailsStructure structure) {
            this.structure = structure;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof String) {
                return columnIndex > 0 ? "" : element.toString();
            }
            if (this.structure.getColumnProperties().length > columnIndex) {
                Object property = this.structure.getColumnProperties()[columnIndex];
                int index = this.structure.getConstantColumnIndex(property.toString());
                String[] detail = (String[])element;
                return detail[index];
            }
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            return null;
        }

        public Color getBackground(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return Display.getDefault().getSystemColor(22);
            }
            if (element instanceof String[]) {
                return this.getHighlightingColor(element, columnIndex);
            }
            return null;
        }

        public Color getHighlightingColor(Object element, int columnIndex) {
            return null;
        }
    }

    public static class DetailsPage {
        private DetailsStructure structure;
        private ContainerCheckedTreeViewer filterViewer;

        private DetailsPage() {
        }

        private DetailsPage(DetailsStructure structure) {
            this.structure = structure;
        }

        private DetailsPage(DetailsStructure structure, ContainerCheckedTreeViewer filter) {
            this.structure = structure;
            this.filterViewer = filter;
        }

        public DetailsStructure getDetailsStructure() {
            return this.structure;
        }

        public ContainerCheckedTreeViewer getFilter() {
            return this.filterViewer;
        }

        public void showFilteredColumns() {
            if (this.filterViewer != null) {
                LinkedList<String> columnIdsToShow = new LinkedList<String>();
                ResourceFilter[] resourceFilterArray = (ResourceFilter[])this.filterViewer.getInput();
                int n = resourceFilterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ResourceFilter filter = resourceFilterArray[n2];
                    columnIdsToShow.addAll(filter.getCheckedSubtreeLeafNames());
                    ++n2;
                }
                this.structure.showColumns(columnIdsToShow);
            }
        }

        public void checkAllFilters() {
            if (this.filterViewer != null) {
                ResourceFilter[] resourceFilterArray = (ResourceFilter[])this.filterViewer.getInput();
                int n = resourceFilterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ResourceFilter filter = resourceFilterArray[n2];
                    filter.setCheckedSubtree(true);
                    this.filterViewer.setChecked((Object)filter, true);
                    ++n2;
                }
            }
        }

        public void checkChildFilters(String ... filterNames) {
            if (this.filterViewer != null) {
                ResourceFilter[] resourceFilterArray = (ResourceFilter[])this.filterViewer.getInput();
                int n = resourceFilterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ResourceFilter filter = resourceFilterArray[n2];
                    for (ResourceFilter child : filter.getChildren()) {
                        String[] stringArray = filterNames;
                        int n3 = filterNames.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String name = stringArray[n4];
                            if (name.equals(child.getName())) {
                                child.setCheckedSubtree(true);
                                this.filterViewer.setChecked((Object)child, true);
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    public static abstract class DetailsStructure {
        protected String[] columnProperties;
        protected String[] headers;
        protected ColumnViewer viewer;

        public DetailsStructure(String[] columnProperties, String[] headers, ColumnViewer viewer) {
            this.columnProperties = columnProperties;
            this.headers = headers;
            this.viewer = viewer;
        }

        public void showColumns(List<String> columnIds) {
            if (!columnIds.contains(this.columnProperties[0])) {
                columnIds.add(0, this.columnProperties[0]);
            }
            this.removeValueColumns();
            String[] newProperties = new String[columnIds.size()];
            columnIds.toArray(newProperties);
            this.viewer.setColumnProperties(newProperties);
            this.addValueColumns(columnIds);
        }

        protected abstract void removeValueColumns();

        protected abstract void addValueColumns(List<String> var1);

        public int getConstantColumnIndex(String columnProperty) {
            int i = 0;
            while (i < this.columnProperties.length) {
                if (this.columnProperties[i].equals(columnProperty)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public Object[] getColumnProperties() {
            return this.viewer.getColumnProperties();
        }

        public abstract void refresh();

        public int[] getConstantColumnIndices() {
            int[] indices = new int[this.getColumnProperties().length];
            int i = 0;
            while (i < this.getColumnProperties().length) {
                indices[i] = this.getConstantColumnIndex((String)this.getColumnProperties()[i]);
                ++i;
            }
            return indices;
        }

        public void setLabelProvider(DetailsLabelProvider labelProvider) {
            this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        }

        public void setInput(String[] columnIds, String[] headers, Object input) {
            this.columnProperties = columnIds;
            this.headers = headers;
            this.viewer.setColumnProperties(new String[]{columnIds[0]});
            this.viewer.setInput(input);
            this.makeInputVisible();
        }

        protected abstract void makeInputVisible();

        public Control getControl() {
            return this.viewer.getControl();
        }
    }

    public static class DetailsTable
    extends DetailsStructure {
        private final Table table;

        public DetailsTable(Composite parent, String[] columnIds, String[] headers, List<String[]> rows) {
            super(columnIds, headers, (ColumnViewer)new TableViewer(parent, 66304));
            this.viewer.setContentProvider((IContentProvider)new ContentProvider());
            this.viewer.setLabelProvider((IBaseLabelProvider)new DetailsLabelProvider(this));
            this.viewer.setColumnProperties(new String[]{columnIds[0]});
            this.table = ((TableViewer)this.viewer).getTable();
            this.table.setLayoutData((Object)new GridData(1808));
            TableColumn detailsColumn = new TableColumn(this.table, 16384);
            detailsColumn.setText(headers[0]);
            detailsColumn.pack();
            this.table.setHeaderVisible(true);
            this.table.setLinesVisible(true);
            this.viewer.setInput(rows);
            this.viewer.setComparator(new ViewerComparator(){

                public int compare(Viewer viewer, Object obj1, Object obj2) {
                    return ((String[])obj1)[0].toString().compareTo(((String[])obj2)[0].toString());
                }
            });
            this.table.setSortDirection(1024);
        }

        @Override
        public void refresh() {
            this.viewer.refresh();
            TableColumn[] tableColumnArray = this.table.getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                column.pack();
                ++n2;
            }
        }

        @Override
        protected void removeValueColumns() {
            while (this.table.getColumnCount() > 1) {
                this.table.getColumn(this.table.getColumnCount() - 1).dispose();
            }
        }

        @Override
        protected void addValueColumns(List<String> columnIds) {
            int i = 1;
            while (i < columnIds.size()) {
                int index = this.getConstantColumnIndex(columnIds.get(i));
                TableColumn column = new TableColumn(this.table, 16384);
                column.setText(this.headers[index]);
                ++i;
            }
            this.refresh();
        }

        @Override
        protected void makeInputVisible() {
        }

        private static class ContentProvider
        implements IStructuredContentProvider {
            private ContentProvider() {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }
    }

    public static class DetailsTree
    extends DetailsStructure {
        private final Tree tree;
        private DetailsTreePresenter presenter;

        public DetailsTree(Composite parent, String[] columnIds, String[] headers, Map<String, List<String[]>> rows) {
            super(columnIds, headers, (ColumnViewer)new TreeViewer(parent, 66304));
            this.viewer.setContentProvider((IContentProvider)new DetailsTreeContentProvider());
            this.viewer.setLabelProvider((IBaseLabelProvider)new DetailsLabelProvider(this));
            this.viewer.setColumnProperties(new String[]{columnIds[0]});
            this.tree = ((TreeViewer)this.viewer).getTree();
            this.tree.setLayoutData((Object)new GridData(1808));
            TreeColumn detailsColumn = new TreeColumn(this.tree, 16384);
            detailsColumn.setText(headers[0]);
            detailsColumn.pack();
            this.tree.setHeaderVisible(true);
            this.tree.setLinesVisible(true);
            this.viewer.setUseHashlookup(true);
            this.viewer.setInput(rows);
            this.viewer.setComparator(new ViewerComparator(){

                public int compare(Viewer viewer, Object obj1, Object obj2) {
                    if (obj1 instanceof String[] && obj2 instanceof String[]) {
                        return ((String[])obj1)[0].toString().compareTo(((String[])obj2)[0].toString());
                    }
                    return obj1.toString().compareTo(obj2.toString());
                }
            });
            this.tree.setSortDirection(1024);
            this.tree.addHelpListener(new HelpListener(){

                public void helpRequested(HelpEvent e) {
                    if (presenter != null) {
                        presenter.attributeHelpRequested();
                    }
                }
            });
            ((TreeViewer)this.viewer).expandAll();
            this.refresh();
        }

        public void setPresenter(DetailsTreePresenter presenter) {
            this.presenter = presenter;
        }

        @Override
        protected void removeValueColumns() {
            while (this.tree.getColumnCount() > 1) {
                this.tree.getColumn(this.tree.getColumnCount() - 1).dispose();
            }
        }

        @Override
        protected void addValueColumns(List<String> columnIds) {
            int i = 1;
            while (i < columnIds.size()) {
                int index = this.getConstantColumnIndex(columnIds.get(i));
                TreeColumn column = new TreeColumn(this.tree, 16384);
                column.setText(this.headers[index]);
                ++i;
            }
            this.refresh();
        }

        @Override
        public void refresh() {
            this.viewer.refresh();
            TreeColumn[] treeColumnArray = this.tree.getColumns();
            int n = treeColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeColumn column = treeColumnArray[n2];
                column.pack();
                ++n2;
            }
        }

        @Override
        protected void makeInputVisible() {
            ((TreeViewer)this.viewer).expandAll();
            this.viewer.refresh();
        }

        public TreeItem[] getSelection() {
            return this.tree.getSelection();
        }

        static class DetailsTreeContentProvider
        implements ITreeContentProvider {
            private Map<String, List<String[]>> input;

            DetailsTreeContentProvider() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.input = (Map)newInput;
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                return this.input.containsKey(element);
            }

            public Object getParent(Object element) {
                if (this.input.containsKey(element)) {
                    return null;
                }
                for (Map.Entry<String, List<String[]>> entry : this.input.entrySet()) {
                    if (!entry.getValue().equals(element)) continue;
                    return entry.getKey();
                }
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return this.input.keySet().toArray();
            }

            public Object[] getChildren(Object parentElement) {
                return this.input.get(parentElement.toString()).toArray();
            }
        }
    }
}

