/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.RetrieveMorePresenter;
import com.ibm.cics.ia.ui.RetrieveMoreView;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

class DefaultRetrieveMoreViewImpl
implements RetrieveMoreView {
    private static final Logger logger = Logger.getLogger(DefaultRetrieveMoreViewImpl.class.getPackage().getName());
    private RetrieveMorePresenter presenter;
    private TreeItem parent;
    private TreeItem treeItem;
    private IViewPart viewPart;

    public DefaultRetrieveMoreViewImpl(Tree tree, IViewPart viewPart) {
        this.viewPart = viewPart;
        tree.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.item != null && event.item == DefaultRetrieveMoreViewImpl.this.treeItem) {
                    DefaultRetrieveMoreViewImpl.this.presenter.viewSelected();
                }
            }
        });
    }

    @Override
    public void hide() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"hide", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.treeItem != null) {
            this.treeItem.dispose();
            this.treeItem = null;
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"hide");
    }

    @Override
    public void show() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"show", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.treeItem = new TreeItem(this.parent, 0);
        this.treeItem.setText(Messages.getString("NavigatorView.msg.retrieveMore"));
        if (this.parent.getItemCount() > 1) {
            TreeItem prevSibling = this.parent.getItem(this.parent.getItemCount() - 2);
            this.treeItem.getParent().setSelection(prevSibling);
        } else {
            this.parent.getParent().setSelection(this.parent);
        }
        this.treeItem.getParent().showItem(this.treeItem);
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"show");
    }

    @Override
    public IWorkbenchSiteProgressService getWorkbenchSiteProgressService() {
        return (IWorkbenchSiteProgressService)this.viewPart.getSite().getAdapter(IWorkbenchSiteProgressService.class);
    }

    @Override
    public void setParentItem(TreeItem parent) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"setParentItem", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.parent == parent) {
            return;
        }
        this.parent = parent;
        if (this.treeItem != null) {
            this.treeItem.dispose();
            this.show();
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"setParentItem");
    }

    @Override
    public void setPresenter(RetrieveMorePresenter presenter) {
        this.presenter = presenter;
    }
}

