/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.ia.model.DB2Resource;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.ResourceRenderer;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class DB2ResourceTypeLabelProvider
extends LabelProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String columnID;

    public DB2ResourceTypeLabelProvider(String columnID) {
        this.columnID = columnID;
    }

    public String getText(Object element) {
        if (element == null) {
            return IAUtilities.EMPTY_STRING;
        }
        if (element instanceof Resource) {
            return ResourceRenderer.asText((Resource)element);
        }
        return element.toString();
    }

    public Image getImage(Object element) {
        if (element instanceof DB2Resource) {
            DB2Resource db2Resource = (DB2Resource)element;
            String typeName = db2Resource.getTypeName();
            if ("TABLE".equals(typeName)) {
                return ImageFactory.getDatabaseTableImage();
            }
            if ("CURSOR".equals(typeName)) {
                return ImageFactory.getDatabaseCursorImage();
            }
            if ("VIEW".equals(typeName)) {
                return ImageFactory.getDatabaseViewImage();
            }
        }
        return ImageFactory.getDatabaseDomainImage();
    }
}

