/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.EngineShell;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.model.threadsafe.CreateThreadsafeReportModel;
import com.ibm.cics.ia.model.threadsafe.CreateThreadsafeReportModelListener;
import com.ibm.cics.ia.model.threadsafe.ThreadsafeReportModel;
import com.ibm.cics.ia.model.threadsafe.ThreadsafeReportModelImpl;
import com.ibm.cics.ia.model.threadsafe.ThreadsafeReportModelListener;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.runtime.Version;
import com.ibm.cics.ia.storedproc.ProcedureCIUSPTSR;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.CreateThreadsafeReportParametersPage;
import com.ibm.cics.ia.ui.CreateThreadsafeReportPresenter;
import com.ibm.cics.ia.ui.CreateThreadsafeReportView;
import com.ibm.cics.ia.ui.ExplorerQueryContext;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.NavigatorView;
import com.ibm.cics.ia.ui.ReportExplorer;
import com.ibm.cics.ia.ui.ReportManager;
import com.ibm.cics.ia.ui.ThreadsafeReportPresenterImpl;
import com.ibm.cics.ia.ui.ThreadsafeReportViewInput;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.xml.sax.SAXException;

public class CreateThreadsafeReportPresenterImpl
implements CreateThreadsafeReportPresenter {
    private static final Logger logger = Logger.getLogger(CreateThreadsafeReportPresenterImpl.class.getPackage().getName());
    private CreateThreadsafeReportView view;
    private CreateThreadsafeReportModel model;
    private Unmarshaller unmarshaller;
    private Marshaller marshaller;

    @Override
    public boolean onFinish() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"onFinish", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (!this.view.getLocationPage().canFileBeCreated()) {
            Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"onFinish");
            return false;
        }
        CreateThreadsafeReportParametersPage paramsPage = this.view.getParametersPage();
        final boolean detailed = paramsPage.getCheckBox().getSelection();
        final AtomicBoolean retrievingReportDataCompleted = new AtomicBoolean(true);
        try {
            this.view.getWizardDialog().run(true, true, new IRunnableWithProgress(){

                public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Debug.enter((Logger)logger, (String)"CreateThreadsafeReportPresenterImpl.onFinish.view.getWizardDialog()", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                    monitor.beginTask(Messages.getString("ThreadsafeReportWizard.report.generating.summary"), -1);
                    EngineShell.EngineListener summaryListener = new EngineShell.EngineListener(){

                        public void statusUpdate(EngineShell.EngineStatus es) {
                            switch (es) {
                                case Error: {
                                    Display.getCurrent().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            String message;
                                            ProcedureCIUSPTSR.Result result = CreateThreadsafeReportPresenterImpl.this.model.getSummaryCommand().getResult();
                                            if (!result.isSuccessful() && IAUtilities.hasContent((String)(message = result.getMessage()))) {
                                                String title = result.isWarning() ? Messages.getString("ThreadsafeReportWizard.ProcedureCIUSPTSR.output.warning") : Messages.getString("ThreadsafeReportWizard.ProcedureCIUSPTSR.output.error");
                                                int boxStyle = result.isWarning() ? 72 : 65;
                                                MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), boxStyle);
                                                messageBox.setMessage(message);
                                                messageBox.setText(title);
                                                messageBox.open();
                                            }
                                        }
                                    });
                                }
                            }
                        }

                        public void notifyResultCount(int count) {
                        }

                        public void dataAvailable(Collection<Object> items) {
                            if (monitor.isCanceled()) {
                                CreateThreadsafeReportPresenterImpl.this.model.getSummaryCommand().cancel();
                                retrievingReportDataCompleted.set(false);
                                return;
                            }
                        }
                    };
                    CreateThreadsafeReportPresenterImpl.this.model.fillReportWithSummaries(summaryListener);
                    if (monitor.isCanceled()) {
                        retrievingReportDataCompleted.set(false);
                        Debug.exit((Logger)logger, (String)"CreateThreadsafeReportPresenterImpl.onFinish.view.getWizardDialog()", (String)"run");
                        return;
                    }
                    CreateThreadsafeReportModelListener detailsListener = new CreateThreadsafeReportModelListener(){

                        public void afterCreatingDetails(int number, int count) {
                            monitor.setTaskName(MessageFormat.format(Messages.getString("ThreadsafeReportWizard.report.generating.detailed"), number, count));
                            if (monitor.isCanceled()) {
                                CreateThreadsafeReportPresenterImpl.this.model.stopCreatingDetails();
                                retrievingReportDataCompleted.set(false);
                                Debug.exit((Logger)logger, (String)"CreateThreadsafeReportPresenterImpl.onFinish.view.getWizardDialog()", (String)"run");
                            }
                        }
                    };
                    if (detailed) {
                        CreateThreadsafeReportPresenterImpl.this.model.addListener(detailsListener);
                        CreateThreadsafeReportPresenterImpl.this.model.fillReportWithDetails();
                        CreateThreadsafeReportPresenterImpl.this.model.removeListener(detailsListener);
                    }
                    monitor.done();
                    Debug.exit((Logger)logger, (String)"CreateThreadsafeReportPresenterImpl.onFinish.view.getWizardDialog()", (String)"run");
                }
            });
        }
        catch (Exception e) {
            Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"onFinish", (String)"Unable to generate threadsafe report", (Throwable)e);
            IAPlugin.getDefault().logError("Unable to generate threadsafe report", (Throwable)e);
        }
        if (retrievingReportDataCompleted.get() && this.model.getReport().getSummaries().isEmpty()) {
            this.view.getLocationPage().setErrorMessage(Messages.getString("ThreadsafeReportWizard.report.generating.error"));
            Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"onFinish");
            return false;
        }
        try {
            if (retrievingReportDataCompleted.get()) {
                Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"onFinish");
                return this.saveReportAndOpenView();
            }
        }
        catch (Exception e) {
            Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"onFinish", (String)"Unable to generate threadsafe report", (Throwable)e);
            IAPlugin.getDefault().logError("Unable to generate threadsafe report", (Throwable)e);
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"onFinish");
        return retrievingReportDataCompleted.get();
    }

    private boolean saveReportAndOpenView() throws JAXBException, SAXException {
        String fileName = this.view.getLocationPage().getFileName();
        IContainer container = this.view.getLocationPage().getIContainer();
        boolean overwrite = this.view.getLocationPage().isOverwriting();
        try {
            ThreadsafeReportPresenterImpl presenter;
            IPath newFilePath = container.getLocation().append(fileName);
            String pathString = newFilePath.toOSString();
            File file = new File(pathString);
            if (overwrite) {
                file.delete();
            }
            file.createNewFile();
            ThreadsafeReportModelImpl threadsafeReportModel = ThreadsafeReportModelImpl.getInstance();
            this.model.getReport().getOptions().setCollectionId(this.view.getParametersPage().getCollectionIdText().getText());
            this.model.getReport().getOptions().setRegion(this.view.getParametersPage().getRegionText().getText().toUpperCase());
            this.model.getReport().getOptions().getResource().setValue(this.view.getParametersPage().getResourceTypeCombo().contextText.getText());
            this.model.getReport().getOptions().getResource().setType(this.view.getParametersPage().getResourceTypeCombo().getContext().isProgram() ? "PROGRAM" : "TRANSID");
            this.model.getReport().getOptions().setCicsTsLevel(this.view.getParametersPage().getCicsTsLevelCombo().getItem(this.view.getParametersPage().getCicsTsLevelCombo().getSelectionIndex()));
            threadsafeReportModel.saveReport(this.model.getReport(), file);
            ReportManager.removeReportManager(this.view.getLocationPage().getReportManager());
            NavigatorView navigatorView = Activator.findNavigatorView();
            if (navigatorView != null) {
                ReportExplorer reportExplorer = navigatorView.getReportExplorer();
                reportExplorer.refresh(container);
            }
            if ((presenter = ThreadsafeReportPresenterImpl.getInstance()).getModel() == null) {
                presenter.setModel((ThreadsafeReportModel)threadsafeReportModel);
                threadsafeReportModel.addListener((ThreadsafeReportModelListener)presenter);
            }
            ThreadsafeReportViewInput input = new ThreadsafeReportViewInput(presenter);
            IEditorPart editor = Activator.openEditor(input, "com.ibm.cics.ia.ui.ThreadsafeReportView", false);
            threadsafeReportModel.setReport(this.model.getReport());
            return true;
        }
        catch (IOException ex) {
            Debug.warning((Logger)logger, (String)CreateThreadsafeReportPresenterImpl.class.getName(), (String)"doSave", (String)Messages.getString("ThreadsafeReportWizard.save.error"), (Throwable)ex);
            IAPlugin.getDefault().logError(MessageFormat.format(Messages.getString("ThreadsafeReportWizard.save.error"), fileName), (Throwable)ex);
            return false;
        }
    }

    @Override
    public void setView(CreateThreadsafeReportView view) {
        this.view = view;
    }

    @Override
    public void setModel(CreateThreadsafeReportModel model) {
        this.model = model;
    }

    @Override
    public void onNextPressed() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"onNextPressed", (Object)("Thread ID: " + Thread.currentThread().getId()));
        IWizardPage page = this.view.getCurrentPage();
        if (page instanceof CreateThreadsafeReportParametersPage) {
            CreateThreadsafeReportParametersPage paramsPage = (CreateThreadsafeReportParametersPage)page;
            this.model.setCollectionId(this.userWildCards2DbWildCards(paramsPage.getCollectionIdText(), false));
            this.model.setApplId(this.userWildCards2DbWildCards(paramsPage.getRegionText(), true));
            if (paramsPage.getResourceTypeCombo().contextText.getText().isEmpty()) {
                this.model.setQueryArg(IAUtilities.DB2_WILD_STR);
                paramsPage.getResourceTypeCombo().contextText.setText(IAUtilities.USER_WILD_STR);
            } else {
                this.model.setQueryArg(paramsPage.getResourceTypeCombo().contextText.getText().toUpperCase().replace(IAUtilities.USER_WILD_STR, IAUtilities.DB2_WILD_STR));
            }
            if (paramsPage.getCicsTsLevelCombo().getItem(paramsPage.getCicsTsLevelCombo().getSelectionIndex()).equals(Messages.getString("ThreadsafeReportWizard.parameters.cicsTsLevel.region"))) {
                this.model.setCicsTsLevel(" ");
            } else {
                this.model.setCicsTsLevel(paramsPage.getCicsTsLevelCombo().getItem(paramsPage.getCicsTsLevelCombo().getSelectionIndex()));
            }
            if (paramsPage.getResourceTypeCombo().getContext().equals((Object)ExplorerQueryContext.PROGRAM)) {
                this.model.setCallType("PGMS");
            } else if (paramsPage.getResourceTypeCombo().getContext().equals((Object)ExplorerQueryContext.TRANSACTION)) {
                this.model.setCallType("TRNS");
            } else {
                this.model.setCallType("");
            }
            Activator.getDefault().ensureConnected();
            String errMsg = this.model.validateInput();
            if (errMsg != null) {
                this.view.getParametersPage().setErrorMessage(errMsg);
            } else {
                this.view.getParametersPage().setErrorMessage(null);
                this.view.getWizardDialog().nextButtonPressed();
            }
        } else {
            this.view.getWizardDialog().nextButtonPressed();
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"onNextPressed");
    }

    private String userWildCards2DbWildCards(Text hb, boolean upcasing) {
        String result;
        if (hb.getText().isEmpty()) {
            result = IAUtilities.DB2_WILD_STR;
            hb.setText(IAUtilities.USER_WILD_STR);
        } else {
            result = hb.getText().replace(IAUtilities.USER_WILD_STR, IAUtilities.DB2_WILD_STR);
            if (upcasing) {
                result = result.toUpperCase();
            }
        }
        return result;
    }

    @Override
    public void onLocationPageCreation() {
        this.view.getLocationPage().setPageComplete(false);
    }

    @Override
    public void onParametersPageCreation() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"onParametersPageCreation", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.model.getResource() != null) {
            if (this.model.getResource() instanceof Program) {
                this.view.getParametersPage().getResourceTypeCombo().setContext(ExplorerQueryContext.PROGRAM);
            } else if (this.model.getResource() instanceof Transaction) {
                this.view.getParametersPage().getResourceTypeCombo().setContext(ExplorerQueryContext.TRANSACTION);
            }
            this.view.getParametersPage().getResourceTypeCombo().contextText.setText(this.model.getResource().getName());
        } else {
            this.view.getParametersPage().getResourceTypeCombo().contextText.setText(IAUtilities.USER_WILD_STR);
        }
        if (this.model.getRegion() == null) {
            this.view.getParametersPage().getRegionText().setText(IAUtilities.USER_WILD_STR);
        } else {
            this.view.getParametersPage().getRegionText().setText(this.model.getRegion().getName());
        }
        if (IASQLCommand.getCollectionId().isEmpty()) {
            this.view.getParametersPage().getCollectionIdText().setText(IAUtilities.USER_WILD_STR);
        } else {
            this.view.getParametersPage().getCollectionIdText().setText(IASQLCommand.getCollectionId());
        }
        this.view.getParametersPage().getCollectionIdText().setEnabled(Version.getInstance().getDBVersion() >= 5100 || Version.getInstance().getDBVersion() == 0);
        this.view.getParametersPage().getRegionText().setEnabled(Version.getInstance().getDBVersion() >= 5100 || Version.getInstance().getDBVersion() == 0);
        this.view.getParametersPage().getResourceTypeCombo().contextText.setEnabled(Version.getInstance().getDBVersion() >= 5100 || Version.getInstance().getDBVersion() == 0);
        this.view.getParametersPage().getCicsTsLevelCombo().setItems(new String[]{Messages.getString("ThreadsafeReportWizard.parameters.cicsTsLevel.region"), "3.1", "3.2", "4.1", "4.2", "5.1", "5.2", "5.3", "5.5", "5.6", "6.1", "6.2", "6.3"});
        this.view.getParametersPage().getCicsTsLevelCombo().select(0);
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"onParametersPageCreation");
    }

    @Override
    public void onBackPressed() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"onBackPressed", (Object)("Thread ID: " + Thread.currentThread().getId()));
        IWizardPage page = this.view.getCurrentPage();
        this.view.getLocationPage().setErrorMessage(null);
        this.view.getWizardDialog().backButtonPressed();
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"onBackPressed");
    }

    @Override
    public boolean canFinish() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"canFinish", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.view.getCurrentPage() == this.view.getLocationPage()) {
            Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"canFinish");
            return this.view.getLocationPage().isPageComplete();
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"canFinish");
        return false;
    }

    @Override
    public void onLocationPageFocusOut() {
        this.view.getLocationPage().setPageComplete(IAUtilities.isValidFilename((String)this.view.getLocationPage().getNewFileName()));
    }

    @Override
    public CreateThreadsafeReportView getView() {
        return this.view;
    }

    @Override
    public CreateThreadsafeReportModel getModel() {
        return this.model;
    }
}

