/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.eclipse.common.ui.JobWithCancelingSupport;
import com.ibm.cics.ia.controller.DisplayableData;
import com.ibm.cics.ia.model.ExecutionAnalyzer;
import com.ibm.cics.ia.model.Interaction;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.model.Verb;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.CollectionIdWidget;
import com.ibm.cics.ia.ui.DefaultEditorInputImpl;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.ResourceRenderer;
import com.ibm.cics.ia.ui.ResourceTypeRenderer;
import com.ibm.cics.ia.ui.TreeSelectionProvider;
import com.ibm.cics.ia.ui.UIUtilities;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class ComparisonEditor
extends EditorPart {
    static final String COPYRIGHT = "Licensed Materials - (c) Copyright HCL Technologies Ltd. *2025..";
    private static final Logger logger = Logger.getLogger(ComparisonEditor.class.getPackage().getName());
    public static final String ID = "com.ibm.cics.ia.ui.comparisonresourceseditor";
    private static final String VERBS_LIST = "VERBS_LIST";
    private static final String TEXT = "TEXT";
    private static final String TARGET_CHILDREN = "TARGET_CHILDREN";
    protected static final String VERB = "VERB";
    private static final String SOURCES = "SOURCES";
    private Tree leftBackupTreeObject;
    private Tree rightBackupTreeObject;
    private ConnectionServiceListener connectionServiceListener;
    private Composite parent;
    private SashForm resourcesSash;
    private ToolBar topToolBar;
    private Tree resourcesTreeLeft;
    private TreeSelectionProvider selectionProvider;
    private Map itemsMap = new HashMap();
    private Tree resourcesTreeRight;
    private Job executionJob;
    private Job executeRightResourceJob;
    private ExecutionAnalyzer currentAnalyzer;
    private ExecutionAnalyzer currentRightResourceAnalyzer;
    private List<Resource> selectedResources = new ArrayList<Resource>();
    private ExecutionAnalyzer.Listener executionAnalyzerListener;
    private ExecutionAnalyzer.Listener executionAnalyzerListenerForRightRes;
    private Map<Resource, List<TreeItem>> resourceToItems = new HashMap<Resource, List<TreeItem>>();
    private List<ExecutionAnalyzer.ResourceAnalysis> analysedResourcesToProcess = new ArrayList<ExecutionAnalyzer.ResourceAnalysis>();
    private List<ExecutionAnalyzer.ResourceAnalysis> analysedResourcesToProcessForRightres = new ArrayList<ExecutionAnalyzer.ResourceAnalysis>();
    private String leftCollectionID;
    private String rightCollectionID;
    private Region leftRegion;
    private Transaction leftTransaction;
    private Region rightRegion;
    private String rightRegionTxt;
    private Transaction rightTransaction;
    private String rightTransactionTxt;
    private TreeColumn resourcesLeftTreeCol1;
    private TreeColumn resourcesTreeRightCol1;
    private ToolItem defaultToolItem;
    private String defaultCollectionId;
    public static final DefaultEditorInputImpl DEFAULT_EDITOR_INPUT = new DefaultEditorInputImpl(){};

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"init", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (DEFAULT_EDITOR_INPUT != input) {
            throw new PartInitException("Invalid Input: Must be ComparisonEditor.DEFAULT_EDITOR_INPUT");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"init");
    }

    protected Job execute(ExecutionAnalyzer executionAnalyzer) {
        Debug.enter((Logger)logger, (String)ComparisonEditor.class.getName(), (String)"execute", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.clear();
        if (!this.parent.isDisposed()) {
            this.parent.setCursor(this.parent.getDisplay().getSystemCursor(3));
        }
        final String searchText = DisplayableData.getDisplayableData((IAdaptable)executionAnalyzer).getDescription();
        if (this.executionJob != null) {
            this.executionJob.cancel();
            try {
                this.executionJob.join();
            }
            catch (InterruptedException e1) {
                logger.throwing(((Object)((Object)this)).getClass().getName(), "execute", e1);
            }
            this.executionJob = null;
            if (this.currentAnalyzer != null) {
                this.currentAnalyzer.removeListener(this.getExecutionAnalyzerListener(this.resourcesTreeLeft));
                if (this.currentAnalyzer.status() == 0) {
                    UIUtilities.cancel((Command)this.currentAnalyzer);
                }
            }
        }
        this.defaultCollectionId = Activator.getDefault().getCollectionIdWidget().getCollectionId();
        CollectionIdWidget collectionIDWidget = Activator.getDefault().getCollectionIdWidget();
        collectionIDWidget.setCollectionId(this.leftCollectionID);
        this.currentAnalyzer = executionAnalyzer;
        this.currentAnalyzer.addListener(this.getExecutionAnalyzerListener(this.resourcesTreeLeft));
        if (this.currentAnalyzer.status() == -1) {
            this.executionJob = new JobWithCancelingSupport(searchText){

                protected IStatus runSub(IProgressMonitor monitor) {
                    monitor.beginTask(searchText, -1);
                    ComparisonEditor.this.currentAnalyzer.start();
                    monitor.done();
                    ComparisonEditor.this.updateVerbTreeChildItems(ComparisonEditor.this.resourcesTreeLeft);
                    IAPlugin.getDefault().taskEnded();
                    Job executeAnotherJob = ComparisonEditor.this.executeAnotherJob();
                    executeAnotherJob.schedule();
                    return Status.OK_STATUS;
                }

                protected void cancelingSub() {
                    super.canceling();
                    IAPlugin.getDefault().taskEnded();
                    UIUtilities.cancel((Command)ComparisonEditor.this.currentAnalyzer);
                }
            };
            UIUtilities.scheduleWorkbenchPartJob((IWorkbenchPart)this, this.executionJob);
        } else {
            if (!this.parent.isDisposed()) {
                this.parent.setCursor(null);
            }
            this.currentAnalyzer.removeListener(this.getExecutionAnalyzerListener(this.resourcesTreeLeft));
        }
        Debug.exit((Logger)logger, (String)ComparisonEditor.class.getName(), (String)"execute");
        return this.executionJob;
    }

    private Job executeAnotherJob() {
        Debug.enter((Logger)logger, (String)ComparisonEditor.class.getName(), (String)"executeAnotherJob", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.itemsMap.clear();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!ComparisonEditor.this.parent.isDisposed()) {
                    ComparisonEditor.this.parent.setCursor(ComparisonEditor.this.parent.getDisplay().getSystemCursor(3));
                }
            }
        });
        this.currentAnalyzer.clear();
        this.currentAnalyzer.clearInteractions();
        ResourceFactory.getSingleton().clear();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                CollectionIdWidget collectionIDWidget = Activator.getDefault().getCollectionIdWidget();
                collectionIDWidget.setCollectionId(ComparisonEditor.this.rightCollectionID);
            }
        });
        this.rightRegion = ResourceFactory.getSingleton().getRegion(this.rightRegionTxt);
        this.rightTransaction = ResourceFactory.getSingleton().getTransaction(this.rightTransactionTxt);
        ExecutionAnalyzer executionAnalyzer = new ExecutionAnalyzer();
        executionAnalyzer.setRoot((Resource)this.rightTransaction);
        executionAnalyzer.setRegion(this.rightRegion);
        DisplayableData rightDisplayableData = DisplayableData.getDisplayableData((IAdaptable)executionAnalyzer);
        rightDisplayableData.setImage(ImageFactory.getUsesImage());
        rightDisplayableData.setDescription(MessageFormat.format(Messages.getString("ExecutionTree.desc.inregion"), ResourceRenderer.asQualifiedName((Resource)this.rightTransaction), this.rightRegion.getName()));
        final String searchText = DisplayableData.getDisplayableData((IAdaptable)executionAnalyzer).getDescription();
        if (this.executeRightResourceJob != null) {
            this.executeRightResourceJob.cancel();
            try {
                this.executeRightResourceJob.join();
            }
            catch (InterruptedException e1) {
                logger.throwing(((Object)((Object)this)).getClass().getName(), "executeAnotherJob", e1);
            }
            this.executeRightResourceJob = null;
            if (this.currentRightResourceAnalyzer != null) {
                this.currentRightResourceAnalyzer.removeListener(this.getExecutionAnalyzerListenerForRightRes(this.resourcesTreeRight));
                if (this.currentRightResourceAnalyzer.status() == 0) {
                    UIUtilities.cancel((Command)this.currentRightResourceAnalyzer);
                }
            }
        }
        this.currentRightResourceAnalyzer = executionAnalyzer;
        this.currentRightResourceAnalyzer.addListener(this.getExecutionAnalyzerListenerForRightRes(this.resourcesTreeRight));
        if (this.currentRightResourceAnalyzer.status() == -1) {
            this.executeRightResourceJob = new JobWithCancelingSupport(searchText){

                protected IStatus runSub(IProgressMonitor monitor) {
                    monitor.beginTask(searchText, -1);
                    ComparisonEditor.this.currentRightResourceAnalyzer.start();
                    monitor.done();
                    ComparisonEditor.this.updateVerbTreeChildItems(ComparisonEditor.this.resourcesTreeRight);
                    IAPlugin.getDefault().taskEnded();
                    ComparisonEditor.this.setOrRemoveCollectionID();
                    return Status.OK_STATUS;
                }

                protected void cancelingSub() {
                    super.canceling();
                    IAPlugin.getDefault().taskEnded();
                    UIUtilities.cancel((Command)ComparisonEditor.this.currentRightResourceAnalyzer);
                    ComparisonEditor.this.setOrRemoveCollectionID();
                }
            };
            UIUtilities.scheduleWorkbenchPartJob((IWorkbenchPart)this, this.executeRightResourceJob);
        } else {
            if (!this.parent.isDisposed()) {
                this.parent.setCursor(null);
            }
            this.currentRightResourceAnalyzer.removeListener(this.getExecutionAnalyzerListenerForRightRes(this.resourcesTreeRight));
        }
        Debug.exit((Logger)logger, (String)ComparisonEditor.class.getName(), (String)"executeAnotherJob");
        return this.executeRightResourceJob;
    }

    private void setOrRemoveCollectionID() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                CollectionIdWidget collectionIDWidget = Activator.getDefault().getCollectionIdWidget();
                if (ComparisonEditor.this.defaultCollectionId != null && ComparisonEditor.this.defaultCollectionId != "") {
                    collectionIDWidget.setCollectionId(ComparisonEditor.this.defaultCollectionId);
                } else {
                    collectionIDWidget.resetCollectionId();
                }
            }
        });
    }

    public void createPartControl(Composite parentComposite) {
        Debug.enter((Logger)logger, (String)ComparisonEditor.class.getName(), (String)"createPartControl", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.parent = parentComposite;
        this.parent.setLayout((Layout)new GridLayout(1, false));
        this.topToolBar = UIUtilities.createToolBar(this.parent);
        Composite topResourcesComposite = new Composite(this.parent, 0);
        GridData data = new GridData(4, 4, true, true);
        topResourcesComposite.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 2;
        topResourcesComposite.setLayout((Layout)gridLayout);
        this.resourcesSash = new SashForm(topResourcesComposite, 256);
        data = new GridData(4, 4, true, true);
        this.resourcesSash.setLayoutData((Object)data);
        this.resourcesTreeLeft = new Tree((Composite)this.resourcesSash, 2564);
        this.resourcesLeftTreeCol1 = new TreeColumn(this.resourcesTreeLeft, 0);
        this.resourcesTreeLeft.setHeaderVisible(true);
        this.resourcesTreeLeft.setLinesVisible(true);
        this.resourcesTreeLeft.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ComparisonEditor.this.resourcesLeftTreeCol1.setWidth(((ComparisonEditor)ComparisonEditor.this).resourcesTreeLeft.getClientArea().width);
            }
        });
        this.resourcesTreeRight = new Tree((Composite)this.resourcesSash, 2564);
        this.resourcesTreeRightCol1 = new TreeColumn(this.resourcesTreeRight, 0);
        this.resourcesTreeRight.setHeaderVisible(true);
        this.resourcesTreeRight.setLinesVisible(true);
        this.resourcesTreeRight.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ComparisonEditor.this.resourcesTreeRightCol1.setWidth(((ComparisonEditor)ComparisonEditor.this).resourcesTreeRight.getClientArea().width);
            }
        });
        this.resourcesSash.setWeights(new int[]{50, 50});
        this.loadActionsAndResources();
        this.connectionServiceListener = this.getConnectionServiceListener();
        ConnectionsPlugin.getDefault().getConnectionService().addConnectionServiceListener(this.connectionServiceListener);
        Debug.exit((Logger)logger, (String)ComparisonEditor.class.getName(), (String)"createPartControl");
    }

    private void loadActionsAndResources() {
        Debug.enter((Logger)logger, (String)ComparisonEditor.class.getName(), (String)"loadActionsAndResources", (Object)("Thread ID: " + Thread.currentThread().getId()));
        ToolItem collapseAllToolItem = new ToolItem(this.topToolBar, 8);
        collapseAllToolItem.setImage(ImageDescriptor.createFromImage((Image)ImageFactory.getCollapseImage()).createImage());
        collapseAllToolItem.setToolTipText(Messages.getString("Button.tooltip.collapseAll"));
        collapseAllToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                UIUtilities.expandTree(ComparisonEditor.this.resourcesTreeLeft, false);
                UIUtilities.expandTree(ComparisonEditor.this.resourcesTreeRight, false);
            }
        });
        ToolItem expandAllToolItem = new ToolItem(this.topToolBar, 8);
        expandAllToolItem.setImage(ImageDescriptor.createFromImage((Image)ImageFactory.getExpandImage()).createImage());
        expandAllToolItem.setToolTipText(Messages.getString("Button.tooltip.expandAll"));
        expandAllToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                UIUtilities.expandTree(ComparisonEditor.this.resourcesTreeLeft, true);
                UIUtilities.expandTree(ComparisonEditor.this.resourcesTreeRight, true);
            }
        });
        ToolItem similarToolItem = new ToolItem(this.topToolBar, 8);
        similarToolItem.setImage(ImageDescriptor.createFromImage((Image)ImageFactory.getCompareResourceSimilarImage()).createImage());
        similarToolItem.setToolTipText(Messages.getString("Button.tooltip.similarResources"));
        similarToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ComparisonEditor.this.defaultToolItem.notifyListeners(13, new Event());
                ComparisonEditor.this.filterTreeBasedOnSimialarObj(ComparisonEditor.this.resourcesTreeLeft, Display.getDefault());
                ComparisonEditor.this.filterTreeBasedOnSimialarObj(ComparisonEditor.this.resourcesTreeRight, Display.getDefault());
            }
        });
        ToolItem distinctToolItem = new ToolItem(this.topToolBar, 8);
        distinctToolItem.setImage(ImageDescriptor.createFromImage((Image)ImageFactory.getDifferenceImage()).createImage());
        distinctToolItem.setToolTipText(Messages.getString("Button.tooltip.variantResources"));
        distinctToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ComparisonEditor.this.defaultToolItem.notifyListeners(13, new Event());
                ComparisonEditor.this.filterTreeBasedOnDistinctObj(ComparisonEditor.this.resourcesTreeLeft, Display.getDefault());
                ComparisonEditor.this.filterTreeBasedOnDistinctObj(ComparisonEditor.this.resourcesTreeRight, Display.getDefault());
            }
        });
        this.defaultToolItem = new ToolItem(this.topToolBar, 8);
        this.defaultToolItem.setImage(ImageDescriptor.createFromImage((Image)ImageFactory.getAllImage()).createImage());
        this.defaultToolItem.setToolTipText(Messages.getString("Button.tooltip.defaultResources"));
        this.defaultToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ComparisonEditor.this.resourcesTreeLeft.removeAll();
                ComparisonEditor.this.resourcesTreeRight.removeAll();
                ComparisonEditor.this.copyBackAllItemToLeftTree();
                ComparisonEditor.this.copyBackAllItemToRightTree();
            }
        });
        this.topToolBar.pack();
    }

    private void copyBackAllItemToLeftTree() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                TreeItem[] treeItemArray = ComparisonEditor.this.leftBackupTreeObject.getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem originalItem = treeItemArray[n2];
                    ComparisonEditor.this.copyTreeItem(originalItem, ComparisonEditor.this.resourcesTreeLeft);
                    ++n2;
                }
            }
        });
    }

    private void copyBackAllItemToRightTree() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                TreeItem[] treeItemArray = ComparisonEditor.this.rightBackupTreeObject.getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem originalItem = treeItemArray[n2];
                    ComparisonEditor.this.copyTreeItem(originalItem, ComparisonEditor.this.resourcesTreeRight);
                    ++n2;
                }
            }
        });
    }

    private void filterTreeBasedOnSimialarObj(TreeItem item, Display display) {
        TreeItem[] treeItemArray = item.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            if (child.getForeground().getRGB().equals((Object)display.getSystemColor(3).getRGB())) {
                child.dispose();
            } else {
                this.filterTreeBasedOnSimialarObj(child, display);
            }
            ++n2;
        }
    }

    private void filterTreeBasedOnSimialarObj(Tree tree, Display display) {
        TreeItem[] treeItemArray = tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getForeground().getRGB().equals((Object)display.getSystemColor(3).getRGB())) {
                item.dispose();
            } else {
                this.filterTreeBasedOnSimialarObj(item, display);
            }
            ++n2;
        }
    }

    private synchronized void filterTreeBasedOnDistinctObj(Tree tree, Display display) {
        TreeItem[] treeItemArray = tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem root = treeItemArray[n2];
            boolean isFirstLevelAllSimilar = true;
            boolean isSecondLevelAllSimilar = true;
            char rootLevelTextLastChar = root.getText().charAt(root.getText().length() - 1);
            if (!root.getForeground().getRGB().equals((Object)display.getSystemColor(3).getRGB())) {
                if (rootLevelTextLastChar == '*') {
                    isFirstLevelAllSimilar = false;
                }
                TreeItem[] treeItemArray2 = root.getItems();
                int n3 = treeItemArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    TreeItem firstLevelItem = treeItemArray2[n4];
                    char firstLevelTextLastChar = firstLevelItem.getText().charAt(firstLevelItem.getText().length() - 1);
                    if (firstLevelItem.getForeground().getRGB().equals((Object)display.getSystemColor(3).getRGB())) {
                        isFirstLevelAllSimilar = false;
                    } else {
                        isSecondLevelAllSimilar = true;
                        if (firstLevelTextLastChar == '*') {
                            isSecondLevelAllSimilar = false;
                        }
                        TreeItem[] treeItemArray3 = firstLevelItem.getItems();
                        int n5 = treeItemArray3.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            TreeItem secondLevelItem = treeItemArray3[n6];
                            char secondLevelTextLastChar = secondLevelItem.getText().charAt(secondLevelItem.getText().length() - 1);
                            if (secondLevelItem.getForeground().getRGB().equals((Object)display.getSystemColor(2).getRGB()) && secondLevelTextLastChar != '*') {
                                secondLevelItem.dispose();
                            } else if (secondLevelItem.getForeground().getRGB().equals((Object)display.getSystemColor(2).getRGB()) && secondLevelTextLastChar == '*') {
                                TreeItem[] treeItemArray4 = secondLevelItem.getItems();
                                int n7 = treeItemArray4.length;
                                int n8 = 0;
                                while (n8 < n7) {
                                    TreeItem thirdLevelItem = treeItemArray4[n8];
                                    if (thirdLevelItem.getForeground().getRGB().equals((Object)display.getSystemColor(2).getRGB())) {
                                        thirdLevelItem.dispose();
                                    }
                                    ++n8;
                                }
                                isSecondLevelAllSimilar = false;
                            } else if (secondLevelItem.getForeground().getRGB().equals((Object)display.getSystemColor(3).getRGB())) {
                                isSecondLevelAllSimilar = false;
                            }
                            ++n6;
                        }
                        if (isSecondLevelAllSimilar) {
                            firstLevelItem.dispose();
                        } else {
                            isFirstLevelAllSimilar = false;
                        }
                    }
                    ++n4;
                }
                if (isFirstLevelAllSimilar && isSecondLevelAllSimilar) {
                    root.dispose();
                }
            }
            ++n2;
        }
    }

    public void setFocus() {
    }

    public void dispose() {
        Debug.enter((Logger)logger, (String)ComparisonEditor.class.getName(), (String)"dispose", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.connectionServiceListener != null) {
            this.connectionServiceListener.makeStale();
        }
        super.dispose();
        Debug.exit((Logger)logger, (String)ComparisonEditor.class.getName(), (String)"dispose");
    }

    private ExecutionAnalyzer.Listener getExecutionAnalyzerListener(final Tree resourcesTreeLeft) {
        if (this.executionAnalyzerListener == null) {
            this.executionAnalyzerListener = new ExecutionAnalyzer.Listener(){

                public void completed() {
                    Debug.enter((Logger)logger, (String)"ComparisonEditor.getExecutionAnalyzerListener", (String)"completed", (Object)("Thread ID: " + Thread.currentThread().getId()));
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!ComparisonEditor.this.parent.isDisposed()) {
                                ComparisonEditor.this.parent.setCursor(null);
                            }
                            ComparisonEditor.this.currentAnalyzer.removeListener(ComparisonEditor.this.getExecutionAnalyzerListener(resourcesTreeLeft));
                        }
                    });
                    Debug.exit((Logger)logger, (String)"ComparisonEditor.getExecutionAnalyzerListener", (String)"completed");
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void resourceAnalyzed(ExecutionAnalyzer.ResourceAnalysis aResourceAnalysis) {
                    16 var2_2 = this;
                    synchronized (var2_2) {
                        ComparisonEditor.this.analysedResourcesToProcess.add(aResourceAnalysis);
                    }
                }

                public void itemsAdded(final Collection interactions) {
                    Display.getDefault().syncExec(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Debug.enter((Logger)logger, (String)"ComparisonEditor.getExecutionAnalyzerListener.itemsAdded", (String)"syncExec", (Object)("Thread ID: " + Thread.currentThread().getId()));
                            2 var1_1 = this;
                            synchronized (var1_1) {
                                ((ComparisonEditor)(this).ComparisonEditor.this).currentAnalyzer.totalInteractions.addAll(interactions);
                                ComparisonEditor.this.insertResources(interactions, resourcesTreeLeft);
                                ComparisonEditor.this.updateRootTreeItems(false, resourcesTreeLeft);
                            }
                            Debug.exit((Logger)logger, (String)"ComparisonEditor.getExecutionAnalyzerListener.itemsAdded", (String)"syncExec");
                        }
                    });
                }

                public void resourceComplete(Resource r) {
                }
            };
        }
        return this.executionAnalyzerListener;
    }

    private ExecutionAnalyzer.Listener getExecutionAnalyzerListenerForRightRes(final Tree resourcesTreeRight) {
        if (this.executionAnalyzerListenerForRightRes == null) {
            this.executionAnalyzerListenerForRightRes = new ExecutionAnalyzer.Listener(){

                public void completed() {
                    Debug.enter((Logger)logger, (String)"ComparisonEditor.getExecutionAnalyzerListenerForRightRes", (String)"completed", (Object)("Thread ID: " + Thread.currentThread().getId()));
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!ComparisonEditor.this.parent.isDisposed()) {
                                ComparisonEditor.this.parent.setCursor(null);
                            }
                            ComparisonEditor.this.currentRightResourceAnalyzer.removeListener(ComparisonEditor.this.getExecutionAnalyzerListenerForRightRes(resourcesTreeRight));
                        }
                    });
                    Debug.exit((Logger)logger, (String)"ComparisonEditor.getExecutionAnalyzerListenerForRightRes", (String)"completed");
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void resourceAnalyzed(ExecutionAnalyzer.ResourceAnalysis aResourceAnalysis) {
                    17 var2_2 = this;
                    synchronized (var2_2) {
                        ComparisonEditor.this.analysedResourcesToProcessForRightres.add(aResourceAnalysis);
                    }
                }

                public void itemsAdded(final Collection interactions) {
                    Display.getDefault().syncExec(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Debug.enter((Logger)logger, (String)"ComparisonEditor.getExecutionAnalyzerListenerForRightRes.itemsAdded", (String)"syncExec", (Object)("Thread ID: " + Thread.currentThread().getId()));
                            2 var1_1 = this;
                            synchronized (var1_1) {
                                ((ComparisonEditor)(this).ComparisonEditor.this).currentRightResourceAnalyzer.totalInteractions.addAll(interactions);
                                ComparisonEditor.this.insertResources(interactions, resourcesTreeRight);
                                ComparisonEditor.this.updateRootTreeItems(false, resourcesTreeRight);
                            }
                            Debug.exit((Logger)logger, (String)"ComparisonEditor.getExecutionAnalyzerListenerForRightRes.itemsAdded", (String)"syncExec");
                        }
                    });
                }

                public void resourceComplete(Resource r) {
                }
            };
        }
        return this.executionAnalyzerListenerForRightRes;
    }

    private void updateVerbTreeChildItems(final Tree resourceTree) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                TreeItem[] getFolderItems;
                TreeItem[] treeItemArray = getFolderItems = resourceTree.getItems();
                int n = getFolderItems.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem[] resourceItems;
                    TreeItem folderItem = treeItemArray[n2];
                    TreeItem[] treeItemArray2 = resourceItems = folderItem.getItems();
                    int n3 = resourceItems.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TreeItem[] verbItems;
                        TreeItem resourceItem = treeItemArray2[n4];
                        TreeItem[] treeItemArray3 = verbItems = resourceItem.getItems();
                        int n5 = verbItems.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            TreeItem verbItem = treeItemArray3[n6];
                            List sources = (List)verbItem.getData(ComparisonEditor.SOURCES);
                            for (Object object : sources) {
                                Resource resource = (Resource)object;
                                TreeItem verbResourceItem = new TreeItem(verbItem, 0);
                                verbResourceItem.setData("RESOURCE", (Object)resource);
                                verbResourceItem.setText(ResourceRenderer.asText(resource));
                                boolean eventable = resource.isEventable();
                                verbResourceItem.setImage(ResourceRenderer.getOverLaidImage(ResourceRenderer.asImage(resource), false, false, eventable));
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        });
    }

    private String getItemText(TreeItem aTreeItem) {
        String itemText = (String)aTreeItem.getData(TEXT);
        if (itemText == null) {
            itemText = aTreeItem.getText();
            aTreeItem.setData(TEXT, (Object)itemText);
        }
        return itemText;
    }

    private void updateRootTreeItems(boolean isComplete, Tree resourceTree) {
        Debug.enter((Logger)logger, (String)ComparisonEditor.class.getName(), (String)"updateRootTreeItems", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (!this.parent.isDisposed()) {
            int totalResources = 0;
            TreeItem[] typeItems = resourceTree.getItems();
            int i = 0;
            while (i < typeItems.length) {
                int resourceCountForType = 0;
                TreeItem[] childItems = typeItems[i].getItems();
                List<Object> resources = new ArrayList();
                int j = 0;
                while (j < childItems.length) {
                    String childText = this.getItemText(childItems[j]);
                    resources.add(childItems[j].getData("RESOURCE"));
                    ++j;
                }
                resources = IAUtilities.asUniqueCollection(resources);
                totalResources += resources.size();
                String itemText = this.getItemText(typeItems[i]);
                typeItems[i].setText(String.valueOf(itemText) + "  (" + (resourceCountForType += resources.size()) + ")");
                ++i;
            }
        }
        Debug.exit((Logger)logger, (String)ComparisonEditor.class.getName(), (String)"updateRootTreeItems");
    }

    private Map getMapChildren(TreeItem treeItem, String dataKey) {
        Debug.enter((Logger)logger, (String)ComparisonEditor.class.getName(), (String)"getMapChildren", (Object)("Thread ID: " + Thread.currentThread().getId()));
        HashMap mapChildren = (HashMap)treeItem.getData(dataKey);
        if (mapChildren == null) {
            mapChildren = new HashMap();
            treeItem.setData(dataKey, mapChildren);
        }
        Debug.exit((Logger)logger, (String)ComparisonEditor.class.getName(), (String)"getMapChildren");
        return mapChildren;
    }

    private synchronized void insertResources(Collection interactions, Tree resourcesTree) {
        Debug.enter((Logger)logger, (String)ComparisonEditor.class.getName(), (String)"insertResources", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (!this.parent.isDisposed()) {
            Iterator iterator = Interaction.getTargetsAndVerbsAndSourcesByType((Collection)interactions).entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o1;
                Map.Entry targetAndVerbsByType = o1 = iterator.next();
                String type = (String)targetAndVerbsByType.getKey();
                TreeItem typeItem = this.getTypeItem(type, resourcesTree);
                Map targetChildren = this.getMapChildren(typeItem, TARGET_CHILDREN);
                Iterator iterator2 = ((Map)targetAndVerbsByType.getValue()).entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry o2;
                    Map.Entry targetAndVerbs = o2 = iterator2.next();
                    Resource target = (Resource)targetAndVerbs.getKey();
                    Map targets = (Map)targetAndVerbs.getValue();
                    TreeItem targetItem = (TreeItem)targetChildren.get(target);
                    if (targetItem == null) {
                        boolean eventable = target.isEventable();
                        targetItem = UIUtilities.createEBCDICSortedTreeItem(typeItem, ResourceRenderer.asText(target), ResourceRenderer.getOverLaidImage(ResourceRenderer.asImage(target), false, false, eventable));
                        targetChildren.put(target, targetItem);
                        targetItem.setData("RESOURCE", (Object)target);
                    }
                    Map verbs = this.getMapChildren(targetItem, VERBS_LIST);
                    for (Map.Entry o3 : targets.entrySet()) {
                        Map.Entry entry = o3;
                        Verb verb = (Verb)entry.getKey();
                        TreeItem verbItem = (TreeItem)verbs.get(verb);
                        if (verbItem == null) {
                            String verbName = verb.getName().trim();
                            if (verbName.isEmpty()) {
                                verbName = "INIT";
                            }
                            String appendixText = "";
                            if (this.currentAnalyzer != null && this.currentAnalyzer.getRegion() != null && verb.getRemoteName() != null && verb.getRemoteSysid() != null) {
                                appendixText = " (" + verb.getRemoteName() + ", " + verb.getRemoteSysid() + ")";
                            }
                            if (this.currentRightResourceAnalyzer != null && this.currentRightResourceAnalyzer.getRegion() != null && verb.getRemoteName() != null && verb.getRemoteSysid() != null) {
                                appendixText = " (" + verb.getRemoteName() + ", " + verb.getRemoteSysid() + ")";
                            }
                            verbItem = UIUtilities.createEBCDICSortedTreeItem(targetItem, String.valueOf(verbName) + appendixText, ImageFactory.getVerbImage());
                            verbItem.setData(VERB, (Object)verb);
                            verbItem.setData(SOURCES, entry.getValue());
                            verbs.put(verb, verbItem);
                            continue;
                        }
                        List sources = (List)verbItem.getData(SOURCES);
                        Collection newValues = (Collection)entry.getValue();
                        for (Object o4 : newValues) {
                            Resource current = (Resource)o4;
                            if (sources.contains(current)) continue;
                            sources.add(current);
                        }
                    }
                }
            }
        }
        Debug.exit((Logger)logger, (String)ComparisonEditor.class.getName(), (String)"insertResources");
    }

    private TreeItem getTypeItem(String type, Tree resourcesTree) {
        Debug.enter((Logger)logger, (String)ComparisonEditor.class.getName(), (String)"getTypeItem", (Object)("Thread ID: " + Thread.currentThread().getId()));
        TreeItem typeItem = (TreeItem)this.itemsMap.get(type);
        if (typeItem == null) {
            typeItem = new TreeItem(resourcesTree, 0);
            typeItem.setText(ResourceTypeRenderer.asText(type));
            typeItem.setImage(ResourceTypeRenderer.asImage(type));
            this.itemsMap.put(type, typeItem);
        }
        Debug.exit((Logger)logger, (String)ComparisonEditor.class.getName(), (String)"getTypeItem");
        return typeItem;
    }

    private void clearChildTreeItems(TreeItem ti) {
        TreeItem[] children = ti.getItems();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
    }

    public void setInput(HashMap<String, Map<String, String>> selectedResources, Map<String, String> collectionIDMap) {
        Debug.enter((Logger)logger, (String)ComparisonEditor.class.getName(), (String)"setInput", (Object)("Thread ID: " + Thread.currentThread().getId()));
        for (String key : selectedResources.keySet()) {
            if (key.equals("LeftResource")) {
                Map<String, String> leftMap = selectedResources.get(key);
                this.leftRegion = ResourceFactory.getSingleton().getRegion(leftMap.get("REGION"));
                this.leftTransaction = ResourceFactory.getSingleton().getTransaction(leftMap.get("TRANSACTION"));
                continue;
            }
            Map<String, String> rightMap = selectedResources.get(key);
            this.rightRegionTxt = rightMap.get("REGION");
            this.rightTransactionTxt = rightMap.get("TRANSACTION");
        }
        for (String key : collectionIDMap.keySet()) {
            if (key.equals("LeftCollectionID")) {
                this.leftCollectionID = collectionIDMap.get(key);
                continue;
            }
            this.rightCollectionID = collectionIDMap.get(key);
        }
        ExecutionAnalyzer leftExecutionAnalyzer = new ExecutionAnalyzer();
        leftExecutionAnalyzer.setRoot((Resource)this.leftTransaction);
        leftExecutionAnalyzer.setRegion(this.leftRegion);
        DisplayableData displayableData = DisplayableData.getDisplayableData((IAdaptable)leftExecutionAnalyzer);
        displayableData.setImage(ImageFactory.getUsesImage());
        this.resourcesLeftTreeCol1.setText(this.leftRegion.getName().concat(" -> ").concat(this.leftCollectionID.concat(" -> ").concat(this.leftTransaction.getName())));
        this.resourcesTreeRightCol1.setText(this.rightRegionTxt.concat(" -> ").concat(this.rightCollectionID.concat(" -> ").concat(this.rightTransactionTxt)));
        displayableData.setDescription(MessageFormat.format(Messages.getString("ExecutionTree.desc.inregion"), ResourceRenderer.asQualifiedName((Resource)this.leftTransaction), this.leftRegion.getName()));
        JobChangeAdapter jobListener = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getJob() == ComparisonEditor.this.executeRightResourceJob) {
                    if (event.getResult().isOK()) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                int startIndex;
                                TreeItem item1;
                                HashMap<String, TreeItem[]> leftTreeItemsMap = new HashMap<String, TreeItem[]>();
                                HashMap<String, TreeItem[]> rightTreeItemsMap = new HashMap<String, TreeItem[]>();
                                TreeItem[] treeItemArray = ComparisonEditor.this.resourcesTreeLeft.getItems();
                                int n = treeItemArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    item1 = treeItemArray[n2];
                                    if (item1.getItemCount() >= 0) {
                                        startIndex = item1.getText().indexOf(40);
                                        leftTreeItemsMap.put(item1.getText().substring(0, startIndex), item1.getItems());
                                    }
                                    ++n2;
                                }
                                treeItemArray = ComparisonEditor.this.resourcesTreeRight.getItems();
                                n = treeItemArray.length;
                                n2 = 0;
                                while (n2 < n) {
                                    item1 = treeItemArray[n2];
                                    if (item1.getItemCount() >= 0) {
                                        startIndex = item1.getText().indexOf(40);
                                        rightTreeItemsMap.put(item1.getText().substring(0, startIndex), item1.getItems());
                                    }
                                    ++n2;
                                }
                                for (String key : leftTreeItemsMap.keySet()) {
                                    if (rightTreeItemsMap.containsKey(key)) {
                                        TreeItem item12;
                                        TreeItem[] leftTreeItemsArray;
                                        boolean thereIsADiff = false;
                                        TreeItem[] rightTreeItemsArray = (TreeItem[])rightTreeItemsMap.get(key);
                                        if (rightTreeItemsArray.length != (leftTreeItemsArray = (TreeItem[])leftTreeItemsMap.get(key)).length) {
                                            thereIsADiff = true;
                                        }
                                        HashMap<String, TreeItem[]> leftTreeItemsChildMap = new HashMap<String, TreeItem[]>();
                                        HashMap<String, TreeItem[]> rightTreeItemChildsMap = new HashMap<String, TreeItem[]>();
                                        TreeItem[] treeItemArray2 = leftTreeItemsArray;
                                        int n3 = leftTreeItemsArray.length;
                                        int n4 = 0;
                                        while (n4 < n3) {
                                            item12 = treeItemArray2[n4];
                                            if (item12.getItemCount() > 0) {
                                                leftTreeItemsChildMap.put(item12.getText(), item12.getItems());
                                            }
                                            ++n4;
                                        }
                                        treeItemArray2 = rightTreeItemsArray;
                                        n3 = rightTreeItemsArray.length;
                                        n4 = 0;
                                        while (n4 < n3) {
                                            item12 = treeItemArray2[n4];
                                            if (item12.getItemCount() > 0) {
                                                rightTreeItemChildsMap.put(item12.getText(), item12.getItems());
                                            }
                                            ++n4;
                                        }
                                        for (String childKey : leftTreeItemsChildMap.keySet()) {
                                            if (rightTreeItemChildsMap.containsKey(childKey)) {
                                                TreeItem item13;
                                                TreeItem[] rightChildTreeItemsArray;
                                                boolean thereIsADiffInChild = false;
                                                TreeItem[] leftChildTreeItemsArray = (TreeItem[])leftTreeItemsChildMap.get(childKey);
                                                if (leftChildTreeItemsArray.length != (rightChildTreeItemsArray = (TreeItem[])rightTreeItemChildsMap.get(childKey)).length) {
                                                    thereIsADiffInChild = true;
                                                }
                                                HashMap<String, TreeItem[]> leftTreeItemsChildResMap = new HashMap<String, TreeItem[]>();
                                                HashMap<String, TreeItem[]> rightTreeItemChildsResMap = new HashMap<String, TreeItem[]>();
                                                TreeItem[] treeItemArray3 = leftChildTreeItemsArray;
                                                int n5 = leftChildTreeItemsArray.length;
                                                int n6 = 0;
                                                while (n6 < n5) {
                                                    item13 = treeItemArray3[n6];
                                                    if (item13.getItemCount() > 0) {
                                                        leftTreeItemsChildResMap.put(item13.getText(), item13.getItems());
                                                    }
                                                    ++n6;
                                                }
                                                treeItemArray3 = rightChildTreeItemsArray;
                                                n5 = rightChildTreeItemsArray.length;
                                                n6 = 0;
                                                while (n6 < n5) {
                                                    item13 = treeItemArray3[n6];
                                                    if (item13.getItemCount() > 0) {
                                                        rightTreeItemChildsResMap.put(item13.getText(), item13.getItems());
                                                    }
                                                    ++n6;
                                                }
                                                for (String childResKey : leftTreeItemsChildResMap.keySet()) {
                                                    if (rightTreeItemChildsResMap.containsKey(childResKey)) {
                                                        TreeItem item14;
                                                        boolean isfinalLeafNodeDiff = false;
                                                        TreeItem[] leftChildFinalTreeItemsArray = (TreeItem[])leftTreeItemsChildResMap.get(childResKey);
                                                        TreeItem[] rightChildFinalTreeItemsArray = (TreeItem[])rightTreeItemChildsResMap.get(childResKey);
                                                        if (rightChildFinalTreeItemsArray.length != leftChildFinalTreeItemsArray.length) {
                                                            isfinalLeafNodeDiff = true;
                                                        }
                                                        HashMap<String, TreeItem> leftTreeItemsFinalChildResMap = new HashMap<String, TreeItem>();
                                                        HashMap<String, TreeItem> rightTreeItemFinalChildsResMap = new HashMap<String, TreeItem>();
                                                        TreeItem[] treeItemArray4 = leftChildFinalTreeItemsArray;
                                                        int n7 = leftChildFinalTreeItemsArray.length;
                                                        int n8 = 0;
                                                        while (n8 < n7) {
                                                            item14 = treeItemArray4[n8];
                                                            leftTreeItemsFinalChildResMap.put(item14.getText(), item14);
                                                            ++n8;
                                                        }
                                                        treeItemArray4 = rightChildFinalTreeItemsArray;
                                                        n7 = rightChildFinalTreeItemsArray.length;
                                                        n8 = 0;
                                                        while (n8 < n7) {
                                                            item14 = treeItemArray4[n8];
                                                            rightTreeItemFinalChildsResMap.put(item14.getText(), item14);
                                                            ++n8;
                                                        }
                                                        for (String finalChildResKey : leftTreeItemsFinalChildResMap.keySet()) {
                                                            if (rightTreeItemFinalChildsResMap.containsKey(finalChildResKey)) continue;
                                                            isfinalLeafNodeDiff = true;
                                                            this.highlightDifferentFinalResource(leftTreeItemsFinalChildResMap, finalChildResKey);
                                                        }
                                                        for (String finalChildResKey : rightTreeItemFinalChildsResMap.keySet()) {
                                                            if (leftTreeItemsFinalChildResMap.containsKey(finalChildResKey)) continue;
                                                            isfinalLeafNodeDiff = true;
                                                            this.highlightDifferentFinalResource(rightTreeItemFinalChildsResMap, finalChildResKey);
                                                        }
                                                        if (!isfinalLeafNodeDiff) continue;
                                                        String leftChildTreeItemText = leftChildFinalTreeItemsArray[0].getParentItem().getText();
                                                        leftChildFinalTreeItemsArray[0].getParentItem().setText(String.valueOf(leftChildTreeItemText) + " *");
                                                        String rightChildTreeItemText = rightChildFinalTreeItemsArray[0].getParentItem().getText();
                                                        rightChildFinalTreeItemsArray[0].getParentItem().setText(String.valueOf(rightChildTreeItemText) + " *");
                                                        continue;
                                                    }
                                                    thereIsADiffInChild = true;
                                                    this.highlightDifferentResource(leftTreeItemsChildResMap, childResKey);
                                                }
                                                for (String childResKey : rightTreeItemChildsResMap.keySet()) {
                                                    if (leftTreeItemsChildResMap.containsKey(childResKey)) continue;
                                                    thereIsADiffInChild = true;
                                                    this.highlightDifferentResource(rightTreeItemChildsResMap, childResKey);
                                                }
                                                if (!thereIsADiffInChild) continue;
                                                String rightChildTreeItemText = leftChildTreeItemsArray[0].getParentItem().getText();
                                                leftChildTreeItemsArray[0].getParentItem().setText(String.valueOf(rightChildTreeItemText) + " *");
                                                String leftChildTreeItemText = rightChildTreeItemsArray[0].getParentItem().getText();
                                                rightChildTreeItemsArray[0].getParentItem().setText(String.valueOf(leftChildTreeItemText) + " *");
                                                continue;
                                            }
                                            thereIsADiff = true;
                                            this.highlightDifferentResource(leftTreeItemsChildMap, childKey);
                                        }
                                        for (String childKey : rightTreeItemChildsMap.keySet()) {
                                            if (leftTreeItemsChildMap.containsKey(childKey)) continue;
                                            thereIsADiff = true;
                                            this.highlightDifferentResource(rightTreeItemChildsMap, childKey);
                                        }
                                        if (!thereIsADiff) continue;
                                        String rightTreeItemText = rightTreeItemsArray[0].getParentItem().getText();
                                        rightTreeItemsArray[0].getParentItem().setText(String.valueOf(rightTreeItemText) + " *");
                                        String leftTreeItemText = leftTreeItemsArray[0].getParentItem().getText();
                                        leftTreeItemsArray[0].getParentItem().setText(String.valueOf(leftTreeItemText) + " *");
                                        continue;
                                    }
                                    this.highlightDifferentResource(leftTreeItemsMap, key);
                                }
                                for (String key : rightTreeItemsMap.keySet()) {
                                    if (leftTreeItemsMap.containsKey(key)) continue;
                                    this.highlightDifferentResource(rightTreeItemsMap, key);
                                }
                            }

                            private void highlightDifferentFinalResource(Map<String, TreeItem> mapTreeItem, String key) {
                                TreeItem treeItem = mapTreeItem.get(key);
                                treeItem.setForeground(Display.getCurrent().getSystemColor(3));
                            }

                            private void highlightDifferentResource(Map<String, TreeItem[]> mapTreeItem, String key) {
                                TreeItem[] treeItems2;
                                TreeItem[] treeItemArray = treeItems2 = mapTreeItem.get(key);
                                int n = treeItems2.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    TreeItem treeItem = treeItemArray[n2];
                                    treeItem.getParentItem().setForeground(Display.getCurrent().getSystemColor(3));
                                    treeItem.setForeground(Display.getCurrent().getSystemColor(3));
                                    if (treeItem.getItemCount() > 0) {
                                        TreeItem[] childItemsLevelOneArray;
                                        TreeItem[] treeItemArray2 = childItemsLevelOneArray = treeItem.getItems();
                                        int n3 = childItemsLevelOneArray.length;
                                        int n4 = 0;
                                        while (n4 < n3) {
                                            TreeItem childItemLevelOne = treeItemArray2[n4];
                                            childItemLevelOne.setForeground(Display.getCurrent().getSystemColor(3));
                                            if (childItemLevelOne.getItemCount() > 0) {
                                                TreeItem[] childItemsLevelTwoArray;
                                                TreeItem[] treeItemArray3 = childItemsLevelTwoArray = childItemLevelOne.getItems();
                                                int n5 = childItemsLevelTwoArray.length;
                                                int n6 = 0;
                                                while (n6 < n5) {
                                                    TreeItem childItemLevelTwo = treeItemArray3[n6];
                                                    childItemLevelTwo.setForeground(Display.getCurrent().getSystemColor(3));
                                                    ++n6;
                                                }
                                            }
                                            ++n4;
                                        }
                                    }
                                    ++n2;
                                }
                            }
                        });
                        ComparisonEditor.this.copyLeftTree();
                        ComparisonEditor.this.copyRightTree();
                    } else {
                        Debug.event((Logger)logger, (Level)Level.WARNING, (String)ComparisonEditor.class.getName(), (String)"setInput", (Object[])new String[]{"ThreadId =" + Thread.currentThread().getId(), "Execution Job is not complete yet!  " + event.getResult().getMessage()});
                    }
                    Job.getJobManager().removeJobChangeListener((IJobChangeListener)this);
                }
            }
        };
        Job.getJobManager().addJobChangeListener((IJobChangeListener)jobListener);
        Job leftResult = this.execute(leftExecutionAnalyzer);
        Debug.exit((Logger)logger, (String)ComparisonEditor.class.getName(), (String)"setInput");
    }

    private void copyLeftTree() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ComparisonEditor.this.leftBackupTreeObject = new Tree((Composite)ComparisonEditor.this.resourcesSash, 2048);
                TreeItem[] treeItemArray = ComparisonEditor.this.resourcesTreeLeft.getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem originalItem = treeItemArray[n2];
                    ComparisonEditor.this.copyTreeItem(originalItem, ComparisonEditor.this.leftBackupTreeObject);
                    ++n2;
                }
                ComparisonEditor.this.leftBackupTreeObject.setVisible(false);
            }
        });
    }

    private void copyRightTree() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ComparisonEditor.this.rightBackupTreeObject = new Tree((Composite)ComparisonEditor.this.resourcesSash, 2048);
                TreeItem[] treeItemArray = ComparisonEditor.this.resourcesTreeRight.getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem originalItem = treeItemArray[n2];
                    ComparisonEditor.this.copyTreeItem(originalItem, ComparisonEditor.this.rightBackupTreeObject);
                    ++n2;
                }
                ComparisonEditor.this.rightBackupTreeObject.setVisible(false);
            }
        });
    }

    private synchronized void copyTreeItem(TreeItem originalItem, Tree copiedTree) {
        TreeItem copiedItem = new TreeItem(copiedTree, 0);
        copiedItem.setText(originalItem.getText());
        copiedItem.setData(originalItem.getData());
        copiedItem.setForeground(originalItem.getForeground());
        copiedItem.setImage(originalItem.getImage());
        TreeItem[] treeItemArray = originalItem.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem originalChild = treeItemArray[n2];
            this.copyTreeItem(originalChild, copiedItem);
            ++n2;
        }
    }

    private void copyTreeItem(TreeItem originalChild, TreeItem copiedItem) {
        TreeItem copiedItemChild = new TreeItem(copiedItem, 0);
        copiedItemChild.setText(originalChild.getText());
        copiedItemChild.setData(originalChild.getData());
        copiedItemChild.setForeground(originalChild.getForeground());
        copiedItemChild.setImage(originalChild.getImage());
        TreeItem[] treeItemArray = originalChild.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem originalChildLevel1 = treeItemArray[n2];
            this.copyTreeItem(originalChildLevel1, copiedItemChild);
            ++n2;
        }
    }

    private ConnectionServiceListener getConnectionServiceListener() {
        return new ConnectionServiceListener(){

            public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
                if ("com.ibm.cics.ia.connection.db2".equals(event.getConnectionCategoryId())) {
                    if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                        this.connected();
                    } else if (event instanceof ConnectionServiceListener.DisconnectedEvent) {
                        this.disconnected();
                    } else if (event instanceof ConnectionServiceListener.ExceptionEvent) {
                        this.exception();
                    }
                }
            }

            public void connected() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ISelectionProvider provider;
                        ComparisonEditor.this.clear();
                        IWorkbenchPartSite site = ComparisonEditor.this.getSite();
                        if (site != null && (provider = site.getSelectionProvider()) != null) {
                            provider.setSelection((ISelection)StructuredSelection.EMPTY);
                        }
                    }
                });
            }

            public void disconnected() {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ISelectionProvider provider;
                        ComparisonEditor.this.currentAnalyzer.clear();
                        ComparisonEditor.this.currentRightResourceAnalyzer.clear();
                        ComparisonEditor.this.clear();
                        IWorkbenchPartSite site = ComparisonEditor.this.getSite();
                        if (site != null && (provider = site.getSelectionProvider()) != null) {
                            provider.setSelection((ISelection)StructuredSelection.EMPTY);
                        }
                    }
                });
            }

            public void exception() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ComparisonEditor.this.currentAnalyzer != null) {
                            if (ComparisonEditor.this.currentAnalyzer.status() != 1) {
                                ComparisonEditor.this.currentAnalyzer.cancel();
                            }
                            ComparisonEditor.this.currentAnalyzer.removeListener(ComparisonEditor.this.getExecutionAnalyzerListener(ComparisonEditor.this.resourcesTreeLeft));
                        }
                        if (ComparisonEditor.this.currentRightResourceAnalyzer != null) {
                            if (ComparisonEditor.this.currentRightResourceAnalyzer.status() != 1) {
                                ComparisonEditor.this.currentRightResourceAnalyzer.cancel();
                            }
                            ComparisonEditor.this.currentRightResourceAnalyzer.removeListener(ComparisonEditor.this.getExecutionAnalyzerListenerForRightRes(ComparisonEditor.this.resourcesTreeLeft));
                        }
                    }
                });
            }
        };
    }

    private void clear() {
        Debug.enter((Logger)logger, (String)ComparisonEditor.class.getName(), (String)"clear", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.itemsMap.clear();
        this.resourceToItems.clear();
        this.analysedResourcesToProcess.clear();
        this.analysedResourcesToProcessForRightres.clear();
        if (this.resourcesTreeLeft != null && !this.resourcesTreeLeft.isDisposed()) {
            this.resourcesTreeLeft.removeAll();
        }
        if (this.resourcesTreeRight != null && !this.resourcesTreeRight.isDisposed()) {
            this.resourcesTreeRight.removeAll();
        }
        this.selectedResources.clear();
        if (this.selectionProvider != null) {
            this.selectionProvider.setSelection((ISelection)StructuredSelection.EMPTY);
        }
        if (this.currentAnalyzer != null) {
            if (this.currentAnalyzer.status() != 1) {
                this.currentAnalyzer.cancel();
            }
            this.currentAnalyzer.clear();
            this.currentAnalyzer.clearInteractions();
        }
        if (this.currentRightResourceAnalyzer != null) {
            if (this.currentRightResourceAnalyzer.status() != 1) {
                this.currentRightResourceAnalyzer.cancel();
            }
            this.currentRightResourceAnalyzer.clear();
            this.currentRightResourceAnalyzer.clearInteractions();
        }
        Debug.exit((Logger)logger, (String)ComparisonEditor.class.getName(), (String)"clear");
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }
}

