/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.ia.controller.DisplayableData;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.UIUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public abstract class CommandHistoryManager {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CommandHistoryManager.class.getPackage().getName());
    private Action searchPreviousAction;
    private Action searchNextAction;
    public List searchHistory = new ArrayList();
    private Command currentCommand;

    abstract void executeCommand(Command var1);

    public IMenuCreator getHistoryMenuCreator() {
        SelectionAdapter historyItemListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem menuItem = (MenuItem)e.widget;
                if (menuItem.getSelection()) {
                    Command command = (Command)menuItem.getData();
                    CommandHistoryManager.this.executeCommand(command);
                    ((MenuItem)e.widget).setSelection(true);
                }
            }
        };
        return new IMenuCreator((SelectionListener)historyItemListener){
            private final /* synthetic */ SelectionListener val$historyItemListener;
            {
                this.val$historyItemListener = selectionListener;
            }

            public void dispose() {
            }

            public Menu getMenu(Control parent) {
                Menu result = new Menu(parent);
                for (Command command : CommandHistoryManager.this.searchHistory) {
                    MenuItem menuItem = new MenuItem(result, 16);
                    DisplayableData displayableData = DisplayableData.getDisplayableData((IAdaptable)command);
                    menuItem.setText(UIUtilities.asFormattedDescription(command, displayableData, 100));
                    menuItem.setImage(displayableData.getImage());
                    menuItem.setData((Object)command);
                    if (command == CommandHistoryManager.this.currentCommand) {
                        menuItem.setSelection(true);
                    }
                    menuItem.addSelectionListener(this.val$historyItemListener);
                }
                if (CommandHistoryManager.this.searchHistory.size() > 0) {
                    new MenuItem(result, 2);
                }
                MenuItem clearHistoryItem = new MenuItem(result, 8);
                clearHistoryItem.setText(Messages.getString("CommandHistoryManager.clearHistoryMenuItem"));
                clearHistoryItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        CommandHistoryManager.this.clear();
                    }
                });
                return result;
            }

            public Menu getMenu(Menu parent) {
                return null;
            }
        };
    }

    public void searchStarted(Command aCommand) {
        Debug.enter((Logger)logger, (String)CommandHistoryManager.class.getName(), (String)"searchStarted", (Object)("Thread ID: " + Thread.currentThread().getId()));
        int indexOfCommandInHistory = this.searchHistory.indexOf(aCommand);
        if (indexOfCommandInHistory == -1) {
            this.searchNextAction.setEnabled(false);
            this.searchHistory.add(aCommand);
            if (this.searchHistory.size() > 20) {
                this.searchHistory.remove(0);
            }
            if (this.searchHistory.size() > 1) {
                this.searchPreviousAction.setEnabled(true);
            } else {
                this.searchPreviousAction.setEnabled(false);
            }
        } else {
            this.searchPreviousAction.setEnabled(indexOfCommandInHistory > 0);
            this.searchNextAction.setEnabled(indexOfCommandInHistory < this.searchHistory.size() - 1);
        }
        this.currentCommand = aCommand;
        Debug.exit((Logger)logger, (String)CommandHistoryManager.class.getName(), (String)"searchStarted");
    }

    public void createActions(IToolBarManager toolBarManager) {
        this.searchPreviousAction = new Action(Messages.getString("CommandHistoryManager.PreviousSearchButton"), ImageDescriptor.createFromImage((Image)ImageFactory.getBackwardImage())){

            public void run() {
                Command previousCommand = (Command)CommandHistoryManager.this.searchHistory.get(CommandHistoryManager.this.searchHistory.indexOf(CommandHistoryManager.this.currentCommand) - 1);
                CommandHistoryManager.this.executeCommand(previousCommand);
            }

            public ImageDescriptor getDisabledImageDescriptor() {
                return ImageDescriptor.createFromImage((Image)ImageFactory.getBackwardImage_DISABLED());
            }
        };
        this.searchNextAction = new Action(Messages.getString("CommandHistoryManager.NextSearchButton"), ImageDescriptor.createFromImage((Image)ImageFactory.getForwardImage())){

            public void run() {
                Command nextCommand = (Command)CommandHistoryManager.this.searchHistory.get(CommandHistoryManager.this.searchHistory.indexOf(CommandHistoryManager.this.currentCommand) + 1);
                CommandHistoryManager.this.executeCommand(nextCommand);
            }

            public ImageDescriptor getDisabledImageDescriptor() {
                return ImageDescriptor.createFromImage((Image)ImageFactory.getForwardImage_DISABLED());
            }
        };
        this.searchNextAction.setEnabled(false);
        this.searchPreviousAction.setEnabled(false);
        toolBarManager.add((IAction)this.searchPreviousAction);
        toolBarManager.add((IAction)this.searchNextAction);
    }

    public void clear() {
        ArrayList newHistory;
        this.searchHistory = newHistory = new ArrayList();
        this.searchNextAction.setEnabled(false);
        this.searchPreviousAction.setEnabled(false);
    }
}

