/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.ui.ScrollLimitManager;
import com.ibm.cics.eclipse.common.ui.JobWithCancelingSupport;
import com.ibm.cics.ia.controller.DisplayableData;
import com.ibm.cics.ia.model.CommandExecution;
import com.ibm.cics.ia.model.ExecutionAnalyzer;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.ResourceAndVerb;
import com.ibm.cics.ia.model.Task;
import com.ibm.cics.ia.model.TaskExecutionAnalyzer;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.model.viz.ResourceFilter;
import com.ibm.cics.ia.query.SQLDefinitions;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.CSVUtils;
import com.ibm.cics.ia.ui.CaptureEPSpecMenu;
import com.ibm.cics.ia.ui.CommandFlowViewColumnDialog;
import com.ibm.cics.ia.ui.CommandHistoryManager;
import com.ibm.cics.ia.ui.DefaultEditorInputImpl;
import com.ibm.cics.ia.ui.FilterContentProvider;
import com.ibm.cics.ia.ui.FilterLabelProvider;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.ResourceRenderer;
import com.ibm.cics.ia.ui.ResourceTypeRenderer;
import com.ibm.cics.ia.ui.ShowDetailsStrategy;
import com.ibm.cics.ia.ui.TreeSearcher;
import com.ibm.cics.ia.ui.TreeSelectionProvider;
import com.ibm.cics.ia.ui.UIUtilities;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TreeCursor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.part.EditorPart;

public class CommandFlowView
extends EditorPart {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CommandFlowView.class.getPackage().getName());
    public static final String ID = "com.ibm.cics.ia.ui.commandflowview";
    public static final String[] DEFAULT_COLUMNS_FOR_CMD_FLOW = new String[]{"APPLID", "TASKID", "TRANSID", "PROGRAM", "FUNCTION_TYPE", "RESOURCE_NAME", "CMD_TIME_LOCAL"};
    public static final String COMMAND = "COMMAND";
    private static final String CALL = "CALL";
    private static final String LINK = "LINK";
    private static final String XCTL = "XCTL";
    private static final String START = "START";
    private static final String NATURAL = "NATURAL";
    private static final String BLANK = "";
    private static final String RIGHT_BRACE = ")";
    private static final String SPACE_LEFT_BRACE = " (";
    public static final String DEFAULT_COLUMNS = "TCBMODE,PREV_TCBMODE,CMD_TIME_LOCAL";
    public static final int DEFAULT_COLUMN_WIDTH = 140;
    public static final DefaultEditorInputImpl DEFAULT_EDITOR_INPUT = new DefaultEditorInputImpl(){};
    private Composite parent;
    private CommandHistoryManager commandHistoryManager;
    private Composite c;
    private Label commandFlowLabel;
    private static final String RESOURCEANDVERB = "RESOURCEANDVERB";
    private Label totalsLabel;
    private JobWithCancelingSupport executionJob;
    private TaskExecutionAnalyzer currentAnalyzer;
    private Display display;
    private static ExecutionAnalyzer.Listener commandAnalyzerListener;
    private Action copyResultsAction;
    private Clipboard clipboard;
    private ToolBar toolBar;
    private SashForm sashForm;
    private TreeItem rootItem;
    private Tree commandFlowTree;
    private TreeCursor commandFlowTreeCursor;
    private IFindReplaceTarget findReplaceTarget;
    private Tree tcbModesUsedTree;
    private Tree tcbModeSwitchedTree;
    private Label titleLabel;
    private Text errorText;
    protected Map<ResourceAndVerb, TreeItem> resourceAndVerbToTreeItem = new WeakHashMap<ResourceAndVerb, TreeItem>();
    private TableLayout commandFLowTreeTableLayout;
    private List<TreeColumn> usedColumns = new ArrayList<TreeColumn>();
    private static final String MINIMIZE_ACTION = "minimize";
    private static final String MAXIMIZE_ACTION = "maximize";
    private static final String COLUMNS_ACTION = "columns";
    private static final String FILTER_ACTION = "filters";
    private TreeSelectionProvider selectionProvider;
    private int[] columnOrderBeforeMovement;
    private ScrollLimitManager scrollLimitManager;
    private ContainerCheckedTreeViewer filterViewer;
    private boolean filterShown;
    private ResourceFilter resourceRootFilter;
    private ResourceFilter commandRootFilter;
    TreeItem parentItem = null;
    Resource nextParent = null;
    private Map<String, TreeItem> tcbModesToTreeItems = new HashMap<String, TreeItem>();
    private Map<String, TreeItem> prevTCBModesToTreeItems = new HashMap<String, TreeItem>();
    private int tcbModeSwitchesSize;
    private static Map<String, TaskExecutionAnalyzer> taskToExecutionAnalyzer;
    private ConnectionServiceListener connectionServiceListener;

    static {
        taskToExecutionAnalyzer = new HashMap<String, TaskExecutionAnalyzer>();
    }

    public List<TreeColumn> getUsedColumns() {
        return this.usedColumns;
    }

    public void createPartControl(final Composite parent) {
        Debug.enter((Logger)logger, (String)CommandFlowView.class.getName(), (String)"createPartControl", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.parent = parent;
        this.display = parent.getDisplay();
        this.commandHistoryManager = new CommandHistoryManager(){

            @Override
            void executeCommand(Command command) {
                CommandFlowView.this.execute((TaskExecutionAnalyzer)command);
            }
        };
        this.clipboard = new Clipboard(this.display);
        this.createPartControl(parent, this.getPreferredOrientation(parent));
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int newPreferredOrientation = CommandFlowView.this.getPreferredOrientation(parent);
                CommandFlowView.this.sashForm.setOrientation(newPreferredOrientation);
                CommandFlowView.this.sashForm.layout();
            }
        });
        this.connectionServiceListener = this.getConnectionServiceListener();
        ConnectionsPlugin.getDefault().getConnectionService().addConnectionServiceListener(this.connectionServiceListener);
        IWorkbenchHelpSystem helpSystem = this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)parent, "com.ibm.cics.ia.help.command_flow_view");
        this.initScrollLimitManager();
        Debug.exit((Logger)logger, (String)CommandFlowView.class.getName(), (String)"initScrollLimitManager");
    }

    private void initScrollLimitManager() {
        Debug.enter((Logger)logger, (String)CommandFlowView.class.getName(), (String)"initScrollLimitManager", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.scrollLimitManager = new ScrollLimitManager(this.c, Messages.getString("CommandFlowView.commands"), (IWorkbenchPart)this){

            public void scrollLimitReached(Command command) {
                super.scrollLimitReached(command);
                if (CommandFlowView.this.c != null && !CommandFlowView.this.c.isDisposed()) {
                    CommandFlowView.this.c.layout(new Control[]{CommandFlowView.this.sashForm, ((CommandFlowView)CommandFlowView.this).scrollLimitManager.scrollLimitComposite});
                    CommandFlowView.this.c.layout(true, true);
                }
            }

            public void dispose() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (CommandFlowView.this.sashForm != null && CommandFlowView.this.c != null && !CommandFlowView.this.sashForm.isDisposed() && !CommandFlowView.this.c.isDisposed()) {
                            CommandFlowView.this.sashForm.setWeights(new int[]{3, 7});
                            CommandFlowView.this.c.layout(new Control[]{CommandFlowView.this.sashForm});
                            CommandFlowView.this.c.layout(true, true);
                        }
                    }
                });
                super.dispose();
            }
        };
        Debug.exit((Logger)logger, (String)CommandFlowView.class.getName(), (String)"initScrollLimitManager");
    }

    private int getPreferredOrientation(Composite parent) {
        Point size = parent.getSize();
        return size.x > size.y ? 256 : 512;
    }

    private void createPartControl(Composite parent, int orientation) {
        Debug.enter((Logger)logger, (String)CommandFlowView.class.getName(), (String)"createPartControl", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "orientation: " + orientation});
        this.c = new Composite(parent, 0);
        this.c.setLayout((Layout)new GridLayout());
        this.toolBar = UIUtilities.createToolBar(this.c);
        this.sashForm = new SashForm(this.c, orientation);
        GridData data = new GridData(4, 4, true, true);
        this.sashForm.setLayoutData((Object)data);
        Composite tcbModeComposite = new Composite((Composite)this.sashForm, 0);
        data = new GridData(4, 4, true, true);
        tcbModeComposite.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 2;
        tcbModeComposite.setLayout((Layout)gridLayout);
        Composite topTCBModeComposite = new Composite(tcbModeComposite, 0);
        data = new GridData(4, 0, true, false);
        topTCBModeComposite.setLayoutData((Object)data);
        gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 2;
        topTCBModeComposite.setLayout((Layout)gridLayout);
        this.titleLabel = new Label(topTCBModeComposite, 0);
        data = new GridData(4, 0x1000000, true, false);
        this.titleLabel.setLayoutData((Object)data);
        SashForm tcbSash = new SashForm(tcbModeComposite, 256);
        data = new GridData(4, 4, true, true);
        tcbSash.setLayoutData((Object)data);
        this.tcbModesUsedTree = new Tree((Composite)tcbSash, 2564);
        data = new GridData(4, 4, true, true);
        this.tcbModesUsedTree.setLayoutData((Object)data);
        final TreeColumn tcbModeTreeCol1 = new TreeColumn(this.tcbModesUsedTree, 0);
        this.tcbModesUsedTree.setHeaderVisible(true);
        tcbModeTreeCol1.setText(Messages.getString("CommandFlowView.treeColumn.TCBModesUsed"));
        this.tcbModesUsedTree.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                tcbModeTreeCol1.setWidth(((CommandFlowView)CommandFlowView.this).tcbModesUsedTree.getClientArea().width);
            }
        });
        this.tcbModesUsedTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommandFlowView.this.showItem(e);
            }
        });
        this.tcbModeSwitchedTree = new Tree((Composite)tcbSash, 2564);
        data = new GridData(4, 4, true, true);
        this.tcbModeSwitchedTree.setLayoutData((Object)data);
        final TreeColumn tcbModeSwapTreeCol1 = new TreeColumn(this.tcbModeSwitchedTree, 0);
        this.tcbModeSwitchedTree.setHeaderVisible(true);
        tcbModeSwapTreeCol1.setText(Messages.getString("CommandFlowView.treeColumn.TCBModesSwitches"));
        this.tcbModeSwitchedTree.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                tcbModeSwapTreeCol1.setWidth(((CommandFlowView)CommandFlowView.this).tcbModeSwitchedTree.getClientArea().width);
            }
        });
        this.tcbModeSwitchedTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommandFlowView.this.showItem(e);
            }
        });
        tcbSash.setWeights(new int[]{5, 5});
        Composite commandFlowComposite = new Composite((Composite)this.sashForm, 0);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        commandFlowComposite.setLayout((Layout)gridLayout);
        Composite topCommandFlowComposite = new Composite(commandFlowComposite, 0);
        data = new GridData(4, 0, true, false);
        topCommandFlowComposite.setLayoutData((Object)data);
        topCommandFlowComposite.setLayout((Layout)new GridLayout(3, false));
        this.commandFlowLabel = new Label(topCommandFlowComposite, 0);
        data = new GridData(4, 0x1000000, true, false);
        this.commandFlowLabel.setLayoutData((Object)data);
        this.totalsLabel = new Label(topCommandFlowComposite, 0);
        data = new GridData(0x1000008, 0x1000000, false, false);
        this.totalsLabel.setLayoutData((Object)data);
        final ToolBar toolBar = new ToolBar(topCommandFlowComposite, 0x800000);
        data = new GridData(131072, 0x1000000, false, false);
        toolBar.setLayoutData((Object)data);
        final ToolBarManager toolBarManager = new ToolBarManager(toolBar);
        Action minimizeAction = new Action(){

            public void run() {
                UIUtilities.expandTree(CommandFlowView.this.commandFlowTree, false);
            }
        };
        minimizeAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)ImageFactory.getCollapseImage()));
        minimizeAction.setToolTipText(Messages.getString("Button.tooltip.minimise"));
        minimizeAction.setId(MINIMIZE_ACTION);
        minimizeAction.setEnabled(true);
        Action maximizeAction = new Action(){

            public void run() {
                UIUtilities.expandTree(CommandFlowView.this.commandFlowTree, true);
            }
        };
        maximizeAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)ImageFactory.getExpandImage()));
        maximizeAction.setToolTipText(Messages.getString("Button.tooltip.maximise"));
        maximizeAction.setId(MAXIMIZE_ACTION);
        maximizeAction.setEnabled(true);
        final Menu menu = new Menu((Decorations)toolBar.getShell(), 8);
        Action columnsAction = new Action(){

            public void run() {
                ToolItem[] items = toolBar.getItems();
                ToolItem item = null;
                int i = 0;
                while (i < items.length) {
                    if (((ActionContributionItem)items[i].getData()).getId().equals(CommandFlowView.COLUMNS_ACTION)) {
                        item = items[i];
                    }
                    ++i;
                }
                if (item != null) {
                    Rectangle rect = item.getBounds();
                    Point pt = toolBar.toDisplay(new Point(rect.x, rect.y + rect.height));
                    menu.setLocation(pt.x, pt.y);
                    menu.setVisible(true);
                }
            }
        };
        columnsAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)ImageFactory.getViewMenu()));
        columnsAction.setToolTipText(Messages.getString("CommandFlowView.columnsToolItemMenu"));
        columnsAction.setId(COLUMNS_ACTION);
        columnsAction.setEnabled(true);
        final SashForm cmdSash = new SashForm(commandFlowComposite, 256);
        data = new GridData(4, 4, true, true);
        cmdSash.setLayoutData((Object)data);
        Action showFilters = new Action(Messages.getString("ResourceConnectionsView.Action.ShowFilters.Tooltip.Text"), 2){

            public void run() {
                cmdSash.setMaximizedControl(CommandFlowView.this.filterShown ? CommandFlowView.this.commandFlowTree : null);
                CommandFlowView commandFlowView = CommandFlowView.this;
                commandFlowView.filterShown = commandFlowView.filterShown ^ true;
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageDescriptor.createFromImage((Image)ImageFactory.getFilterImage());
            }
        };
        showFilters.setId(FILTER_ACTION);
        toolBarManager.add((IAction)minimizeAction);
        toolBarManager.add((IAction)maximizeAction);
        toolBarManager.add((IAction)showFilters);
        toolBarManager.add((IAction)columnsAction);
        toolBarManager.update(true);
        toolBar.pack();
        toolBarManager.getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID > -1) {
                    String id = toolBarManager.getItems()[e.childID].getId();
                    if (id.equals(CommandFlowView.MINIMIZE_ACTION)) {
                        e.result = String.valueOf(CommandFlowView.this.getContentDescription()) + Messages.getString("Button.tooltip.minimise");
                    } else if (id.equals(CommandFlowView.MAXIMIZE_ACTION)) {
                        e.result = String.valueOf(CommandFlowView.this.getContentDescription()) + Messages.getString("Button.tooltip.maximise");
                    } else if (id.equals(CommandFlowView.COLUMNS_ACTION)) {
                        e.result = String.valueOf(CommandFlowView.this.getContentDescription()) + Messages.getString("CommandFlowView.columnsToolItemMenu");
                    }
                }
            }
        });
        MenuItem resetColumns = new MenuItem(menu, 8);
        resetColumns.setText(Messages.getString("CommandFlowView.resetColumnsMenuItem"));
        resetColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPreferenceStore store = CommandFlowView.this.getPreferenceStore();
                store.setToDefault("com.ibm.cics.ia.ui.commandflowview.columnNames");
                store.setToDefault("com.ibm.cics.ia.ui.commandflowview.columnWidths");
                CommandFlowView.this.resetColumns();
            }
        });
        MenuItem equalizeWidths = new MenuItem(menu, 8);
        equalizeWidths.setText(Messages.getString("CommandFlowView.equalizeColumnWidthsMenItem"));
        equalizeWidths.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeColumn[] treeColumnArray = CommandFlowView.this.commandFlowTree.getColumns();
                int n = treeColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeColumn column = treeColumnArray[n2];
                    column.setWidth(140);
                    ++n2;
                }
                CommandFlowView.this.commandFlowTree.getParent().layout();
            }
        });
        MenuItem customizeColumns = new MenuItem(menu, 8);
        customizeColumns.setText(Messages.getString("CommandFlowView.customizeColumnsMenuItem"));
        customizeColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommandFlowViewColumnDialog dialog = new CommandFlowViewColumnDialog(CommandFlowView.this.getEditorSite().getWorkbenchWindow().getShell(), CommandFlowView.this);
                dialog.open();
            }
        });
        this.commandFlowTree = new Tree((Composite)cmdSash, 68356);
        data = new GridData(4, 4, true, true);
        this.commandFlowTree.setLayoutData((Object)data);
        this.commandFlowTreeCursor = new TreeCursor(this.commandFlowTree, 0);
        this.commandFlowTreeCursor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TreeItem selected = CommandFlowView.this.commandFlowTreeCursor.getRow();
                if (selected != null && !selected.isDisposed()) {
                    Object source = selected.getData("RESOURCE");
                    ShowDetailsStrategy.showDetails(source);
                }
            }
        });
        this.commandFlowTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                Object source = ShowDetailsStrategy.extractSourceFromTree(CommandFlowView.this.commandFlowTree, "RESOURCE");
                ShowDetailsStrategy.showDetails(source);
            }
        });
        new ShowDetailsStrategy((Control)this.tcbModesUsedTree){

            @Override
            public Object extractSource() {
                return 19.extractSourceFromTree(CommandFlowView.this.tcbModesUsedTree, "RESOURCE");
            }
        };
        new ShowDetailsStrategy((Control)this.tcbModeSwitchedTree){

            @Override
            public Object extractSource() {
                return 20.extractSourceFromTree(CommandFlowView.this.tcbModeSwitchedTree, "RESOURCE");
            }
        };
        this.commandFlowTreeCursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem selected = CommandFlowView.this.commandFlowTreeCursor.getRow();
                if (selected != null && !selected.isDisposed()) {
                    CommandFlowView.this.commandFlowTree.setSelection(selected);
                    CommandFlowView.this.showRespCodes(selected);
                }
            }
        });
        TreeColumn verbAndResource = new TreeColumn(this.commandFlowTree, 0);
        verbAndResource.setMoveable(false);
        this.commandFLowTreeTableLayout = new TableLayout();
        this.commandFLowTreeTableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(150));
        this.addColumns();
        this.commandFlowTree.setLayout((Layout)this.commandFLowTreeTableLayout);
        this.commandFlowTree.setHeaderVisible(true);
        this.commandFlowTree.setLinesVisible(true);
        this.errorText = new Text(commandFlowComposite, 8);
        this.commandFlowTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] selection;
                Widget widget = e.widget;
                if (widget instanceof Tree && (selection = ((Tree)widget).getSelection()).length > 0) {
                    CommandFlowView.this.showRespCodes(selection[0]);
                }
            }
        });
        this.commandFlowTree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CommandFlowView.this.saveColumns();
            }
        });
        this.filterViewer = new ContainerCheckedTreeViewer((Composite)cmdSash);
        this.filterViewer.setLabelProvider((IBaseLabelProvider)new FilterLabelProvider());
        this.filterViewer.setContentProvider((IContentProvider)new FilterContentProvider());
        this.resourceRootFilter = CommandFlowView.initializeResourceFilters();
        this.commandRootFilter = CommandFlowView.initializeCommandFilters();
        this.filterViewer.setInput((Object)new ResourceFilter[]{this.resourceRootFilter, this.commandRootFilter});
        this.resourceRootFilter.setCheckedSubtree(true);
        this.filterViewer.setChecked((Object)this.resourceRootFilter, true);
        this.commandRootFilter.setCheckedSubtree(true);
        this.filterViewer.setChecked((Object)this.commandRootFilter, true);
        this.filterViewer.expandAll();
        this.filterViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ResourceFilter filter = (ResourceFilter)event.getElement();
                filter.setCheckedSubtree(event.getChecked());
                if (CommandFlowView.this.currentAnalyzer != null) {
                    CommandFlowView.this.clear(false);
                    String searchText = DisplayableData.getDisplayableData((IAdaptable)CommandFlowView.this.currentAnalyzer).getDescription();
                    CommandFlowView.this.setTitleLabel(searchText);
                    CommandFlowView.this.insertResources(CommandFlowView.this.currentAnalyzer.getResults());
                }
            }
        });
        cmdSash.setWeights(new int[]{8, 2});
        cmdSash.setMaximizedControl((Control)this.commandFlowTree);
        this.sashForm.setWeights(new int[]{3, 7});
        this.createActions();
        this.commandFlowTree.addKeyListener((KeyListener)new CtrlChandler());
        this.tcbModesUsedTree.addKeyListener((KeyListener)new CtrlChandler());
        this.tcbModeSwitchedTree.addKeyListener((KeyListener)new CtrlChandler());
        Debug.exit((Logger)logger, (String)CommandFlowView.class.getName(), (String)"resetColumns");
    }

    private void showRespCodes(TreeItem item) {
        Object data = item.getData(COMMAND);
        if (data == null) {
            this.errorText.setText(BLANK);
            this.errorText.getParent().layout();
        } else if (data instanceof CommandExecution) {
            CommandExecution commandExecution = (CommandExecution)data;
            if (commandExecution.isError()) {
                this.errorText.setText(commandExecution.getErrors());
            } else {
                this.errorText.setText(BLANK);
            }
            this.errorText.getParent().layout();
        }
    }

    protected void resetColumns() {
        Debug.enter((Logger)logger, (String)CommandFlowView.class.getName(), (String)"resetColumns", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.commandFlowTree.setRedraw(false);
        for (TreeColumn column : this.usedColumns) {
            column.dispose();
        }
        this.usedColumns.clear();
        this.addColumns();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!CommandFlowView.this.commandFlowTree.isDisposed()) {
                    CommandFlowView.this.commandFlowTree.setRedraw(true);
                }
            }
        });
        this.commandFlowTree.getParent().layout();
        Debug.exit((Logger)logger, (String)CommandFlowView.class.getName(), (String)"getSavedColumnData");
    }

    public LinkedHashMap<String, Integer> getSavedColumnData() {
        Debug.enter((Logger)logger, (String)CommandFlowView.class.getName(), (String)"getSavedColumnData", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId()});
        IPreferenceStore store = this.getPreferenceStore();
        String columnNamesPrefName = "com.ibm.cics.ia.ui.commandflowview.columnNames";
        String columnWidthsPrefName = "com.ibm.cics.ia.ui.commandflowview.columnWidths";
        String columnNamesPrefValue = store.getString(columnNamesPrefName);
        String columnWidthsPrefValue = store.getString(columnWidthsPrefName);
        if (columnNamesPrefValue.equals(BLANK)) {
            columnNamesPrefValue = DEFAULT_COLUMNS;
        }
        LinkedHashMap<String, Integer> result = UIUtilities.getColumns(columnNamesPrefValue, columnWidthsPrefValue);
        Debug.exit((Logger)logger, (String)CommandFlowView.class.getName(), (String)"getSavedColumnData", (Object)("result size: " + result.size()));
        return result;
    }

    protected void saveColumns() {
        Debug.enter((Logger)logger, (String)CommandFlowView.class.getName(), (String)"saveColumns", (Object)("Thread ID: " + Thread.currentThread().getId()));
        StringBuffer namesPrefValue = new StringBuffer();
        StringBuilder widthsPrefValue = new StringBuilder();
        for (TreeColumn column : this.usedColumns) {
            String name = (String)column.getData();
            namesPrefValue.append(name);
            widthsPrefValue.append(column.getWidth());
            if (this.usedColumns.indexOf(column) == this.usedColumns.size() - 1) continue;
            namesPrefValue.append(",");
            widthsPrefValue.append(",");
        }
        IPreferenceStore store = this.getPreferenceStore();
        String columnNamesPrefName = "com.ibm.cics.ia.ui.commandflowview.columnNames";
        String columnWidthsPrefName = "com.ibm.cics.ia.ui.commandflowview.columnWidths";
        store.putValue(columnNamesPrefName, namesPrefValue.toString());
        store.putValue(columnWidthsPrefName, widthsPrefValue.toString());
        Debug.exit((Logger)logger, (String)CommandFlowView.class.getName(), (String)"getPreferenceStore");
    }

    private IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    protected void showItem(SelectionEvent e) {
        TreeItem item;
        Object itemData;
        Debug.enter((Logger)logger, (String)CommandFlowView.class.getName(), (String)"showItem", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (e.item != null && (itemData = e.item.getData(RESOURCEANDVERB)) != null && itemData instanceof ResourceAndVerb && (item = this.resourceAndVerbToTreeItem.get((ResourceAndVerb)itemData)) != null) {
            this.commandFlowTree.select(item);
            this.commandFlowTree.showItem(item);
        }
        Debug.exit((Logger)logger, (String)CommandFlowView.class.getName(), (String)"createActions");
    }

    private void createActions() {
        Debug.enter((Logger)logger, (String)CommandFlowView.class.getName(), (String)"createActions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.selectionProvider = new TreeSelectionProvider(this.commandFlowTree, "RESOURCE");
        this.selectionProvider.registerTree(this.tcbModesUsedTree);
        this.selectionProvider.registerTree(this.tcbModeSwitchedTree);
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        MenuManager menuMgr = new MenuManager();
        final Menu commandFlowPopupMenu = menuMgr.createContextMenu((Control)this.commandFlowTree);
        this.commandFlowTree.setMenu(commandFlowPopupMenu);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Resource resource;
                TreeItem[] items = CommandFlowView.this.commandFlowTree.getSelection();
                if (items.length == 1 && items[0].getData("RESOURCE") instanceof Resource && (resource = (Resource)items[0].getData("RESOURCE")) != null) {
                    CaptureEPSpecMenu.createResourceActions(manager, resource, null);
                }
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.selectionProvider);
        this.commandFlowTreeCursor.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                commandFlowPopupMenu.setVisible(true);
            }
        });
        menuMgr = new MenuManager();
        this.tcbModesUsedTree.setMenu(menuMgr.createContextMenu((Control)this.tcbModesUsedTree));
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.selectionProvider);
        menuMgr = new MenuManager();
        this.tcbModeSwitchedTree.setMenu(menuMgr.createContextMenu((Control)this.tcbModeSwitchedTree));
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.selectionProvider);
        this.copyResultsAction = new Action(Messages.getString("QueryResultsView.action.copy"), ImageDescriptor.createFromImage((Image)ImageFactory.getSaveImage())){

            public void run() {
                CommandFlowView.this.doCopy();
            }
        };
        this.copyResultsAction.setEnabled(false);
        ToolBarManager toolBarManager = new ToolBarManager(this.toolBar);
        toolBarManager.add((IContributionItem)new Separator());
        this.commandHistoryManager.createActions((IToolBarManager)toolBarManager);
        toolBarManager.update(true);
        this.toolBar.pack();
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyResultsAction);
        Debug.exit((Logger)logger, (String)CommandFlowView.class.getName(), (String)"setSearchInProgress");
    }

    private void setSearchInProgress(boolean aBool) {
        Debug.enter((Logger)logger, (String)CommandFlowView.class.getName(), (String)"setSearchInProgress", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "aBool: " + aBool});
        if (!this.c.isDisposed()) {
            this.commandFlowLabel.setEnabled(!aBool);
            this.copyResultsAction.setEnabled(!aBool);
        }
        Debug.exit((Logger)logger, (String)CommandFlowView.class.getName(), (String)"setSearchInProgress");
    }

    private void clear(boolean disposeScrollLimitManager) {
        Debug.enter((Logger)logger, (String)CommandFlowView.class.getName(), (String)"clear", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "disposeScrollLimitManager: " + disposeScrollLimitManager});
        if (this.c != null && !this.c.isDisposed()) {
            this.totalsLabel.setText(BLANK);
            this.commandFlowLabel.setText(BLANK);
            this.commandFlowTree.removeAll();
            this.tcbModesUsedTree.removeAll();
            this.tcbModeSwitchedTree.removeAll();
            this.resourceAndVerbToTreeItem.clear();
            this.setTitleLabel(BLANK);
        }
        this.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(null);
        if (this.selectionProvider != null) {
            this.selectionProvider.setSelection((ISelection)StructuredSelection.EMPTY);
        }
        this.parentItem = null;
        this.nextParent = null;
        this.tcbModesToTreeItems = new HashMap<String, TreeItem>();
        this.prevTCBModesToTreeItems = new HashMap<String, TreeItem>();
        this.tcbModeSwitchesSize = 0;
        if (disposeScrollLimitManager && this.scrollLimitManager != null) {
            this.scrollLimitManager.dispose();
        }
        Debug.exit((Logger)logger, (String)CommandFlowView.class.getName(), (String)"clear");
    }

    public void dispose() {
        Debug.enter((Logger)logger, (String)CommandFlowView.class.getName(), (String)"dispose", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.currentAnalyzer != null) {
            this.currentAnalyzer.removeListener(commandAnalyzerListener);
            commandAnalyzerListener = null;
        }
        if (this.connectionServiceListener != null) {
            this.connectionServiceListener.makeStale();
        }
        super.dispose();
        Debug.exit((Logger)logger, (String)CommandFlowView.class.getName(), (String)"enclosing_method");
    }

    private void removeIncompatibleColumns() {
        Debug.enter((Logger)logger, (String)CommandFlowView.class.getName(), (String)"removeIncompatibleColumns", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.commandFlowTree.setRedraw(false);
        ArrayList<TreeColumn> unUsedColumns = new ArrayList<TreeColumn>();
        for (TreeColumn column : this.usedColumns) {
            String data = (String)column.getData();
            boolean contains = false;
            String[] stringArray = SQLDefinitions.CMDFLOW_ATTRIBUTES.getAdjustedAttributes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String columnName = stringArray[n2];
                if (columnName.equals(data)) {
                    contains = true;
                    break;
                }
                ++n2;
            }
            if (column.getData().toString().equals("CMD_TCB_CPUTIME")) {
                contains = true;
            }
            if (contains) continue;
            unUsedColumns.add(column);
            column.dispose();
        }
        this.usedColumns.removeAll(unUsedColumns);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!CommandFlowView.this.commandFlowTree.isDisposed()) {
                    CommandFlowView.this.commandFlowTree.setRedraw(true);
                }
            }
        });
        this.commandFlowTree.getParent().layout();
        Debug.exit((Logger)logger, (String)CommandFlowView.class.getName(), (String)"setInput");
    }

    public Job setInput(Task task) {
        Debug.enter((Logger)logger, (String)CommandFlowView.class.getName(), (String)"setInput", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "task: " + task.getName()});
        TaskExecutionAnalyzer executionAnalyzer = null;
        String taskKey = String.valueOf(task.getTaskID()) + task.getDistributedUOW() + task.getTraceId() + task.getApplId();
        if (taskToExecutionAnalyzer.containsKey(taskKey)) {
            executionAnalyzer = taskToExecutionAnalyzer.get(taskKey);
        } else {
            executionAnalyzer = new TaskExecutionAnalyzer(task);
            taskToExecutionAnalyzer.put(taskKey, executionAnalyzer);
        }
        DisplayableData displayableData = DisplayableData.getDisplayableData((IAdaptable)executionAnalyzer);
        displayableData.setImage(ImageFactory.getUsesImage());
        Region region = executionAnalyzer.getRegion();
        this.scrollLimitManager.setTaskName(task.getName());
        if (region == null) {
            displayableData.setDescription(MessageFormat.format(Messages.getString("CommandFlow.desc.undertransaction"), ResourceRenderer.asQualifiedName((Resource)task), task.getTransaction()));
        } else {
            displayableData.setDescription(MessageFormat.format(Messages.getString("CommandFlow.desc.undertransactioninregion"), ResourceRenderer.asQualifiedName((Resource)task), task.getTransaction(), region.getName()));
        }
        Job result = this.execute(executionAnalyzer);
        Debug.exit((Logger)logger, (String)CommandFlowView.class.getName(), (String)"setInput", (Object)("result: " + (result != null ? result.getName() : BLANK)));
        return result;
    }

    protected Job execute(TaskExecutionAnalyzer executionAnalyzer) {
        Debug.enter((Logger)logger, (String)CommandFlowView.class.getName(), (String)"execute", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "executionAnalyzer: " + executionAnalyzer.getDescription()});
        this.clear(true);
        this.removeIncompatibleColumns();
        this.setSearchInProgress(true);
        if (!this.c.isDisposed()) {
            this.c.setCursor(this.parent.getDisplay().getSystemCursor(3));
        }
        final String searchText = DisplayableData.getDisplayableData((IAdaptable)executionAnalyzer).getDescription();
        this.setTitleLabel(searchText);
        this.commandHistoryManager.searchStarted((Command)executionAnalyzer);
        if (this.executionJob != null) {
            this.executionJob.cancel();
            this.executionJob = null;
            this.currentAnalyzer.removeListener(this.getExecutionAnalyzerListener());
            if (this.currentAnalyzer.status() == 0) {
                UIUtilities.cancel((Command)this.currentAnalyzer);
            }
        }
        this.currentAnalyzer = executionAnalyzer;
        this.currentAnalyzer.removeListener(commandAnalyzerListener);
        commandAnalyzerListener = null;
        this.currentAnalyzer.addListener(this.getExecutionAnalyzerListener());
        if (this.currentAnalyzer.status() == -1 || this.currentAnalyzer.status() == 3) {
            this.executionJob = new JobWithCancelingSupport(searchText){

                protected IStatus runSub(IProgressMonitor monitor) {
                    Debug.enter((Logger)logger, (String)"CommandFlowView.execute().JobWithCancelingSupport", (String)"runSub", (Object)("Thread ID: " + Thread.currentThread().getId()));
                    monitor.beginTask(searchText, -1);
                    CommandFlowView.this.currentAnalyzer.start();
                    monitor.done();
                    IAPlugin.getDefault().taskEnded();
                    Debug.exit((Logger)logger, (String)"CommandFlowView.execute().JobWithCancelingSupport", (String)"runSub");
                    return Status.OK_STATUS;
                }

                protected void cancelingSub() {
                    Debug.enter((Logger)logger, (String)"CommandFlowView.execute().JobWithCancelingSupport", (String)"cancellingSub", (Object)("Thread ID: " + Thread.currentThread().getId()));
                    super.canceling();
                    IAPlugin.getDefault().taskEnded();
                    UIUtilities.cancel((Command)CommandFlowView.this.currentAnalyzer);
                    Debug.exit((Logger)logger, (String)"CommandFlowView.execute().JobWithCancelingSupport", (String)"cancellingSub");
                }
            };
            UIUtilities.scheduleWorkbenchPartJob((IWorkbenchPart)this, (Job)this.executionJob);
        } else {
            this.processCompletedCommand(true);
        }
        Debug.exit((Logger)logger, (String)CommandFlowView.class.getName(), (String)"execute", (Object)("executionJob: " + (this.executionJob != null ? this.executionJob.getName() : BLANK)));
        return this.executionJob;
    }

    private void processCompletedCommand(final boolean isComplete) {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                CommandFlowView.this.setSearchInProgress(false);
                if (isComplete) {
                    CommandFlowView.this.insertResources(CommandFlowView.this.currentAnalyzer.getResults());
                }
                if (!CommandFlowView.this.c.isDisposed()) {
                    CommandFlowView.this.c.setCursor(null);
                }
                CommandFlowView.this.currentAnalyzer.removeListener(CommandFlowView.this.getExecutionAnalyzerListener());
            }
        });
    }

    private ExecutionAnalyzer.Listener getExecutionAnalyzerListener() {
        if (commandAnalyzerListener == null) {
            commandAnalyzerListener = new ExecutionAnalyzer.Listener(){

                public void completed() {
                    if (CommandFlowView.this.scrollLimitManager != null) {
                        CommandFlowView.this.scrollLimitManager.dispose();
                    }
                    if (CommandFlowView.this.currentAnalyzer.status() == 2) {
                        CommandFlowView.this.display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                CommandFlowView.this.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(MessageFormat.format(Messages.getString("CommandFlowView.errorMessage"), CommandFlowView.BLANK));
                            }
                        });
                    }
                    CommandFlowView.this.processCompletedCommand(false);
                }

                public void resourceAnalyzed(ExecutionAnalyzer.ResourceAnalysis aResourceAnalysis) {
                }

                public void itemsAdded(final Collection interactions) {
                    CommandFlowView.this.display.syncExec(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            2 var1_1 = this;
                            synchronized (var1_1) {
                                CommandFlowView.this.insertResources(interactions);
                                if (CommandFlowView.this.currentAnalyzer.status() == 3) {
                                    CommandFlowView.this.scrollLimitManager.scrollLimitReached((Command)CommandFlowView.this.currentAnalyzer.getCommand());
                                }
                                if (!CommandFlowView.this.c.isDisposed()) {
                                    CommandFlowView.this.c.setCursor(null);
                                }
                            }
                        }
                    });
                }

                public void resourceComplete(Resource r) {
                }
            };
        }
        return commandAnalyzerListener;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void insertResources(Collection interactions) {
        Debug.enter((Logger)logger, (String)CommandFlowView.class.getName(), (String)"insertResources", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "interactions siza: " + interactions.size()});
        if (!this.c.isDisposed()) {
            if (this.rootItem == null || this.rootItem.isDisposed()) {
                this.createRootItem();
            }
            List filteredInteractions = this.filterInteractions(interactions);
            this.totalsLabel.setText(MessageFormat.format(Messages.getString("CommandFlowView.totalsLabel.filteredCommands"), filteredInteractions.size(), interactions.size()));
            this.totalsLabel.getParent().layout();
            TreeItem oldParent = this.rootItem;
            Program currentSource = null;
            for (Object object : filteredInteractions) {
                CommandExecution commandExecution = (CommandExecution)object;
                Program source = commandExecution.getProgram();
                if (this.nextParent != null && !currentSource.equals((Object)source)) {
                    this.parentItem = new TreeItem(this.parentItem, 0);
                    this.parentItem.setData("RESOURCE", (Object)this.nextParent);
                    this.parentItem.setText(ResourceRenderer.asText(this.nextParent));
                    this.parentItem.setImage(ResourceRenderer.getOverLaidImage(ResourceRenderer.asImage(this.nextParent), false, false, this.nextParent.isEventable()));
                    this.nextParent = null;
                    oldParent = this.parentItem;
                } else if (this.parentItem == null || this.parentItem.isDisposed()) {
                    this.parentItem = new TreeItem(oldParent, 0);
                    this.parentItem.setData("RESOURCE", (Object)source);
                    this.parentItem.setText(ResourceRenderer.asText((Resource)source));
                    this.parentItem.setImage(ResourceRenderer.getOverLaidImage(ResourceRenderer.asImage(source), false, false, source.isEventable()));
                } else {
                    TreeItem parent;
                    Resource oldParentResource;
                    TreeItem currentParent = this.parentItem;
                    Resource currentParentResource = (Resource)currentParent.getData("RESOURCE");
                    if (currentSource != null && !currentSource.equals((Object)source) && !"FFFFFFFF".equals(commandExecution.get("OFFSET"))) {
                        oldParentResource = (Resource)oldParent.getData("RESOURCE");
                        parent = oldParent;
                        boolean haveParent = false;
                        while (!parent.equals(this.rootItem)) {
                            Resource resource = (Resource)parent.getData("RESOURCE");
                            if (resource.equals((Object)source)) {
                                haveParent = true;
                                break;
                            }
                            parent = parent.getParentItem();
                        }
                        if (haveParent) {
                            this.parentItem = new TreeItem(parent.getParentItem().equals(oldParent) ? parent : parent.getParentItem(), 0);
                            this.parentItem.setData("RESOURCE", (Object)source);
                            this.parentItem.setText(ResourceRenderer.asText((Resource)source));
                            this.parentItem.setImage(ResourceRenderer.getOverLaidImage(ResourceRenderer.asImage(source), false, false, source.isEventable()));
                            oldParent = this.parentItem;
                            this.nextParent = null;
                        } else {
                            void var14_23;
                            TreeItem treeItem = oldParent;
                            while (var14_23 != this.rootItem) {
                                Resource parentResource = (Resource)var14_23.getData("RESOURCE");
                                for (Map.Entry<ResourceAndVerb, TreeItem> entry : this.resourceAndVerbToTreeItem.entrySet()) {
                                    TreeItem entryItem = entry.getValue();
                                    if (!entryItem.getParentItem().equals(var14_23) || !entryItem.getData("RESOURCE").equals(source)) continue;
                                    parent = entryItem.getParentItem();
                                    haveParent = true;
                                    break;
                                }
                                if (haveParent) break;
                                TreeItem treeItem2 = var14_23.getParentItem();
                            }
                            if (haveParent) {
                                this.parentItem = new TreeItem(parent.getParentItem().equals(this.rootItem) ? parent : parent.getParentItem(), 0);
                                this.parentItem.setData("RESOURCE", (Object)source);
                                this.parentItem.setText(ResourceRenderer.asText((Resource)source));
                                this.parentItem.setImage(ResourceRenderer.getOverLaidImage(ResourceRenderer.asImage(source), false, false, source.isEventable()));
                                oldParent = this.parentItem;
                                this.nextParent = null;
                            } else {
                                this.parentItem = new TreeItem(currentParent, 0);
                                this.parentItem.setData("RESOURCE", (Object)source);
                                this.parentItem.setText(ResourceRenderer.asText((Resource)source));
                                this.parentItem.setImage(ResourceRenderer.getOverLaidImage(ResourceRenderer.asImage(source), false, false, source.isEventable()));
                                oldParent = this.parentItem;
                                this.nextParent = null;
                            }
                        }
                    } else if (source != currentParentResource) {
                        oldParentResource = (Resource)oldParent.getData("RESOURCE");
                        parent = oldParent;
                        boolean haveParent = false;
                        while (!parent.equals(this.rootItem)) {
                            Resource resource = (Resource)parent.getData("RESOURCE");
                            if (resource.equals((Object)source)) {
                                haveParent = true;
                                break;
                            }
                            parent = parent.getParentItem();
                        }
                        if (haveParent) {
                            this.parentItem = new TreeItem(parent.getParentItem(), 0);
                            this.parentItem.setData("RESOURCE", (Object)source);
                            this.parentItem.setText(ResourceRenderer.asText((Resource)source));
                            this.parentItem.setImage(ResourceRenderer.getOverLaidImage(ResourceRenderer.asImage(source), false, false, source.isEventable()));
                            oldParent = this.parentItem;
                        } else {
                            this.parentItem = new TreeItem(oldParent, 0);
                            this.parentItem.setData("RESOURCE", (Object)source);
                            this.parentItem.setText(ResourceRenderer.asText((Resource)source));
                            this.parentItem.setImage(ResourceRenderer.getOverLaidImage(ResourceRenderer.asImage(source), false, false, source.isEventable()));
                            oldParent = this.parentItem;
                        }
                    }
                }
                String verb = commandExecution.getResourceAndVerb().getVerb();
                Resource resource = commandExecution.getResourceAndVerb().getResource();
                String functionType = commandExecution.get("FUNCTION_TYPE");
                if (verb.equals(CALL) || verb.equals(LINK) || verb.equals(XCTL) || verb.equals(START) && functionType.equals(NATURAL)) {
                    this.nextParent = resource;
                }
                currentSource = source;
                ResourceAndVerb childResourceAndVerb = commandExecution.getResourceAndVerb();
                TreeItem treeItem = new TreeItem(this.parentItem, 0);
                treeItem.setData("RESOURCE", childResourceAndVerb.getData());
                this.resourceAndVerbToTreeItem.put(childResourceAndVerb, treeItem);
                treeItem.setText(0, ResourceRenderer.asText(childResourceAndVerb));
                boolean bl = true;
                int[] columnOrder = this.commandFlowTree.getColumnOrder();
                for (TreeColumn additionalColumn : this.usedColumns) {
                    void var14_20;
                    treeItem.setText(columnOrder[++var14_20], commandExecution.get((String)additionalColumn.getData()));
                }
                Image image = ResourceRenderer.asImage(childResourceAndVerb);
                boolean tcbSwap = !commandExecution.getTCBMode().equals(commandExecution.getPrevTCBMode());
                boolean error = commandExecution.isError();
                boolean eventable = childResourceAndVerb.getData() instanceof Resource ? ((Resource)childResourceAndVerb.getData()).isEventable() : false;
                image = ResourceRenderer.getOverLaidImage(image, error, tcbSwap, eventable);
                if (error || tcbSwap) {
                    this.parentItem.setImage(ResourceRenderer.getOverLaidImage(this.parentItem.getImage(), error, tcbSwap, false));
                    this.rootItem.setImage(ResourceRenderer.getOverLaidImage(this.rootItem.getImage(), error, tcbSwap, false));
                }
                treeItem.setImage(image);
                treeItem.setData(COMMAND, (Object)commandExecution);
                if (this.parentItem.getExpanded()) continue;
                this.parentItem.setExpanded(true);
            }
            this.rootItem.setExpanded(true);
            this.tcbModesToTreeItems.clear();
            this.tcbModesUsedTree.removeAll();
            Map targetsByTCBMode = CommandExecution.getTargetsByTCBMode((Collection)filteredInteractions);
            for (Map.Entry entry : targetsByTCBMode.entrySet()) {
                this.createTreeItems(this.tcbModesToTreeItems, entry, this.tcbModesUsedTree);
            }
            this.prevTCBModesToTreeItems.clear();
            this.tcbModeSwitchedTree.removeAll();
            this.tcbModeSwitchesSize = 0;
            HashMap hashMap = CommandExecution.getTargetsByTCBModeSwap((Collection)filteredInteractions);
            for (Map.Entry entry : hashMap.entrySet()) {
                String prevTCBMode = (String)entry.getKey();
                TreeItem prevTCBModeItem = this.prevTCBModesToTreeItems.get(prevTCBMode);
                if (prevTCBModeItem == null) {
                    prevTCBModeItem = new TreeItem(this.tcbModeSwitchedTree, 0);
                    this.prevTCBModesToTreeItems.put(prevTCBMode, prevTCBModeItem);
                }
                Map tcbModeToResourceAndVerbs = (Map)entry.getValue();
                HashMap<String, HashMap<String, TreeItem>> prevTCBModesToTCBModesAndTreeItems = new HashMap<String, HashMap<String, TreeItem>>();
                int prevTotal = 0;
                for (Map.Entry<String, List<ResourceAndVerb>> entry2 : tcbModeToResourceAndVerbs.entrySet()) {
                    HashMap<String, TreeItem> nextTCBModesToTreeItems = (HashMap<String, TreeItem>)prevTCBModesToTCBModesAndTreeItems.get(prevTCBMode);
                    if (nextTCBModesToTreeItems == null) {
                        nextTCBModesToTreeItems = new HashMap<String, TreeItem>();
                        prevTCBModesToTCBModesAndTreeItems.put(prevTCBMode, nextTCBModesToTreeItems);
                    }
                    prevTotal += this.createTreeItems(nextTCBModesToTreeItems, entry2, prevTCBModeItem);
                }
                prevTCBModeItem.setText(String.valueOf(prevTCBMode) + SPACE_LEFT_BRACE + prevTotal + RIGHT_BRACE);
                prevTCBModeItem.setImage(ResourceTypeRenderer.asImage(prevTCBMode));
            }
        }
        Debug.exit((Logger)logger, (String)CommandFlowView.class.getName(), (String)"insertResources");
    }

    private void createRootItem() {
        Debug.enter((Logger)logger, (String)CommandFlowView.class.getName(), (String)"createRootItem", (Object)("ThreadID: " + Thread.currentThread().getId()));
        this.rootItem = new TreeItem(this.commandFlowTree, 0);
        Transaction transaction = (Transaction)this.currentAnalyzer.getRoot();
        this.rootItem.setText(ResourceRenderer.asText((Resource)transaction));
        boolean eventable = transaction.isEventable();
        this.rootItem.setImage(ResourceRenderer.getOverLaidImage(ResourceRenderer.asImage(transaction), false, false, eventable));
        this.rootItem.setData("RESOURCE", (Object)transaction);
        Debug.exit((Logger)logger, (String)CommandFlowView.class.getName(), (String)"createRootItem");
    }

    private List filterInteractions(Collection interactions) {
        Debug.enter((Logger)logger, (String)CommandFlowView.class.getName(), (String)"filterInteractions", (Object[])new String[]{"ThreadId: " + Thread.currentThread().getId(), "iteractions size: " + interactions.size()});
        ArrayList<CommandExecution> filtered = new ArrayList<CommandExecution>();
        HashMap<String, List> uncheckedResourcesByType = new HashMap<String, List>();
        HashMap<String, List> uncheckedCommandsByType = new HashMap<String, List>();
        String[] keys = new String[]{ResourceFilter.CICS, ResourceFilter.DB2, ResourceFilter.IMS, ResourceFilter.MQ, ResourceFilter.NATURAL};
        ResourceFilter emptyResourceFilter = this.resourceRootFilter.getFilter(ResourceFilter.EMPTY);
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            List uncheckedResources = this.resourceRootFilter.getFilter(key).getUncheckedSubtreeLeafNames();
            if (!emptyResourceFilter.isChecked()) {
                uncheckedResources.add(ResourceFilter.EMPTY);
            }
            uncheckedResourcesByType.put(key, uncheckedResources);
            List uncheckedCommands = this.commandRootFilter.getFilter(key).getUncheckedSubtreeLeafNames();
            uncheckedCommandsByType.put(key, uncheckedCommands);
            ++n2;
        }
        uncheckedResourcesByType.put(BLANK, new ArrayList());
        ArrayList<String> uncheckedCommandsForEmptyFunctionType = new ArrayList<String>();
        if (!this.commandRootFilter.getFilter("START OF TRANSACTION").isChecked()) {
            uncheckedCommandsForEmptyFunctionType.add(this.commandRootFilter.getFilter("START OF TRANSACTION").getName());
        }
        uncheckedCommandsByType.put(BLANK, uncheckedCommandsForEmptyFunctionType);
        for (Object object : interactions) {
            CommandExecution cmdExec = (CommandExecution)object;
            String functionType = cmdExec.get("FUNCTION_TYPE");
            if (!uncheckedCommandsByType.keySet().contains(functionType)) {
                filtered.add(cmdExec);
                continue;
            }
            if (((List)uncheckedResourcesByType.get(functionType)).contains(cmdExec.get("TYPE")) || ((List)uncheckedCommandsByType.get(functionType)).contains(cmdExec.get("FUNCTION"))) continue;
            filtered.add(cmdExec);
        }
        Debug.exit((Logger)logger, (String)CommandFlowView.class.getName(), (String)"filterInteractions", (Object)("filtered size: " + filtered.size()));
        return filtered;
    }

    private int createTreeItems(Map<String, TreeItem> tcbModesToTreeItems, Map.Entry<String, List<ResourceAndVerb>> entry, Object parent) {
        Debug.enter((Logger)logger, (String)CommandFlowView.class.getName(), (String)"createTreeItems", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "tcbModesToTreeItems size: " + tcbModesToTreeItems.size(), "parent class: " + parent.getClass()});
        String tcbMode = entry.getKey();
        TreeItem tcbModeTreeItem = tcbModesToTreeItems.get(tcbMode);
        List<ResourceAndVerb> resourcesAndVerbs = entry.getValue();
        int size = resourcesAndVerbs.size();
        if (tcbModeTreeItem == null) {
            tcbModeTreeItem = parent instanceof TreeItem ? new TreeItem((TreeItem)parent, 0) : new TreeItem((Tree)parent, 0);
            tcbModeTreeItem.setImage(ResourceTypeRenderer.asImage(tcbMode));
            tcbModesToTreeItems.put(tcbMode, tcbModeTreeItem);
        }
        for (ResourceAndVerb resourceAndVerb : resourcesAndVerbs) {
            TreeItem treeItem = new TreeItem(tcbModeTreeItem, 0);
            treeItem.setData("RESOURCE", resourceAndVerb.getData());
            treeItem.setData(RESOURCEANDVERB, (Object)resourceAndVerb);
            treeItem.setText(ResourceRenderer.asText(resourceAndVerb));
            treeItem.setImage(ResourceRenderer.asImage(resourceAndVerb));
        }
        if (parent instanceof TreeItem) {
            this.tcbModeSwitchesSize += size;
            tcbModeTreeItem.setText(String.valueOf(tcbMode) + SPACE_LEFT_BRACE + this.tcbModeSwitchesSize + RIGHT_BRACE);
        } else {
            tcbModeTreeItem.setText(String.valueOf(tcbMode) + SPACE_LEFT_BRACE + tcbModeTreeItem.getItemCount() + RIGHT_BRACE);
        }
        Debug.exit((Logger)logger, (String)CommandFlowView.class.getName(), (String)"createTreeItems", (Object)("return: " + size));
        return size;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        Debug.enter((Logger)logger, (String)CommandFlowView.class.getName(), (String)"init", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "site: " + site.getId(), "input: " + input.getName()});
        if (DEFAULT_EDITOR_INPUT != input) {
            Debug.event((Logger)logger, (Level)Level.FINEST, (String)CommandFlowView.class.getName(), (String)"init", (Object)"exception throw: \"Invalid Input: Must be CommandFlowView.DEFAULT_EDITOR_INPUT\"");
            throw new PartInitException("Invalid Input: Must be CommandFlowView.DEFAULT_EDITOR_INPUT");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        Debug.exit((Logger)logger, (String)CommandFlowView.class.getName(), (String)"init");
    }

    private void clearAndResetSelection() {
        ISelectionProvider provider;
        Debug.enter((Logger)logger, (String)CommandFlowView.class.getName(), (String)"clearAndResetSelection", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.clear(true);
        IWorkbenchPartSite site = this.getSite();
        if (site != null && (provider = site.getSelectionProvider()) != null) {
            provider.setSelection((ISelection)StructuredSelection.EMPTY);
        }
        Debug.exit((Logger)logger, (String)CommandFlowView.class.getName(), (String)"clearAndResetSelection");
    }

    private ConnectionServiceListener getConnectionServiceListener() {
        return new ConnectionServiceListener(){

            public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
                if ("com.ibm.cics.ia.connection.db2".equals(event.getConnectionCategoryId())) {
                    if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                        this.connected();
                    } else if (event instanceof ConnectionServiceListener.DisconnectedEvent) {
                        this.disconnected();
                    } else if (event instanceof ConnectionServiceListener.ExceptionEvent) {
                        this.exception();
                    }
                }
            }

            public void connected() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CommandFlowView.this.commandHistoryManager.clear();
                        CommandFlowView.this.clearAndResetSelection();
                    }
                });
            }

            public void disconnected() {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        CommandFlowView.this.commandHistoryManager.clear();
                        CommandFlowView.this.clearAndResetSelection();
                        taskToExecutionAnalyzer = new HashMap();
                    }
                });
            }

            public void exception() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (CommandFlowView.this.currentAnalyzer != null) {
                            if (CommandFlowView.this.currentAnalyzer.status() != 1) {
                                CommandFlowView.this.currentAnalyzer.cancel();
                            }
                            CommandFlowView.this.currentAnalyzer.removeListener(CommandFlowView.this.getExecutionAnalyzerListener());
                        }
                    }
                });
            }
        };
    }

    private void addColumns() {
        Debug.enter((Logger)logger, (String)CommandFlowView.class.getName(), (String)"addColumns", (Object)("Thread ID: " + Thread.currentThread().getId()));
        for (Map.Entry<String, Integer> entry : this.getSavedColumnData().entrySet()) {
            int width = entry.getValue();
            if (width == UIUtilities.NO_WIDTH_SPECIFIED) {
                width = 140;
            }
            this.addColumn(entry.getKey(), width);
        }
        Debug.exit((Logger)logger, (String)CommandFlowView.class.getName(), (String)"addColumns");
    }

    public void addColumn(String column, int width) {
        Debug.enter((Logger)logger, (String)CommandFlowView.class.getName(), (String)"addColumn", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "column: " + column, "width: " + width});
        this.commandFlowTree.setRedraw(false);
        TreeColumn treeColumn = new TreeColumn(this.commandFlowTree, 0);
        treeColumn.setData((Object)column);
        treeColumn.setMoveable(true);
        treeColumn.setText(com.ibm.cics.ia.query.Messages.getString((String)("Column." + column)));
        treeColumn.addListener(10, new Listener(){

            public void handleEvent(Event event) {
                int[] columnOrderAfterMovement = CommandFlowView.this.commandFlowTree.getColumnOrder();
                if (columnOrderAfterMovement[0] != 0) {
                    CommandFlowView.this.commandFlowTree.setColumnOrder(CommandFlowView.this.columnOrderBeforeMovement);
                    return;
                }
                ArrayList<TreeColumn> columns = new ArrayList<TreeColumn>();
                int i = 0;
                while (i < columnOrderAfterMovement.length) {
                    TreeColumn column = CommandFlowView.this.commandFlowTree.getColumn(columnOrderAfterMovement[i]);
                    if (CommandFlowView.this.usedColumns.contains(column)) {
                        columns.add(column);
                    }
                    ++i;
                }
                CommandFlowView.this.columnOrderBeforeMovement = Arrays.copyOf(columnOrderAfterMovement, columnOrderAfterMovement.length);
                CommandFlowView.this.usedColumns = columns;
            }
        });
        this.commandFLowTreeTableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(width));
        this.usedColumns.add(treeColumn);
        int position = this.usedColumns.indexOf(treeColumn) + 1;
        for (TreeItem treeItem : this.resourceAndVerbToTreeItem.values()) {
            CommandExecution commandExecution;
            if (treeItem.isDisposed() || (commandExecution = (CommandExecution)treeItem.getData(COMMAND)) == null) continue;
            treeItem.setText(position, commandExecution.get(column));
        }
        this.commandFlowTree.getParent().layout();
        treeColumn.pack();
        this.commandFlowTree.setRedraw(true);
        this.setInitialColumnOrder();
        Debug.exit((Logger)logger, (String)CommandFlowView.class.getName(), (String)"addColumn");
    }

    public void removeColumn(String column) {
        TreeColumn[] columns;
        Debug.enter((Logger)logger, (String)CommandFlowView.class.getName(), (String)"removeColumn", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "column: " + column});
        TreeColumn[] treeColumnArray = columns = this.commandFlowTree.getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn treeColumn = treeColumnArray[n2];
            Object data = treeColumn.getData();
            if (data != null && data.equals(column)) {
                this.usedColumns.remove(treeColumn);
                treeColumn.dispose();
            }
            ++n2;
        }
        this.commandFlowTree.setRedraw(true);
        this.commandFlowTree.getParent().layout();
        this.setInitialColumnOrder();
        Debug.exit((Logger)logger, (String)CommandFlowView.class.getName(), (String)"removeColumn");
    }

    private void setTitleLabel(final String title) {
        Debug.enter((Logger)logger, (String)CommandFlowView.class.getName(), (String)"setTitleLabel", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "title: " + title});
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (CommandFlowView.this.titleLabel != null) {
                        CommandFlowView.this.titleLabel.setText(title);
                        CommandFlowView.this.titleLabel.getParent().getParent().layout(true);
                    }
                }
            });
        } else if (this.titleLabel != null) {
            this.titleLabel.setText(title);
            this.titleLabel.getParent().getParent().layout(true);
        }
        Debug.exit((Logger)logger, (String)CommandFlowView.class.getName(), (String)"setTitleLabel");
    }

    public void setFocus() {
        this.sashForm.setFocus();
    }

    public String getPartProperty(String key) {
        if (IConnectionCategory.class.getName().equals(key)) {
            return "com.ibm.cics.ia.connection.db2";
        }
        return super.getPartProperty(key);
    }

    private void doCopy() {
        Debug.enter((Logger)logger, (String)CommandFlowView.class.getName(), (String)"doCopy", (Object)("Thread ID: " + Thread.currentThread().getId()));
        List results = null;
        if (this.currentAnalyzer != null) {
            results = this.filterInteractions(this.currentAnalyzer.getResults());
        }
        if (results != null && results.size() > 0) {
            ArrayList<String> columnNames = new ArrayList<String>();
            String[] stringArray = DEFAULT_COLUMNS_FOR_CMD_FLOW;
            int n = DEFAULT_COLUMNS_FOR_CMD_FLOW.length;
            int n2 = 0;
            while (n2 < n) {
                String column = stringArray[n2];
                columnNames.add(column);
                ++n2;
            }
            for (TreeColumn candidateColumn : this.usedColumns) {
                String columnName = candidateColumn.getData().toString();
                if (columnNames.contains(columnName)) continue;
                columnNames.add(columnName);
            }
            this.commandFlowTree.getParent().setRedraw(false);
            Point originalSize = this.commandFlowTree.getSize();
            GC gc = null;
            Image image = null;
            Display display = Display.getCurrent();
            try {
                Point size = this.commandFlowTree.computeSize(-1, -1, true);
                int height = size.y + 25;
                GC gcForLengthCalc = new GC((Drawable)display);
                Point currentTextArea = gcForLengthCalc.stringExtent(Messages.getString("CommandFlowView.CreatedByIaPlugin"));
                gcForLengthCalc.dispose();
                int width = Math.max(size.x, currentTextArea.x + 10);
                image = new Image((Device)display, width, height);
                gc = new GC((Drawable)image);
                this.commandFlowTree.setSize(size);
                this.commandFlowTree.print(gc);
                gc.setBackground(display.getSystemColor(25));
                gc.fillRectangle(0, height - 20, width, 20);
                gc.setForeground(display.getSystemColor(16));
                gc.drawString(Messages.getString("CommandFlowView.CreatedByIaPlugin"), 5, height - 20);
                this.commandFlowTree.setSize(originalSize);
                ImageTransfer imageTransfer = ImageTransfer.getInstance();
                Object[] data = new Object[]{CSVUtils.createCSVForCmdView(results, columnNames).toString(), image.getImageData()};
                Transfer[] dataTypes = new Transfer[]{TextTransfer.getInstance(), imageTransfer};
                this.clipboard.setContents(data, dataTypes);
                this.commandFlowTree.setSize(originalSize);
                this.commandFlowTree.getParent().setRedraw(true);
            }
            finally {
                if (gc != null) {
                    gc.dispose();
                }
                if (image != null) {
                    image.dispose();
                }
            }
        }
        Debug.exit((Logger)logger, (String)CtrlChandler.class.getName(), (String)"doCopy");
    }

    public void setInitialColumnOrder() {
        this.columnOrderBeforeMovement = this.commandFlowTree.getColumnOrder();
    }

    public static ResourceFilter initializeCommandFilters() {
        String function;
        Debug.enter((Logger)logger, (String)CommandFlowView.class.getName(), (String)"initializeCommandFilters", (Object)("Thread ID: " + Thread.currentThread().getId()));
        ResourceFilter rootFilter = ResourceFilter.createFilter((String)ResourceFilter.ROOT, (String)Messages.getString("CommandFlowView.Filter.Command.All.Text"), null, (boolean)false);
        ResourceFilter.createFilter((String)"START OF TRANSACTION", (String)"START OF TRANSACTION", (ResourceFilter)rootFilter, (boolean)false);
        ResourceFilter cicsFunctionsFilter = ResourceFilter.createFilter((String)ResourceFilter.CICS, (String)Messages.getString("ResourceConnectionsView.Fiter.CICS.Text"), (ResourceFilter)rootFilter, (boolean)false);
        ResourceFilter db2FunctionsFilter = ResourceFilter.createFilter((String)ResourceFilter.DB2, (String)Messages.getString("ResourceConnectionsView.Filter.DB2.Text"), (ResourceFilter)rootFilter, (boolean)false);
        ResourceFilter imsFunctionsFilter = ResourceFilter.createFilter((String)ResourceFilter.IMS, (String)Messages.getString("ResourceConnectionsView.Filter.IMS.Text"), (ResourceFilter)rootFilter, (boolean)false);
        ResourceFilter mqFunctionsFilter = ResourceFilter.createFilter((String)ResourceFilter.MQ, (String)Messages.getString("ResourceConnectionsView.Filter.MQ.Text"), (ResourceFilter)rootFilter, (boolean)false);
        ResourceFilter naturalFunctionsFilter = ResourceFilter.createFilter((String)ResourceFilter.NATURAL, (String)Messages.getString("ResourceConnectionsView.Filter.NATURAL.Text"), (ResourceFilter)rootFilter, (boolean)false);
        String[] stringArray = SQLDefinitions.CICS_FUNCTIONS;
        int n = SQLDefinitions.CICS_FUNCTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            function = stringArray[n2];
            ResourceFilter.createFilter((String)function, (String)function, (ResourceFilter)cicsFunctionsFilter, (boolean)false);
            ++n2;
        }
        stringArray = SQLDefinitions.DB2_FUNCTIONS;
        n = SQLDefinitions.DB2_FUNCTIONS.length;
        n2 = 0;
        while (n2 < n) {
            function = stringArray[n2];
            ResourceFilter.createFilter((String)function, (String)function, (ResourceFilter)db2FunctionsFilter, (boolean)false);
            ++n2;
        }
        stringArray = SQLDefinitions.IMS_FUNCTIONS;
        n = SQLDefinitions.IMS_FUNCTIONS.length;
        n2 = 0;
        while (n2 < n) {
            function = stringArray[n2];
            ResourceFilter.createFilter((String)function, (String)function, (ResourceFilter)imsFunctionsFilter, (boolean)false);
            ++n2;
        }
        stringArray = SQLDefinitions.MQ_FUNCTIONS;
        n = SQLDefinitions.MQ_FUNCTIONS.length;
        n2 = 0;
        while (n2 < n) {
            function = stringArray[n2];
            ResourceFilter.createFilter((String)function, (String)function, (ResourceFilter)mqFunctionsFilter, (boolean)false);
            ++n2;
        }
        stringArray = SQLDefinitions.NATURAL_FUNCTIONS;
        n = SQLDefinitions.NATURAL_FUNCTIONS.length;
        n2 = 0;
        while (n2 < n) {
            function = stringArray[n2];
            ResourceFilter.createFilter((String)function, (String)function, (ResourceFilter)naturalFunctionsFilter, (boolean)false);
            ++n2;
        }
        Debug.exit((Logger)logger, (String)CommandFlowView.class.getName(), (String)"initializeCommandFilters");
        return rootFilter;
    }

    public static ResourceFilter initializeResourceFilters() {
        String type;
        Debug.enter((Logger)logger, (String)CommandFlowView.class.getName(), (String)"initializeResourceFilters", (Object)("Thread ID: " + Thread.currentThread().getId()));
        ResourceFilter rootFilter = ResourceFilter.createFilter((String)ResourceFilter.ROOT, (String)Messages.getString("ResourceConnectionsView.Filter.All.Text"), null, (boolean)false);
        ResourceFilter.createFilter((String)ResourceFilter.EMPTY, (String)Messages.getString("ResourceConnectionsView.Filter.Empty.Text"), (ResourceFilter)rootFilter, (boolean)false);
        ResourceFilter cicsResourceFilter = ResourceFilter.createFilter((String)ResourceFilter.CICS, (String)Messages.getString("ResourceConnectionsView.Fiter.CICS.Text"), (ResourceFilter)rootFilter, (boolean)false);
        ResourceFilter db2ResourceFilter = ResourceFilter.createFilter((String)ResourceFilter.DB2, (String)Messages.getString("ResourceConnectionsView.Filter.DB2.Text"), (ResourceFilter)rootFilter, (boolean)false);
        ResourceFilter imsResourceFilter = ResourceFilter.createFilter((String)ResourceFilter.IMS, (String)Messages.getString("ResourceConnectionsView.Filter.IMS.Text"), (ResourceFilter)rootFilter, (boolean)false);
        ResourceFilter mqResourceFilter = ResourceFilter.createFilter((String)ResourceFilter.MQ, (String)Messages.getString("ResourceConnectionsView.Filter.MQ.Text"), (ResourceFilter)rootFilter, (boolean)false);
        ResourceFilter naturalResourceFilter = ResourceFilter.createFilter((String)ResourceFilter.NATURAL, (String)Messages.getString("ResourceConnectionsView.Filter.NATURAL.Text"), (ResourceFilter)rootFilter, (boolean)false);
        String[] stringArray = SQLDefinitions.CICS_TYPES;
        int n = SQLDefinitions.CICS_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            type = stringArray[n2];
            ResourceFilter.createFilter((String)type, (String)type, (ResourceFilter)cicsResourceFilter, (boolean)false);
            ++n2;
        }
        stringArray = SQLDefinitions.DB2_TYPES;
        n = SQLDefinitions.DB2_TYPES.length;
        n2 = 0;
        while (n2 < n) {
            type = stringArray[n2];
            ResourceFilter.createFilter((String)type, (String)type, (ResourceFilter)db2ResourceFilter, (boolean)false);
            ++n2;
        }
        stringArray = SQLDefinitions.IMS_TYPES;
        n = SQLDefinitions.IMS_TYPES.length;
        n2 = 0;
        while (n2 < n) {
            type = stringArray[n2];
            ResourceFilter.createFilter((String)type, (String)type, (ResourceFilter)imsResourceFilter, (boolean)false);
            ++n2;
        }
        stringArray = SQLDefinitions.MQ_TYPES;
        n = SQLDefinitions.MQ_TYPES.length;
        n2 = 0;
        while (n2 < n) {
            type = stringArray[n2];
            ResourceFilter.createFilter((String)type, (String)type, (ResourceFilter)mqResourceFilter, (boolean)false);
            ++n2;
        }
        stringArray = SQLDefinitions.NATURAL_TYPES;
        n = SQLDefinitions.NATURAL_TYPES.length;
        n2 = 0;
        while (n2 < n) {
            type = stringArray[n2];
            ResourceFilter.createFilter((String)type, (String)type, (ResourceFilter)naturalResourceFilter, (boolean)false);
            ++n2;
        }
        Debug.exit((Logger)logger, (String)CommandFlowView.class.getName(), (String)"initializeResourceFilters");
        return rootFilter;
    }

    public Object getAdapter(Class adapter) {
        if (IFindReplaceTarget.class.equals((Object)adapter)) {
            if (this.findReplaceTarget == null) {
                this.findReplaceTarget = new TreeSearcher(this.commandFlowTree, this.commandFlowTreeCursor);
            }
            return this.findReplaceTarget;
        }
        return super.getAdapter(adapter);
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public String getTitleToolTip() {
        return this.getTitle();
    }

    class CtrlChandler
    extends UIUtilities.CopyListener {
        CtrlChandler() {
        }

        @Override
        public void copy() {
            CommandFlowView.this.doCopy();
        }
    }
}

