/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.ia.commands.CincGetRequest;
import com.ibm.cics.ia.commands.GetApplicationInfoCommand;
import com.ibm.cics.ia.commands.WebServiceRequest;
import com.ibm.cics.ia.model.AtomContent;
import com.ibm.cics.ia.model.AtomContentElement;
import com.ibm.cics.ia.model.AtomDefinitions;
import com.ibm.cics.ia.model.CincCollector;
import com.ibm.cics.ia.model.CintCollector;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.runtime.AtomController;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.sm.comm.AtomConnection;
import com.ibm.cics.ia.sm.comm.IAtomConnection;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.IAOperationsView;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.UIUtilities;
import com.ibm.cics.ia.ui.composites.ApplicationInfoPropertyItem;
import com.ibm.cics.ia.ui.composites.GenericPropertyItem;
import com.ibm.cics.ia.ui.composites.ISwitchablePropertyItem;
import com.ibm.cics.ia.ui.composites.PropertyFieldFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;

public abstract class CollectorOptionsEditor
extends EditorPart
implements ISaveablePart {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CollectorOptionsEditor.class.getPackage().getName());
    private Tree propertyTree;
    private Composite stackParent;
    private Composite loadingComposite;
    private ProgressMonitorPart progressMonitorPart;
    private Composite editComposite;
    private StackLayout stackLayout;
    private PropertyFieldFactory propertyFieldFactory;
    private AtomContent collector;
    private boolean dirty = false;
    private Label titleLabel;
    private Label errorLabel;
    private final String ACCESSIBLE_LISTENER = "ACCESSIBLE_LISTENER";
    private LinkedHashMap<Control, String> errors;
    private ApplicationInfoPropertyItem applicationInfoPropertyItem;

    public void createPartControl(Composite parent) {
        Debug.enter((Logger)logger, (String)CollectorOptionsEditor.class.getName(), (String)"createPartControl", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.stackLayout = new StackLayout();
        this.stackParent = new Composite(parent, 0);
        this.stackParent.setLayout((Layout)this.stackLayout);
        this.loadingComposite = new Composite(this.stackParent, 0);
        this.loadingComposite.setLayout((Layout)new GridLayout());
        this.progressMonitorPart = new ProgressMonitorPart(this.loadingComposite, (Layout)new GridLayout());
        this.progressMonitorPart.setLayoutData((Object)new GridData(4, 0, true, false));
        this.progressMonitorPart.setVisible(true);
        this.editComposite = new Composite(this.stackParent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginLeft = 0;
        this.editComposite.setLayout((Layout)layout);
        this.titleLabel = new Label(this.editComposite, 4);
        FontData fontData = this.editComposite.getFont().getFontData()[0];
        Font titleFont = new Font((Device)this.editComposite.getDisplay(), fontData.getName(), fontData.getHeight() + 1, fontData.getStyle() | 1);
        this.titleLabel.setFont(titleFont);
        this.titleLabel.setText(" ");
        GridData data = new GridData(4, 0, true, false);
        data.grabExcessHorizontalSpace = true;
        data.horizontalIndent = 0;
        data.verticalIndent = 0;
        data.horizontalSpan = 0;
        this.titleLabel.setLayoutData((Object)data);
        this.errorLabel = new Label(this.editComposite, 4);
        fontData = this.editComposite.getFont().getFontData()[0];
        Font errorFont = new Font((Device)this.editComposite.getDisplay(), fontData.getName(), fontData.getHeight(), fontData.getStyle() | 1);
        this.errorLabel.setFont(errorFont);
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(Display.getCurrent().getSystemColor(3));
        data = new GridData(4, 0, true, false);
        data.grabExcessHorizontalSpace = true;
        data.horizontalIndent = 0;
        data.verticalIndent = 0;
        data.horizontalSpan = 0;
        data.horizontalAlignment = 4;
        this.errorLabel.setLayoutData((Object)data);
        this.createTreeArea(this.editComposite);
        this.stackLayout.topControl = this.editComposite;
        this.stackParent.layout();
        this.setEditorHelp(this.stackParent);
        Debug.exit((Logger)logger, (String)CollectorOptionsEditor.class.getName(), (String)"createPartControl");
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"init", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"init");
    }

    public void createTreeArea(Composite parent) {
        Debug.enter((Logger)logger, (String)CollectorOptionsEditor.class.getName(), (String)"createTreeArea", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.propertyTree = new Tree(parent, 100356);
        this.propertyTree.setHeaderVisible(true);
        this.propertyTree.setLinesVisible(true);
        this.propertyTree.setLayoutData((Object)new GridData(4, 4, true, true));
        final TreeColumn nameColumn = new TreeColumn(this.propertyTree, 0);
        nameColumn.setText(Messages.getString("CollectorOptionsEditor.PropertyColumn.Text"));
        nameColumn.setWidth(this.propertyTree.getSize().x / 2);
        final TreeColumn valueColumn = new TreeColumn(this.propertyTree, 0);
        valueColumn.setText(Messages.getString("CollectorOptionsEditor.ValueColumn.Text"));
        valueColumn.setWidth(this.propertyTree.getSize().x / 2);
        this.propertyTree.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                Rectangle area = CollectorOptionsEditor.this.propertyTree.getClientArea();
                nameColumn.setWidth(area.width / 2);
                valueColumn.setWidth(area.width / 2);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        Debug.exit((Logger)logger, (String)CollectorOptionsEditor.class.getName(), (String)"createTreeArea");
    }

    public void setFocus() {
        this.propertyTree.setFocus();
    }

    public void setInput(AtomContent collector) {
        Debug.enter((Logger)logger, (String)CollectorOptionsEditor.class.getName(), (String)"setInput", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (collector == this.collector) {
            return;
        }
        this.fireNotDirty();
        this.errors = new LinkedHashMap();
        this.errorLabel.setText(" ");
        this.collector = collector;
        String msg = this.getEditorMessage();
        this.setPartName(this.getEditorTitle());
        this.setTitleToolTip(this.getEditorTitle());
        this.titleLabel.setText(msg);
        this.titleLabel.setToolTipText(msg);
        if (this.propertyFieldFactory == null) {
            this.propertyFieldFactory = new PropertyFieldFactory(this.propertyTree, this);
        }
        this.propertyTree.setRedraw(false);
        if (this.collector instanceof CincCollector) {
            CincGetRequest request;
            AtomController controller = AtomController.getInstance();
            IConnection connection = controller.getConnection(this.collector.getConnectionID());
            if (this.collector.isConnectedToAtom()) {
                request = new CincGetRequest(Messages.getString("IAOperationsView.fetchingCollectorInformationText"), connection);
                request.addJobChangeListener((IJobChangeListener)new RequestChangeAdapter());
            } else {
                request = new WebServiceRequest(Messages.getString("IAOperationsView.fetchingCollectorInformationText"), "STAT", null, (IAtomConnection)((AtomConnection)connection));
                request.addJobChangeListener((IJobChangeListener)new RequestChangeAdapter());
            }
            request.schedule();
        }
        AtomContentElement element = this.getGeneralOptionsRootElement();
        Map properties = null;
        if (this.collector instanceof CintCollector && (properties = this.collector.isConnectedToAtom() ? ((CintCollector)this.collector).getProperties() : ((CintCollector)this.collector).getPropertiesForEditor()) != null) {
            this.loadGeneralOptions(properties);
        }
        TreeItem[] items = this.propertyTree.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].setExpanded(true);
            ++i;
        }
        this.propertyTree.setRedraw(true);
        this.stackLayout.topControl = this.editComposite;
        this.stackParent.layout();
        Debug.exit((Logger)logger, (String)CollectorOptionsEditor.class.getName(), (String)"setInput");
    }

    private void loadGeneralOptions(Map attributes) {
        int n;
        int n2;
        String[] stringArray;
        Debug.enter((Logger)logger, (String)CollectorOptionsEditor.class.getName(), (String)"loadGeneralOptions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (!Arrays.asList(this.getCollectorAttributes()).contains("comm_inlist_name") && this.propertyFieldFactory.getPropertyField("comm_inlist_name", false) != null) {
            stringArray = this.propertyTree.getItems();
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String category = stringArray[n];
                if ("CollectorOptionsEditor.CommandIncludeList.Category".equals(category.getData())) {
                    category.removeAll();
                    category.dispose();
                }
                ++n;
            }
            this.propertyFieldFactory.removeComposite("comm_inlist_name");
            this.propertyFieldFactory.removeComposite("kcics");
            this.propertyFieldFactory.removeComposite("kyims");
            this.propertyFieldFactory.removeComposite("keymq");
            this.propertyFieldFactory.removeComposite("kydb2");
            this.propertyFieldFactory.removeComposite("kynat");
        }
        stringArray = this.getCollectorAttributes();
        n2 = stringArray.length;
        n = 0;
        while (n < n2) {
            GenericPropertyItem newItem;
            String attribute = stringArray[n];
            if (!this.loadApplicationProperties(attributes, attribute) && (newItem = this.propertyFieldFactory.getPropertyField(attribute, true)) != null) {
                String value = (String)attributes.get(attribute);
                if (value == null) {
                    value = "";
                }
                newItem.setValue(value, false);
            }
            ++n;
        }
        this.applicationInfoPropertyItem.refreshValue(false);
        Debug.exit((Logger)logger, (String)CollectorOptionsEditor.class.getName(), (String)"loadGeneralOptions");
    }

    private boolean loadApplicationProperties(Map attributes, String key) {
        Debug.enter((Logger)logger, (String)CollectorOptionsEditor.class.getName(), (String)"loadApplicationProperties", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (key.equals("appl_name") || key.equals("appl_ver1") || key.equals("appl_ver2") || key.equals("appl_ver3")) {
            String value;
            if (this.applicationInfoPropertyItem == null) {
                this.applicationInfoPropertyItem = (ApplicationInfoPropertyItem)this.propertyFieldFactory.getPropertyField("appl_name", true);
                if (this.collector instanceof CintCollector) {
                    this.applicationInfoPropertyItem.setApplIds(((CintCollector)this.collector).getRegion().getName());
                }
            }
            if ((value = (String)attributes.get(key)) != null && !value.isEmpty()) {
                if (key.equals("appl_name")) {
                    this.applicationInfoPropertyItem.getCurrentInfo().setName(value);
                    this.applicationInfoPropertyItem.getOldInfo().setName(value);
                } else if (key.equals("appl_ver1")) {
                    this.applicationInfoPropertyItem.getCurrentInfo().setMajorVersion(Integer.valueOf(value).intValue());
                    this.applicationInfoPropertyItem.getOldInfo().setMajorVersion(Integer.valueOf(value).intValue());
                } else if (key.equals("appl_ver2")) {
                    this.applicationInfoPropertyItem.getCurrentInfo().setMinorVersion(Integer.valueOf(value).intValue());
                    this.applicationInfoPropertyItem.getOldInfo().setMinorVersion(Integer.valueOf(value).intValue());
                } else if (key.equals("appl_ver3")) {
                    this.applicationInfoPropertyItem.getCurrentInfo().setMicroVersion(Integer.valueOf(value).intValue());
                    this.applicationInfoPropertyItem.getOldInfo().setMicroVersion(Integer.valueOf(value).intValue());
                }
            }
            Debug.exit((Logger)logger, (String)CollectorOptionsEditor.class.getName(), (String)"loadApplicationProperties");
            return true;
        }
        Debug.exit((Logger)logger, (String)CollectorOptionsEditor.class.getName(), (String)"loadApplicationProperties");
        return false;
    }

    private void saveApplicationInfoModel(AtomContentElement element, String name, String ver1, String ver2, String ver3) {
        element.setAttribute("appl_name", name);
        element.setAttribute("appl_ver1", ver1);
        element.setAttribute("appl_ver2", ver2);
        element.setAttribute("appl_ver3", ver3);
    }

    public void updateInput(AtomContentElement element) {
        Debug.enter((Logger)logger, (String)CollectorOptionsEditor.class.getName(), (String)"updateInput", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.collector != null) {
            boolean keepDirty = false;
            AtomContentElement resultElement = element.getFirstElementByName("updated");
            if (resultElement == null && element.getName().equals("update")) {
                resultElement = element;
                keepDirty = true;
            }
            if (resultElement != null) {
                Map attributes = resultElement.getAttributes();
                Set keySet = attributes.keySet();
                for (String key : keySet) {
                    GenericPropertyItem propertyItem;
                    if (this.propertyTree != null && this.propertyFieldFactory != null && !this.propertyTree.isDisposed() && !this.loadApplicationProperties(attributes, key) && (propertyItem = this.propertyFieldFactory.getPropertyField(key, false)) != null) {
                        propertyItem.setValue((String)attributes.get(key), keepDirty);
                    }
                    if (keepDirty) continue;
                    this.getGeneralOptionsRootElement().setAttribute(key, (String)attributes.get(key));
                }
                if (this.applicationInfoPropertyItem != null) {
                    this.applicationInfoPropertyItem.refreshValue(keepDirty);
                }
                if (this.collector instanceof CincCollector) {
                    List elements;
                    Map properties = null;
                    if (this.collector.isConnectedToAtom()) {
                        elements = resultElement.getChildElementsByName("app");
                        properties = ((CincCollector)this.collector).getProperties();
                        HashMap<String, String[]> regionMap = null;
                        if (properties != null) {
                            regionMap = (HashMap<String, String[]>)properties.get("cincstate");
                        }
                        if (regionMap == null) {
                            regionMap = new HashMap<String, String[]>();
                            properties.put("cincstate", regionMap);
                        }
                        for (AtomContentElement atomContentElement : elements) {
                            GenericPropertyItem propertyItem;
                            String number = atomContentElement.getAttribute("number");
                            String key = "applid" + number;
                            String value = atomContentElement.getValue();
                            if (!keepDirty) {
                                String[] values = (String[])regionMap.get(number);
                                if (values == null) {
                                    values = new String[]{value, "", "", ""};
                                }
                                regionMap.put(number, values);
                            }
                            if (this.propertyTree == null || this.propertyFieldFactory == null || this.propertyTree.isDisposed() || (propertyItem = this.propertyFieldFactory.getPropertyField(key, false)) == null) continue;
                            propertyItem.setValue(value, keepDirty);
                        }
                    } else {
                        elements = resultElement.getChildElementsByName("cincstate");
                        properties = ((CincCollector)this.collector).getFreshProperties();
                        HashMap<String, String[]> regionMap = null;
                        if (properties != null) {
                            regionMap = (HashMap<String, String[]>)properties.get("cincstate");
                        }
                        if (regionMap == null) {
                            regionMap = new HashMap<String, String[]>();
                            properties.put("cincstate", regionMap);
                        }
                        for (AtomContentElement atomContentElement : elements) {
                            GenericPropertyItem propertyItem;
                            String number = atomContentElement.getAttribute("number");
                            String key = "applid" + number;
                            String value = atomContentElement.getAttribute("app");
                            if (!keepDirty) {
                                String[] values = (String[])regionMap.get(number);
                                if (values == null) {
                                    values = new String[]{value, "", "", ""};
                                }
                                if (IAUtilities.hasContent((String)values[0])) {
                                    regionMap.put(number, values);
                                }
                            }
                            if (this.propertyTree == null || this.propertyFieldFactory == null || this.propertyTree.isDisposed() || (propertyItem = this.propertyFieldFactory.getPropertyField(key, false)) == null) continue;
                            propertyItem.setValue(value, keepDirty);
                        }
                    }
                }
                if (this.collector instanceof CincCollector) {
                    ((CincCollector)this.collector).clearPropertySource();
                } else if (this.collector instanceof CintCollector) {
                    ((CintCollector)this.collector).clearPropertySource();
                }
                IAOperationsView iaOperationsView = Activator.findIAOperationsView();
                if (iaOperationsView != null) {
                    ArrayList<AtomContent> value = new ArrayList<AtomContent>();
                    value.add(this.collector);
                    iaOperationsView.setInput(value);
                }
                if (keepDirty) {
                    this.fireDirty();
                } else {
                    this.fireNotDirty();
                }
            }
        }
        Debug.exit((Logger)logger, (String)CollectorOptionsEditor.class.getName(), (String)"updateInput");
    }

    public void doSave(IProgressMonitor monitor) {
        Debug.enter((Logger)logger, (String)CollectorOptionsEditor.class.getName(), (String)"doSave", (Object)("Thread ID: " + Thread.currentThread().getId()));
        AtomContentElement element = new AtomContentElement();
        element.setName("update");
        TreeItem[] categoryItems = this.propertyTree.getItems();
        if (this.collector.isConnectedToAtom()) {
            int i = 0;
            while (i < categoryItems.length) {
                TreeItem[] attributeItems = categoryItems[i].getItems();
                int j = 0;
                while (j < attributeItems.length) {
                    GenericPropertyItem propertyItem = (GenericPropertyItem)attributeItems[j].getData();
                    if (propertyItem.isModified()) {
                        if (propertyItem instanceof ApplicationInfoPropertyItem) {
                            if (this.getPropertyField("appl_mode", false).getValue().equals(AtomDefinitions.APPLICATION_MODE_FIELDS[1])) {
                                GetApplicationInfoCommand.ApplicationInfo appInfo = ((ApplicationInfoPropertyItem)propertyItem).getCurrentInfo();
                                this.saveApplicationInfoModel(element, appInfo.getName(), String.valueOf(appInfo.getMajorVersion()), String.valueOf(appInfo.getMinorVersion()), String.valueOf(appInfo.getMicroVersion()));
                            } else {
                                this.saveApplicationInfoModel(element, propertyItem.getEmptyValue(), propertyItem.getEmptyValue(), propertyItem.getEmptyValue(), propertyItem.getEmptyValue());
                            }
                        } else {
                            String key = propertyItem.getKey();
                            String value = propertyItem.getValue();
                            if (propertyItem instanceof ISwitchablePropertyItem && !((ISwitchablePropertyItem)((Object)propertyItem)).isEnabled()) {
                                value = propertyItem.getEmptyValue();
                            }
                            if (!categoryItems[i].getData().equals("CollectorOptionsEditor.Applids.Category")) {
                                element.setAttribute(key, value);
                            } else {
                                AtomContentElement childElement = new AtomContentElement();
                                childElement.setName("app");
                                int k = 0;
                                while (k < AtomDefinitions.CMDFLOW_APPLIDS.length) {
                                    if (key.equals(AtomDefinitions.CMDFLOW_APPLIDS[k])) {
                                        String sysid;
                                        childElement.setAttribute("number", Integer.toString(k + 1));
                                        if (value.equals("")) {
                                            value = " ";
                                            sysid = " ";
                                        } else {
                                            sysid = (String)((CincCollector)this.collector).getMroRegions().get(value);
                                        }
                                        childElement.setValue(value);
                                        childElement.setAttribute("sysid", sysid);
                                        break;
                                    }
                                    ++k;
                                }
                                if (childElement.getValue() != null && !childElement.getValue().equals("")) {
                                    element.addElement(childElement);
                                }
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            if (this.collector instanceof CincCollector) {
                element.setAttribute("nameid", ((CincCollector)this.collector).getUserId());
            }
            int i = 0;
            while (i < categoryItems.length) {
                TreeItem[] attributeItems = categoryItems[i].getItems();
                int j = 0;
                while (j < attributeItems.length) {
                    GenericPropertyItem propertyItem = (GenericPropertyItem)attributeItems[j].getData();
                    if (propertyItem instanceof ApplicationInfoPropertyItem) {
                        if (this.getPropertyField("appl_mode", false).getValue().equals(AtomDefinitions.APPLICATION_MODE_FIELDS[1])) {
                            GetApplicationInfoCommand.ApplicationInfo appInfo = ((ApplicationInfoPropertyItem)propertyItem).getCurrentInfo();
                            this.saveApplicationInfoModel(element, appInfo.getName(), String.valueOf(appInfo.getMajorVersion()), String.valueOf(appInfo.getMinorVersion()), String.valueOf(appInfo.getMicroVersion()));
                        } else {
                            this.saveApplicationInfoModel(element, propertyItem.getEmptyValue(), propertyItem.getEmptyValue(), propertyItem.getEmptyValue(), propertyItem.getEmptyValue());
                        }
                    } else {
                        String key = propertyItem.getKey();
                        String value = propertyItem.getValue();
                        if (propertyItem instanceof ISwitchablePropertyItem && !((ISwitchablePropertyItem)((Object)propertyItem)).isEnabled()) {
                            value = propertyItem.getEmptyValue();
                        }
                        if (!categoryItems[i].getData().equals("CollectorOptionsEditor.Applids.Category")) {
                            element.setAttribute(key, value);
                        }
                        if (categoryItems[i].getData().equals("CollectorOptionsEditor.Applids.Category")) {
                            key = propertyItem.getKey();
                            value = propertyItem.getValue();
                            if (propertyItem instanceof ISwitchablePropertyItem && !((ISwitchablePropertyItem)((Object)propertyItem)).isEnabled()) {
                                value = propertyItem.getEmptyValue();
                            }
                            AtomContentElement childElement = new AtomContentElement();
                            childElement.setName("app");
                            int k = 0;
                            while (k < AtomDefinitions.CMDFLOW_APPLIDS.length) {
                                if (key.equals(AtomDefinitions.CMDFLOW_APPLIDS[k])) {
                                    String sysid;
                                    childElement.setAttribute("number", Integer.toString(k + 1));
                                    if (value.equals("")) {
                                        value = " ";
                                        sysid = " ";
                                    } else {
                                        sysid = (String)((CincCollector)this.collector).getMroRegions().get(value);
                                    }
                                    childElement.setValue(value);
                                    childElement.setAttribute("sysid", sysid);
                                    break;
                                }
                                ++k;
                            }
                            if (childElement.getValue() != null && !childElement.getValue().equals("")) {
                                element.addElement(childElement);
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.saveOptions(element);
        Debug.exit((Logger)logger, (String)CollectorOptionsEditor.class.getName(), (String)"doSave");
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        boolean noErrors = true;
        if (this.errors != null) {
            noErrors = this.errors.isEmpty();
        }
        return this.dirty && noErrors;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public void fireDirty() {
        this.dirty = true;
        this.firePropertyChange(257);
    }

    public void fireNotDirty() {
        this.dirty = false;
        this.firePropertyChange(257);
    }

    public AtomContent getCollector() {
        return this.collector;
    }

    public void setCollector(AtomContent collector) {
        this.collector = collector;
    }

    public String getPartProperty(String key) {
        if (IConnectionCategory.class.getName().equals(key)) {
            return "com.ibm.cics.ia.connection.db2";
        }
        return super.getPartProperty(key);
    }

    public void addError(final Control control, final String errorMessage) {
        Debug.enter((Logger)logger, (String)CollectorOptionsEditor.class.getName(), (String)"addError", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.errors.put(control, errorMessage);
        this.errorLabel.setText(errorMessage);
        Object accessibleListener = (AccessibleListener)control.getData("ACCESSIBLE_LISTENER");
        if (accessibleListener == null) {
            accessibleListener = new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = errorMessage;
                    control.getAccessible().removeAccessibleListener((AccessibleListener)this);
                    control.setData("ACCESSIBLE_LISTENER", null);
                }
            };
            control.setData("ACCESSIBLE_LISTENER", accessibleListener);
            control.getAccessible().addAccessibleListener(accessibleListener);
            control.getAccessible().selectionChanged();
        }
        this.firePropertyChange(257);
        Debug.exit((Logger)logger, (String)CollectorOptionsEditor.class.getName(), (String)"addError");
    }

    public void removeError(Control control) {
        Debug.enter((Logger)logger, (String)CollectorOptionsEditor.class.getName(), (String)"removeError", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.errors.remove(control);
        AccessibleListener listener = (AccessibleListener)control.getData("ACCESSIBLE_LISTENER");
        if (listener != null) {
            control.getAccessible().removeAccessibleListener(listener);
        }
        if (this.errors.isEmpty()) {
            this.errorLabel.setText(" ");
            this.firePropertyChange(257);
        } else {
            this.errorLabel.setText(this.errors.values().iterator().next());
        }
        Debug.exit((Logger)logger, (String)CollectorOptionsEditor.class.getName(), (String)"removeError");
    }

    public GenericPropertyItem getPropertyField(String key, boolean create) {
        if (this.propertyFieldFactory == null) {
            return null;
        }
        return this.propertyFieldFactory.getPropertyField(key, create);
    }

    public abstract String getEditorTitle();

    public abstract String getEditorMessage();

    public abstract String[] getCollectorAttributes();

    public abstract AtomContentElement getGeneralOptionsRootElement();

    public abstract void saveOptions(AtomContentElement var1);

    public abstract void setEditorHelp(Composite var1);

    public String getTitleToolTip() {
        return this.getTitle();
    }

    class RequestChangeAdapter
    extends JobChangeAdapter {
        RequestChangeAdapter() {
        }

        public void running(IJobChangeEvent event) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    CollectorOptionsEditor.this.progressMonitorPart.beginTask(Messages.getString("IAOperationsView.fetchingCollectorInformationText"), -1);
                    ((CollectorOptionsEditor)((RequestChangeAdapter)RequestChangeAdapter.this).CollectorOptionsEditor.this).stackLayout.topControl = CollectorOptionsEditor.this.loadingComposite;
                    CollectorOptionsEditor.this.stackParent.layout();
                }
            });
        }

        public void done(IJobChangeEvent event) {
            if (event.getResult().isOK()) {
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!CollectorOptionsEditor.this.progressMonitorPart.isDisposed()) {
                            Map regionMap;
                            Map properties;
                            CollectorOptionsEditor.this.progressMonitorPart.done();
                            CollectorOptionsEditor.this.collector = (AtomContent)ResourceFactory.getSingleton().getCincCollector(CollectorOptionsEditor.this.collector.getConnectionID(), ((CincCollector)CollectorOptionsEditor.this.collector).getUserId());
                            AtomContentElement element = CollectorOptionsEditor.this.getGeneralOptionsRootElement();
                            if (element != null) {
                                CollectorOptionsEditor.this.loadGeneralOptions(element.getAttributes());
                            }
                            if ((properties = ((CincCollector)CollectorOptionsEditor.this.collector).getProperties()) != null && (regionMap = (Map)properties.get("cincstate")) != null) {
                                int i = 0;
                                while (i < AtomDefinitions.CMDFLOW_APPLIDS.length) {
                                    String key = AtomDefinitions.CMDFLOW_APPLIDS[i];
                                    String number = Integer.toString(i + 1);
                                    GenericPropertyItem newItem = CollectorOptionsEditor.this.propertyFieldFactory.getPropertyField(key, true);
                                    if (newItem != null) {
                                        String value = regionMap.containsKey(number) ? ((String[])regionMap.get(number))[0] : "";
                                        newItem.setValue(value, false);
                                    }
                                    ++i;
                                }
                            }
                            UIUtilities.expandTree(CollectorOptionsEditor.this.propertyTree, true);
                            ((CollectorOptionsEditor)((RequestChangeAdapter)RequestChangeAdapter.this).CollectorOptionsEditor.this).stackLayout.topControl = CollectorOptionsEditor.this.editComposite;
                            CollectorOptionsEditor.this.stackParent.layout();
                        }
                    }
                });
            }
        }
    }
}

