/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.command.EngineShell;
import com.ibm.cics.dbfunc.ui.ScrollLimitManager;
import com.ibm.cics.ia.commands.FindCollectionIdsCommand;
import com.ibm.cics.ia.runtime.Version;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.DBLevelAdjustable;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.SelectionProvider;
import com.ibm.cics.ia.ui.State;
import com.ibm.cics.ia.ui.TableSelectionProvider;
import com.ibm.cics.ia.ui.UIUtilities;
import com.ibm.cics.ia.ui.composites.HistoryBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.part.ViewPart;

public class CollectionIdsView
extends ViewPart
implements DBLevelAdjustable {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CollectionIdsView.class.getPackage().getName());
    public static final String ID = "com.ibm.cics.ia.ui.CollectionIdsView";
    private Display display;
    private Composite rootComp;
    private Composite parent;
    private Table collectionIdsTable;
    private ArrayList<String> collectionIds;
    private State lowerThan3200State = new LevelLowerThan3200();
    private State level3200State = new Level3200();
    private State level5100State = new Level5100();
    private State disconnectedState = new DisconnectedState();
    private State state;
    private boolean viewInitialized;
    private String taskName = "";
    private TableItem dummyTableItem;
    private FindCollectionIdsCommand sqlCommand;
    private EngineShell.EngineListener commandListener;
    private HistoryBox searchHB;
    private Label searchLabel;
    private ScrollLimitManager scrollLimitManager;
    private SelectionProvider selectionProvider;
    private ConnectionServiceListener connectionServiceListener;

    public void createPartControl(Composite parent) {
        Debug.enter((Logger)logger, (String)CollectionIdsView.class.getName(), (String)"createPartControl", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.parent = parent;
        this.display = parent.getDisplay();
        this.rootComp = new Composite(parent, 4);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        this.rootComp.setLayout((Layout)gridLayout);
        Composite topComposite = new Composite(this.rootComp, 0);
        GridData data = new GridData(4, 0, true, false);
        topComposite.setLayoutData((Object)data);
        gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 2;
        topComposite.setLayout((Layout)new FormLayout());
        this.searchHB = new HistoryBox(topComposite, 128);
        FormData formData = new FormData();
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(0, 2);
        formData.bottom = new FormAttachment(100, -2);
        this.searchHB.setLayoutData(formData);
        this.searchLabel = new Label(topComposite, 0);
        formData = new FormData();
        formData.right = new FormAttachment(100, -5);
        formData.top = new FormAttachment(0, 5);
        this.searchLabel.setLayoutData((Object)formData);
        this.searchLabel.setText("      ");
        this.searchLabel.setEnabled(true);
        this.searchHB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                Debug.enter((Logger)logger, (String)"CollectionIdsView.searchHB.SelectionAdapter", (String)"widgetDefaultSelected", (Object)("Thread ID: " + Thread.currentThread().getId()));
                IConnectable resourceManager = ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.ia.connection.db2");
                if (!resourceManager.isConnected()) {
                    Activator.getDefault().ensureConnected();
                } else {
                    CollectionIdsView.this.runSearch();
                }
                Debug.exit((Logger)logger, (String)"CollectionIdsView.searchHB.SelectionAdapter", (String)"widgetDefaultSelected");
            }
        });
        this.searchHB.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                AccessibleEvent i = e;
                i.toString();
                e.result = Messages.getString("CollectionIdsView.access.msg.filterbyname");
            }
        });
        this.searchHB.setToolTipText(com.ibm.cics.ia.controller.Messages.getString("FindResourceContributionItem.tooltiptxt.usewildcardname"));
        this.collectionIdsTable = new Table(this.rootComp, 2564);
        data = new GridData(4, 4, true, true);
        this.collectionIdsTable.setLayoutData((Object)data);
        this.scrollLimitManager = new ScrollLimitManager(this.rootComp, Messages.getString("QueryResultsView.txt.resource"), (IViewPart)this){

            public void scrollLimitReached(Command command) {
                super.scrollLimitReached(command);
                CollectionIdsView.this.rootComp.layout(new Control[]{CollectionIdsView.this.collectionIdsTable, ((CollectionIdsView)CollectionIdsView.this).scrollLimitManager.scrollLimitComposite});
            }

            public void dispose() {
                CollectionIdsView.this.rootComp.layout(new Control[]{CollectionIdsView.this.collectionIdsTable});
                super.dispose();
            }
        };
        this.rootComp.pack();
        this.createPopupMenu();
        IWorkbenchHelpSystem helpSystem = this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)parent, "com.ibm.cics.ia.help.collection_ids_view");
        this.collectionIds = new ArrayList();
        this.viewInitialized = true;
        this.connectionServiceListener = this.getConnectionServiceListener();
        ConnectionsPlugin.getDefault().getConnectionService().addConnectionServiceListener(this.connectionServiceListener);
        this.updateAccordingToDBLevel();
        Debug.exit((Logger)logger, (String)CollectionIdsView.class.getName(), (String)"createPartControl");
    }

    private void updateAccordingToDBLevel() {
        Debug.enter((Logger)logger, (String)CollectionIdsView.class.getName(), (String)"updateAccordingToDBLevel", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (!this.viewInitialized) {
            Debug.exit((Logger)logger, (String)CollectionIdsView.class.getName(), (String)"updateAccordingToDBLevel");
            return;
        }
        IConnectable resourceManager = ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.ia.connection.db2");
        if (!resourceManager.isConnected()) {
            if (this.state == null) {
                this.state = this.disconnectedState;
            }
            this.state.switchToDisconnectedState();
        } else if (Version.getInstance().getDBVersion() >= 5100) {
            if (this.state == null) {
                this.state = this.level5100State;
            }
            this.state.switchToLevel5100();
        } else if (Version.getInstance().getDBVersion() == 3200) {
            if (this.state == null) {
                this.state = this.level3200State;
            }
            this.state.switchToLevel3200();
        } else if (Version.getInstance().getDBVersion() < 3200) {
            if (this.state == null) {
                this.state = this.lowerThan3200State;
            }
            this.state.switchToLevelLowerThan3200(Version.getInstance().getDBVersion());
        }
        Debug.exit((Logger)logger, (String)CollectionIdsView.class.getName(), (String)"updateAccordingToDBLevel");
    }

    private void createPopupMenu() {
        Debug.enter((Logger)logger, (String)CollectionIdsView.class.getName(), (String)"createPopupMenu", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.selectionProvider = new TableSelectionProvider(this.collectionIdsTable);
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        Menu popupMenu = menuMgr.createContextMenu((Control)this.collectionIdsTable);
        this.collectionIdsTable.setMenu(popupMenu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.selectionProvider);
        Debug.exit((Logger)logger, (String)CollectionIdsView.class.getName(), (String)"createPopupMenu");
    }

    public void setFocus() {
        if (this.collectionIdsTable != null && !this.collectionIdsTable.isDisposed()) {
            this.collectionIdsTable.setFocus();
        }
    }

    private String getTaskName() {
        return this.taskName;
    }

    public Job runSearch() {
        Debug.enter((Logger)logger, (String)CollectionIdsView.class.getName(), (String)"runSearch", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.collectionIdsTable != null) {
            this.clear();
            IConnectable resourceManager = ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.ia.connection.db2");
            if (!resourceManager.isConnected()) {
                Debug.exit((Logger)logger, (String)CollectionIdsView.class.getName(), (String)"runSearch", (Object)"return null");
                return null;
            }
            this.dummyTableItem = UIUtilities.createDummyTableItem(this.collectionIdsTable);
            this.sqlCommand = new FindCollectionIdsCommand();
            this.sqlCommand.setFilterCriteria(this.searchHB.getText(true));
            this.sqlCommand.addListener(this.getCommandListener());
            this.rootComp.setCursor(this.parent.getDisplay().getSystemCursor(3));
            Job findResourceJob = new Job(this.getTaskName()){

                protected IStatus run(IProgressMonitor monitor) {
                    Debug.enter((Logger)logger, (String)"CollectionIdsView.runSearch().Job", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                    monitor.beginTask(CollectionIdsView.this.getTaskName(), -1);
                    if (CollectionIdsView.this.sqlCommand != null) {
                        CollectionIdsView.this.sqlCommand.setAsync(false);
                        CollectionIdsView.this.sqlCommand.start();
                    }
                    monitor.done();
                    Debug.exit((Logger)logger, (String)"CollectionIdsView.runSearch().Job", (String)"run", (Object)("return: " + Status.OK_STATUS));
                    return Status.OK_STATUS;
                }
            };
            this.scrollLimitManager.setTaskName(this.getTaskName());
            findResourceJob.schedule();
            Debug.exit((Logger)logger, (String)CollectionIdsView.class.getName(), (String)"runSearch", (Object)("return: " + findResourceJob.getName()));
            return findResourceJob;
        }
        Debug.exit((Logger)logger, (String)CollectionIdsView.class.getName(), (String)"runSearch", (Object)"return null");
        return null;
    }

    private EngineShell.EngineListener getCommandListener() {
        if (this.commandListener == null) {
            this.commandListener = new EngineShell.EngineListener(){

                public void statusUpdate(EngineShell.EngineStatus es) {
                    switch (es) {
                        case Paused: {
                            CollectionIdsView.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!CollectionIdsView.this.rootComp.isDisposed()) {
                                        if (CollectionIdsView.this.scrollLimitManager != null) {
                                            CollectionIdsView.this.scrollLimitManager.scrollLimitReached((Command)CollectionIdsView.this.sqlCommand);
                                        }
                                        CollectionIdsView.this.rootComp.setCursor(null);
                                    }
                                }
                            });
                            break;
                        }
                        case Complete: {
                            CollectionIdsView.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!CollectionIdsView.this.rootComp.isDisposed()) {
                                        if (CollectionIdsView.this.scrollLimitManager != null) {
                                            CollectionIdsView.this.scrollLimitManager.dispose();
                                        }
                                        CollectionIdsView.this.rootComp.setCursor(null);
                                        CollectionIdsView.this.disposeDummyTableItem();
                                    }
                                }
                            });
                            break;
                        }
                        case Error: {
                            CollectionIdsView.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!CollectionIdsView.this.rootComp.isDisposed()) {
                                        if (CollectionIdsView.this.scrollLimitManager != null) {
                                            CollectionIdsView.this.scrollLimitManager.dispose();
                                        }
                                        CollectionIdsView.this.rootComp.setCursor(null);
                                        CollectionIdsView.this.disposeDummyTableItem();
                                    }
                                }
                            });
                            break;
                        }
                        case Cancelled: {
                            CollectionIdsView.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!CollectionIdsView.this.rootComp.isDisposed()) {
                                        if (CollectionIdsView.this.scrollLimitManager != null) {
                                            CollectionIdsView.this.scrollLimitManager.dispose();
                                        }
                                        CollectionIdsView.this.rootComp.setCursor(null);
                                        CollectionIdsView.this.clear();
                                    }
                                }
                            });
                        }
                    }
                }

                public void notifyResultCount(int count) {
                }

                public void dataAvailable(final Collection<Object> items) {
                    if (CollectionIdsView.this.display != null) {
                        CollectionIdsView.this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    if (items.size() > 0) {
                                        CollectionIdsView.this.insertResources(items);
                                    }
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                        });
                    }
                }
            };
        }
        return this.commandListener;
    }

    private void insertResources(Collection<Object> items) {
        Debug.enter((Logger)logger, (String)CollectionIdsView.class.getName(), (String)"insertResources", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "items size: " + items.size()});
        if (this.collectionIdsTable != null && !this.collectionIdsTable.isDisposed()) {
            this.disposeDummyTableItem();
            for (String string : items) {
                if (this.collectionIds.contains(string)) continue;
                TableItem newItem = new TableItem(this.collectionIdsTable, 0);
                newItem.setText(string);
                newItem.setData((Object)string);
                newItem.setImage(ImageFactory.getCollectionIdImage());
                this.collectionIds.add(string);
            }
            this.searchLabel.setText("(" + this.collectionIdsTable.getItemCount() + ")");
            this.searchLabel.getParent().layout(new Control[]{this.searchLabel});
            this.collectionIdsTable.setRedraw(true);
        }
        Debug.exit((Logger)logger, (String)CollectionIdsView.class.getName(), (String)"insertResources");
    }

    private void disposeDummyTableItem() {
        Debug.enter((Logger)logger, (String)CollectionIdsView.class.getName(), (String)"disposeDummyTableItem", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.dummyTableItem != null) {
            this.dummyTableItem.dispose();
            this.dummyTableItem = null;
        }
        Debug.exit((Logger)logger, (String)CollectionIdsView.class.getName(), (String)"disposeDummyTableItem");
    }

    private void clear() {
        Debug.enter((Logger)logger, (String)CollectionIdsView.class.getName(), (String)"clear", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.rootComp != null && !this.rootComp.isDisposed()) {
            this.collectionIdsTable.removeAll();
            this.disposeDummyTableItem();
            if (this.searchLabel != null) {
                this.searchLabel.setText("      ");
            }
            if (this.collectionIds != null) {
                this.collectionIds.clear();
            }
            if (this.scrollLimitManager != null) {
                this.scrollLimitManager.dispose();
            }
            if (this.selectionProvider != null) {
                this.selectionProvider.setSelection((ISelection)StructuredSelection.EMPTY);
            }
            if (this.rootComp != null && !this.rootComp.isDisposed()) {
                this.rootComp.setCursor(null);
            }
        }
        Debug.exit((Logger)logger, (String)CollectionIdsView.class.getName(), (String)"clear");
    }

    public void dispose() {
        Debug.enter((Logger)logger, (String)CollectionIdsView.class.getName(), (String)"dispose", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.connectionServiceListener != null) {
            this.connectionServiceListener.makeStale();
        }
        super.dispose();
        Debug.exit((Logger)logger, (String)CollectionIdsView.class.getName(), (String)"enclosing_method");
    }

    public void init(IViewSite site) throws PartInitException {
        Debug.enter((Logger)logger, (String)CollectionIdsView.class.getName(), (String)"init", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "site: " + site.getId()});
        super.init(site);
        this.setTitleToolTip(this.getTitle());
        Debug.exit((Logger)logger, (String)CollectionIdsView.class.getName(), (String)"enclosing_method");
    }

    public String getPartProperty(String key) {
        if (IConnectionCategory.class.getName().equals(key)) {
            return "com.ibm.cics.ia.connection.db2";
        }
        return super.getPartProperty(key);
    }

    private ConnectionServiceListener getConnectionServiceListener() {
        return new ConnectionServiceListener(){

            public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
                if ("com.ibm.cics.ia.connection.db2".equals(event.getConnectionCategoryId())) {
                    if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                        this.connected();
                    } else if (event instanceof ConnectionServiceListener.DisconnectedEvent) {
                        this.disconnected();
                    }
                }
            }

            public void connected() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CollectionIdsView.this.updateAccordingToDBLevel();
                    }
                });
            }

            public void disconnected() {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        CollectionIdsView.this.clear();
                    }
                });
            }
        };
    }

    private void insertResults() {
        if (this.collectionIdsTable != null && this.isCommandExecutable()) {
            this.runSearch();
        }
    }

    private boolean isCommandExecutable() {
        return this.sqlCommand == null || this.sqlCommand != null && this.sqlCommand.status() != 0 && this.sqlCommand.status() != 3;
    }

    public void setState(State state) {
        this.state = state;
    }

    @Override
    public void switchToLevelLowerThan3200(int dbLevel) {
        this.state.switchToLevelLowerThan3200(dbLevel);
    }

    @Override
    public void switchToLevel3200() {
        this.state.switchToLevel3200();
    }

    @Override
    public void switchToLevel5100() {
        this.state.switchToLevel5100();
    }

    @Override
    public void switchToDisconnectedState() {
        this.state.switchToDisconnectedState();
    }

    public ArrayList<String> getCollectionIds() {
        return this.collectionIds;
    }

    class DisconnectedState
    implements State {
        DisconnectedState() {
        }

        @Override
        public void switchToLevelLowerThan3200(int dbLevel) {
            CollectionIdsView.this.setState(CollectionIdsView.this.lowerThan3200State);
            CollectionIdsView.this.switchToLevelLowerThan3200(dbLevel);
        }

        @Override
        public void switchToLevel3200() {
            CollectionIdsView.this.setState(CollectionIdsView.this.level3200State);
            CollectionIdsView.this.switchToLevel3200();
        }

        @Override
        public void switchToLevel5100() {
            CollectionIdsView.this.setState(CollectionIdsView.this.level5100State);
            CollectionIdsView.this.switchToLevel5100();
        }

        @Override
        public void switchToDisconnectedState() {
            CollectionIdsView.this.searchHB.setText("");
            CollectionIdsView.this.searchHB.setEnabled(true);
        }
    }

    class Level3200
    implements State {
        Level3200() {
        }

        @Override
        public void switchToLevelLowerThan3200(int dbLevel) {
            CollectionIdsView.this.setState(CollectionIdsView.this.lowerThan3200State);
            CollectionIdsView.this.switchToLevelLowerThan3200(dbLevel);
        }

        @Override
        public void switchToLevel3200() {
            CollectionIdsView.this.searchHB.setEnabled(true);
            CollectionIdsView.this.insertResults();
        }

        @Override
        public void switchToLevel5100() {
            CollectionIdsView.this.setState(CollectionIdsView.this.level5100State);
            CollectionIdsView.this.switchToLevel5100();
        }

        @Override
        public void switchToDisconnectedState() {
            CollectionIdsView.this.setState(CollectionIdsView.this.disconnectedState);
            CollectionIdsView.this.switchToDisconnectedState();
        }
    }

    class Level5100
    implements State {
        Level5100() {
        }

        @Override
        public void switchToLevelLowerThan3200(int dbLevel) {
            CollectionIdsView.this.setState(CollectionIdsView.this.lowerThan3200State);
            CollectionIdsView.this.switchToLevelLowerThan3200(dbLevel);
        }

        @Override
        public void switchToLevel3200() {
            CollectionIdsView.this.setState(CollectionIdsView.this.level3200State);
            CollectionIdsView.this.switchToLevel3200();
        }

        @Override
        public void switchToLevel5100() {
            CollectionIdsView.this.searchHB.setEnabled(true);
            CollectionIdsView.this.insertResults();
        }

        @Override
        public void switchToDisconnectedState() {
            CollectionIdsView.this.setState(CollectionIdsView.this.disconnectedState);
            CollectionIdsView.this.switchToDisconnectedState();
        }
    }

    class LevelLowerThan3200
    implements State {
        LevelLowerThan3200() {
        }

        @Override
        public void switchToLevelLowerThan3200(int dbLevel) {
            if (dbLevel != 0) {
                TableItem tableItem = new TableItem(CollectionIdsView.this.collectionIdsTable, 0);
                tableItem.setText(Messages.getString("CollectionIdsView.access.msg.dblevel"));
            }
            CollectionIdsView.this.searchHB.setText("");
            CollectionIdsView.this.searchHB.setEnabled(false);
        }

        @Override
        public void switchToLevel3200() {
            CollectionIdsView.this.setState(CollectionIdsView.this.level3200State);
            CollectionIdsView.this.switchToLevel3200();
        }

        @Override
        public void switchToLevel5100() {
            CollectionIdsView.this.setState(CollectionIdsView.this.level5100State);
            CollectionIdsView.this.switchToLevel5100();
        }

        @Override
        public void switchToDisconnectedState() {
            CollectionIdsView.this.setState(CollectionIdsView.this.disconnectedState);
            CollectionIdsView.this.switchToDisconnectedState();
        }
    }
}

