/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.eclipse.common.ui.TextInput;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.Messages;
import java.util.logging.Logger;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;

public class CollectionIdWidget
extends WorkbenchWindowControlContribution {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CollectionIdWidget.class.getPackage().getName());
    public static final String ID = "com.ibm.cics.ia.ui.CollectionIdWidget";
    private Composite parent;
    private Composite rootComp;
    private Display display;
    private Text collectionIdText;
    private Label collectionIdLabel;
    private ToolItem clearItem;
    private ConnectionServiceListener connectionServiceListener = new ConnectionServiceListener(){

        public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
            if ("com.ibm.cics.ia.connection.db2".equals(event.getConnectionCategoryId()) && event instanceof ConnectionServiceListener.DisconnectedEvent) {
                this.disconnected();
            }
        }

        public void disconnected() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CollectionIdWidget.this.resetCollectionId();
                }
            });
        }
    };

    protected Control createControl(Composite parent) {
        Debug.enter((Logger)logger, (String)CollectionIdWidget.class.getName(), (String)"createControl", (Object)("Thread ID: " + Thread.currentThread().getId()));
        parent.getParent().setRedraw(true);
        this.parent = parent;
        this.rootComp = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        this.rootComp.setLayout((Layout)gridLayout);
        this.collectionIdLabel = new Label(this.rootComp, 0);
        this.collectionIdLabel.setText(Messages.getString("CollectionIdWidget.label"));
        this.collectionIdText = new Text(this.rootComp, 2056);
        TextInput.setAccessibleLabel((Text)this.collectionIdText, (Label)this.collectionIdLabel);
        this.collectionIdText.setText(IASQLCommand.getCollectionId());
        this.collectionIdText.setData((Object)IASQLCommand.getCollectionId());
        GridData data = new GridData(4, 0x1000000, false, true);
        FontData fontData = this.collectionIdText.getFont().getFontData()[0];
        Font boldFont = new Font((Device)parent.getDisplay(), fontData.getName(), fontData.getHeight(), fontData.getStyle() | 1);
        this.collectionIdText.setFont(boldFont);
        data.widthHint = 120;
        this.collectionIdText.setLayoutData((Object)data);
        this.collectionIdText.setToolTipText(com.ibm.cics.ia.controller.Messages.getString("CollectionIdContributionItem.tooltiptxt"));
        ToolBar toolBar1 = new ToolBar(this.rootComp, 0x800000);
        this.clearItem = new ToolItem(toolBar1, 0);
        this.clearItem.setImage(ImageFactory.getClearImage());
        this.clearItem.setDisabledImage(ImageFactory.getClearImage_DISABLED());
        this.clearItem.setEnabled(!IASQLCommand.getCollectionId().isEmpty());
        this.clearItem.setToolTipText(com.ibm.cics.ia.controller.Messages.getString("CollectionIdClearButton.tooltiptxt"));
        this.clearItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CollectionIdWidget.this.resetCollectionId();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.rootComp.pack();
        Activator.getDefault().setCollectionIdWidget(this);
        ConnectionsPlugin.getDefault().getConnectionService().addConnectionServiceListener(this.connectionServiceListener);
        Debug.exit((Logger)logger, (String)CollectionIdWidget.class.getName(), (String)"createControl");
        return this.rootComp;
    }

    public void dispose() {
        if (this.connectionServiceListener != null) {
            this.connectionServiceListener.makeStale();
        }
        super.dispose();
    }

    public String getCollectionId() {
        return (String)this.collectionIdText.getData();
    }

    public void setCollectionId(String aCollectionId) {
        Debug.enter((Logger)logger, (String)CollectionIdWidget.class.getName(), (String)"setCollectionId", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "aCollectioId: " + aCollectionId});
        if (this.collectionIdText != null && !this.collectionIdText.isDisposed()) {
            this.collectionIdText.setData((Object)aCollectionId);
            this.collectionIdText.setText(aCollectionId);
        }
        IASQLCommand.setCollectionId((String)aCollectionId);
        if (this.clearItem != null && !this.clearItem.isDisposed()) {
            if (IAUtilities.hasContent((String)aCollectionId)) {
                this.clearItem.setEnabled(true);
            } else {
                this.clearItem.setEnabled(false);
            }
        }
        Debug.exit((Logger)logger, (String)CollectionIdWidget.class.getName(), (String)"setCollectionId");
    }

    public void resetCollectionId() {
        Debug.enter((Logger)logger, (String)CollectionIdWidget.class.getName(), (String)"resetCollectionId", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.setCollectionId("");
        Debug.exit((Logger)logger, (String)CollectionIdWidget.class.getName(), (String)"resetCollectionId");
    }

    public boolean isDynamic() {
        return true;
    }
}

