/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.command.EngineShell;
import com.ibm.cics.dbfunc.command.SQLCommand;
import com.ibm.cics.ia.commands.FindTSApplicationsCommand;
import com.ibm.cics.ia.model.Operation;
import com.ibm.cics.ia.model.Platform;
import com.ibm.cics.ia.model.TSApplication;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.runtime.Version;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.DefaultRetrieveMorePresenterImpl;
import com.ibm.cics.ia.ui.DefaultRetrieveMoreViewImpl;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.NavigatorView;
import com.ibm.cics.ia.ui.Resource2CSV;
import com.ibm.cics.ia.ui.ResourceRenderer;
import com.ibm.cics.ia.ui.RetrieveMorePresenter;
import com.ibm.cics.ia.ui.RetrieveMoreView;
import com.ibm.cics.ia.ui.UIUtilities;
import com.ibm.cics.ia.ui.composites.HistoryBox;
import com.ibm.cics.ia.ui.composites.HistoryBoxModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;

public class CloudExplorer {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CloudExplorer.class.getPackage().getName());
    private Tree tree;
    private FindTSApplicationsCommand findTSApplicationsCommand;
    private Display display;
    private HistoryBox searchHB;
    private HistoryBoxModel searchHbModel;
    private HistoryBox platformHB;
    private HistoryBoxModel platformHbModel;
    private TreeItem dummyTreeItem;
    private EngineShell.EngineListener commandListener;
    private Action runAction;
    private Action copyAction;
    private Action refreshAction;
    private Composite parent;
    protected static final String RESOURCE_TYPE = "RESOURCE_TYPE";
    private HashMap<Object, TreeItem> treeItems = new HashMap();
    private ConnectionServiceListener connectionServiceListener;
    private TreeItem root;
    private NavigatorView navigatorView;
    private RetrieveMoreView retrieveMoreApplicationsView;
    private RetrieveMorePresenter retrieveMoreApplicationsPresenter;
    private Composite topComposite;

    public CloudExplorer(NavigatorView navigatorView) {
        this.navigatorView = navigatorView;
        this.tree = navigatorView.getTree();
        this.root = UIUtilities.createTreeItem(this.tree, Messages.getString("NavigatorView.category.cloudExplorer"), ImageFactory.getCloudImage());
    }

    public void createPartControl(Composite parent) {
        Debug.enter((Logger)logger, (String)CloudExplorer.class.getName(), (String)"createPartControl", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.parent = parent;
        this.display = parent.getDisplay();
        this.createActions();
        if (NavigatorView.isConnected()) {
            this.dummyTreeItem = UIUtilities.createDummyTreeItem(this.root);
        }
        this.tree.addKeyListener((KeyListener)new UIUtilities.CopyListener(){

            @Override
            public void copy() {
                if (CloudExplorer.this.copyAction.isEnabled()) {
                    Resource2CSV.parse(CloudExplorer.this.tree, CloudExplorer.this.display);
                }
            }
        });
        this.tree.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                CloudExplorer.this.copyAction.setEnabled(true);
            }

            public void focusGained(FocusEvent e) {
                if (CloudExplorer.this.tree.getSelection().length == 0 && CloudExplorer.this.tree.getItemCount() > 0) {
                    CloudExplorer.this.tree.setSelection(CloudExplorer.this.tree.getItem(0));
                }
                if (CloudExplorer.this.tree.getItemCount() == 0) {
                    CloudExplorer.this.copyAction.setEnabled(false);
                } else {
                    CloudExplorer.this.copyAction.setEnabled(true);
                }
            }
        });
        this.retrieveMoreApplicationsView = new DefaultRetrieveMoreViewImpl(this.tree, (IViewPart)this.navigatorView);
        this.retrieveMoreApplicationsPresenter = new DefaultRetrieveMorePresenterImpl(this.retrieveMoreApplicationsView);
        this.retrieveMoreApplicationsView.setPresenter(this.retrieveMoreApplicationsPresenter);
        this.connectionServiceListener = this.getConnectionServiceListener();
        ConnectionsPlugin.getDefault().getConnectionService().addConnectionServiceListener(this.connectionServiceListener);
        Debug.exit((Logger)logger, (String)CloudExplorer.class.getName(), (String)"createPartControl");
    }

    private void clear() {
        Debug.enter((Logger)logger, (String)CloudExplorer.class.getName(), (String)"clear", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.dummyTreeItem != null) {
            this.dummyTreeItem.dispose();
        }
        if (this.retrieveMoreApplicationsView != null) {
            this.retrieveMoreApplicationsView.hide();
        }
        if (this.findTSApplicationsCommand != null && this.findTSApplicationsCommand.status() == 0) {
            this.findTSApplicationsCommand.removeListener(this.getCommandListener());
            this.findTSApplicationsCommand.cancel();
        }
        this.findTSApplicationsCommand = null;
        this.treeItems = new HashMap();
        if (this.tree != null) {
            this.root.removeAll();
        }
        this.navigatorView.getViewSite().getActionBars().getStatusLineManager().setErrorMessage(null);
        if (this.navigatorView.getSelectionProvider() != null) {
            this.navigatorView.getSelectionProvider().setSelection((ISelection)StructuredSelection.EMPTY);
        }
        Debug.exit((Logger)logger, (String)CloudExplorer.class.getName(), (String)"clear");
    }

    public Job runSearch() {
        Debug.enter((Logger)logger, (String)CloudExplorer.class.getName(), (String)"runSearch", (Object)("Thread ID: " + Thread.currentThread().getId()));
        IConnectable resourceManager = ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.ia.connection.db2");
        if (!resourceManager.isConnected()) {
            Debug.exit((Logger)logger, (String)CloudExplorer.class.getName(), (String)"runSearch");
            return null;
        }
        this.clear();
        this.dummyTreeItem = UIUtilities.createDummyTreeItem(this.root);
        this.findTSApplicationsCommand = new FindTSApplicationsCommand();
        this.findTSApplicationsCommand.setApplicationName(UIUtilities.widgetExists((Widget)this.searchHB) ? this.searchHB.getText(false) : "");
        this.findTSApplicationsCommand.setPlatformName(UIUtilities.widgetExists((Widget)this.platformHB) ? this.platformHB.getText(false) : "");
        this.findTSApplicationsCommand.addListener(this.getCommandListener());
        this.retrieveMoreApplicationsPresenter.setCommand((Command)this.findTSApplicationsCommand);
        final String taskNameTS = Messages.getString("CloudExplorer.TaskName.TS");
        Job findTSApplicationJob = new Job(taskNameTS){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(taskNameTS, -1);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (UIUtilities.widgetExists((Widget)CloudExplorer.this.searchHB)) {
                            CloudExplorer.this.searchHB.setEnabled(false);
                        }
                        if (UIUtilities.widgetExists((Widget)CloudExplorer.this.platformHB)) {
                            CloudExplorer.this.platformHB.setEnabled(false);
                        }
                    }
                });
                CloudExplorer.this.findTSApplicationsCommand.setAsync(false);
                try {
                    CloudExplorer.this.findTSApplicationsCommand.start();
                }
                catch (Exception ex) {
                    IAPlugin.getDefault().logInformation(Messages.getString("CloudExplorer.Error.ProcedureCIUSPAP1.isUnavailable"));
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (UIUtilities.widgetExists((Widget)CloudExplorer.this.searchHB)) {
                            CloudExplorer.this.searchHB.setEnabled(true);
                        }
                        if (UIUtilities.widgetExists((Widget)CloudExplorer.this.platformHB)) {
                            CloudExplorer.this.platformHB.setEnabled(true);
                        }
                    }
                });
                monitor.done();
                return Status.OK_STATUS;
            }

            protected void canceling() {
                super.canceling();
                CloudExplorer.this.findTSApplicationsCommand.pause();
            }
        };
        findTSApplicationJob.schedule();
        this.retrieveMoreApplicationsPresenter.setTaskName(taskNameTS);
        Debug.exit((Logger)logger, (String)CloudExplorer.class.getName(), (String)"runSearch");
        return findTSApplicationJob;
    }

    private EngineShell.EngineListener getCommandListener() {
        if (this.commandListener == null) {
            this.commandListener = new EngineShell.EngineListener(){

                public void dataAvailable(final Collection<Object> items) {
                    Debug.enter((Logger)logger, (String)"CloudExplorer.getCommandListener()", (String)"dataAvailable", (Object)("Thread ID: " + Thread.currentThread().getId()));
                    CloudExplorer.this.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Debug.enter((Logger)logger, (String)"CloudExplorer.getCommandListener().dataAvailavble().syncExec", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                            CloudExplorer.this.applicationsFound(items);
                            Debug.exit((Logger)logger, (String)"CloudExplorer.getCommandListener().dataAvailavble().syncExec", (String)"run");
                        }
                    });
                    Debug.exit((Logger)logger, (String)"CloudExplorer.getCommandListener()", (String)"dataAvailable");
                }

                public void notifyResultCount(int count) {
                }

                public void statusUpdate(EngineShell.EngineStatus es) {
                    Debug.enter((Logger)logger, (String)"CloudExplorer.getCommandListener()", (String)"statusUpdate", (Object)("Thread ID: " + Thread.currentThread().getId()));
                    switch (es) {
                        case Paused: {
                            CloudExplorer.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (CloudExplorer.this.parent != null && !CloudExplorer.this.parent.isDisposed()) {
                                        if (CloudExplorer.this.retrieveMoreApplicationsView != null) {
                                            CloudExplorer.this.retrieveMoreApplicationsView.show();
                                        }
                                        CloudExplorer.this.parent.setCursor(null);
                                    }
                                }
                            });
                            break;
                        }
                        case Complete: {
                            CloudExplorer.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    Debug.enter((Logger)logger, (String)"CloudExplorer.getCommandListener().statusUpdate.asyncExec", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                                    CloudExplorer.this.parent.setCursor(null);
                                    if (CloudExplorer.this.dummyTreeItem != null && !CloudExplorer.this.dummyTreeItem.isDisposed()) {
                                        CloudExplorer.this.dummyTreeItem.dispose();
                                        CloudExplorer.this.dummyTreeItem = null;
                                    }
                                    Debug.exit((Logger)logger, (String)"CloudExplorer.getCommandListener().statusUpdate.asyncExec", (String)"run");
                                }
                            });
                            break;
                        }
                        case Error: {
                            CloudExplorer.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    Debug.enter((Logger)logger, (String)"CloudExplorer.getCommandListener().statusUpdate.asyncExec", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                                    CloudExplorer.this.parent.setCursor(null);
                                    CloudExplorer.this.clear();
                                    ArrayList<String> error = new ArrayList<String>();
                                    error.add(Messages.getString("CloudExplorer.Error.ProcedureCIUSPAP1.isUnavailable"));
                                    CloudExplorer.this.applicationsFound(error);
                                    Debug.exit((Logger)logger, (String)"CloudExplorer.getCommandListener().statusUpdate.asyncExec", (String)"run");
                                }
                            });
                        }
                    }
                    Debug.exit((Logger)logger, (String)"CloudExplorer.getCommandListener()", (String)"statusUpdate", (Object)("Thread ID: " + Thread.currentThread().getId()));
                }
            };
        }
        return this.commandListener;
    }

    private void applicationsFound(Collection items) {
        Debug.enter((Logger)logger, (String)CloudExplorer.class.getName(), (String)"applicationsFound", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.tree.setRedraw(false);
        if (this.dummyTreeItem != null) {
            this.dummyTreeItem.dispose();
            this.dummyTreeItem = null;
        }
        for (Object value : items) {
            if (value instanceof String) {
                TreeItem item = new TreeItem(this.root, 0);
                item.setText((String)value);
                item.setData((Object)((String)value));
                item.setImage(ImageFactory.getErrorImage());
                continue;
            }
            if (!(value instanceof TSApplication)) continue;
            TSApplication application = (TSApplication)value;
            Platform platform = application.getPlatform();
            TreeItem applicationItem = null;
            if (platform != null) {
                TreeItem platformItem = this.treeItems.get(platform.getName());
                if (platformItem == null) {
                    platformItem = new TreeItem(this.root, 0);
                    platformItem.setText(platform.getName());
                    platformItem.setImage(ImageFactory.getPlatformImage());
                    this.treeItems.put(platform.getName(), platformItem);
                    platformItem.setData((Object)platform);
                }
                if ((applicationItem = (TreeItem)platformItem.getData(application.getFullName())) == null) {
                    applicationItem = new TreeItem(platformItem, 0);
                    applicationItem.setText(String.valueOf(application.getName()) + " (" + application.getMajorVersion() + "." + application.getMinorVersion() + "." + application.getMicroVersion() + ")");
                    applicationItem.setImage(ResourceRenderer.asImage(application));
                    applicationItem.setData((Object)application);
                    platformItem.setData(application.getFullName(), (Object)applicationItem);
                    this.retrieveMoreApplicationsView.setParentItem(applicationItem);
                }
            } else {
                applicationItem = this.treeItems.get(application.getFullName());
                if (applicationItem == null) {
                    applicationItem = new TreeItem(this.root, 0);
                    applicationItem.setText(String.valueOf(application.getName()) + " (" + application.getMajorVersion() + "." + application.getMinorVersion() + "." + application.getMicroVersion() + ")");
                    applicationItem.setImage(ResourceRenderer.asImage(application));
                    applicationItem.setData((Object)application);
                    this.treeItems.put(application.getFullName(), applicationItem);
                    this.retrieveMoreApplicationsView.setParentItem(this.root);
                }
            }
            for (Operation operation : application.getOperations()) {
                TreeItem operationItem = (TreeItem)applicationItem.getData(operation.getName());
                if (operationItem != null) continue;
                operationItem = new TreeItem(applicationItem, 0);
                operationItem.setText(operation.getName());
                operationItem.setImage(ImageFactory.getOperationImage());
                operationItem.setData((Object)operation);
                applicationItem.setData(operation.getName(), (Object)operationItem);
            }
        }
        this.tree.setRedraw(true);
        Debug.exit((Logger)logger, (String)CloudExplorer.class.getName(), (String)"applicationsFound");
    }

    private void errorFound(Throwable e) {
    }

    public void setFocus() {
    }

    public void dispose() {
        Debug.enter((Logger)logger, (String)CloudExplorer.class.getName(), (String)"dispose", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.connectionServiceListener != null) {
            this.connectionServiceListener.makeStale();
        }
        Debug.exit((Logger)logger, (String)CloudExplorer.class.getName(), (String)"dispose");
    }

    public void init(IViewSite site) throws PartInitException {
    }

    private ConnectionServiceListener getConnectionServiceListener() {
        return new ConnectionServiceListener(){

            public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
                Debug.enter((Logger)logger, (String)ConnectionServiceListener.class.getName(), (String)"event", (Object)("Thread ID: " + Thread.currentThread().getId()));
                if ("com.ibm.cics.ia.connection.db2".equals(event.getConnectionCategoryId())) {
                    if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                        this.connected();
                    } else if (event instanceof ConnectionServiceListener.DisconnectedEvent) {
                        this.disconnected();
                    }
                }
                Debug.exit((Logger)logger, (String)ConnectionServiceListener.class.getName(), (String)"event");
            }

            public void connected() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ISelectionProvider provider;
                        Debug.enter((Logger)logger, (String)"ConnectionServiceListener.connected().Runnable.asyncExec", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                        CloudExplorer.this.clear();
                        CloudExplorer.this.dummyTreeItem = NavigatorView.createDummyIfNotExists(CloudExplorer.this.dummyTreeItem, CloudExplorer.this.root);
                        IWorkbenchPartSite site = CloudExplorer.this.navigatorView.getSite();
                        if (site != null && (provider = site.getSelectionProvider()) != null) {
                            provider.setSelection((ISelection)StructuredSelection.EMPTY);
                        }
                        if (UIUtilities.widgetExists((Widget)CloudExplorer.this.platformHB)) {
                            CloudExplorer.this.platformHB.setEnabled(Version.getInstance().getDBVersion() >= 5200);
                        }
                        Debug.exit((Logger)logger, (String)"ConnectionServiceListener.connected().Runnable.asyncExec", (String)"run");
                    }
                });
            }

            public void disconnected() {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ISelectionProvider provider;
                        Debug.enter((Logger)logger, (String)"ConnectionServiceListener.disconnected().Runnable.asyncExec", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                        CloudExplorer.this.clear();
                        IWorkbenchPartSite site = CloudExplorer.this.navigatorView.getSite();
                        if (site != null && (provider = site.getSelectionProvider()) != null) {
                            provider.setSelection((ISelection)StructuredSelection.EMPTY);
                        }
                        if (UIUtilities.widgetExists((Widget)CloudExplorer.this.platformHB)) {
                            CloudExplorer.this.platformHB.setEnabled(false);
                        }
                        Debug.exit((Logger)logger, (String)"ConnectionServiceListener.disconnected().Runnable.asyncExec", (String)"run");
                    }
                });
            }
        };
    }

    private void createActions() {
        this.runAction = new Action(){

            public void run() {
                CloudExplorer.this.runSearch();
            }
        };
        this.refreshAction = new Action(Messages.getString("CloudExplorer.refreshButtonText"), ImageDescriptor.createFromImage((Image)ImageFactory.getRefreshImage())){

            public void run() {
                CloudExplorer.this.runSearch();
            }
        };
        this.navigatorView.getViewSite().getActionBars().setGlobalActionHandler("com.ibm.cics.ia.action.run", (IAction)this.runAction);
        this.copyAction = new Action("Copy", null){

            public void run() {
                if (CloudExplorer.this.tree.isFocusControl()) {
                    Resource2CSV.parse(CloudExplorer.this.tree, CloudExplorer.this.display);
                }
            }
        };
        this.navigatorView.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
    }

    public TreeItem getRoot() {
        return this.root;
    }

    public void buildPopupMenu(IMenuManager manager, TreeItem[] selectedItems) {
        manager.add((IContributionItem)new Separator("additions"));
        if (selectedItems.length == 1) {
            TreeItem item = selectedItems[0];
            if (item == this.root) {
                manager.add((IAction)this.refreshAction);
            }
            MenuManager showCommandsMenu = new MenuManager();
            manager.add((IContributionItem)showCommandsMenu);
        }
    }

    public void rootExpanded() {
        if (NavigatorView.canRunCommand((SQLCommand)this.findTSApplicationsCommand) && UIUtilities.widgetExists((Widget)this.dummyTreeItem) && NavigatorView.isConnected()) {
            if (this.navigatorView.getTopComposite() != this.topComposite) {
                this.createTopComposite();
            }
            this.runSearch();
        }
    }

    public void selected() {
        if (this.navigatorView.getTopComposite() != this.topComposite) {
            this.createTopComposite();
        }
    }

    private void createTopComposite() {
        this.topComposite = new Composite(this.parent, 0);
        GridData data = new GridData(4, 0, true, false);
        this.topComposite.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 2;
        this.topComposite.setLayout((Layout)gridLayout);
        this.topComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CloudExplorer.this.searchHbModel = CloudExplorer.this.searchHB.getModel();
                CloudExplorer.this.platformHbModel = CloudExplorer.this.platformHB.getModel();
            }
        });
        Label platformLabel = new Label(this.topComposite, 0);
        platformLabel.setText(Messages.getString("CloudExplorer.Platform.Label"));
        data = new GridData(4, 0x1000000, false, false);
        platformLabel.setLayoutData((Object)data);
        this.platformHB = new HistoryBox(this.topComposite, 128);
        if (this.platformHbModel != null) {
            this.platformHB.setModel(this.platformHbModel);
        }
        data = new GridData(4, 0x1000000, false, false);
        data.widthHint = 70;
        this.platformHB.setLayoutData(data);
        this.platformHB.setEnabled(Version.getInstance().getDBVersion() >= 5200);
        this.platformHB.setLayoutData(new GridData(4, 0x1000000, false, false));
        this.platformHB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                Debug.enter((Logger)logger, (String)"CloudExplorer.platformHB.SelectionAdapter", (String)"widgetDefaultSelected", (Object)("Thread ID: " + Thread.currentThread().getId()));
                IConnectable resourceManager = ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.ia.connection.db2");
                if (!resourceManager.isConnected()) {
                    Activator.getDefault().ensureConnected();
                } else {
                    CloudExplorer.this.runSearch();
                }
                Debug.exit((Logger)logger, (String)"CloudExplorer.platformHB.SelectionAdapter", (String)"widgetDefaultSelected");
            }
        });
        this.platformHB.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                AccessibleEvent i = e;
                i.toString();
                e.result = Messages.getString("CloudExplorer.access.msg.filterByPlatform");
            }
        });
        this.platformHB.setToolTipText(com.ibm.cics.ia.controller.Messages.getString("FindResourceContributionItem.tooltiptxt.usewildcardname"));
        this.platformHB.setEnabled(Version.getInstance().getDBVersion() >= 5200);
        Label applicationLabel = new Label(this.topComposite, 0);
        applicationLabel.setText(Messages.getString("CloudExplorer.Application.Label"));
        data = new GridData(4, 0x1000000, false, false);
        applicationLabel.setLayoutData((Object)data);
        this.searchHB = new HistoryBox(this.topComposite, 128);
        if (this.searchHbModel != null) {
            this.searchHB.setModel(this.searchHbModel);
        }
        data = new GridData(4, 0x1000000, false, false);
        data.widthHint = 70;
        this.searchHB.setLayoutData(data);
        this.searchHB.setLayoutData(new GridData(4, 0x1000000, false, false));
        this.searchHB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                Debug.enter((Logger)logger, (String)"CloudExplorer.searchHB.SelectionAdapter", (String)"widgetDefaultSelected", (Object)("Thread ID: " + Thread.currentThread().getId()));
                IConnectable resourceManager = ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.ia.connection.db2");
                if (!resourceManager.isConnected()) {
                    Activator.getDefault().ensureConnected();
                } else {
                    CloudExplorer.this.runSearch();
                }
                Debug.exit((Logger)logger, (String)"CloudExplorer.searchHB.SelectionAdapter", (String)"widgetDefaultSelected");
            }
        });
        this.searchHB.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                AccessibleEvent i = e;
                i.toString();
                e.result = Messages.getString("CloudExplorer.access.msg.filterByName");
            }
        });
        this.searchHB.setToolTipText(com.ibm.cics.ia.controller.Messages.getString("FindResourceContributionItem.tooltiptxt.usewildcardname"));
        this.navigatorView.setTopComposite(this.topComposite);
    }

    public void refresh(final Action afterRefreshAction) {
        Job runJob = this.runSearch();
        if (runJob != null) {
            runJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    afterRefreshAction.run();
                }
            });
        } else {
            afterRefreshAction.run();
        }
    }
}

