/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.bundle.ui.BundleUIMessages;
import com.ibm.cics.bundle.ui.NewCICSBundleProjectWizard;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.CicsBundleResource;
import com.ibm.cics.ia.model.CiuspdepModel;
import com.ibm.cics.ia.model.EntryPoint;
import com.ibm.cics.ia.model.EntryPointTreeItem;
import com.ibm.cics.ia.model.EntryPointsModel;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.CellEditorValidator;
import com.ibm.cics.ia.ui.EntryPointsPresenter;
import com.ibm.cics.ia.ui.EntryPointsTreeByAppLabelProvider;
import com.ibm.cics.ia.ui.EntryPointsTreeByAppWithDepLabelProvider;
import com.ibm.cics.ia.ui.EntryPointsTreeByRegionLabelProvider;
import com.ibm.cics.ia.ui.EntryPointsTreeUtilities;
import com.ibm.cics.ia.ui.EntryPointsView;
import com.ibm.cics.ia.ui.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class CiuspepsEntryPointsPresenter
implements EntryPointsPresenter {
    private static final Logger logger = Logger.getLogger(CiuspepsEntryPointsPresenter.class.getPackage().getName());
    protected String[] columnNames = new String[]{"!", Messages.getString("ApplicationCreationWizard.table.column.collectionId"), Messages.getString("ApplicationCreationWizard.table.column.applId"), Messages.getString("ApplicationCreationWizard.table.column.type"), BundleUIMessages.EntryPointDialog_nameLabel, BundleUIMessages.EntryPointDialog_operationLabel, Messages.getString("ApplicationCreationWizard.table.column.platform"), Messages.getString("ApplicationCreationWizard.table.column.application"), Messages.getString("ApplicationCreationWizard.table.column.operation")};
    protected EntryPointsView view;
    protected EntryPointsModel model;
    protected Map<Integer, ICellEditorValidator> validators;
    protected Map<Integer, ICellEditorListener> cellEditorListeners;

    public String createProject() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"createProject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String projectName = null;
        NewCICSBundleProjectWizard wizard = new NewCICSBundleProjectWizard();
        WizardDialog wizardDialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        wizardDialog.setBlockOnOpen(true);
        if (wizardDialog.open() == 0 && wizard.getNewProject() != null) {
            IProject p = wizard.getNewProject();
            this.view.getUpdatePage().setProjectComboContents((String[])IAUtilities.concat((Object[])new String[]{Messages.getString("ApplicationCreationWizard.newProject")}, (Object[][])new String[][]{this.model.getCicsBundleProjectNames()}));
            projectName = p.getName();
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"createProject");
        return projectName;
    }

    @Override
    public void onFinish() {
        this.model.addEntryPointsToProject();
    }

    @Override
    public void setView(EntryPointsView view) {
        this.view = view;
    }

    @Override
    public void setModel(EntryPointsModel model) {
        this.model = model;
    }

    protected boolean canFinish() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"canFinish", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String selectedCombo1Item = this.view.getUpdatePage().getSelectedCombo1Item();
        if (selectedCombo1Item == null) {
            Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"canFinish");
            return false;
        }
        if (this.view.getUpdatePage().getSelectedProjectComboIndex() <= 0) {
            Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"canFinish");
            return false;
        }
        if (this.view.getUpdatePage().getErrorMessage() != null) {
            Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"canFinish");
            return false;
        }
        if (this.model.getCachedEntryPoints().isEmpty()) {
            Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"canFinish");
            return false;
        }
        for (EntryPoint entryPoint : this.model.getCachedEntryPoints()) {
            if (!entryPoint.isEnabled() || !entryPoint.isSelected()) continue;
            Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"canFinish");
            return true;
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"canFinish");
        return false;
    }

    @Override
    public void onUpdatePageCreation() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"onUpdatePageCreation", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.view.getUpdatePage().setPageComplete(false);
        this.view.getUpdatePage().setCombo1Items(new String[]{Messages.getString("ApplicationCreationWizard.type.transaction"), Messages.getString("ApplicationCreationWizard.type.urimap")});
        this.view.getUpdatePage().setCicsTsLevelComboContents(new String[]{EntryPointsModel.CicsTsLevel.LEVEL_51.toString(), EntryPointsModel.CicsTsLevel.LEVEL_52.toString(), EntryPointsModel.CicsTsLevel.LEVEL_53.toString(), EntryPointsModel.CicsTsLevel.LEVEL_55.toString(), EntryPointsModel.CicsTsLevel.LEVEL_56.toString(), EntryPointsModel.CicsTsLevel.LEVEL_61.toString(), EntryPointsModel.CicsTsLevel.LEVEL_62.toString(), EntryPointsModel.CicsTsLevel.LEVEL_63.toString()});
        String[] projectNames = this.model.getCicsBundleProjectNames();
        this.view.getUpdatePage().setProjectComboContents((String[])IAUtilities.concat((Object[])new String[]{Messages.getString("ApplicationCreationWizard.type.newProject")}, (Object[][])new String[][]{projectNames}));
        final CellEditorValidator operationValidator = new CellEditorValidator();
        ICellEditorListener cellEditorListener = new ICellEditorListener(){

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                CiuspepsEntryPointsPresenter.this.view.getUpdatePage().setErrorMessage(operationValidator.getErrorMessage());
            }

            public void cancelEditor() {
                CiuspepsEntryPointsPresenter.this.updateGeneralErrorMessage();
            }

            public void applyEditorValue() {
                CiuspepsEntryPointsPresenter.this.updateGeneralErrorMessage();
            }
        };
        this.validators = new HashMap<Integer, ICellEditorValidator>();
        this.cellEditorListeners = new HashMap<Integer, ICellEditorListener>();
        List input = this.model.getCachedEntryPoints();
        String type = this.view.getUpdatePage().getTreeType();
        if (type.equals(EntryPointsTreeUtilities.TreeTypes.ByRegion.toString())) {
            this.view.getUpdatePage().getTreeViewer().setLabelProvider((IBaseLabelProvider)new EntryPointsTreeByRegionLabelProvider());
            this.columnNames = new String[]{"!", Messages.getString("ApplicationCreationWizard.table.column.collectionId"), Messages.getString("ApplicationCreationWizard.table.column.applId"), Messages.getString("ApplicationCreationWizard.table.column.type"), BundleUIMessages.EntryPointDialog_nameLabel, BundleUIMessages.EntryPointDialog_operationLabel, Messages.getString("ApplicationCreationWizard.table.column.platform"), Messages.getString("ApplicationCreationWizard.table.column.application"), Messages.getString("ApplicationCreationWizard.table.column.operation")};
            this.view.getUpdatePage().setCellModifier(new EntryPointCellModifier());
            this.validators.put(5, operationValidator);
            this.cellEditorListeners.put(5, cellEditorListener);
            this.view.getUpdatePage().getTreeViewer().setColumnProperties(this.columnNames);
            this.view.getUpdatePage().initTable(this.getColumnNames(), this.validators, this.cellEditorListeners, input);
        }
        if (type.equals(EntryPointsTreeUtilities.TreeTypes.ByApp.toString())) {
            this.view.getUpdatePage().getTreeViewer().setLabelProvider((IBaseLabelProvider)new EntryPointsTreeByAppLabelProvider());
            this.columnNames = new String[]{"!", Messages.getString("ApplicationCreationWizard.table.column.collectionId"), Messages.getString("ApplicationCreationWizard.table.column.platform"), Messages.getString("ApplicationCreationWizard.table.column.application"), Messages.getString("ApplicationCreationWizard.table.column.operation"), BundleUIMessages.EntryPointDialog_nameLabel, Messages.getString("ApplicationCreationWizard.table.column.type"), Messages.getString("ApplicationCreationWizard.table.column.applId"), BundleUIMessages.EntryPointDialog_operationLabel};
            this.view.getUpdatePage().setCellModifier(new EntryPointByAppCellModifier());
            this.validators.put(4, operationValidator);
            this.cellEditorListeners.put(4, cellEditorListener);
            this.view.getUpdatePage().getTreeViewer().setColumnProperties(this.columnNames);
            this.view.getUpdatePage().initTable(this.getColumnNames(), this.validators, this.cellEditorListeners, input);
        }
        if (type.equals(EntryPointsTreeUtilities.TreeTypes.ByAppWithDep.toString())) {
            this.view.getUpdatePage().getTreeViewer().setLabelProvider((IBaseLabelProvider)new EntryPointsTreeByAppWithDepLabelProvider());
            this.columnNames = new String[]{"!", Messages.getString("ApplicationCreationWizard.table.column.collectionId"), Messages.getString("ApplicationCreationWizard.table.column.platform"), Messages.getString("ApplicationCreationWizard.table.column.application"), Messages.getString("ApplicationCreationWizard.table.column.operation"), Messages.getString("ApplicationCreationWizard.table.column.entryType"), BundleUIMessages.EntryPointDialog_nameLabel, Messages.getString("ApplicationCreationWizard.table.column.type"), Messages.getString("ApplicationCreationWizard.table.column.applId"), BundleUIMessages.EntryPointDialog_operationLabel};
            ArrayList<EntryPoint> entriesFromDep = new ArrayList<EntryPoint>();
            CiuspdepModel depModel = new CiuspdepModel(this.model.getResource());
            List dependencies = depModel.getFreshDependencies();
            if (dependencies != null) {
                for (CicsBundleResource dep : dependencies) {
                    EntryPoint entry = new EntryPoint(dep.getName(), dep.getApplOperation(), dep.getBundlePartType(), dep.getAdditionalAttributes());
                    entry.setIsDep(true);
                    entry.setEnabled(true);
                    if (entry.getOperation() == null) {
                        entry.setOperation("");
                    }
                    entriesFromDep.add(entry);
                }
            }
            if (entriesFromDep.size() != 0) {
                input.addAll(entriesFromDep);
            }
            this.view.getUpdatePage().setCellModifier(new EntryPointByAppCellModifier());
            this.validators.put(4, operationValidator);
            this.cellEditorListeners.put(4, cellEditorListener);
            this.view.getUpdatePage().getTreeViewer().setColumnProperties(this.columnNames);
            this.view.getUpdatePage().initTable(this.getColumnNames(), this.validators, this.cellEditorListeners, input);
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"onUpdatePageCreation");
    }

    protected String[] getColumnNames() {
        return this.columnNames;
    }

    @Override
    public void combo1Selected() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"combo1Selected", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String selectedCombo1Item = this.view.getUpdatePage().getSelectedCombo1Item();
        if (selectedCombo1Item != null) {
            this.updateModelOnCombo1Selection(selectedCombo1Item);
            String[] columnNames = this.getColumnNames();
            List entryPoints = this.model.getFreshEntryPoints();
            this.model.validateResources();
            this.updateGeneralErrorMessage();
            final CellEditorValidator operationValidator = new CellEditorValidator();
            ICellEditorListener cellEditorListener = new ICellEditorListener(){

                public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                    CiuspepsEntryPointsPresenter.this.view.getUpdatePage().setErrorMessage(operationValidator.getErrorMessage());
                }

                public void cancelEditor() {
                    CiuspepsEntryPointsPresenter.this.updateGeneralErrorMessage();
                }

                public void applyEditorValue() {
                    CiuspepsEntryPointsPresenter.this.updateGeneralErrorMessage();
                }
            };
            HashMap<Integer, ICellEditorValidator> validators = new HashMap<Integer, ICellEditorValidator>();
            validators.put(5, operationValidator);
            HashMap<Integer, ICellEditorListener> cellEditorListeners = new HashMap<Integer, ICellEditorListener>();
            cellEditorListeners.put(5, cellEditorListener);
            this.view.getUpdatePage().initTable(columnNames, validators, cellEditorListeners, entryPoints);
        }
        this.view.getUpdatePage().setPageComplete(this.canFinish());
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"combo1Selected");
    }

    public void updateModelOnCombo1Selection(String selectedCombo1Item) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"updateModelOnCombo1Selection", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (Messages.getString("ApplicationCreationWizard.type.transaction").equals(selectedCombo1Item)) {
            this.model.setCallTypeParam(EntryPointsModel.CallType.T);
        } else if (Messages.getString("ApplicationCreationWizard.type.urimap").equals(selectedCombo1Item)) {
            this.model.setCallTypeParam(EntryPointsModel.CallType.U);
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"updateModelOnCombo1Selection");
    }

    protected void updateGeneralErrorMessage() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"updateGeneralErrorMessage", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.model.hasInvalidResources()) {
            this.view.getUpdatePage().setErrorMessage(Messages.getString("ApplicationCreationWizard.EntryPointsPage.invalidEntryPoints"));
        } else {
            this.view.getUpdatePage().setErrorMessage(null);
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"updateGeneralErrorMessage");
    }

    @Override
    public void projectSelected() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"projectSelected", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String projectName = null;
        if (this.view.getUpdatePage().getSelectedProjectComboIndex() == 0) {
            projectName = this.createProject();
            this.view.getUpdatePage().selectProjectComboItem(projectName);
            this.model.setProjectName(projectName);
            this.model.validateResources();
            this.updateGeneralErrorMessage();
        }
        if (this.view.getUpdatePage().getSelectedProjectComboIndex() > 0) {
            projectName = this.view.getUpdatePage().getSelectedProject();
            this.model.setProjectName(projectName);
            this.model.validateResources();
            this.updateGeneralErrorMessage();
            this.view.getUpdatePage().setProjectComboToolTip(projectName);
        }
        this.view.getUpdatePage().refreshTable();
        this.view.getUpdatePage().setPageComplete(this.canFinish());
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"projectSelected");
    }

    @Override
    public void treeTypeSelected() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"projectSelected", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String type = this.view.getUpdatePage().getTreeType();
        final CellEditorValidator operationValidator = new CellEditorValidator();
        ICellEditorListener cellEditorListener = new ICellEditorListener(){

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                CiuspepsEntryPointsPresenter.this.view.getUpdatePage().setErrorMessage(operationValidator.getErrorMessage());
            }

            public void cancelEditor() {
                CiuspepsEntryPointsPresenter.this.updateGeneralErrorMessage();
            }

            public void applyEditorValue() {
                CiuspepsEntryPointsPresenter.this.updateGeneralErrorMessage();
            }
        };
        this.view.getUpdatePage().cachedTreeItems.clear();
        this.validators = new HashMap<Integer, ICellEditorValidator>();
        this.cellEditorListeners = new HashMap<Integer, ICellEditorListener>();
        List input = new ArrayList();
        input = this.model.getFreshEntryPoints();
        if (type.equals(EntryPointsTreeUtilities.TreeTypes.ByRegion.toString())) {
            this.view.getUpdatePage().getTreeViewer().setLabelProvider((IBaseLabelProvider)new EntryPointsTreeByRegionLabelProvider());
            this.columnNames = new String[]{"!", Messages.getString("ApplicationCreationWizard.table.column.collectionId"), Messages.getString("ApplicationCreationWizard.table.column.applId"), Messages.getString("ApplicationCreationWizard.table.column.type"), BundleUIMessages.EntryPointDialog_nameLabel, BundleUIMessages.EntryPointDialog_operationLabel, Messages.getString("ApplicationCreationWizard.table.column.platform"), Messages.getString("ApplicationCreationWizard.table.column.application"), Messages.getString("ApplicationCreationWizard.table.column.operation")};
            this.view.getUpdatePage().setCellModifier(new EntryPointCellModifier());
            this.validators.put(5, operationValidator);
            this.cellEditorListeners.put(5, cellEditorListener);
            this.view.getUpdatePage().getTreeViewer().setColumnProperties(this.columnNames);
            this.view.getUpdatePage().initTable(this.getColumnNames(), this.validators, this.cellEditorListeners, input);
        }
        if (type.equals(EntryPointsTreeUtilities.TreeTypes.ByApp.toString())) {
            this.view.getUpdatePage().getTreeViewer().setLabelProvider((IBaseLabelProvider)new EntryPointsTreeByAppLabelProvider());
            this.columnNames = new String[]{"!", Messages.getString("ApplicationCreationWizard.table.column.collectionId"), Messages.getString("ApplicationCreationWizard.table.column.platform"), Messages.getString("ApplicationCreationWizard.table.column.application"), Messages.getString("ApplicationCreationWizard.table.column.operation"), BundleUIMessages.EntryPointDialog_nameLabel, Messages.getString("ApplicationCreationWizard.table.column.type"), Messages.getString("ApplicationCreationWizard.table.column.applId"), BundleUIMessages.EntryPointDialog_operationLabel};
            this.view.getUpdatePage().setCellModifier(new EntryPointByAppCellModifier());
            this.validators.put(4, operationValidator);
            this.cellEditorListeners.put(4, cellEditorListener);
            this.view.getUpdatePage().getTreeViewer().setColumnProperties(this.columnNames);
            this.view.getUpdatePage().initTable(this.getColumnNames(), this.validators, this.cellEditorListeners, input);
        }
        if (type.equals(EntryPointsTreeUtilities.TreeTypes.ByAppWithDep.toString())) {
            this.view.getUpdatePage().getTreeViewer().setLabelProvider((IBaseLabelProvider)new EntryPointsTreeByAppWithDepLabelProvider());
            this.columnNames = new String[]{"!", Messages.getString("ApplicationCreationWizard.table.column.collectionId"), Messages.getString("ApplicationCreationWizard.table.column.platform"), Messages.getString("ApplicationCreationWizard.table.column.application"), Messages.getString("ApplicationCreationWizard.table.column.operation"), Messages.getString("ApplicationCreationWizard.table.column.entryType"), BundleUIMessages.EntryPointDialog_nameLabel, Messages.getString("ApplicationCreationWizard.table.column.type"), Messages.getString("ApplicationCreationWizard.table.column.applId"), BundleUIMessages.EntryPointDialog_operationLabel};
            ArrayList<EntryPoint> entriesFromDep = new ArrayList<EntryPoint>();
            CiuspdepModel depModel = new CiuspdepModel(this.model.getResource());
            List dependencies = depModel.getFreshDependencies();
            if (dependencies != null) {
                for (CicsBundleResource dep : dependencies) {
                    EntryPoint entry = new EntryPoint(dep.getName(), dep.getApplOperation(), dep.getBundlePartType(), dep.getAdditionalAttributes());
                    entry.setIsDep(true);
                    entry.setEnabled(true);
                    if (entry.getOperation() == null) {
                        entry.setOperation("");
                    }
                    if (input.contains(entry)) continue;
                    entriesFromDep.add(entry);
                }
            }
            if (entriesFromDep.size() != 0) {
                input.addAll(entriesFromDep);
            }
            this.view.getUpdatePage().setCellModifier(new EntryPointByAppCellModifier());
            this.validators.put(4, operationValidator);
            this.cellEditorListeners.put(4, cellEditorListener);
            this.view.getUpdatePage().getTreeViewer().setColumnProperties(this.columnNames);
            this.view.getUpdatePage().initTable(this.getColumnNames(), this.validators, this.cellEditorListeners, input);
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"projectSelected");
    }

    @Override
    public void onRowSelection() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"onRowSelection", (Object)("Thread ID: " + Thread.currentThread().getId()));
        ISelection selection = this.view.getUpdatePage().getSelectedRow();
        if (selection != null && selection instanceof TreeSelection) {
            try {
                EntryPoint dependency = ((EntryPointTreeItem)((TreeSelection)selection).getFirstElement()).getEntryPoint();
                if (dependency != null && dependency.getError() != null) {
                    this.view.getUpdatePage().setErrorMessage(dependency.getError());
                } else {
                    this.updateGeneralErrorMessage();
                }
                this.view.getUpdatePage().setPageComplete(this.canFinish());
            }
            catch (NullPointerException e) {
                Debug.event((Logger)logger, (Level)Level.FINEST, (String)this.getClass().getName(), (String)"onRowSelection", (Object)e);
            }
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"onRowSelection");
    }

    @Override
    public void onSelectAll() {
        this.selectAllEntryPoints(true);
    }

    @Override
    public void onDeselectAll() {
        this.selectAllEntryPoints(false);
    }

    private void selectAllEntryPoints(boolean selected) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"selectAllEntryPoints", (Object)("Thread ID: " + Thread.currentThread().getId()));
        for (EntryPoint entryPoint : this.model.getCachedEntryPoints()) {
            if (!entryPoint.isEnabled()) continue;
            entryPoint.setSelected(selected);
            this.view.getUpdatePage().updateElem(entryPoint, null);
        }
        this.model.validateResources();
        this.updateGeneralErrorMessage();
        this.view.getUpdatePage().setPageComplete(this.canFinish());
        this.view.getUpdatePage().initTable(this.getColumnNames(), this.validators, this.cellEditorListeners, this.model.getCachedEntryPoints());
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"selectAllEntryPoints");
    }

    @Override
    public void cicsTsLevelSelected() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"cicsTsLevelSelected", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String cicsTsLevel = this.view.getUpdatePage().getSelectedCicsTsLevel();
        if (cicsTsLevel.equals(EntryPointsModel.CicsTsLevel.LEVEL_51.toString())) {
            this.model.setCicsTsLevel(EntryPointsModel.CicsTsLevel.LEVEL_51);
        } else if (cicsTsLevel.equals(EntryPointsModel.CicsTsLevel.LEVEL_52.toString())) {
            this.model.setCicsTsLevel(EntryPointsModel.CicsTsLevel.LEVEL_52);
        } else if (cicsTsLevel.equals(EntryPointsModel.CicsTsLevel.LEVEL_53.toString())) {
            this.model.setCicsTsLevel(EntryPointsModel.CicsTsLevel.LEVEL_53);
        } else if (cicsTsLevel.equals(EntryPointsModel.CicsTsLevel.LEVEL_55.toString())) {
            this.model.setCicsTsLevel(EntryPointsModel.CicsTsLevel.LEVEL_55);
        } else if (cicsTsLevel.equals(EntryPointsModel.CicsTsLevel.LEVEL_56.toString())) {
            this.model.setCicsTsLevel(EntryPointsModel.CicsTsLevel.LEVEL_56);
        } else if (cicsTsLevel.equals(EntryPointsModel.CicsTsLevel.LEVEL_61.toString())) {
            this.model.setCicsTsLevel(EntryPointsModel.CicsTsLevel.LEVEL_61);
        } else if (cicsTsLevel.equals(EntryPointsModel.CicsTsLevel.LEVEL_62.toString())) {
            this.model.setCicsTsLevel(EntryPointsModel.CicsTsLevel.LEVEL_62);
        } else if (cicsTsLevel.equals(EntryPointsModel.CicsTsLevel.LEVEL_63.toString())) {
            this.model.setCicsTsLevel(EntryPointsModel.CicsTsLevel.LEVEL_63);
        }
        this.model.validateResources();
        this.updateGeneralErrorMessage();
        this.view.getUpdatePage().setInput(this.model.getCachedEntryPoints());
        this.view.getUpdatePage().setPageComplete(this.canFinish());
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"cicsTsLevelSelected");
    }

    public class EntryPointByAppCellModifier
    implements ICellModifier {
        public boolean canModify(Object element, String property) {
            int columnIndex = Arrays.asList(CiuspepsEntryPointsPresenter.this.getColumnNames()).indexOf(property);
            if (element instanceof EntryPointTreeItem) {
                return ((EntryPointTreeItem)element).isEnabled() && (columnIndex == 0 || columnIndex == 4);
            }
            return ((EntryPoint)element).isEnabled() && (columnIndex == 0 || columnIndex == 4);
        }

        public Object getValue(Object element, String property) {
            int columnIndex = Arrays.asList(CiuspepsEntryPointsPresenter.this.getColumnNames()).indexOf(property);
            EntryPointTreeItem entryPoint = (EntryPointTreeItem)element;
            switch (columnIndex) {
                case 0: {
                    return entryPoint.isSelected();
                }
                case 1: {
                    return entryPoint.getCollectionID();
                }
                case 2: {
                    return entryPoint.getPlatform();
                }
                case 3: {
                    return entryPoint.getApplication();
                }
                case 4: {
                    return entryPoint.getOperation();
                }
                case 5: {
                    return entryPoint.getName();
                }
                case 6: {
                    return entryPoint.getPlatform();
                }
                case 7: {
                    return entryPoint.getRegion();
                }
                case 8: {
                    return entryPoint.getApplOperation();
                }
            }
            return this.getEmergencyValue(columnIndex, entryPoint.getEntryPoint());
        }

        public Object getEmergencyValue(int columnIndex, EntryPoint entryPoint) {
            return null;
        }

        public void modify(Object element, String property, Object value) {
            int columnIndex = Arrays.asList(CiuspepsEntryPointsPresenter.this.getColumnNames()).indexOf(property);
            TreeItem item = (TreeItem)element;
            EntryPointTreeItem entryPointTreeItem = (EntryPointTreeItem)item.getData();
            switch (columnIndex) {
                case 0: {
                    entryPointTreeItem.setSelected(((Boolean)value).booleanValue());
                    break;
                }
                case 4: {
                    entryPointTreeItem.setOperation(value.toString());
                }
            }
            int i = 0;
            while (i < CiuspepsEntryPointsPresenter.this.model.getCachedEntryPoints().size()) {
                EntryPoint entryPoint = (EntryPoint)CiuspepsEntryPointsPresenter.this.model.getCachedEntryPoints().get(i);
                if (entryPoint.equals(entryPointTreeItem.getEntryPoint())) {
                    entryPoint.setSelected(entryPointTreeItem.isSelected());
                    entryPoint.setOperation(entryPointTreeItem.getOperation());
                    if (!EntryPointsTreeUtilities.containsInvalidCharsInOper(entryPointTreeItem)) {
                        entryPointTreeItem.setError(null);
                        entryPoint.setError(null);
                    }
                    entryPoint.setOperation(entryPointTreeItem.getOperation());
                }
                ++i;
            }
            CiuspepsEntryPointsPresenter.this.model.validateResources();
            if (entryPointTreeItem.getError() != null && entryPointTreeItem.isSelected()) {
                CiuspepsEntryPointsPresenter.this.view.getUpdatePage().setErrorMessage(entryPointTreeItem.getError());
            } else {
                CiuspepsEntryPointsPresenter.this.updateGeneralErrorMessage();
            }
            CiuspepsEntryPointsPresenter.this.view.getUpdatePage().setPageComplete(CiuspepsEntryPointsPresenter.this.canFinish());
            CiuspepsEntryPointsPresenter.this.view.getUpdatePage().updateElem(entryPointTreeItem, null);
            CiuspepsEntryPointsPresenter.this.view.getUpdatePage().refreshTable();
        }
    }

    public class EntryPointByAppWithDepCellModifier
    implements ICellModifier {
        public boolean canModify(Object element, String property) {
            int columnIndex = Arrays.asList(CiuspepsEntryPointsPresenter.this.getColumnNames()).indexOf(property);
            if (element instanceof EntryPointTreeItem) {
                return ((EntryPointTreeItem)element).isEnabled() && (columnIndex == 0 || columnIndex == 4);
            }
            return ((EntryPoint)element).isEnabled() && (columnIndex == 0 || columnIndex == 4);
        }

        public Object getValue(Object element, String property) {
            int columnIndex = Arrays.asList(CiuspepsEntryPointsPresenter.this.getColumnNames()).indexOf(property);
            EntryPointTreeItem entryPoint = (EntryPointTreeItem)element;
            switch (columnIndex) {
                case 0: {
                    return entryPoint.isSelected();
                }
                case 1: {
                    return entryPoint.getCollectionID();
                }
                case 2: {
                    return entryPoint.getPlatform();
                }
                case 3: {
                    return entryPoint.getApplication();
                }
                case 4: {
                    return entryPoint.getOperation();
                }
                case 6: {
                    return entryPoint.getName();
                }
                case 7: {
                    return entryPoint.getType();
                }
                case 8: {
                    return entryPoint.getRegion();
                }
                case 9: {
                    return entryPoint.getApplOperation();
                }
            }
            return this.getEmergencyValue(columnIndex, entryPoint.getEntryPoint());
        }

        public Object getEmergencyValue(int columnIndex, EntryPoint entryPoint) {
            return null;
        }

        public void modify(Object element, String property, Object value) {
            int columnIndex = Arrays.asList(CiuspepsEntryPointsPresenter.this.getColumnNames()).indexOf(property);
            TreeItem item = (TreeItem)element;
            EntryPointTreeItem entryPointTreeItem = (EntryPointTreeItem)item.getData();
            switch (columnIndex) {
                case 0: {
                    entryPointTreeItem.setSelected(((Boolean)value).booleanValue());
                    break;
                }
                case 4: {
                    entryPointTreeItem.setOperation(value.toString());
                }
            }
            int i = 0;
            while (i < CiuspepsEntryPointsPresenter.this.model.getCachedEntryPoints().size()) {
                EntryPoint entryPoint = (EntryPoint)CiuspepsEntryPointsPresenter.this.model.getCachedEntryPoints().get(i);
                if (entryPoint.equals(entryPointTreeItem.getEntryPoint())) {
                    entryPoint.setSelected(entryPointTreeItem.isSelected());
                    entryPoint.setOperation(entryPointTreeItem.getOperation());
                    if (!EntryPointsTreeUtilities.containsInvalidCharsInOper(entryPointTreeItem)) {
                        entryPointTreeItem.setError(null);
                        entryPoint.setError(null);
                    }
                    entryPoint.setOperation(entryPointTreeItem.getOperation());
                }
                ++i;
            }
            CiuspepsEntryPointsPresenter.this.model.validateResources();
            if (entryPointTreeItem.getError() != null && entryPointTreeItem.isSelected()) {
                CiuspepsEntryPointsPresenter.this.view.getUpdatePage().setErrorMessage(entryPointTreeItem.getError());
            } else {
                CiuspepsEntryPointsPresenter.this.updateGeneralErrorMessage();
            }
            CiuspepsEntryPointsPresenter.this.view.getUpdatePage().setPageComplete(CiuspepsEntryPointsPresenter.this.canFinish());
            CiuspepsEntryPointsPresenter.this.view.getUpdatePage().updateElem(entryPointTreeItem, null);
            CiuspepsEntryPointsPresenter.this.view.getUpdatePage().refreshTable();
        }
    }

    public class EntryPointCellModifier
    implements ICellModifier {
        public boolean canModify(Object element, String property) {
            int columnIndex = Arrays.asList(CiuspepsEntryPointsPresenter.this.getColumnNames()).indexOf(property);
            if (element instanceof EntryPointTreeItem) {
                return ((EntryPointTreeItem)element).isEnabled() && (columnIndex == 0 || columnIndex == 5);
            }
            return ((EntryPoint)element).isEnabled() && (columnIndex == 0 || columnIndex == 5);
        }

        public Object getValue(Object element, String property) {
            int columnIndex = Arrays.asList(CiuspepsEntryPointsPresenter.this.getColumnNames()).indexOf(property);
            EntryPointTreeItem entryPoint = (EntryPointTreeItem)element;
            switch (columnIndex) {
                case 0: {
                    return entryPoint.isSelected();
                }
                case 1: {
                    return entryPoint.getCollectionID();
                }
                case 2: {
                    return entryPoint.getRegion();
                }
                case 3: {
                    return entryPoint.getType();
                }
                case 4: {
                    return entryPoint.getName();
                }
                case 5: {
                    return entryPoint.getOperation();
                }
                case 6: {
                    return entryPoint.getPlatform();
                }
                case 7: {
                    return entryPoint.getApplication();
                }
                case 8: {
                    return entryPoint.getApplOperation();
                }
                case 9: {
                    return entryPoint.getObject();
                }
            }
            return this.getEmergencyValue(columnIndex, entryPoint.getEntryPoint());
        }

        public Object getEmergencyValue(int columnIndex, EntryPoint entryPoint) {
            return null;
        }

        public void modify(Object element, String property, Object value) {
            int columnIndex = Arrays.asList(CiuspepsEntryPointsPresenter.this.getColumnNames()).indexOf(property);
            TreeItem item = (TreeItem)element;
            EntryPointTreeItem entryPointTreeItem = (EntryPointTreeItem)item.getData();
            switch (columnIndex) {
                case 0: {
                    entryPointTreeItem.setSelected(((Boolean)value).booleanValue());
                    break;
                }
                case 5: {
                    entryPointTreeItem.setOperation(value.toString());
                }
            }
            int i = 0;
            while (i < CiuspepsEntryPointsPresenter.this.model.getCachedEntryPoints().size()) {
                EntryPoint entryPoint = (EntryPoint)CiuspepsEntryPointsPresenter.this.model.getCachedEntryPoints().get(i);
                if (entryPoint.equals(entryPointTreeItem.getEntryPoint())) {
                    entryPoint.setSelected(entryPointTreeItem.isSelected());
                    entryPoint.setOperation(entryPointTreeItem.getOperation());
                    if (!EntryPointsTreeUtilities.containsInvalidCharsInOper(entryPointTreeItem)) {
                        entryPointTreeItem.setError(null);
                        entryPoint.setError(null);
                    }
                    entryPoint.setOperation(entryPointTreeItem.getOperation());
                }
                ++i;
            }
            CiuspepsEntryPointsPresenter.this.model.validateResources();
            if (entryPointTreeItem.getError() != null && entryPointTreeItem.isSelected()) {
                CiuspepsEntryPointsPresenter.this.view.getUpdatePage().setErrorMessage(entryPointTreeItem.getError());
            } else {
                CiuspepsEntryPointsPresenter.this.updateGeneralErrorMessage();
            }
            CiuspepsEntryPointsPresenter.this.view.getUpdatePage().setPageComplete(CiuspepsEntryPointsPresenter.this.canFinish());
            CiuspepsEntryPointsPresenter.this.view.getUpdatePage().updateElem(entryPointTreeItem, null);
            CiuspepsEntryPointsPresenter.this.view.getUpdatePage().refreshTable();
        }
    }
}

