/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.AtomContentElement;
import com.ibm.cics.ia.model.AtomDefinitions;
import com.ibm.cics.ia.model.CintCollector;
import com.ibm.cics.ia.ui.CollectorOptionsEditor;
import com.ibm.cics.ia.ui.DefaultEditorInputImpl;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.actions.SaveCintOptionsAction;
import java.text.MessageFormat;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class CintEditor
extends CollectorOptionsEditor {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String ID = "com.ibm.cics.ia.ui.CintEditor";
    private static final Logger logger = Logger.getLogger(CintEditor.class.getPackage().getName());
    public static final DefaultEditorInputImpl DEFAULT_EDITOR_INPUT = new DefaultEditorInputImpl(){};

    @Override
    public String getEditorTitle() {
        return ((CintCollector)super.getCollector()).getRegion().getName();
    }

    @Override
    public String getEditorMessage() {
        return MessageFormat.format(Messages.getString("CintEditor.title.text"), ((CintCollector)super.getCollector()).getRegion().getName());
    }

    @Override
    public String[] getCollectorAttributes() {
        return AtomDefinitions.CINT_ATTRIBUTES;
    }

    @Override
    public void saveOptions(AtomContentElement element) {
        SaveCintOptionsAction saveAction = new SaveCintOptionsAction((CintCollector)super.getCollector());
        saveAction.run(element);
    }

    @Override
    public AtomContentElement getGeneralOptionsRootElement() {
        return this.getCollector().getContentElement().getFirstElementByName("region");
    }

    @Override
    public void setEditorHelp(Composite parent) {
        IWorkbenchHelpSystem helpSystem = this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)parent, "com.ibm.cics.ia.help.cint_editor");
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"init", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (DEFAULT_EDITOR_INPUT != input) {
            throw new PartInitException("Invalid Input: Must be CintEditor.DEFAULT_EDITOR_INPUT");
        }
        super.init(site, input);
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"init");
    }
}

