/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ep.model.eventbinding.capture.CaptureResources;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.actions.CreateCommandEventAction;
import com.ibm.cics.ia.ui.actions.CreateEventAction;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;

public class CaptureEPSpecMenu {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CaptureEPSpecMenu.class.getPackage().getName());

    public static void createResourceActions(IMenuManager manager, Resource resource, Region region) {
        Map resourceToApiMap;
        List actionIds;
        Debug.enter((Logger)logger, (String)CaptureEPSpecMenu.class.getName(), (String)"createResourceActions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        MenuManager createSystemEventMenu = new MenuManager(Messages.getString("PopupMenu.createEvent"));
        if (resource != null && (actionIds = (List)(resourceToApiMap = CaptureResources.getCaptureResources().getResourceToApiMap()).get(resource.getEpType())) != null) {
            for (String actionId : actionIds) {
                CreateEventAction action = new CreateEventAction();
                action.setEnabled(true);
                action.setId(actionId);
                action.setText(actionId);
                action.setResource(resource);
                action.setRegion(region);
                action.setEpResourceType(resource.getEpType());
                createSystemEventMenu.add((IAction)action);
            }
            manager.add((IContributionItem)createSystemEventMenu);
        }
        Debug.exit((Logger)logger, (String)CaptureEPSpecMenu.class.getName(), (String)"createResourceActions");
    }

    public static void createCommandActions(IMenuManager manager, String commandName, List<Resource> resources) {
        Debug.enter((Logger)logger, (String)CaptureEPSpecMenu.class.getName(), (String)"createCommandActions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        MenuManager createSystemEventMenu = new MenuManager(Messages.getString("PopupMenu.createEvent"));
        CreateCommandEventAction action = new CreateCommandEventAction(commandName, resources);
        action.setEnabled(true);
        action.setId(commandName);
        action.setText(commandName);
        createSystemEventMenu.add((IAction)action);
        manager.add((IContributionItem)createSystemEventMenu);
        Debug.exit((Logger)logger, (String)CaptureEPSpecMenu.class.getName(), (String)"createCommandActions");
    }
}

