/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.ia.model.AffinityLifetime;
import com.ibm.cics.ia.model.AffinityRelation;
import com.ibm.cics.ia.model.BuiltAffGroup;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.ui.BuildTreeViewerNode;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.Messages;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

class BuilderTreeCellLabelProvider
extends StyledCellLabelProvider {
    private static String AFFINITY = Messages.getString("AffinityBuildEditor.Overview.Trangroups.Affinity.Text");
    private static String LIFETIME = Messages.getString("AffinityBuildEditor.Overview.Trangroups.Lifetime.Text");
    private static String MATCH = Messages.getString("AffinityBuildEditor.Overview.Trangroups.Match.Text");
    private static String STATE = Messages.getString("AffinityBuildEditor.Overview.Trangroups.State.Text");
    private static String TRANSACTIONS = Messages.getString("AffinityBuildEditor.Overview.Trangroups.ConsistsOfTransactions.Text");
    private static String GROUPS = Messages.getString("AffinityBuildEditor.Overview.Trangroups.ConsistsOfGroups.Text");
    private static String TRANGROUP = Messages.getString("AffinityBuildEditor.Overview.Trangroups.Trangroup.Text");
    private static Color hilightColor = new Color((Device)Display.getDefault(), 42, 0, 255);

    BuilderTreeCellLabelProvider() {
    }

    public void update(ViewerCell cell) {
        BuildTreeViewerNode node = (BuildTreeViewerNode)cell.getElement();
        if (node.getType().equals((Object)BuildTreeViewerNode.Type.Dummy)) {
            cell.setText(Messages.getString("AffinityBuildEditor.TransactionGroups.Dummy.Text"));
        } else if (node.getType().equals((Object)BuildTreeViewerNode.Type.Group)) {
            String trangroup = ((BuiltAffGroup)node.getData()).getTranGroup().toString();
            String text = String.valueOf(TRANGROUP) + trangroup;
            cell.setText(text);
            StyleRange trangroupRange = new StyleRange(TRANGROUP.length(), trangroup.length(), hilightColor, null, 1);
            StyleRange[] ranges = new StyleRange[]{trangroupRange};
            cell.setStyleRanges(ranges);
        } else if (node.getType().equals((Object)BuildTreeViewerNode.Type.Affinity)) {
            String affinity = ((AffinityRelation)node.getData()).toString();
            String text = String.valueOf(AFFINITY) + affinity;
            cell.setText(text);
            StyleRange affinityRange = new StyleRange(AFFINITY.length(), affinity.length(), hilightColor, null, 1);
            StyleRange[] ranges = new StyleRange[]{affinityRange};
            cell.setStyleRanges(ranges);
        } else if (node.getType().equals((Object)BuildTreeViewerNode.Type.Lifetime)) {
            String lifetime = ((AffinityLifetime)node.getData()).toString();
            String text = String.valueOf(LIFETIME) + lifetime;
            cell.setText(text);
            StyleRange lifetimeRange = new StyleRange(LIFETIME.length(), lifetime.length(), hilightColor, null, 1);
            StyleRange[] ranges = new StyleRange[]{lifetimeRange};
            cell.setStyleRanges(ranges);
        } else if (node.getType().equals((Object)BuildTreeViewerNode.Type.Match)) {
            String match = (String)node.getData();
            String text = String.valueOf(MATCH) + match;
            cell.setText(text);
            StyleRange matchRange = new StyleRange(MATCH.length(), match.length(), hilightColor, null, 1);
            StyleRange[] ranges = new StyleRange[]{matchRange};
            cell.setStyleRanges(ranges);
        } else if (node.getType().equals((Object)BuildTreeViewerNode.Type.State)) {
            String state = (String)node.getData();
            String text = String.valueOf(STATE) + state;
            cell.setText(text);
            StyleRange stateRange = new StyleRange(STATE.length(), state.length(), hilightColor, null, 1);
            StyleRange[] ranges = new StyleRange[]{stateRange};
            cell.setStyleRanges(ranges);
        } else if (node.getType().equals((Object)BuildTreeViewerNode.Type.Transactions)) {
            String text = TRANSACTIONS;
            cell.setText(text);
        } else if (node.getType().equals((Object)BuildTreeViewerNode.Type.Transaction)) {
            String text = ((Transaction)node.getData()).getName();
            cell.setText(text);
            cell.setImage(ImageFactory.getTransactionImage());
        } else if (node.getType().equals((Object)BuildTreeViewerNode.Type.Merges)) {
            String text = GROUPS;
            cell.setText(text);
        } else if (node.getType().equals((Object)BuildTreeViewerNode.Type.MergedReport)) {
            String text = (String)node.getData();
            cell.setText(text);
        } else if (node.getType().equals((Object)BuildTreeViewerNode.Type.MergedGroup)) {
            String text = (String)node.getData();
            cell.setText(text);
            int rangeStart = text.indexOf(40);
            int rangeEnd = text.indexOf(41);
            StyleRange groupRange = new StyleRange(rangeStart, rangeEnd - rangeStart, hilightColor, null, 1);
            StyleRange[] ranges = new StyleRange[]{groupRange};
            cell.setStyleRanges(ranges);
        }
        super.update(cell);
    }
}

