/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.dbfunc.command.EngineShell;
import com.ibm.cics.dbfunc.command.SQLCommand;
import com.ibm.cics.eclipse.common.ui.JobWithCancelingSupport;
import com.ibm.cics.ia.commands.FindAffCommandsCommand;
import com.ibm.cics.ia.commands.FindAffGroupsCommand;
import com.ibm.cics.ia.model.AffCommand;
import com.ibm.cics.ia.model.AffGroup;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.AffCommandTableLabelProvider;
import com.ibm.cics.ia.ui.AffGroupTableLabelProvider;
import com.ibm.cics.ia.ui.AffinityByTypeMenu;
import com.ibm.cics.ia.ui.DefaultEditorInputImpl;
import com.ibm.cics.ia.ui.SelectionProviderWrapper;
import com.ibm.cics.ia.ui.TableSelectionProvider;
import com.ibm.cics.ia.ui.UIUtilities;
import com.ibm.cics.ia.ui.actions.Messages;
import com.ibm.cics.ia.ui.actions.MoreRegionsAction;
import com.ibm.cics.ia.ui.actions.MoreRegionsUsedByProgAction;
import com.ibm.cics.ia.ui.actions.MoreRegionsUsedByTranAction;
import com.ibm.cics.ia.ui.actions.TransactionRunsAction;
import com.ibm.cics.ia.ui.actions.TransactionTasksAction;
import com.ibm.cics.ia.ui.actions.UsedByProgramAction;
import com.ibm.cics.ia.ui.actions.UsedByTransactionAction;
import com.ibm.cics.ia.ui.actions.UsesAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.part.EditorPart;

public class AffinityView
extends EditorPart {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(AffinityView.class.getPackage().getName());
    public static final String ID = "com.ibm.cics.ia.ui.AffinityView";
    public static final DefaultEditorInputImpl DEFAULT_EDITOR_INPUT = new DefaultEditorInputImpl(){};
    protected static final String RESOURCE_TYPE = "RESOURCE_TYPE";
    private String taskName = "";
    private String description = "";
    private Display display;
    private Composite rootComp;
    private Table affCommandTable;
    private Table affGroupTable;
    private TableViewer affGroupViewer;
    private TableViewer affCommandViewer;
    private Region region;
    private Resource resource;
    private String groupType;
    private SQLCommand sqlCommand;
    private EngineShell.EngineListener commandListener;
    private Job findResourceJob;
    private Label descriptionLabel;
    TableSelectionProvider affGroupSelectionProvider;
    TableSelectionProvider affCommandSelectionProvider;
    SelectionProviderWrapper selectionProviderWrapper;
    private ConnectionServiceListener connectionServiceListener;

    public void createPartControl(Composite parent) {
        Debug.enter((Logger)logger, (String)AffinityView.class.getName(), (String)"createPartControl", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.display = parent.getDisplay();
        this.rootComp = new Composite(parent, 4);
        final Sash sash = new Sash(this.rootComp, 256);
        FormLayout formLayout = new FormLayout();
        this.rootComp.setLayout((Layout)formLayout);
        this.descriptionLabel = new Label(this.rootComp, 4);
        this.descriptionLabel.setText("");
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        this.descriptionLabel.setLayoutData((Object)formData);
        final FormData sashData = new FormData();
        int limit = 20;
        int percent = 50;
        sashData.left = new FormAttachment(0, 0);
        sashData.right = new FormAttachment(100, 0);
        sashData.top = new FormAttachment(50, 0);
        sash.setLayoutData((Object)sashData);
        sash.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Rectangle sashRect = sash.getBounds();
                Rectangle compRect = AffinityView.this.rootComp.getBounds();
                int top = compRect.height - sashRect.height - 20;
                event.y = Math.max(Math.min(event.y, top), 20);
                if (event.y != sashRect.y) {
                    sashData.top = new FormAttachment(0, event.y);
                    AffinityView.this.rootComp.layout();
                }
            }
        });
        boolean commandCount = false;
        this.affGroupViewer = new TableViewer(this.rootComp, 68356);
        this.affGroupViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.affGroupViewer.setLabelProvider((IBaseLabelProvider)new AffGroupTableLabelProvider());
        this.affGroupTable = this.affGroupViewer.getTable();
        this.affGroupTable.setLinesVisible(true);
        this.affGroupTable.setHeaderVisible(true);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment((Control)this.descriptionLabel, 0);
        formData.bottom = new FormAttachment((Control)sash, 0);
        this.affGroupTable.setLayoutData((Object)formData);
        this.affGroupSelectionProvider = new TableSelectionProvider(this.affGroupTable);
        this.affGroupTable.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                TableItem[] selection = AffinityView.this.affGroupTable.getSelection();
                TableItem first = null;
                if (selection.length > 0) {
                    first = selection[0];
                }
                if (first != null) {
                    AffinityView.this.populateCommandTable((AffGroup)first.getData());
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.affGroupTable.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                AffinityView.this.selectionProviderWrapper.setSelectionProvider(AffinityView.this.affGroupSelectionProvider);
                if (AffinityView.this.affGroupTable.getSelectionIndex() < 0 && AffinityView.this.affGroupTable.getItemCount() > 0) {
                    AffinityView.this.affGroupTable.setSelection(0);
                }
            }
        });
        this.affCommandViewer = new TableViewer(this.rootComp, 68356);
        this.affCommandViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.affCommandViewer.setLabelProvider((IBaseLabelProvider)new AffCommandTableLabelProvider());
        this.affCommandTable = this.affCommandViewer.getTable();
        this.affCommandTable.setLinesVisible(true);
        this.affCommandTable.setHeaderVisible(true);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment((Control)sash, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.affCommandTable.setLayoutData((Object)formData);
        this.affCommandTable.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                Object first = null;
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.affCommandSelectionProvider = new TableSelectionProvider(this.affCommandTable);
        this.affCommandTable.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                AffinityView.this.selectionProviderWrapper.setSelectionProvider(AffinityView.this.affCommandSelectionProvider);
                if (AffinityView.this.affCommandTable.getSelectionIndex() < 0 && AffinityView.this.affCommandTable.getItemCount() > 0) {
                    AffinityView.this.affCommandTable.setSelection(0);
                }
            }
        });
        this.selectionProviderWrapper = new SelectionProviderWrapper();
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProviderWrapper);
        MenuManager affGroupMenuMgr = new MenuManager();
        affGroupMenuMgr.setRemoveAllWhenShown(true);
        Menu affGroupPopupMenu = affGroupMenuMgr.createContextMenu((Control)this.affGroupTable);
        this.affGroupTable.setMenu(affGroupPopupMenu);
        affGroupMenuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AffGroup affGroup;
                TableItem[] items = AffinityView.this.affGroupTable.getSelection();
                if (items.length > 0 && (affGroup = (AffGroup)AffinityView.this.affGroupTable.getSelection()[0].getData()) != null && affGroup.getResource() != null) {
                    AffinityView.this.createActions(manager, affGroup);
                }
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        this.getSite().registerContextMenu(affGroupMenuMgr, (ISelectionProvider)this.selectionProviderWrapper);
        MenuManager affCommandMenuMgr = new MenuManager();
        affCommandMenuMgr.setRemoveAllWhenShown(true);
        Menu affCommandPopupMenu = affCommandMenuMgr.createContextMenu((Control)this.affCommandTable);
        this.affCommandTable.setMenu(affCommandPopupMenu);
        affCommandMenuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AffCommand affCommand;
                TableItem[] items = AffinityView.this.affCommandTable.getSelection();
                if (items.length > 0 && (affCommand = (AffCommand)AffinityView.this.affCommandTable.getSelection()[0].getData()) != null) {
                    AffinityView.this.createActions(manager, affCommand);
                }
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        this.getSite().registerContextMenu(affCommandMenuMgr, (ISelectionProvider)this.selectionProviderWrapper);
        Control[] tabList = new Control[]{this.affGroupTable, this.affCommandTable};
        this.rootComp.setTabList(tabList);
        IWorkbenchHelpSystem helpSystem = this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)this.rootComp, "com.ibm.cics.ia.help.affinities_view");
        this.rootComp.pack();
        this.connectionServiceListener = this.getConnectionServiceListener();
        ConnectionsPlugin.getDefault().getConnectionService().addConnectionServiceListener(this.connectionServiceListener);
        Debug.exit((Logger)logger, (String)AffinityView.class.getName(), (String)"createPartControl");
    }

    private ConnectionServiceListener getConnectionServiceListener() {
        return new ConnectionServiceListener(){

            public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
                Debug.enter((Logger)logger, (String)ConnectionServiceListener.class.getName(), (String)"event", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "event: " + event.toString()});
                if ("com.ibm.cics.ia.connection.db2".equals(event.getConnectionCategoryId()) && event instanceof ConnectionServiceListener.DisconnectedEvent) {
                    this.disconnected();
                }
                Debug.exit((Logger)logger, (String)ConnectionServiceListener.class.getName(), (String)"event");
            }

            public void disconnected() {
                Debug.enter((Logger)logger, (String)ConnectionServiceListener.class.getName(), (String)"disconnected", (Object)("Thread ID: " + Thread.currentThread().getId()));
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        AffinityView.this.clear();
                    }
                });
                Debug.exit((Logger)logger, (String)ConnectionServiceListener.class.getName(), (String)"disconnected");
            }
        };
    }

    public void dispose() {
        Debug.enter((Logger)logger, (String)AffinityView.class.getName(), (String)"dispose", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.connectionServiceListener != null) {
            this.connectionServiceListener.makeStale();
        }
        super.dispose();
        Debug.exit((Logger)logger, (String)AffinityView.class.getName(), (String)"enclosing_method");
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"init", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "site: " + site.getId(), "input: " + input.getName()});
        if (DEFAULT_EDITOR_INPUT != input) {
            throw new PartInitException("Invalid Input: Must be AffinityView.DEFAULT_EDITOR_INPUT");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"init");
    }

    private void clear() {
        Debug.enter((Logger)logger, (String)AffinityView.class.getName(), (String)"clear", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.clearUIElements();
        if (this.affGroupSelectionProvider != null) {
            this.affGroupSelectionProvider.setSelection((ISelection)StructuredSelection.EMPTY);
        }
        if (this.affCommandSelectionProvider != null) {
            this.affCommandSelectionProvider.setSelection((ISelection)StructuredSelection.EMPTY);
        }
        Debug.exit((Logger)logger, (String)AffinityView.class.getName(), (String)"clear");
    }

    private void createActions(IMenuManager manager, AffGroup affGroup) {
        Debug.enter((Logger)logger, (String)AffinityView.class.getName(), (String)"createActions", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "manager: =" + manager.getId(), "affGroup: " + affGroup, "region: " + affGroup.getRegionName()});
        Resource actionsResource = affGroup.getResource();
        if (actionsResource != null && actionsResource.getTypeName().equals("PROGRAM")) {
            this.addProgramMenu(manager, (Program)actionsResource);
        } else {
            this.addResourceMenu(manager, actionsResource);
        }
        Debug.exit((Logger)logger, (String)AffinityView.class.getName(), (String)"createActions");
    }

    private void createActions(IMenuManager manager, AffCommand affCommand) {
        Debug.enter((Logger)logger, (String)AffinityView.class.getName(), (String)"createActions", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "manager: " + manager.getId(), "affCommand: " + affCommand.getCommand(), "transaction: " + affCommand.getTransaction(), "region: " + affCommand.getRegionName(), "program: " + affCommand.getProgramName()});
        Transaction transaction = affCommand.getTransaction();
        Program program = affCommand.getProgram();
        MenuManager tranMenu = new MenuManager(MessageFormat.format(com.ibm.cics.ia.ui.Messages.getString("AffinityView.transactionPopup"), transaction.getName()));
        this.addTransactionMenu((IMenuManager)tranMenu, transaction);
        manager.add((IContributionItem)tranMenu);
        MenuManager progMenu = new MenuManager(MessageFormat.format(com.ibm.cics.ia.ui.Messages.getString("AffinityView.programPopup"), program.getName()));
        this.addProgramMenu((IMenuManager)progMenu, program);
        manager.add((IContributionItem)progMenu);
        Debug.exit((Logger)logger, (String)AffinityView.class.getName(), (String)"createActions");
    }

    private void addResourceMenu(IMenuManager manager, Resource resource) {
        Debug.enter((Logger)logger, (String)AffinityView.class.getName(), (String)"addResourceMenu", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "manager: " + manager.getId(), "resource: " + (resource == null ? resource : resource.getName())});
        MenuManager usedByProgramsMenu = new MenuManager(com.ibm.cics.ia.ui.Messages.getString("AffinityView.UsedByProgs"));
        UsedByProgramAction usedByProgsAll = new UsedByProgramAction();
        usedByProgsAll.setText(com.ibm.cics.ia.ui.Messages.getString("AffinityView.AllRegions"));
        usedByProgsAll.setRegion(this.region);
        usedByProgsAll.setResource(resource);
        MoreRegionsUsedByProgAction usedByProgs = new MoreRegionsUsedByProgAction(resource);
        usedByProgs.setText(com.ibm.cics.ia.ui.Messages.getString("AffinityView.SpecificRegion"));
        usedByProgs.setResource(resource);
        usedByProgs.setTitle(Messages.getString("MoreRegionsUsedByProgAction.title"));
        usedByProgramsMenu.add((IAction)usedByProgsAll);
        usedByProgramsMenu.add((IAction)usedByProgs);
        MenuManager usedByTransactionsMenu = new MenuManager(com.ibm.cics.ia.ui.Messages.getString("AffinityView.UsedByTrans"));
        UsedByTransactionAction usedByTransAll = new UsedByTransactionAction();
        usedByTransAll.setText(com.ibm.cics.ia.ui.Messages.getString("AffinityView.AllRegions"));
        usedByTransAll.setRegion(this.region);
        usedByTransAll.setResource(resource);
        MoreRegionsUsedByTranAction usedByTrans = new MoreRegionsUsedByTranAction(resource);
        usedByTrans.setText(com.ibm.cics.ia.ui.Messages.getString("AffinityView.SpecificRegion"));
        usedByTrans.setResource(resource);
        usedByTrans.setTitle(Messages.getString("MoreRegionsUsedByTranAction.title"));
        usedByTransactionsMenu.add((IAction)usedByTransAll);
        usedByTransactionsMenu.add((IAction)usedByTrans);
        manager.add((IContributionItem)usedByProgramsMenu);
        manager.add((IContributionItem)usedByTransactionsMenu);
        Debug.exit((Logger)logger, (String)AffinityView.class.getName(), (String)"enclosing_method");
    }

    private void addTransactionMenu(IMenuManager tranMenu, Transaction transaction) {
        Debug.enter((Logger)logger, (String)AffinityView.class.getName(), (String)"addTransactionMenu", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "tranMenu: " + tranMenu.getId(), "transaction: " + (transaction == null ? transaction : transaction.getName())});
        TransactionRunsAction showCommandFlowRuns = new TransactionRunsAction(transaction);
        showCommandFlowRuns.setText(com.ibm.cics.ia.ui.Messages.getString("AffinityView.showCommandFlowRuns"));
        TransactionTasksAction showTasks = new TransactionTasksAction();
        showTasks.setText(com.ibm.cics.ia.ui.Messages.getString("AffinityView.showTasks"));
        showTasks.setTransaction(transaction);
        MenuManager tranUsedByProgramsMenu = new MenuManager(com.ibm.cics.ia.ui.Messages.getString("AffinityView.UsedByProgs"));
        UsedByProgramAction tranUsedByProgsAll = new UsedByProgramAction();
        tranUsedByProgsAll.setText(com.ibm.cics.ia.ui.Messages.getString("AffinityView.AllRegions"));
        tranUsedByProgsAll.setRegion(this.region);
        tranUsedByProgsAll.setResource((Resource)transaction);
        MoreRegionsUsedByProgAction tranUsedByProgs = new MoreRegionsUsedByProgAction((Resource)transaction);
        tranUsedByProgs.setText(com.ibm.cics.ia.ui.Messages.getString("AffinityView.SpecificRegion"));
        tranUsedByProgs.setResource((Resource)transaction);
        tranUsedByProgs.setTitle(Messages.getString("MoreRegionsUsedByProgAction.title"));
        tranUsedByProgramsMenu.add((IAction)tranUsedByProgsAll);
        tranUsedByProgramsMenu.add((IAction)tranUsedByProgs);
        MenuManager tranUsedByTransactionsMenu = new MenuManager(com.ibm.cics.ia.ui.Messages.getString("AffinityView.UsedByTrans"));
        UsedByTransactionAction tranUsedByTransAll = new UsedByTransactionAction();
        tranUsedByTransAll.setText(com.ibm.cics.ia.ui.Messages.getString("AffinityView.AllRegions"));
        tranUsedByTransAll.setRegion(this.region);
        tranUsedByTransAll.setResource((Resource)transaction);
        MoreRegionsUsedByTranAction tranUsedByTrans = new MoreRegionsUsedByTranAction((Resource)transaction);
        tranUsedByTrans.setText(com.ibm.cics.ia.ui.Messages.getString("AffinityView.SpecificRegion"));
        tranUsedByTrans.setResource((Resource)transaction);
        tranUsedByTrans.setTitle(Messages.getString("MoreRegionsUsedByTranAction.title"));
        tranUsedByTransactionsMenu.add((IAction)tranUsedByTransAll);
        tranUsedByTransactionsMenu.add((IAction)tranUsedByTrans);
        MenuManager tranShowAffsByTypeMenu = AffinityByTypeMenu.getAffinityMenuManager(tranMenu, (Resource)transaction);
        MenuManager tranUsesResourcesMenu = new MenuManager(com.ibm.cics.ia.ui.Messages.getString("AffinityView.UsesResources"));
        UsesAction tranUsesResourcesAll = new UsesAction((Resource)transaction, null);
        tranUsesResourcesAll.setText(com.ibm.cics.ia.ui.Messages.getString("AffinityView.AllRegions"));
        MoreRegionsAction tranUsesResources = new MoreRegionsAction(com.ibm.cics.ia.ui.Messages.getString("AffinityView.SpecificRegion"));
        tranUsesResources.setText(com.ibm.cics.ia.ui.Messages.getString("AffinityView.SpecificRegion"));
        tranUsesResources.setResource((Resource)transaction);
        tranUsesResources.setTitle(Messages.getString("MoreRegionsUsesAction.title"));
        tranUsesResourcesMenu.add((IAction)tranUsesResourcesAll);
        tranUsesResourcesMenu.add((IAction)tranUsesResources);
        tranMenu.add((IAction)showCommandFlowRuns);
        tranMenu.add((IAction)showTasks);
        tranMenu.add((IContributionItem)tranUsedByProgramsMenu);
        tranMenu.add((IContributionItem)tranUsedByTransactionsMenu);
        tranMenu.add((IContributionItem)tranShowAffsByTypeMenu);
        tranMenu.add((IContributionItem)tranUsesResourcesMenu);
        Debug.exit((Logger)logger, (String)AffinityView.class.getName(), (String)"addProgramMenu");
    }

    private void addProgramMenu(IMenuManager progMenu, Program program) {
        Debug.enter((Logger)logger, (String)AffinityView.class.getName(), (String)"addProgramMenu", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "progMenu: " + progMenu.getId(), "program: " + (program == null ? program : program.getName())});
        MenuManager progUsedByProgramsMenu = new MenuManager(com.ibm.cics.ia.ui.Messages.getString("AffinityView.UsedByProgs"));
        UsedByProgramAction progUsedByProgsAll = new UsedByProgramAction();
        progUsedByProgsAll.setText(com.ibm.cics.ia.ui.Messages.getString("AffinityView.AllRegions"));
        progUsedByProgsAll.setRegion(this.region);
        progUsedByProgsAll.setResource((Resource)program);
        MoreRegionsUsedByProgAction progUsedByProgs = new MoreRegionsUsedByProgAction((Resource)program);
        progUsedByProgs.setText(com.ibm.cics.ia.ui.Messages.getString("AffinityView.SpecificRegion"));
        progUsedByProgs.setResource((Resource)program);
        progUsedByProgs.setTitle(Messages.getString("MoreRegionsUsedByProgAction.title"));
        progUsedByProgramsMenu.add((IAction)progUsedByProgsAll);
        progUsedByProgramsMenu.add((IAction)progUsedByProgs);
        MenuManager progUsedByTransactionsMenu = new MenuManager(com.ibm.cics.ia.ui.Messages.getString("AffinityView.UsedByTrans"));
        UsedByTransactionAction progUsedByTransAll = new UsedByTransactionAction();
        progUsedByTransAll.setText(com.ibm.cics.ia.ui.Messages.getString("AffinityView.AllRegions"));
        progUsedByTransAll.setRegion(this.region);
        progUsedByTransAll.setResource((Resource)program);
        MoreRegionsUsedByTranAction progUsedByTrans = new MoreRegionsUsedByTranAction((Resource)program);
        progUsedByTrans.setText(com.ibm.cics.ia.ui.Messages.getString("AffinityView.SpecificRegion"));
        progUsedByTrans.setResource((Resource)program);
        progUsedByTrans.setTitle(Messages.getString("MoreRegionsUsedByTranAction.title"));
        progUsedByTransactionsMenu.add((IAction)progUsedByTransAll);
        progUsedByTransactionsMenu.add((IAction)progUsedByTrans);
        MenuManager progShowAffsByTypeMenu = AffinityByTypeMenu.getAffinityMenuManager(progMenu, (Resource)program);
        MenuManager progUsesResourcesMenu = new MenuManager(com.ibm.cics.ia.ui.Messages.getString("AffinityView.UsesResources"));
        UsesAction progUsesResourcesAll = new UsesAction((Resource)program, null);
        progUsesResourcesAll.setText(com.ibm.cics.ia.ui.Messages.getString("AffinityView.AllRegions"));
        MoreRegionsAction progUsesResources = new MoreRegionsAction(com.ibm.cics.ia.ui.Messages.getString("AffinityView.SpecificRegion"));
        progUsesResources.setText(com.ibm.cics.ia.ui.Messages.getString("AffinityView.SpecificRegion"));
        progUsesResources.setResource((Resource)program);
        progUsesResources.setTitle(Messages.getString("MoreRegionsUsesAction.title"));
        progUsesResourcesMenu.add((IAction)progUsesResourcesAll);
        progUsesResourcesMenu.add((IAction)progUsesResources);
        progMenu.add((IContributionItem)progUsedByProgramsMenu);
        progMenu.add((IContributionItem)progUsedByTransactionsMenu);
        progMenu.add((IContributionItem)progShowAffsByTypeMenu);
        progMenu.add((IContributionItem)progUsesResourcesMenu);
        Debug.exit((Logger)logger, (String)AffinityView.class.getName(), (String)"addProgramMenu");
    }

    private void populateCommandTable(AffGroup affGroup) {
        Debug.enter((Logger)logger, (String)AffinityView.class.getName(), (String)"populateCommandTable", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "affGroup: " + affGroup.toString(), "region: " + affGroup.getRegionName()});
        this.affCommandTable.removeAll();
        if (affGroup.getAffCommands() == null) {
            FindAffCommandsCommand command = new FindAffCommandsCommand(affGroup);
            command.start();
            ArrayList affCommands = new ArrayList();
            if (command.status() != 2) {
                affCommands.addAll(command.getResults());
            }
            affGroup.setAffCommands(affCommands);
        }
        this.affCommandViewer.setInput((Object)affGroup.getAffCommands().toArray());
        TableColumn[] tableColumnArray = this.affCommandTable.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
        Debug.exit((Logger)logger, (String)AffinityView.class.getName(), (String)"populateCommandTable");
    }

    public void setFocus() {
        this.affGroupTable.setFocus();
    }

    protected String getResourceTypesDescription() {
        return null;
    }

    protected String getTaskName() {
        return this.taskName;
    }

    protected SQLCommand createFindAffGroupsCommand(Region region, Resource resource, String groupType) {
        FindAffGroupsCommand sqlCommand = new FindAffGroupsCommand(region, resource, groupType);
        return sqlCommand;
    }

    protected void setHelpContextIDs(Composite parentComposite) {
    }

    public Job runSearch(String affGroup) {
        Debug.enter((Logger)logger, (String)AffinityView.class.getName(), (String)"runSearch", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "affGroup: " + affGroup});
        IConnectable resourceManager = ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.ia.connection.db2");
        if (!resourceManager.isConnected()) {
            Debug.exit((Logger)logger, (String)AffinityView.class.getName(), (String)"runSearch");
            return this.findResourceJob;
        }
        this.clear();
        if (affGroup == null) {
            this.sqlCommand = this.createFindAffGroupsCommand(this.region, this.resource, this.groupType);
        }
        this.sqlCommand.addListener(this.getCommandListener());
        this.findResourceJob = new JobWithCancelingSupport(this.getTaskName()){

            protected void cancelingSub() {
                Debug.enter((Logger)logger, (String)"AffinityView.runSearch().JobWithCancelingSupport", (String)"cancelingSub", (Object)("Thread ID: " + Thread.currentThread().getId()));
                if (AffinityView.this.sqlCommand != null) {
                    AffinityView.this.sqlCommand.cancel();
                }
                IAPlugin.getDefault().taskEnded();
                Debug.exit((Logger)logger, (String)"AffinityView.runSearch().JobWithCancelingSupport", (String)"cancelingSub", (Object)("Thread ID: " + Thread.currentThread().getId()));
            }

            protected IStatus runSub(IProgressMonitor monitor) {
                Debug.enter((Logger)logger, (String)"AffinityView.runSearch().JobWithCancelingSupport", (String)"runSub", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId()});
                Activator.getDefault().ensureConnected();
                monitor.beginTask(AffinityView.this.getTaskName(), -1);
                if (AffinityView.this.sqlCommand != null) {
                    AffinityView.this.sqlCommand.setAsync(false);
                    AffinityView.this.sqlCommand.start();
                }
                monitor.done();
                IAPlugin.getDefault().taskEnded();
                Debug.exit((Logger)logger, (String)"AffinityView.runSearch().JobWithCancelingSupport", (String)"runSub", (Object)("Thread ID: " + Thread.currentThread().getId()));
                return Status.OK_STATUS;
            }
        };
        UIUtilities.scheduleWorkbenchPartJob((IWorkbenchPart)this, this.findResourceJob);
        Debug.exit((Logger)logger, (String)AffinityView.class.getName(), (String)"runSearch");
        return this.findResourceJob;
    }

    private EngineShell.EngineListener getCommandListener() {
        if (this.commandListener == null) {
            this.commandListener = new EngineShell.EngineListener(){

                public void statusUpdate(EngineShell.EngineStatus es) {
                }

                public void notifyResultCount(int count) {
                }

                public void dataAvailable(final Collection<Object> items) {
                    Debug.enter((Logger)logger, (String)"AffinityView.getCommandListener()", (String)"dataAvailable", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "items size: " + items.size()});
                    AffinityView.this.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Debug.enter((Logger)logger, (String)"AffinityView.getCommandListener().dataAvailable().Runnable", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                            try {
                                if (items.size() == 0) {
                                    AffinityView.this.descriptionLabel.setText(com.ibm.cics.ia.ui.Messages.getString("QueryResultsView.noResultsText"));
                                    while (AffinityView.this.affGroupTable.getColumnCount() > 0) {
                                        AffinityView.this.affGroupTable.getColumn(0).dispose();
                                    }
                                    while (AffinityView.this.affCommandTable.getColumnCount() > 0) {
                                        AffinityView.this.affCommandTable.getColumn(0).dispose();
                                    }
                                } else {
                                    AffinityView.this.createTableColumns();
                                    AffinityView.this.affGroupViewer.setInput((Object)items);
                                    TableColumn[] tableColumnArray = AffinityView.this.affGroupTable.getColumns();
                                    int n = tableColumnArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        TableColumn column = tableColumnArray[n2];
                                        column.pack();
                                        ++n2;
                                    }
                                    AffinityView.this.setFocus();
                                    AffinityView.this.affGroupTable.setSelection(0);
                                    AffinityView.this.populateCommandTable((AffGroup)items.toArray()[0]);
                                }
                            }
                            catch (Exception ex) {
                                Debug.warning((Logger)logger, (String)AffinityView.class.getName(), (String)"dataAvailable.Runnable run", (String)"empty catch", (Throwable)ex);
                            }
                            Debug.exit((Logger)logger, (String)"AffinityView.getCommandListener().dataAvailable().Runnable", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                        }
                    });
                    Debug.exit((Logger)logger, (String)"AffinityView.getCommandListener()", (String)"dataAvailable", (Object)("Thread ID: " + Thread.currentThread().getId()));
                }
            };
        }
        return this.commandListener;
    }

    public Job setInput(Region aRegion, Resource aResource, String aGroupType) {
        Debug.enter((Logger)logger, (String)AffinityView.class.getName(), (String)"setInput", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "region: " + (aRegion == null ? aRegion : aRegion.getName()), "resource: " + (aResource == null ? aResource : aResource.getName()), "group type: " + aGroupType});
        this.region = aRegion;
        this.resource = aResource;
        this.groupType = aGroupType;
        this.setDescription();
        Job result = this.runSearch(null);
        Debug.exit((Logger)logger, (String)AffinityView.class.getName(), (String)"setInput");
        return result;
    }

    private void setDescription() {
        Debug.enter((Logger)logger, (String)AffinityView.class.getName(), (String)"setDescription", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.description = "";
        if (this.region != null && this.resource != null) {
            this.description = MessageFormat.format(com.ibm.cics.ia.ui.Messages.getString("AffinityView.affinitiesForResourceInRegion"), this.groupType, this.resource.getTypeName(), this.resource.getName(), this.region.getName());
            this.taskName = MessageFormat.format(com.ibm.cics.ia.ui.Messages.getString("AffinityView.retrievingAffinitiesForResourceInRegion"), this.groupType, this.resource.getTypeName(), this.resource.getName(), this.region.getName());
        } else if (this.region != null && this.resource == null) {
            this.description = MessageFormat.format(com.ibm.cics.ia.ui.Messages.getString("AffinityView.affinitiesInRegion"), this.groupType, this.region.getName());
            this.taskName = MessageFormat.format(com.ibm.cics.ia.ui.Messages.getString("AffinityView.retrievingAffinitiesInRegion"), this.groupType, this.region.getName());
        } else if (this.region == null && this.resource != null) {
            this.description = MessageFormat.format(com.ibm.cics.ia.ui.Messages.getString("AffinityView.affinitiesForResourceInAllRegions"), this.groupType, this.resource.getTypeName(), this.resource.getName());
            this.taskName = MessageFormat.format(com.ibm.cics.ia.ui.Messages.getString("AffinityView.retrievingAffinitiesForResourceInAllRegions"), this.groupType, this.resource.getTypeName(), this.resource.getName());
        } else if (this.region == null && this.resource == null) {
            this.description = MessageFormat.format(com.ibm.cics.ia.ui.Messages.getString("AffinityView.affinitiesInAllRegions"), this.groupType);
            this.taskName = MessageFormat.format(com.ibm.cics.ia.ui.Messages.getString("AffinityView.retrievingAffinitiesInAllRegions"), this.groupType);
        }
        Debug.exit((Logger)logger, (String)AffinityView.class.getName(), (String)"setDescription");
    }

    private void clearUIElements() {
        Debug.enter((Logger)logger, (String)AffinityView.class.getName(), (String)"clearUIElements", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.affGroupTable != null && !this.affGroupTable.isDisposed()) {
            this.affGroupTable.removeAll();
            while (this.affGroupTable.getColumns().length > 0) {
                this.affGroupTable.getColumn(0).dispose();
            }
        }
        if (this.affCommandTable != null && !this.affCommandTable.isDisposed()) {
            this.affCommandTable.removeAll();
            while (this.affCommandTable.getColumns().length > 0) {
                this.affCommandTable.getColumn(0).dispose();
            }
        }
        Debug.exit((Logger)logger, (String)AffinityView.class.getName(), (String)"clearUIElements");
    }

    public void createTableColumns() {
        Debug.enter((Logger)logger, (String)AffinityView.class.getName(), (String)"createTableColumns", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.descriptionLabel.setText(this.description);
        this.clearUIElements();
        String[] groupTitles = new String[3];
        if (this.groupType.equals("ENQ/DEQ") || this.groupType.equals("LOAD/RELEASE") || this.groupType.equals("TEMPORARY STORAGE")) {
            groupTitles[0] = com.ibm.cics.ia.ui.Messages.getString("AffinityView.resource");
            groupTitles[1] = com.ibm.cics.ia.ui.Messages.getString("AffinityView.relationType");
            groupTitles[2] = com.ibm.cics.ia.ui.Messages.getString("AffinityView.lifetime");
        } else {
            groupTitles = this.groupType.equals("CANCEL/DELAY/POST/START") || this.groupType.equals("ADDRESS CWA") ? new String[]{com.ibm.cics.ia.ui.Messages.getString("AffinityView.relationType"), com.ibm.cics.ia.ui.Messages.getString("AffinityView.lifetime")} : new String[]{com.ibm.cics.ia.ui.Messages.getString("AffinityView.affinityGroup")};
        }
        int i = 0;
        while (i < groupTitles.length) {
            TableColumn column = new TableColumn(this.affGroupTable, 0);
            column.setText(groupTitles[i]);
            ++i;
        }
        i = 0;
        while (i < groupTitles.length) {
            this.affGroupTable.getColumn(i).pack();
            ++i;
        }
        String[] commandTitles = new String[]{com.ibm.cics.ia.ui.Messages.getString("AffinityView.transaction"), com.ibm.cics.ia.ui.Messages.getString("AffinityView.program"), com.ibm.cics.ia.ui.Messages.getString("AffinityView.command")};
        int i2 = 0;
        while (i2 < commandTitles.length) {
            TableColumn column = new TableColumn(this.affCommandTable, 0);
            column.setText(commandTitles[i2]);
            ++i2;
        }
        i2 = 0;
        while (i2 < commandTitles.length) {
            this.affCommandTable.getColumn(i2).pack();
            ++i2;
        }
        Debug.exit((Logger)logger, (String)AffinityView.class.getName(), (String)"createTableColumns");
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public String getTitleToolTip() {
        if (IAUtilities.hasContent((String)this.description)) {
            return this.description;
        }
        return com.ibm.cics.ia.ui.Messages.getString("QueryResultsView.noResultsText");
    }
}

