/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.AffinityReport;
import com.ibm.cics.ia.ui.AffinityReportEditorInput;
import com.ibm.cics.ia.ui.AffinityReportOverviewEditorPage;
import com.ibm.cics.ia.ui.AffinityReportTrangroupsEditorPage;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.ReportManager;
import java.io.File;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;

public class AffinityReportEditor
extends FormEditor {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String ID = "com.ibm.cics.ia.ui.AffinityReportEditor";
    private String reportDescription;
    private AffinityReport report;
    private IFile reportFile;
    private static final Logger logger = Logger.getLogger(AffinityReportEditor.class.getPackage().getName());

    protected void addPages() {
        try {
            this.addPage((IFormPage)new AffinityReportOverviewEditorPage(this, ((AffinityReportEditorInput)this.getEditorInput()).getAffinityReport()));
            this.addPage((IFormPage)new AffinityReportTrangroupsEditorPage(this, ((AffinityReportEditorInput)this.getEditorInput()).getAffinityReport()));
        }
        catch (PartInitException e) {
            Debug.warning((Logger)logger, (String)AffinityReportEditor.class.getName(), (String)"addPages", (String)"empty catch", (Throwable)e);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        Debug.enter((Logger)logger, (String)AffinityReportEditor.class.getName(), (String)"doSave", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId()});
        monitor.beginTask(Messages.getString("AffinityReportEditor.Saving"), 0);
        File file = new File(this.reportFile.getLocation().toOSString());
        boolean result = file.delete();
        if (result) {
            this.report.setDescription(this.reportDescription);
            this.report.write(file);
        }
        monitor.done();
        this.firePropertyChange(257);
        Debug.exit((Logger)logger, (String)AffinityReportEditor.class.getName(), (String)"doSave", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public String getTitleToolTip() {
        return this.getTitle();
    }

    public Image getTitleImage() {
        return ImageFactory.getAffinityReportImage();
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.report = ((AffinityReportEditorInput)input).getAffinityReport();
        this.reportDescription = this.report.getDescription();
        this.reportFile = ((AffinityReportEditorInput)input).getReportFile();
        this.setPartName(String.valueOf(ReportManager.getNameWithoutTimestamp(this.reportFile)) + ReportManager.getUserTimeStamp(this.reportFile));
    }

    public boolean isDirty() {
        return !this.report.getDescription().equals(this.reportDescription);
    }

    public void setReportDescription(String description) {
        this.reportDescription = description;
        this.firePropertyChange(257);
    }
}

