/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.AffinityType;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.actions.ShowAffinityAction;
import java.util.logging.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class AffinityByTypeMenu {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(AffinityByTypeMenu.class.getPackage().getName());
    protected static final String RESOURCE_TYPE = "RESOURCE_TYPE";
    public static final String PREFIX = "AffinityType.";
    public static final AffinityType[] AFFINITY_TYPES = AffinityType.values();

    static void addAffinitySubmenu(Menu parentMenu, SelectionListener listener) {
        MenuItem item;
        Debug.enter((Logger)logger, (String)AffinityByTypeMenu.class.getName(), (String)"addAffinitySubmenu", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Menu topMenu = new Menu(parentMenu);
        int i = 0;
        while (i < AFFINITY_TYPES.length) {
            item = new MenuItem(topMenu, 8);
            item.setData(RESOURCE_TYPE, (Object)(PREFIX + AFFINITY_TYPES[i]));
            item.setText(AFFINITY_TYPES[i].getName());
            item.addSelectionListener(listener);
            ++i;
        }
        item = new MenuItem(parentMenu, 64);
        item.setText(Messages.getString("RegionExplorer.menu.showaffinities"));
        item.setMenu(topMenu);
        Debug.exit((Logger)logger, (String)AffinityByTypeMenu.class.getName(), (String)"addAffinitySubmenu");
    }

    static MenuManager getAffinityMenuManager(IMenuManager parentMenu, Resource resource) {
        Debug.enter((Logger)logger, (String)AffinityByTypeMenu.class.getName(), (String)"getAffinityMenuManager", (Object)("Thread ID: " + Thread.currentThread().getId()));
        MenuManager topMenu = new MenuManager(Messages.getString("RegionExplorer.menu.showaffinities"));
        int i = 0;
        while (i < AFFINITY_TYPES.length) {
            ShowAffinityAction action = new ShowAffinityAction();
            action.setText(AFFINITY_TYPES[i].getName());
            action.setAffinityType(PREFIX + AFFINITY_TYPES[i]);
            action.setResource(resource);
            topMenu.add((IAction)action);
            ++i;
        }
        Debug.exit((Logger)logger, (String)AffinityByTypeMenu.class.getName(), (String)"getAffinityMenuManager");
        return topMenu;
    }
}

