/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.AffinityBuilderOutput;
import com.ibm.cics.ia.model.AffinityReport;
import com.ibm.cics.ia.ui.AffinityBuildEditor;
import com.ibm.cics.ia.ui.BuilderTreeCellLabelProvider;
import com.ibm.cics.ia.ui.BuilderTreeContentProvider;
import com.ibm.cics.ia.ui.Messages;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class AffinityBuildOverviewEditorPage
extends FormPage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private AffinityBuildEditor editor;
    private AffinityBuilderOutput affinityBuilderOutput;
    private Tree trangroupTree;
    private TreeViewer trangroupViewer;
    private Text contextText;
    private BuilderTreeContentProvider treeContentProvider;
    private BuilderTreeCellLabelProvider treeCellLabelProvider;
    private static final Logger logger = Logger.getLogger(AffinityBuildOverviewEditorPage.class.getPackage().getName());

    public AffinityBuildOverviewEditorPage(FormEditor editor, AffinityBuilderOutput affinityBuilderOutput) {
        super(editor, "com.ibm.cics.ia.affinity.report.overview.page", Messages.getString("AffinityBuildEditor.Overview.Title"));
        this.editor = (AffinityBuildEditor)editor;
        this.affinityBuilderOutput = affinityBuilderOutput;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IWorkbenchHelpSystem helpSystem = this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)parent, "com.ibm.cics.ia.help.affinity_build_editor");
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        Debug.enter((Logger)logger, (String)AffinityBuildOverviewEditorPage.class.getName(), (String)"createFormContent", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.affinityBuilderOutput == null) {
            Debug.exit((Logger)logger, (String)AffinityBuildOverviewEditorPage.class.getName(), (String)"createFormContent", (Object)"affinityBuilderOutput == null");
            return;
        }
        Form form = managedForm.getForm().getForm();
        managedForm.getToolkit().decorateFormHeading(form);
        Composite parent = form.getBody();
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 6;
        layout.marginHeight = 12;
        parent.setLayout((Layout)layout);
        GridData headerData = new GridData(768);
        Section headerSection = toolkit.createSection(parent, 384);
        headerSection.setText(Messages.getString("AffinityBuildEditor.Overview.General.Section.Text"));
        headerSection.setDescription(Messages.getString("AffinityBuildEditor.Overview.General.Section.Description"));
        headerSection.setLayoutData((Object)headerData);
        layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginWidth = 3;
        layout.marginHeight = 3;
        Composite headerClient = toolkit.createComposite((Composite)headerSection, 64);
        headerClient.setLayout((Layout)layout);
        GridData headerChildrenData = new GridData(16384, 128, false, false);
        Label dateLabel = new Label(headerClient, 0);
        dateLabel.setText(Messages.getString("AffinityBuildEditor.Overview.General.Date.Label"));
        dateLabel.setLayoutData((Object)headerChildrenData);
        headerChildrenData = new GridData(4, 128, true, false);
        Text dateText = new Text(headerClient, 2048);
        dateText.setText(AffinityReport.DATE_FORMAT.format(this.affinityBuilderOutput.getGenerationDate()));
        dateText.setLayoutData((Object)headerChildrenData);
        dateText.setEnabled(false);
        headerChildrenData = new GridData(16384, 128, false, false);
        Label contextLabel = new Label(headerClient, 0);
        contextLabel.setText(Messages.getString("AffinityBuildEditor.Overview.General.Context.Label"));
        contextLabel.setLayoutData((Object)headerChildrenData);
        headerChildrenData = new GridData(4, 128, true, false);
        this.contextText = new Text(headerClient, 2048);
        this.contextText.setText(this.affinityBuilderOutput.getContext());
        this.contextText.setLayoutData((Object)headerChildrenData);
        this.contextText.setEnabled(false);
        headerChildrenData = new GridData(16384, 128, false, false);
        Label matchLabel = new Label(headerClient, 0);
        matchLabel.setText(Messages.getString("AffinityBuildEditor.Overview.General.Match.Label"));
        matchLabel.setLayoutData((Object)headerChildrenData);
        headerChildrenData = new GridData(4, 128, true, false);
        Text matchText = new Text(headerClient, 2048);
        matchText.setText(this.affinityBuilderOutput.getMatch());
        matchText.setLayoutData((Object)headerChildrenData);
        matchText.setEnabled(false);
        headerChildrenData = new GridData(16384, 128, false, false);
        Label stateLabel = new Label(headerClient, 0);
        stateLabel.setText(Messages.getString("AffinityBuildEditor.Overview.General.State.Label"));
        stateLabel.setLayoutData((Object)headerChildrenData);
        headerChildrenData = new GridData(4, 128, true, false);
        Text stateText = new Text(headerClient, 2048);
        stateText.setText(this.affinityBuilderOutput.getState());
        stateText.setLayoutData((Object)headerChildrenData);
        stateText.setEnabled(false);
        headerChildrenData = new GridData(16384, 128, false, false);
        Label descriptionLabel = new Label(headerClient, 0);
        descriptionLabel.setText(Messages.getString("AffinityBuildEditor.Overview.General.Description.Label"));
        descriptionLabel.setLayoutData((Object)headerChildrenData);
        headerChildrenData = new GridData(4, 128, true, false);
        headerChildrenData.horizontalSpan = 3;
        headerChildrenData.heightHint = 75;
        final Text descriptionText = new Text(headerClient, 2562);
        descriptionText.setText(this.affinityBuilderOutput.getDescription());
        descriptionText.setLayoutData((Object)headerChildrenData);
        descriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AffinityBuildOverviewEditorPage.this.editor.setBuildDescription(descriptionText.getText());
            }
        });
        headerSection.setClient((Control)headerClient);
        GridData trangroupData = new GridData(1808);
        trangroupData.grabExcessHorizontalSpace = true;
        trangroupData.grabExcessVerticalSpace = true;
        trangroupData.horizontalSpan = 1;
        Section trangroupSection = toolkit.createSection(parent, 256);
        trangroupSection.setText(Messages.getString("AffinityBuildEditor.Overview.Trangroups.Section.Text"));
        trangroupSection.setLayoutData((Object)trangroupData);
        Composite trangroupClient = toolkit.createComposite((Composite)trangroupSection, 64);
        trangroupClient.setLayout((Layout)layout);
        GridData trangroupChildrenData = new GridData(1808);
        this.trangroupTree = toolkit.createTree(trangroupClient, 68352);
        this.trangroupTree.setLayoutData((Object)trangroupChildrenData);
        this.trangroupViewer = new TreeViewer(this.trangroupTree);
        this.treeContentProvider = new BuilderTreeContentProvider();
        this.trangroupViewer.setContentProvider((IContentProvider)this.treeContentProvider);
        this.treeCellLabelProvider = new BuilderTreeCellLabelProvider();
        this.trangroupViewer.setLabelProvider((IBaseLabelProvider)this.treeCellLabelProvider);
        trangroupSection.setClient((Control)trangroupClient);
        this.refresh();
        this.editor.updateRunEnablement();
        Debug.exit((Logger)logger, (String)AffinityBuildOverviewEditorPage.class.getName(), (String)"createFormContent");
    }

    public void refresh() {
        this.trangroupViewer.setInput((Object)this.affinityBuilderOutput);
        this.trangroupViewer.expandAll();
        TreeColumn[] treeColumnArray = this.trangroupTree.getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            column.pack();
            ++n2;
        }
        this.contextText.setText(this.affinityBuilderOutput.getContext());
    }
}

