/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.ia.controller.CPSMDeploymentController;
import com.ibm.cics.ia.model.AffinityBuilderOutput;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.AffinityBuildCPSMInputEditorPage;
import com.ibm.cics.ia.ui.AffinityBuildJCLPage;
import com.ibm.cics.ia.ui.AffinityBuildOverviewEditorPage;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.ReportManager;
import com.ibm.cics.ia.ui.SaveBuildDialog;
import com.ibm.cics.zos.ui.ZOSActivator;
import com.ibm.cics.zos.ui.editor.jcl.CustomiserFactory;
import com.ibm.cics.zos.ui.editor.jcl.JCLPartitionTokenScanner;
import com.ibm.cics.zos.ui.editor.jcl.JCLTextEditorCustomiser;
import java.io.File;
import java.util.logging.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.FileEditorInput;

public class AffinityBuildEditor
extends SharedHeaderFormEditor
implements IDocumentListener {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String ID = "com.ibm.cics.ia.ui.AffinityBuildEditor";
    private String buildDescription;
    private String datasetName;
    private String memberName;
    private String cmasName;
    private String outputUserName;
    private String printNode;
    private AffinityBuilderOutput.Action action;
    private boolean isNew;
    private boolean isDirty;
    private AffinityBuilderOutput output;
    private IFile iFile;
    private JCLTextEditorCustomiser customiser;
    private AffinityBuildOverviewEditorPage overviewPage;
    private AffinityBuildCPSMInputEditorPage CPSMInputPage;
    private AffinityBuildJCLPage jclPage;
    private Action runAction;
    private IToolBarManager toolbarManager;
    private static final Logger logger = Logger.getLogger(AffinityBuildEditor.class.getPackage().getName());
    private ConnectionServiceListener connectionServiceListener = new ConnectionServiceListener(){

        public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
            if ("com.ibm.cics.zos.comm.connection".equals(event.getConnectionCategoryId())) {
                if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                    this.connected();
                } else if (event instanceof ConnectionServiceListener.DisconnectedEvent) {
                    this.disconnected();
                }
            }
        }

        public void connected() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (AffinityBuildEditor.this.CPSMInputPage != null) {
                        AffinityBuildEditor.this.CPSMInputPage.setSelectDataSetEnabled(true);
                        AffinityBuildEditor.this.CPSMInputPage.setCreateDataSetEnbled(true);
                    }
                    if (AffinityBuildEditor.this.runAction != null) {
                        AffinityBuildEditor.this.updateRunEnablement();
                    }
                }
            });
        }

        public void disconnected() {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (AffinityBuildEditor.this.CPSMInputPage != null) {
                        AffinityBuildEditor.this.CPSMInputPage.setSelectDataSetEnabled(false);
                        AffinityBuildEditor.this.CPSMInputPage.setCreateDataSetEnbled(false);
                    }
                    if (AffinityBuildEditor.this.runAction != null) {
                        AffinityBuildEditor.this.runAction.setEnabled(false);
                    }
                }
            });
        }
    };

    protected void addPages() {
        try {
            if (this.pages != null) {
                this.customiser = CustomiserFactory.getCustomiser();
                this.overviewPage = new AffinityBuildOverviewEditorPage((FormEditor)this, this.output);
                this.jclPage = new AffinityBuildJCLPage((SourceViewerConfiguration)this.customiser.getTextSourceViewerConfiguration(), new JCLPartitionTokenScanner());
                this.CPSMInputPage = new AffinityBuildCPSMInputEditorPage((FormEditor)this, this.output);
                this.addPage((IFormPage)this.overviewPage);
                this.addPage((IFormPage)this.CPSMInputPage);
                this.addPage((IEditorPart)this.jclPage, this.getEditorInput());
                this.jclPage.getDocument().addDocumentListener((IDocumentListener)this.CPSMInputPage);
                this.jclPage.getDocument().addDocumentListener((IDocumentListener)this);
                this.jclPage.initialize((FormEditor)this);
                ConnectionsPlugin.getDefault().getConnectionService().addConnectionServiceListener(this.connectionServiceListener);
            }
        }
        catch (PartInitException e) {
            Debug.warning((Logger)logger, (String)AffinityBuildEditor.class.getName(), (String)"addPages", (String)"empty catch", (Throwable)e);
        }
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        Debug.enter((Logger)logger, (String)AffinityBuildEditor.class.getName(), (String)"createHeaderContents", (Object)("Thread ID: " + Thread.currentThread().getId()));
        ScrolledForm sform = headerForm.getForm();
        this.getToolkit().decorateFormHeading(sform.getForm());
        this.toolbarManager = sform.getToolBarManager();
        this.createContributions(this.toolbarManager);
        this.updateRunEnablement();
        Debug.exit((Logger)logger, (String)AffinityBuildEditor.class.getName(), (String)"createHeaderContents", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    private void createContributions(IToolBarManager manager) {
        this.runAction = new Action(){

            public String getText() {
                return Messages.getString("AffinityBuildEditor.CPSMInput.RunAction");
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageDescriptor.createFromImage((Image)ImageFactory.getRunImage());
            }

            public void run() {
                CPSMDeploymentController runnable = new CPSMDeploymentController((IWorkbenchPart)AffinityBuildEditor.this, AffinityBuildEditor.this.output, AffinityBuildEditor.this.datasetName, AffinityBuildEditor.this.memberName, AffinityBuildEditor.this.cmasName, AffinityBuildEditor.this.outputUserName, AffinityBuildEditor.this.printNode);
                runnable.schedule();
            }
        };
        this.getEditorSite().getActionBars().setGlobalActionHandler("com.ibm.cics.ia.ui.deployToCPSM", (IAction)this.runAction);
        this.getEditorSite().getActionBars().updateActionBars();
        manager.add((IAction)this.runAction);
        manager.update(true);
    }

    public void doSave(IProgressMonitor monitor) {
        Debug.enter((Logger)logger, (String)AffinityBuildEditor.class.getName(), (String)"doSave", (Object)("Thread ID: " + Thread.currentThread().getId()));
        File file = null;
        IContainer container = null;
        if (this.isNew) {
            SaveBuildDialog dialog = new SaveBuildDialog(Display.getDefault().getActiveShell());
            int dialogResult = dialog.open();
            if (dialogResult == 0) {
                container = dialog.getContainer();
                String fileName = dialog.getFileName();
                IPath newFilePath = container.getLocation().append(fileName);
                String pathString = newFilePath.toOSString();
                file = new File(pathString);
                this.iFile = container.getFile(newFilePath);
                this.setPartName(this.iFile.getFullPath().removeFileExtension().lastSegment());
            }
        } else {
            file = new File(this.iFile.getLocation().toOSString());
        }
        if (file != null) {
            boolean result;
            monitor.beginTask(Messages.getString("AffinityBuildEditor.Saving"), 0);
            if (!this.isNew && !(result = file.delete())) {
                monitor.done();
                return;
            }
            this.output.setDescription(this.buildDescription);
            this.output.setDataSetName(this.datasetName);
            this.output.setMemberName(this.memberName);
            this.output.setCmasName(this.cmasName);
            this.output.setOutputUserName(this.outputUserName);
            this.output.setPrintNode(this.printNode);
            this.output.setAction(this.action);
            this.output.setJcl(this.getJcl());
            this.output.write(file);
            if (this.isNew) {
                ReportManager.refreshAll(container);
            }
            this.isNew = false;
            this.isDirty = false;
            this.firePropertyChange(257);
            monitor.worked(50);
            if (ZOSActivator.getZOSConnectable().isConnected()) {
                CPSMDeploymentController controller = new CPSMDeploymentController((IWorkbenchPart)this, this.output, this.datasetName, this.memberName, this.cmasName, this.outputUserName, this.printNode);
                controller.save();
            } else {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageBox box = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 40);
                        box.setMessage(Messages.getString("AffinityBuildEditor.Warning.NoConnection.Message"));
                        box.setText(Messages.getString("AffinityBuildEditor.Warning.NoConnection.Text"));
                        box.open();
                    }
                });
            }
            monitor.worked(100);
            monitor.done();
        }
        Debug.exit((Logger)logger, (String)AffinityBuildEditor.class.getName(), (String)"doSave", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    public String getPartProperty(String key) {
        if (IConnectionCategory.class.getName().equals(key)) {
            return "com.ibm.cics.zos.comm.connection";
        }
        return super.getPartProperty(key);
    }

    public String getTitle() {
        if (this.iFile != null) {
            return this.iFile.getName();
        }
        return super.getTitle();
    }

    public String getTitleToolTip() {
        return this.getTitle();
    }

    public Image getTitleImage() {
        return ImageFactory.getBuildImage();
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        Debug.enter((Logger)logger, (String)AffinityBuildEditor.class.getName(), (String)"setInput", (Object[])new String[]{"ThreadId: " + Thread.currentThread().getId(), "input: " + input.getName()});
        FileEditorInput fileEditorInput = (FileEditorInput)input;
        IFile iFile = fileEditorInput.getFile();
        File file = new File(iFile.getLocation().toOSString());
        if (file.exists()) {
            this.output = AffinityBuilderOutput.parse((File)file);
            if (!iFile.getFullPath().getFileExtension().equals("tmp")) {
                this.iFile = iFile;
            }
            this.buildDescription = this.output.getDescription();
            this.datasetName = this.output.getDataSetName();
            this.memberName = this.output.getMemberName();
            this.cmasName = this.output.getCmasName();
            this.outputUserName = this.output.getOutputUserName();
            this.printNode = this.output.getPrintNode();
            this.action = this.output.getAction();
            if (this.iFile == null) {
                this.isNew = true;
                this.setPartName(Messages.getString("AffinityBuildEditorInput.New"));
            } else {
                this.isNew = false;
                this.setPartName(this.iFile.getFullPath().removeFileExtension().lastSegment());
            }
        }
        Debug.exit((Logger)logger, (String)AffinityBuildEditor.class.getName(), (String)"setInput");
    }

    public boolean isDirty() {
        if (this.output == null) {
            return false;
        }
        return this.isNew || this.isDirty || !this.output.getDescription().equals(this.buildDescription) || !this.output.getDataSetName().equals(this.datasetName) || !this.output.getMemberName().equals(this.memberName) || !this.output.getCmasName().equals(this.cmasName) || !this.output.getOutputUserName().equals(this.outputUserName) || !this.output.getPrintNode().equals(this.printNode) || !this.output.getAction().equals((Object)this.action);
    }

    public void setBuildDescription(String description) {
        this.buildDescription = description;
        this.firePropertyChange(257);
    }

    public void setDatasetName(String datasetName) {
        this.datasetName = datasetName;
        this.firePropertyChange(257);
        this.updateRunEnablement();
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
        this.firePropertyChange(257);
        this.updateRunEnablement();
    }

    public void setCmasName(String cmasName) {
        this.cmasName = cmasName;
        this.firePropertyChange(257);
        this.updateRunEnablement();
    }

    public void setOutputUserName(String outputUserName) {
        this.outputUserName = outputUserName;
        this.firePropertyChange(257);
        this.updateRunEnablement();
    }

    public void setPrintNode(String printNode) {
        this.printNode = printNode;
        this.firePropertyChange(257);
        this.updateRunEnablement();
    }

    public void fireDirty() {
        this.isDirty = true;
        this.firePropertyChange(257);
    }

    public void refreshOverview() {
        if (this.overviewPage != null) {
            this.overviewPage.refresh();
        }
    }

    public String getJcl() {
        return this.jclPage.getDocument().get();
    }

    public void setJcl(String jcl) {
        this.jclPage.getDocument().set(jcl);
        this.updateRunEnablement();
    }

    public AffinityBuilderOutput.Action getAction() {
        return this.action;
    }

    public void setAction(AffinityBuilderOutput.Action action) {
        this.action = action;
    }

    protected void pageChange(int newPageIndex) {
        switch (newPageIndex) {
            case 0: {
                this.getHeaderForm().getForm().setText(Messages.getString("AffinityBuildEditor.Overview.Title"));
                break;
            }
            case 1: {
                this.getHeaderForm().getForm().setText(Messages.getString("AffinityBuildEditor.CPSMInput.Title"));
                break;
            }
            case 2: {
                this.getHeaderForm().getForm().setText(Messages.getString("AffinityBuildEditor.DeploymentJCL.Title"));
            }
        }
        super.pageChange(newPageIndex);
    }

    public void updateRunEnablement() {
        Debug.enter((Logger)logger, (String)AffinityBuildEditor.class.getName(), (String)"updateRunEnablement", (Object)("ThreadID: " + Thread.currentThread().getId()));
        ScrolledForm form = this.getHeaderForm().getForm();
        form.getMessageManager().removeAllMessages();
        if (!IAUtilities.hasContent((String)this.datasetName)) {
            form.getMessageManager().addMessage((Object)"NO_DATASET", Messages.getString("AffinityBuildEditor.CPSMInput.DeploymentParameters.Warning.DataSet.NotSpecified"), null, 2);
            this.runAction.setEnabled(false);
            return;
        }
        if (!IAUtilities.hasContent((String)this.memberName)) {
            form.getMessageManager().addMessage((Object)"NO_MEMBER", Messages.getString("AffinityBuildEditor.CPSMInput.DeploymentParameters.Warning.Member.NotSpecified"), null, 2);
            this.runAction.setEnabled(false);
            return;
        }
        if (!IAUtilities.hasContent((String)this.cmasName)) {
            form.getMessageManager().addMessage((Object)"NO_CMAS", Messages.getString("AffinityBuildEditor.CPSMInput.DeploymentParameters.Warning.CMAS.NotSpecified"), null, 2);
            this.runAction.setEnabled(false);
            return;
        }
        if (!IAUtilities.hasContent((String)this.outputUserName)) {
            form.getMessageManager().addMessage((Object)"NO_USER", Messages.getString("AffinityBuildEditor.CPSMInput.DeploymentParameters.Warning.User.NotSpecified"), null, 2);
            this.runAction.setEnabled(false);
            return;
        }
        if (!IAUtilities.hasContent((String)this.printNode)) {
            form.getMessageManager().addMessage((Object)"NO_PRINT_NODE", Messages.getString("AffinityBuildEditor.CPSMInput.DeploymentParameters.Warning.PrintNode.NotSpecified"), null, 2);
            this.runAction.setEnabled(false);
            return;
        }
        this.runAction.setEnabled(ZOSActivator.getZOSConnectable().canPerform("ACTION_SUPPORT_JOBS", ""));
        Debug.exit((Logger)logger, (String)AffinityBuildEditor.class.getName(), (String)"updateRunEnablement");
    }

    public void dispose() {
        if (this.connectionServiceListener != null) {
            this.connectionServiceListener.makeStale();
        }
        super.dispose();
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        if (this.output != null) {
            this.output.setJcl(event.getDocument().get());
        }
    }
}

