/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.ia.model.AffGroup;
import com.ibm.cics.ia.ui.ResourceRenderer;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class AffGroupTableLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public Image getColumnImage(Object element, int columnIndex) {
        AffGroup affGroup = (AffGroup)element;
        String groupType = affGroup.getGroupType().trim();
        if (groupType.equals("ENQ/DEQ") || groupType.equals("LOAD/RELEASE") || groupType.equals("TEMPORARY STORAGE")) {
            switch (columnIndex) {
                case 0: {
                    return ResourceRenderer.asImage(affGroup.getResource());
                }
            }
            return null;
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        AffGroup affGroup = (AffGroup)element;
        String groupType = affGroup.getGroupType().trim();
        if (groupType.equals("ENQ/DEQ") || groupType.equals("LOAD/RELEASE") || groupType.equals("TEMPORARY STORAGE")) {
            switch (columnIndex) {
                case 0: {
                    return ResourceRenderer.asText(affGroup.getResource());
                }
                case 1: {
                    return affGroup.getAffinity().toString().trim();
                }
                case 2: {
                    return affGroup.getLifetime().toString().trim();
                }
            }
            return null;
        }
        if (groupType.equals("CANCEL/DELAY/POST/START") || groupType.equals("ADDRESS CWA")) {
            switch (columnIndex) {
                case 0: {
                    return affGroup.getAffinity().toString().trim();
                }
                case 1: {
                    return affGroup.getLifetime().toString().trim();
                }
            }
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return affGroup.getTranGroup().trim();
            }
        }
        return null;
    }
}

